// RAINBOW DEMO source code written for DJGPP C
// N.B. THIS DEMO ONLY RUNS UNDER A DOS-PROMPT IN WINDOWS
// Hi to Alex, Hitan, Table-tennis Miller and the rest
// Compile in DJGPP with 'GCC rainbow.c -orainbow.exe'
// Thanks to PC Format for original idea and code
// Thanks to iD software for wasting my time by making Quake multiplayer...
// This is FREEWARE - do whatever you want with it...
// For other demos by me see :5DEMO.ZIP and KALY.ZIP

#include <stdio.h>
#include <stdlib.h> 
#include <math.h> 
#include <dos.h> 
#include <sys\nearptr.h> 
#include <time.h>

#define SPEED 1.0    // Change to a higher number to make run faster

typedef struct  
{ 
   unsigned char red,green,blue; 
} pal; 


pal palette[256];
char tuntex[256][256], ScreenBuffer[200][320];

unsigned char AngleSet[200][320];
unsigned char RadiusSet[200][320];
union REGS r;
char *scrptr;

void ModeText(void) 
{ 
   r.h.ah=0; 
   r.h.al=0x03; 
   int86(0x10, &r, &r); 
} 

void ModeVga(void)
{
   r.h.ah=0;
   r.h.al=0x13;
   int86(0x10, &r, &r);
}

void TargaIn(char *filename)
{       
	FILE *in;

	if ( (in=fopen(filename, "rb")) == NULL )
	{
		printf("Ooops cannot open %s :(\n", filename);
		exit(1);                
	}

	fseek(in, 18, SEEK_SET);                
	fread(palette, 768, 1, in);
	fread(tuntex, 65536, 1, in);

	fclose(in);
}       

void BuffertoScreen(void)
{
	memcpy(scrptr, ScreenBuffer, 64000);    
	memset(ScreenBuffer, 0, 64000); 
}

void SetPalette(pal *palptr)
{
	short i;
	disable();
   outportb(0x3c8,0);
	for (i=0; i<256; i++)
	{
		outportb(0x3c9, palptr[i].blue>>2);
		outportb(0x3c9, palptr[i].green>>2);
		outportb(0x3c9, palptr[i].red>>2);
	}
	enable();
}

void CalcRadiusTable(void)
{
	long i,j;

	for (j=-100; j<100; j++)        
	{
      for (i=-160; i<160; i++)
		{
         RadiusSet[j+100][i+160]=((long) sqrt((i*i) + (j*j)) ) & 255;
		}               
	}               
}       

void CalcAngleTable(void)
{
	float x,y, angle;
	long i,j;

	for (j=-100; j<100; j++)
	{
		for (i=-160; i<160; i++)
		{
			if(i!=0 || j!=0)
			{
				x=i;
				y=j;
				angle=atan2(y,x);

				angle*=(256/6.284);

            AngleSet[j+100][i+160]=((long) angle) & 255;     
			}
		}
	}               
}       

void DoTunnel(unsigned char radoff, unsigned char angoff)
{
   register long i,j;
   register unsigned char radius,angle;

   angoff&=255;
   radoff&=255;

   for (j=0; j<100; j++)
	{
      for (i=0; i<160; i++)
		{
         radius=(radoff+RadiusSet[j][i]) & 255;
         angle=(angoff+AngleSet[j][i]) & 255;
         ScreenBuffer[j*2][i*2]=tuntex[radius][angle];
         radius=(radoff+RadiusSet[100+j][160+i]) & 255;
         angle=(angoff+AngleSet[100+j][160+i]) & 255;
         ScreenBuffer[j*2][(i*2)+1]=tuntex[radius][angle];
         radius=(radoff+RadiusSet[100+j][i]) & 255;
         angle=(angoff+AngleSet[100+j][i]) & 255;
         ScreenBuffer[(j*2)+1][(i*2)]=tuntex[radius][angle];
         radius=(radoff+RadiusSet[j][160+i]) & 255;
         angle=(angoff+AngleSet[j][160+i]) & 255;
         ScreenBuffer[(j*2)+1][(i*2)+1]=tuntex[radius][angle];
		}
	}
   BuffertoScreen();
}
 
int main (void) 
{ 
   float ft=0;
	unsigned char t=0;

   __djgpp_nearptr_enable();
   scrptr = (char*) (__djgpp_conventional_base + 0xa0000);

   TargaIn("rainbow.tga");
   ModeVga();

	CalcRadiusTable();
   CalcAngleTable();

	SetPalette(palette);
	while(!kbhit())
	{
      DoTunnel((long) -t*3, (long) t);
      ft+=SPEED;
      t=ft;
	}
	getch();

   ModeText();
   return(0);
}
