
/************************************************************************
 *																								*
 *		D48 8048 Disassembler - Copyright (C) 1995-1996 by						*
 *		Jeffery L. Post																	*
 *		22726 Benner Ave.																	*
 *		Torrance, CA  90505																*
 *																								*
 *		D48PASS.C - Disassembly Passes 1 - 3										*
 *																								*
 *		Version 2.0 - 08/20/96															*
 *																								*
 *	This program is free software; you can redistribute it and/or modify	*
 *	it under the terms of the GNU General Public License as published by	*
 *	the Free Software Foundation; either version 2 of the License, or		*
 *	(at your option) any later version.												*
 *																								*
 *	This program is distributed in the hope that it will be useful,		*
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of			*
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the			*
 *	GNU General Public License for more details.									*
 *																								*
 *	You should have received a copy of the GNU General Public License		*
 *	along with this program; if not, write to the Free Software				*
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.				*
 *																								*
 ************************************************************************/

#include	<stdio.h>
#include	<stdlib.h>
#include	<ctype.h>
#include	<string.h>
#include	<time.h>
#include	"d48.h"

#ifdef	MSDOS
#include	<dos.h>
#include	<alloc.h>
#endif

#ifdef	LINUX
#include	<malloc.h>
#endif

/*********************
 *							*
 *		Prototypes		*
 *							*
 *********************/

void	pass1(void);
void	pass2(void);
void	pass3(void);
void	doopcode(char *str);
void	splitcheck(word i);
void	chk_ref(word i);
int	is_ascii(byte data);
int	ascii(int i);
void	puthex(word j);
void	dump_ascii(word adrs);
void	dump_bytes(word adrs);

extern char	*find_entry(word val, word count, SYM_PTR *table);

#ifdef	DEBUG
extern void	dump_flags(void);
#endif

/***************************
 *									*
 *		Global variables		*
 *									*
 ***************************/

int	newline;

#ifdef	MSDOS
struct date	date_data;						/* disassembly date				*/
struct time	time_data;						/* disassembly time				*/
#endif

#ifdef	LINUX
struct tm	*date_time;						/* disassembly time				*/
#endif

extern char	src[32], dst[32];				/* file name buffers				*/
extern char	linebuffer[128];				/* input line buffer				*/
extern FILE	*fp;								/* source file						*/
extern byte	hexflag;							/* append hex flag				*/
extern byte	fileflag;						/* file type flag					*/
extern byte	flag41;							/* 8041 flag						*/
extern int	kcnt;								/* output char counter			*/
extern byte	pdata[PSIZE];					/* program data space			*/
extern byte	pflag[PSIZE];					/* program flag space			*/
extern char	string[ASCLIMIT];				/* ascii output buffer			*/
extern int	asc_cnt;							/* count for ascii data			*/
extern byte	byte_data[BYTELIMIT];		/* binary data for defb			*/
extern int	byte_cnt;						/* count for binary data		*/
extern byte	optbl[256];
extern byte	bctbl[256];
extern struct entry mnemtbl[256];
extern int	dump;
extern word	symbol_count;					/* number of symbols				*/
extern word	label_count;					/* number of labels				*/
extern struct sym	*sym_tab;				/* symbol table pointer			*/
extern struct sym	*lab_tab;				/* label table pointer			*/
extern SYM_PTR	*sym_val_index;			/* symbol table pointer array	*/
extern SYM_PTR	*lab_val_index;			/* label table pointer array	*/
extern char	defbstr[8];
extern char	defwstr[8];

/*********************
 *							*
 *			Code			*
 *							*
 *********************/

/***********************************************************************

	Pass one of disassembly. Examine opcodes for internal references
	to other memory locations. If such references are found, flag the
	referenced location so that a label can be generated in the output
	file during pass two.

************************************************************************/

void pass1(void)
{
	int	i, j, pc, mbank;
	char	*inp;
	byte	k, mask;

	printf("\rPass 1");

	pc = mbank = 0;
	mask = (byte) (PF_CLREF | PF_SPLIT);
	for (i=0; i<PSIZE; )
	{
		if (pflag[i] == PF_INIT || i > PSIZE - 1)
			i++;							/* ignore un-initialized data */
											/* ignore if last byte in address space */
											/* since second byte of opcode can't be */
											/* within the allowed address space */
		else if (!(pflag[i] & (PF_ADRS | PF_WORD | PF_BYTE | PF_ASCII)))
		{									/* if code... */
			k = pdata[i];				/* get stored opcode */
			if (k == 0xe5)
				mbank = 0;				/* modify if select bank code */
			else if (k == 0xf5)
				mbank = 1;
			j = optbl[k] & 0xf;			/* get flags byte */
			if (j == OPT_PAGE)			/* if memory reference in current page */
			{
				pc = i & 0xf00;						/* get current page */
				pc = pc | (pdata[i + 1] & 0xff);	/* add address from opcode */
				pflag[pc] = (pflag[pc] & ~mask) | PF_REF;	/* flag reference */
			}
			if (j == OPT_EXT)				/* if extended memory reference */
			{
				pc = (k & 0xe0) << 3;				/* extract page number */
				pc = pc | (pdata[i + 1] & 0xff);	/* add address from opcode */
				if (mbank)
					pc = pc | 0x800;
				if ((word) pc < PSIZE)				/* flag reference */
					pflag[pc] = (pflag[pc] & ~mask) | PF_REF;
				mbank = (i < 2048) ? 0 : 1;
			}
			i = i + bctbl[k];				/* update location pointer */
		}
		else									/* not executable code */
			i++;
		if (i == 2048)
			mbank = 1;						/* passing into upper bank */
		if (!(i & 0xff))
			putchar('.');					/* show progress every 256 bytes */
	}
	printf("\rPass 1 - Reference search complete");
}										/*  End of Pass 1 */

/************************************************************************

	Pass two of disassembly. Rescan data array and generate output file.
	Generate label if location flagged as referenced by some other opcode.
	If un-initialized data is encountered, ignore it but set skip flag so
	that an ORG statement can be generated when the next initialized data
	is found.

*************************************************************************/

void pass2(void)
{
	char	c, *cptr;
	int	i, j, k, pc, skip, mbank;
	word	q, temp;
	byte	code;

#ifdef	LINUX
	time_t	tp;
#endif

	j = -1;
	k = 0;
	mbank = 0;
	dump = 0;
	byte_cnt = 0;
	asc_cnt = 0;
	newline = 0;
	skip = 1;
	printf("\nPass 2");

	if ((fp = fopen(dst, "w")) == NULL)
	{
		printf("\n* Can't open file %s *\n", dst);
		exit(FILE_ERROR);
	}
	i = flag41 ? 8041 : 8048;
	fprintf(fp, ";\n;  %d Disassembly of %s", i, src);

#ifdef	MSDOS
	getdate(&date_data);
	gettime(&time_data);
	fprintf(fp, "\n;  %d/%d/%d %d:%02d", date_data.da_mon, date_data.da_day,
		date_data.da_year, time_data.ti_hour, time_data.ti_min);
#endif

#ifdef	LINUX
	time(&tp);									/* get current time */
	date_time = localtime(&tp);			/* convert to hr/min/day etc */
	fprintf(fp, "\n;  %d/%d/%d %d:%02d", date_time->tm_mon + 1,
		date_time->tm_mday, date_time->tm_year,
		date_time->tm_hour, date_time->tm_min);
#endif

/*  Generate output file */

	for (i=0; i<PSIZE; )
	{
		if (pflag[i] == PF_INIT)			/* ignore un-initialized data */
		{
			if (byte_cnt)				/* if binary or ascii data in buffers... */
				dump_bytes(i);
			if (asc_cnt)
				dump_ascii(i);
			if (dump)
			{
				dump = 0;				/* if we had to flush buffers...	*/
				fprintf(fp, "\n;");	/* do a newline, since we will	*/
				newline++;				/* be doing an org (or end)		*/
			}
			i++;							/* next program location */
			skip++;						/* flag skip for ORG statement */
			j = -1;
		}
		else if (pflag[i] & (PF_ADRS | PF_WORD | PF_BYTE | PF_ASCII))
		{											/* if not executable code */
			if (!(j & 0x80) && !skip)
			{
				j = -1;
				fprintf(fp, "\n;");
				newline++;
			}
			switch (pflag[i] & ~PF_REF)		/* ignore reference bit */
			{
				case PF_ASCII:						/* if ascii text... */
					if (byte_cnt)					/* dump any pending binary */
						dump_bytes(i);
					if (skip)						/* insert ORG statement */
					{
						if (!newline)
							fprintf(fp, "\n;");
						fprintf(fp, "\n\torg\t");
						puthex(i);
						fprintf(fp, "\n;");
						newline++;
						skip = 0;
					}
					if (is_ascii(pdata[i]))		/* if it really is ascii... */
					{
						string[asc_cnt] = pdata[i];
						asc_cnt++;
						if (asc_cnt >= ASCLIMIT)
							dump_ascii(i);
					}
					else								/* else treat it as binary data */
					{
						pflag[i] |= PF_BYTE;
						if (asc_cnt)				/* dump any accumulated ascii */
							dump_ascii(i);
						byte_data[byte_cnt] = pdata[i];	/* add data to buffer */
						byte_cnt++;
					}
					break;

				case PF_WORD:					/* if word data... */
					if (byte_cnt)			/* dump any binary or ascii in buffers */
						dump_bytes(i);
					if (asc_cnt)
						dump_ascii(i);
					if (skip)					/* insert ORG statement */
					{
						if (!newline)
							fprintf(fp, "\n;");
						fprintf(fp, "\n\torg\t");
						puthex(i);
						fprintf(fp, "\n;");
						newline++;
						skip = 0;				/* reset skip flag */
					}
					chk_ref(i);							/* add label if referenced */
					q = ((word) pdata[i]) << 8;	/* get word value */
					temp = pdata[i + 1] & 0xff;
					q |= temp;
					fprintf(fp, "%s\t", defwstr);
					cptr = find_entry(q, symbol_count, sym_val_index);	/* see if symbol exists */
					if (cptr == NULL)						/* if not, do hex value */
						puthex(q);
					else
						fprintf(fp, "%s", cptr);		/* else output symbol */
					if (hexflag)							/* add comment field */
						fprintf(fp, "\t\t; %04x - %02x %02x  %c%c",
							i, pdata[i], pdata[i + 1],
							ascii(pdata[i]), ascii(pdata[i + 1]));
					i++;
					if (pflag[i + 2] != PF_ADRS && pflag[i + 2] != PF_WORD)
					{
						fprintf(fp, "\n;");
						newline++;
					}
					break;

				case PF_ADRS:					/* if address data... */
					if (byte_cnt)				/* output any pending binary or */
						dump_bytes(i);			/* ascii data from buffers */
					if (asc_cnt)
						dump_ascii(i);
					if (skip)					/* insert ORG statement */
					{
						if (!newline)
							fprintf(fp, "\n;");
						fprintf(fp, "\n\torg\t");
						puthex(i);
						fprintf(fp, "\n;");
						newline++;
						skip = 0;				/* reset skip flag */
					}
					chk_ref(i);					/* add label if referenced */
					q = ((word) pdata[i]) << 8;	/* get address value */
					temp = pdata[i + 1] & 0xff;
					q |= temp;
					fprintf(fp, "%s\t", defwstr);
					cptr = find_entry(q, label_count, lab_val_index);	/* see if label exists */
					if (cptr == NULL)						/* if not, output hex */
					{
						cptr = find_entry(q, symbol_count, sym_val_index);
						if (cptr == NULL)
							fprintf(fp, "X%04x", q);
						else
							fprintf(fp, "%s", cptr);
					}
					else
						fprintf(fp, "%s", cptr);		/* else output label text */
					if (hexflag)							/* do comment field */
						fprintf(fp, "\t\t; %04x   %02x %02x  %c%c",
							i, pdata[i], pdata[i + 1],
							ascii(pdata[i]), ascii(pdata[i + 1]));
					i++;
					if (pflag[i + 2] != PF_ADRS)
					{
						fprintf(fp, "\n;");
						newline++;
					}
					break;

				default:							/* default = binary data... */
					if (asc_cnt)				/* output any pending ascii data */
						dump_ascii(i);
					if (skip)					/* insert ORG statement */
					{
						if (!newline)
							fprintf(fp, "\n;");
						fprintf(fp, "\n\torg\t");
						puthex(i);
						fprintf(fp, "\n;");
						newline++;
						skip = 0;				/* reset skip flag */
					}
					byte_data[byte_cnt] = pdata[i];	/* add data to buffer */
					byte_cnt++;
					if (byte_cnt >= BYTELIMIT)			/* if end of buffer...	*/
						dump_bytes(i);						/* dump accumulated data */
			}
			i++;									/* next program location */
			if (pflag[i] != PF_INIT && pflag[i] & PF_ASCII)
			{										/* if next byte is flagged as	*/
				if (!is_ascii(pdata[i]))	/* ascii, but is not...			*/
					pflag[i] |= PF_BYTE;		/* then flag it as binary		*/
			}
		}

/*	If previous data was an unconditional transfer, AND current
	location is not referenced by some other opcode, AND current
	byte is 0 or 0FFH, then treat this byte as un-initialized data.
*/

		else if ((j & OPT_XFER) && (!(pflag[i] & PF_REF)) &&
				((!pdata[i]) || (pdata[i] == NO_DATA)))
		{
			if (byte_cnt)				/* since we're going to skip some */
				dump_bytes(i);			/* data, output any pending ascii */
			if (asc_cnt)				/* or binary data remaining in buffers */
				dump_ascii(i);
			if (dump)					/* if ascii or binary output was done, */
			{								/* stick in a newline */
				fprintf(fp, "\n;");
				dump = 0;
				newline++;
			}
			pflag[i] = PF_INIT;				/* flag as uninitialized data */
			i++;
			skip++;
			byte_cnt = 0;
		}

/*	If previous opcode was 0 or 0FFH, AND current location is not
	referenced but is initialized, AND current opcode is 0 or 0ffh,
	un-initialize it.
*/

		else if ((k == 0 || k == 0xff) &&
			(!(pflag[i] & PF_REF)) && (!pdata[i] || pdata[i] == 0xff) &&
			(!(pflag[i] & PF_CLREF)) && !(pflag[i] & PF_NOINIT))
		{
			pflag[i] = PF_INIT;				/* flag as uninitialized data */
			i++;
			skip++;
			fprintf(fp, "\t; data truncated");
			j = -1;
		}

		else								/**** IT'S EXECUTABLE CODE! ****/
		{
			pflag[i] &= ~PF_NOINIT;	/* clear for label search in pass 3 */
			if (byte_cnt)				/* if any ascii or binary data remains */
				dump_bytes(i);			/* in the buffers, output them now */
			if (asc_cnt)
				dump_ascii(i);
			if (dump)
			{
				fprintf(fp, "\n;");
				dump = 0;
				newline++;
			}
			byte_cnt = 0;
			if (skip)						/* insert ORG statement */
			{
				if (!newline)
					fprintf(fp, "\n;");
				fprintf(fp, "\n\torg\t");
				puthex(i);
				fprintf(fp, "\n;");
				newline++;
				skip = 0;					/* reset skip flag */
			}
			k = pdata[i] & 0xff;			/* get opcode offset into table */
			if (k == 0xe5)
				mbank = 0;					/* set memory bank */
			if (k == 0xf5)
				mbank = 1;
			j = optbl[k];
			if (j == OPT_INVAL && !newline)
			{
				fprintf(fp, "\n;");
				newline++;
			}
			chk_ref(i);						/* add label if referenced */
			kcnt = 0;
			doopcode(mnemtbl[k].mnem);	/* output opcode */

	/* Generate operands */

			if (j == OPT_INVAL)			/* if invalid opcode */
				puthex(k);					/* put hex defb in file */

			else if (j == OPT_IMM)		/* if immediate data */
			{
				cptr = find_entry(pdata[i + 1], symbol_count, sym_val_index);
				if (cptr == NULL)
					puthex(pdata[i + 1] & 0xff);
				else
					kcnt += fprintf(fp, "%s", cptr);
				splitcheck(i+1);								/* test for split ref */
			}

			else if ((j & 0xf) == OPT_PAGE)		/* if page address */
			{
				q = (i & 0xff00) | (pdata[i+1] & 0xff);
				cptr = find_entry(q, label_count, lab_val_index);
				if (cptr == NULL)
					kcnt += fprintf(fp, "X%04x", q);	/* put address */
				else
					kcnt += fprintf(fp, "%s", cptr);
				splitcheck(i+1);
			}

			else if ((j & 0xf) == OPT_EXT)		/* if extended address */
			{
				q = ((k & 0xe0) << 3) | (pdata[i+1] & 0xff);
				if (mbank)
					q |= 0x800;
				cptr = find_entry(q, label_count, lab_val_index);
				if (cptr == NULL)
					kcnt += fprintf(fp, "X%04x", q);
				else
					kcnt += fprintf(fp, "%s", cptr);
				mbank = (i < 2048) ? 0 : 1;
				splitcheck(i+1);
			}

			if (hexflag)				/* do comment field */
			{
				while (kcnt < TSTOP)
				{
					putc('\t', fp);
					kcnt = (kcnt + 8) & 0x78;
				}
				fprintf(fp,"\t; %04x - %02x", i, pdata[i] & 0xff);
				if (bctbl[k] > 1)
					fprintf(fp, " %02x", pdata[i + 1] & 0xff);
				fprintf(fp, "\t%c", ascii(pdata[i]));
				if (bctbl[k] > 1)
					fprintf(fp, "%c", ascii(pdata[i + 1]));
			}

			newline = 0;
			if ((j & OPT_XFER) | (j == OPT_INVAL))
			{											/* if unconditional transfer or */
				fprintf(fp, "\n;");				/* invalid code, add a newline */
				newline++;
			}
			i += bctbl[k];							/* update location counter */
		}
		if (i == 2048)
			mbank = 1;								/* passing into upper bank */
		if (!(i & 0xff))
			putchar('.');							/* show progress every 256 bytes */
	}
	if (byte_cnt)					/* if any remaining ascii or binary, */
		dump_bytes(i);				/* output it now */
	if (asc_cnt)
		dump_ascii(i);
	printf("\rPass 2 - Source generation complete");
}

/*********************************************************************
 *																							*
 *						Pass three of disassembly									*
 *	Search for references to un-initialized data or split references	*
 *	and, if found, generate EQU statements for them.						*
 *																							*
 *********************************************************************/

void pass3(void)
{
	word	i, j, index, val;
	struct sym	*ptr;
	char	*cptr;

	printf("\nPass 3");

	/* search label table for labels referenced but not generated */

	j = 1;
	for (index=0; index<label_count; index++)
	{
		ptr = lab_val_index[index];
		if (ptr->used)
		{
			val = ptr->val;
			val = (word) pflag[val];
			val &= (PF_NOINIT | PF_CLREF | PF_SPLIT | PF_REF);
			if (val == (PF_REF | PF_SPLIT) || val == (PF_REF | PF_NOINIT))
			{
				if (j)								/* do header if first one */
				{
					j = 0;
					if (!newline || dump)
						fprintf(fp, "\n;");
					fprintf(fp, "\n;\tlabel equates\n;\n;"
						"  these are labels in the control file that reference\n;"
						"  the middle of a multibyte instruction or reference\n;"
						"  an address outside the initialized space\n;");
				}
				fprintf(fp, "\n%s\tequ\t", ptr->name);
				puthex(ptr->val);
				newline = 0;
			}
		}
	}

	/* now do equates for symbol table */

	j = 1;
	for (index=0; index<symbol_count; index++)
	{
		ptr = sym_val_index[index];
		if (ptr->used)								/* do header if first one */
		{
			if (j)
			{
				j = 0;
				if (!newline || dump)
					fprintf(fp, "\n;");
				fprintf(fp, "\n;\tsymbol equates\n;\n;"
								"  these are symbols from the control\n;"
								"  file that are referenced in the code\n;");
			}
			fprintf(fp, "\n%s\tequ\t", ptr->name);
			puthex(ptr->val);
			newline = 0;
		}
	}

	j = 1;
	for (i=0; i<PSIZE; i++)
	{
		if (pflag[i] & PF_REF)		/* if is un-initialized or is referenced */
		{
			if (!(pflag[i] & PF_CLREF) && (pflag[i] & PF_SPLIT))
			{						/* ignore if not referenced or not split opcode */
				cptr = find_entry(i, label_count, lab_val_index);
				if (cptr == NULL)					/* if not in label list */
				{
					if (j)			/* do a newline if first one */
					{
						j = 0;
						if (!newline || dump)
							fprintf(fp, "\n;");
						fprintf(fp, "\n;\tmiscellaneous equates\n;\n;"
										"  these are addresses referenced in the code but\n;"
										"  which are in the middle of a multibyte instruction\n;"
										"  or are addresses outside the initialized space\n;");
						newline = 0;
					}
					fprintf(fp, "\nX%04x\tequ\t", i);		/* do EQU statement */
					puthex(i);
				}
			}
		}
	}
	printf("\rPass 3 - Equate generation complete");
	if (!newline || dump)
		fprintf(fp, "\n");
	fprintf(fp, ";\n\tend\n;\n\n");				/* finally, we're done */
	fflush(fp);
	fclose(fp);
}										/*  End of Pass 3 */

/***************************************
 *													*
 *		Output opcode for current code	*
 *													*
 ***************************************/

void doopcode(char *str)
{
	char	c;

	if (!*str)						/* if invalid opcode... */
	{
		kcnt += fprintf(fp, "%s\t", defbstr);
		kcnt = (kcnt + 8) & 0x78;		/* fprintf treats \t as a single char */
	}
	else								/* executable code */
	{
		c = *str++;
		while (c)
		{
			if (c == ' ')
			{
				putc('\t', fp);
				kcnt = (kcnt + 8) & 0x78;
			}
			else
			{
				putc(c, fp);
				kcnt++;
			}
			c = *str++;
		}
	}
}

/***************************************************
 *																	*
 *		Check for reference to address in middle of	*
 *		code and flag split reference if true			*
 *																	*
 ***************************************************/

void splitcheck(word i)
{
	if (!(pflag[i] & PF_CLREF))	/* ignore if not referenced */
		pflag[i] |= PF_SPLIT;		/* else flag split ref */
}

/*********************************************************************
 *																							*
 *	add label to output line if current location marked as referenced	*
 *																							*
 *********************************************************************/

void chk_ref(word i)
{
	int	cnt;
	char	*cptr;

	if ((pflag[i] & (PF_REF | PF_CLREF)) == PF_REF)
	{
		cptr = find_entry(i, label_count, lab_val_index);	/* see if label exists */
		if (cptr == NULL)
			cnt = fprintf(fp, "\nX%04x:", i);	/* if not, output hex value */
		else
			cnt = fprintf(fp, "\n%s:", cptr);	/* else output label text */
		if (cnt > 8)
			fprintf(fp, "\n\t");
		else
			fprintf(fp, "\t");
	}
	else
		fprintf(fp, "\n\t");
}

/************************************************************************
 *																								*
 *		Check if data is printable ascii other than the string delimiter	*
 *																								*
 ************************************************************************/

int is_ascii(byte data)
{
	if (data < ' ' || data > 0x7e || data == '\'')
		return(0);
	return(1);
}

/************************************
 *												*
 *		Output hexadecimal operand		*
 *												*
 ************************************/

void puthex(word j)
{
	if (j < 10)
		kcnt += fprintf(fp, "%x", j);
	else if (j < 16)
		kcnt += fprintf(fp, "0%xh", j);
	else if (j < 0xa0)
		kcnt += fprintf(fp, "%xh", j);
	else if (j < 0x100)
		kcnt += fprintf(fp, "0%xh", j);
	else if (j < 0xa00)
		kcnt += fprintf(fp, "%xh", j);
	else if (j < 0x1000)
		kcnt += fprintf(fp, "0%xh", j);
	else if (j < 0xa000)
		kcnt += fprintf(fp, "%xh", j);
	else
		kcnt += fprintf(fp, "0%xh", j);
}

/******************************************
 *														*
 *		Convert code to printable ascii		*
 *														*
 ******************************************/

int ascii(int i)
{
	i = i & 0x7f;
	if (i == 0x7f)
		return ('.');
	else if (i < 0x20)
		return ('.');
	else
		return (i);
}

/************************************************
 *																*
 *		Output ascii data accumulated in buffer	*
 *																*
 ************************************************/

void dump_ascii(word adrs)
{
	word	padrs, off, cnt;
	char	*cptr;

	padrs = adrs - asc_cnt;			/* print address for comment field */
	adrs = padrs;						/* address in program array */
	cnt = off = 0;						/* cnt = char count, off = buffer offset */
	while (asc_cnt)					/* while data in ascii buffer... */
	{
		if (pflag[adrs] & PF_REF)		/* if addresss is referenced... */
		{
			if (cnt)
			{
				putc('\'', fp);			/* terminate line */
				kcnt++;
				if (hexflag)				/* if comment field requested... */
				{
					do								/* show hex address */
					{
						putc('\t', fp);		/* but tab out to field first */
						kcnt = (kcnt + 8) & 0x78;
					} while (kcnt < XSTOP);

					fprintf(fp, "; %04x", padrs);
				}
				padrs += cnt;					/* update print address */
				cnt = 0;							/* clear char count for this line */
			}
			cptr = find_entry(adrs, label_count, lab_val_index);
												/* see if label exists for this adrs */
			if (cptr == NULL)				/* if not, show address in hex */
				fprintf(fp, "\nX%04x:\t%s\t'", adrs, defbstr);
			else								/* else show label name */
				fprintf(fp, "\n%s:\t%s\t'", cptr, defbstr);
			kcnt = 17;
		}
		else if (!cnt)
		{
			fprintf(fp, "\n\t%s\t'", defbstr);
			kcnt = 17;
		}
		putc(string[off], fp);			/* output data in ascii */
		kcnt++;								/* character position in this line */
		cnt++;								/* increment char in this line */
		off++;								/* increment offset into asci buffer */
		adrs++;								/* offset into program memory */
		if (cnt >= ASCLINE)				/* if max characters per line... */
		{
			putc('\'', fp);				/* terminate line */
			kcnt++;
			if (hexflag)					/* if comment field requested */
			{
				do									/* show hex address */
				{
					putc('\t', fp);
					kcnt = (kcnt + 8) & 0x78;
				} while (kcnt < XSTOP);

				fprintf(fp, "; %04x", padrs);
			}
			padrs += cnt;					/* update print address */
			cnt = 0;
		}
		--asc_cnt;
	}
	putc('\'', fp);					/* terminate line */
	kcnt++;
	if (hexflag && cnt)				/* if comment field requested... */
	{
		do										/* show address */
		{
			putc('\t', fp);
			kcnt = (kcnt + 8) & 0x78;
		} while (kcnt < XSTOP);

		fprintf(fp, "; %04x", padrs);
	}
	dump = 1;
}

/************************************************
 *																*
 *		Output binary data accumulated in buffer	*
 *																*
 ************************************************/

void dump_bytes(word adrs)
{
	word	padrs, bcnt, off, k;
	char	*cptr, chr;

	padrs = adrs - byte_cnt;			/* compute adrs to print in ascii part */
	adrs = padrs;
	bcnt = off = 0;						/* no bytes output yet */
	while (byte_cnt)						/* while data in binary buffer... */
	{
		if (pflag[adrs] & PF_REF)		/* if data adrs is referenced... */
		{
			if (off && hexflag)				/* dump any remaining ascii first */
			{
				do
				{
					putc('\t', fp);
					kcnt = (kcnt + 8) & 0x78;
				} while (kcnt < XSTOP);

				fprintf(fp, "; %04x ", padrs);
				for (k=0; k<off; k++)
					putc(ascii(pdata[padrs + k]), fp);
				padrs += k;						/* update print address */
				off = 0;
			}
			cptr = find_entry(adrs, label_count, lab_val_index);	/* then do a label */
			if (cptr == NULL)
				fprintf(fp, "\nX%04x:\t%s\t", adrs, defbstr);
			else
				fprintf(fp, "\n%s:\t%s\t", cptr, defbstr);
			kcnt = 16;
			bcnt = 0;
		}
		else if (!bcnt)						/* else if first byte... */
		{
			kcnt = 16;
			fprintf(fp, "\n\t%s\t", defbstr);
		}
		else
		{
			putc(',', fp);						/* else separate bytes */
			kcnt++;
		}
		cptr = find_entry(pdata[adrs], symbol_count, sym_val_index);
		if (cptr)
			kcnt += fprintf(fp, "%s", cptr);
		else
		{
			if (!pflag[adrs] & PF_ASCII)
				puthex(pdata[adrs]);
			else									/* user defined this as ascii text */
			{										/* even though it's not; let's try */
				chr = pdata[adrs];			/* to give him what he wants. */
				if (chr & 0x80)				/* if flagged binary byte because */
				{									/* high bit is set... */
					chr &= 0x7f;
					if (chr >= ' ' && chr <= 'z')		/* would it be ascii */
					{											/* without bit 7 set? */
						kcnt += fprintf(fp, "'%c'+80h", chr);	/* yes */
						bcnt += 3;
					}
					else							/* else do as binary and remove */
					{								/* ascii flag */
						puthex(pdata[adrs]);
						pflag[adrs] &= ~PF_ASCII;
					}
				}
				else								/* high bit not set, so is */
				{									/* really binary, not ascii */
					puthex(pdata[adrs]);
					pflag[adrs] &= ~PF_ASCII;
				}
			}
		}
		bcnt++;
		if (bcnt >= BYTELINE)				/* if max bytes per line... */
		{
			bcnt = 0;
			if (hexflag)						/* do ascii dump of previous bytes */
			{
				do
				{
					putc('\t', fp);
					kcnt = (kcnt + 8) & 0x78;
				} while (kcnt < XSTOP);

				fprintf(fp, "; %04x ", padrs);
				for (k=0; k<BYTELINE; k++)
				{
					if (!(pflag[padrs + k] & PF_ASCII))		/* don't show ascii */
						putc(ascii(pdata[padrs + k]), fp);	/* if already ascii */
				}
				padrs += k;
				off = 0;
			}
		}
		else
			off++;
		--byte_cnt;
		adrs++;
	}
	if (off && hexflag)					/* generate comment line */
	{
		do
		{
			putc('\t', fp);
			kcnt = (kcnt + 8) & 0x78;
		} while (kcnt < XSTOP);

		fprintf(fp, "; %04x ", padrs);	/* show address and ascii for data */
		for (k=0; k<off; k++)
		{
			if (!(pflag[padrs + k] & PF_ASCII))		/* don't show ascii */
				putc(ascii(pdata[padrs + k]), fp);	/* if already ascii */
		}
	}
	dump = 1;
}

/* end of d48pass.c */

