// Savings, investment account calculator,
// for determining accumulated interest on account over time.
// A demonstration program written by Robert J. Manning,
// South Bay Computer Assistance.
// Copyright 1995 where applicable.

#include <conio.h>
#include <stdio.h>
#include <math.h>

void end(int reason);

void main(void)
{
	float amount = 0.0, interest = 0.0, endBalance = 0.0, years = 0.0;
	int comp = 0, choice = 0;

	do
	{
		textcolor(15);
		textbackground(1);
		clrscr();
		gotoxy(12,3);
		cprintf("ͻ\r\n");
		gotoxy(12,4);
		cprintf(" Calculator to find savings account balance over time. \r\n");
		gotoxy(12,5);
		cprintf("   Utility program courtesy of Robert Manning, SBCA.   \r\n");
		gotoxy(12,6);
		cprintf("ͼ\r\n");

		gotoxy(20,8);
		cprintf("The formula used for this calculation is:");
		gotoxy(4,9);
		cprintf("Amount = Principle * ((1 + Interest/Compounding) ^ (Compounding * Years))");

		gotoxy(13,11);
		cprintf("Enter the current account balance: $");
		cscanf("%10f", &amount);
		if (amount <= 0.0) end(1);

		gotoxy(13,12);
		cprintf("Enter the interest rate (ie, enter 5 for 5%): ");
		cscanf("%10f", &interest);
		if (interest <= 0.0) end(2);
		if (interest > 1) interest /= 100;

		gotoxy(13,13);
		cprintf("Enter compounding periods per year (ie, 12 for monthly): ");
		cscanf("%5d", &comp);
		if (comp < 1) end(3);

		gotoxy(13,14);
		cprintf("Enter the time in years to consider this investment: ");
		cscanf("%5f", &years);
		if (years < 0) end(4);

		endBalance = pow(((interest/comp)+1), (comp * years));
		endBalance *= amount;
		gotoxy(13,16);
		cprintf("%1.2f = %1.2f * ((1 + %1.2f / %d) ^ (%d * %1.1f))",
			endBalance, interest, interest, comp, comp, years);
		gotoxy(13,18);
		cprintf("So, the balance of your $%1.2f account at the end of", amount);
		gotoxy(13,19);
		cprintf("%1.1f years, at %1.2f%% interest will be $%1.2f", years, interest, endBalance);
		gotoxy(13,21);
		cprintf("Calculate again (Y/N) ");
		while (kbhit()) getch();
		choice = getch();
	} while ((choice == 'Y') || (choice == 'y'));
textcolor(7);
textbackground(0);
return;
}

void end(int reason)
{
	textcolor(7);
	textbackground(0);
	clrscr();
	switch (reason)
	{
		case 1: printf("Amount must be greater than zero!\n"); break;
		case 2: printf("Interest must be greater than zero!\n"); break;
		case 3: printf("Compounding must be at least 1 (Annual)!\n"); break;
		case 4: printf("Time in years must be greater than zero!\n"); break;
	}
	printf("Sorry, program terminated!\n");
	abort();
	return;
}