program savings(input, output);
uses dos, crt;
var
   amount, interest, endBalance: real;
   comp, years: integer;
   choice: string;

{ Note Pascal doesn't have a power function, so here's one to use: }

function Power(Y, X: real): real;
   begin
      Power := Exp(X * Ln(Y)); { Note: A^x = e^(x Ln A) }
   end;

begin {* main *}
  choice := 'Y';
  while (choice = 'Y') or (choice = 'y') do
  begin
   clrscr;
   writeln('Calculator to find savings account balance over time.');
   writeln(' ');
   writeln('Enter the current account balance: ');
   readln(amount);
   writeln('Enter the interest rate (ie, enter 5 for 5%): ');
   readln(interest);
   if (interest > 1) then interest := interest / 100;
   writeln('Enter compounding periods per year (ie, 12 for monthly): ');
   readln(comp);
   writeln('Enter the time in years to consider this investment: ');
   readln(years);
   writeln(' ');
   writeln('The formula used for this calculation is:');
   writeln('Amount = Principle * ((1 + Interest/Compounding) ^ (Compounding * Years))');
   writeln(' ');
   writeln('Using the amounts you entered, this formula becomes:');
   endBalance := Power(((interest / comp) + 1), (comp * years)) * amount;
   writeln(endBalance:2:2, ' = ', amount:2:2, ' * ((1 + ', interest:1:2, ' / ', comp:2, ') ^ (', comp:2, ' * ', years:2, '))');
   writeln(' ');
   writeln('So, the balance of your $', amount:2:2, ' account at the end of ', years, ' years,');
   writeln('at ', interest * 100:2:1, '% interest will be $', endBalance:2:2);
   writeln(' ');
   writeln('Calculate again (Y/N) ?');
   readln(choice);
  end;
end.
