{ database record definition for hschurch dataset, note that all records
  are not used in every program but are here for common definitions.
  The dates (longint) are managed using the TP4IO.TPU unit.
  Homogenized Software, Gerry Rohr, RR#3, Anamosa, Iowa 52205.
}
type
   keystring = string[25];

   mail_rec = record
      mail_stat :longint;
      mail_no   :integer;
      category  :string[2];
      lastname  :string[25];
      firstname :string[20];
      title     :string[10];
      address   :string[30];
      city      :string[20];
      state     :string[2];
      zip       :string[10];
      special1  :string[2];
      special2  :string[2];
      special3  :string[2];
      date_reg  :longint;
      andfamily :string[1];
      mailout   :string[1];
      homephone :string[14];
      publish   :string[1];
      visitarea :string[4];
      marital   :string[1];
      note1     :string[30];
      whovisits :string[3];
   end;

   memb_rec = record
      memb_stat :longint;
      mail_no   :integer;
      pers_no   :integer;
      status    :string[2];
      lastname  :string[25];
      firstname :string[20];
      middlename:string[20];
      title     :string[10];
      relation  :string[1];
      m_f       :string[1];
      workphone :string[20];
      adult     :string[1];
      occupat   :string[30];
      employed  :string[30];
      code1     :string[2];
      code2     :string[2];
      code3     :string[2];
      code4     :string[2];
      code5     :string[2];
      born      :longint;
      married   :longint;
      membsince :longint;
      confirmed :longint;
      baptized  :longint;
      date6     :longint;
      date7     :longint;
      date8     :longint;
      env_no    :integer;
      pers_id   :integer;
      father_id :integer;
      mother_id :integer;
   end;

   memx_rec = record
      memx_stat :longint;
      pers_id   :integer;
      c_no      :integer;
      comment   :string[60];
   end;

   l_rec = record              { Master List record }
      list_stat :longint;
      pers_id  :integer;
      ldate    :longint;       { YYYYMMMDDD }
      majorlst :integer;
      minorlst :integer;
   end;

   r_rec = record                { Contribution record }
      r_stat      :longint;
      pers_id     :integer;
      ldate       :longint;      { YYYYMMDD }
      contrib     :real;         { Contribution field }
      fund        :integer;      { Special Fund or note type.  The
                                   Fund numbers are in monyfund.dat. }
   end;

   n_rec = record                { note record format }
      n_stat      :longint;
      id_no       :integer;      { Family ID number if - else person number }
      ldate       :longint;      { YYYYMMDD }
      code1       :string[4];    { codes to define lists }
      code2       :string[4];
      note        :string[50];   { the actual note }
   end;

   l_desc = record               { defines the list types used }
      desc        :string[20];
      major       :integer;
      minor       :integer;
   end;

   r_desc = record               { fund descriptions for the money database}
      fund        :integer;
      desc        :string[20];
   end;

   MaxDataType = memb_rec;   { largest data record type }
   MaxKeyType = keystring;   { largest key allowed }
