#include "cdascii.h"
#include "cdmcrt.h"

#define OKAY 0
#define FAIL 1

char far*fldNames[ MAXFIELDS ];
char far*fldTypes[ MAXFIELDS ];

REQUIREDFIELDARRAY TR_TrackRecord[] =
  {
    { 3, "Disc ID",          "N",    1 },
    { 3, "Track ID",         "N",    2 },
    { 1, "Title",            "A80",  3 },
    { 1, "Min",              "S",    4 },
    { 1, "Sec",              "S",    5 },
    { 1, "Sec100",           "S",    6 }
  };

REQUIREDFIELDARRAY DR_DiscRecord[] =
  {
    { 3, "Disc ID",          "N",    1 },
    { 1, "Artist",           "A80",  2 },
    { 1, "Title",            "A80",  3 },
    { 1, "Tracks",           "S",    4 },
    { 1, "Min",              "S",    5 },
    { 1, "Sec",              "S",    6 },
    { 1, "Entry Date",	     "D",    7 }
  };

REQUIREDFIELDARRAY *TR_TrackArray[ 24 ];
extern char MouseChar;
extern ColorSet EsColors,
		cdColors;
RawWindow lcWindow;
char lcString[ 80 ];

/*--------------------------------------------------------------------------*/
int Error( int lcRC )
  {
    if ( lcRC != PXSUCCESS )
      {
	CharStr( ' ', 78, lcString );
        lcWindow.wFastText( lcString, 20, 2 );
	sprintf( lcString, "CDASCII: %s", PXErrMsg( lcRC ) );
	lcWindow.wFastText( lcString, 20, 2 );
      }

    return lcRC;
  }

/*--------------------------------------------------------------------------*/
word track_scrn( int lctracks )
{
  word Status;
  ScrollingEntryScreen ES;

  OPEntryInit();

  #if defined(UseMouse)
  if (MouseInstalled) {
      //activate mouse cursor
      SoftMouseCursor(0x0000, (ColorMono(EsColors.MouseColor, EsColors.MouseMono) << 8)+
			     MouseChar);
      ShowMouse();
      //enable mouse support
      EntryCommands.cpOptionsOn(cpEnableMouse);
    };
  #endif

  //initialize entry screen
  Status = cd_trackscrn( ES, EsColors, lctracks );
  if (Status != 0) {
    printf("Error initializing entry screen: %u\r\n", Status);
    exit( 0 );
    return Status;
  };

  ES.Process();
  ES.Erase();
  #if defined(UseMouse)
  HideMouse();
  #endif
  Status = ES.GetLastCommand();
  ES.Done();
  return Status;
};

TABLEHANDLE glDiscTable;
RECORDHANDLE glDiscRecord;

/*--------------------------------------------------------------------------*/
void PickTitle( word lcItem, pkMode lcMode,
                pkItemType &lcType, char *lcIString,
                PickListPtr PickPtr )
  {
    int lcRC,
        lcDone = 0,
        lcCount = 0;

    lcRC = Error( PXSrchFld( glDiscTable, glDiscRecord, DR_DiscRecord[ DR_Artist ].fldHandle, SEARCHFIRST ) );
    do
      {      
        lcCount++;
        if ( ( lcItem == lcCount ) &&
             ( lcRC == PXSUCCESS ) )
          {
            if ( lcRC == PXSUCCESS )
              lcRC = Error( PXRecGet( glDiscTable, glDiscRecord ) );
            if ( lcRC == PXSUCCESS )
              lcRC = Error( PXGetAlpha( glDiscRecord, DR_DiscRecord[ DR_Title ].fldHandle, BUFSIZ, DR_DiscRecord[ DR_Title ].fldBuffer ) );
            strcpy( lcIString, DR_DiscRecord[ DR_Title ].fldBuffer );
            lcDone = 1;
          }
         if ( ( lcRC == PXSUCCESS ) &&
              ( !lcDone ) )
           lcRC = PXSrchFld( glDiscTable, glDiscRecord, DR_DiscRecord[ DR_Artist ].fldHandle, SEARCHNEXT );
      }
    while ( ( lcRC == PXSUCCESS ) &&
            ( !lcDone ) );
  }

/*--------------------------------------------------------------------------*/
word disc_search( TABLEHANDLE lcDiscTable, RECORDHANDLE lcDiscRecord )
  {
    PickList lcPick;
    int lcRC,
        lcCount;
    long lcLong;
    word lcCmd = ccUser2;

    lcRC = Error( PXPutAlpha( lcDiscRecord, DR_DiscRecord[ DR_Artist ].fldHandle, DR_DiscRecord[ DR_Artist].fldBuffer ) );
    if ( lcRC == PXSUCCESS )
      lcRC = PXSrchFld( lcDiscTable, lcDiscRecord, DR_DiscRecord[ DR_Artist ].fldHandle, SEARCHFIRST );
    if ( lcRC == PXSUCCESS )
      {
        lcCount = 0;
        do
          {
            lcRC = PXSrchFld( lcDiscTable, lcDiscRecord, DR_DiscRecord[ DR_Artist ].fldHandle, SEARCHNEXT );
            lcCount++;
          }
        while ( lcRC == PXSUCCESS );
        glDiscTable = lcDiscTable;
        glDiscRecord = lcDiscRecord;

        OPPickInit();
        lcRC = lcPick.InitCustom ( 35, 10, 70, 20,
                            EsColors,
                            DefWindowOptions | wBordered,
                            35,
                            lcCount,
                            PickTitle,
                            PickVertical,
                            SingleChoice );
        lcPick.SetSearchMode(PickCharSearch);
        lcPick.wFrame.AddShadow( shBR, shOverWrite);
        lcPick.wFrame.AddHeader( DR_DiscRecord[ DR_Artist ].fldBuffer, heTL );
        lcPick.Process();
        lcPick.Erase();
        //get selection
        if ( lcPick.GetLastCommand() == ccSelect )
          {
            lcCmd = ccUser4;
            lcRC = Error( PXGetLong( glDiscRecord, DR_DiscRecord[ DR_DiscID ].fldHandle, &lcLong ) );
            sprintf( DR_DiscRecord[ DR_DiscID ].fldBuffer, "%ld", lcLong );
          }
        lcPick.Done();
      }
    else
      {
        lcWindow.wFastText( "CDMUSIC: Artist Search Failed", 20, 2 );
      }
    return lcCmd;
  }

/*--------------------------------------------------------------------------*/
word cd_scrn( TABLEHANDLE lcDiscTable, RECORDHANDLE lcDiscRecord )
{
  word Status;
  EntryScreen ES;

  OPEntryInit();

  #if defined(UseMouse)
  if (MouseInstalled) {
      //activate mouse cursor
      SoftMouseCursor(0x0000, (ColorMono(EsColors.MouseColor, EsColors.MouseMono) << 8)+
			     MouseChar);
      ShowMouse();
      //enable mouse support
      EntryCommands.cpOptionsOn(cpEnableMouse);
    };
  #endif

  //initialize entry screen
  Status = cd_discscrn(ES, EsColors );
  if (Status != 0) {
    printf("Error initializing entry screen: %u\r\n", Status);
    exit( 0 );
    return Status;
  };

  EntryCommands.AddCommand( ccUser0, 1, 0x3B00, 0 );
  EntryCommands.AddCommand( ccUser1, 1, 0x3C00, 0 );
  EntryCommands.AddCommand( ccUser2, 1, 0x3D00, 0 );

  do
    {
      ES.Process();
      Status = ES.GetLastCommand();
      if ( Status == ccUser2 )
        {
          Status = disc_search( lcDiscTable, lcDiscRecord );
        }
    }
  while ( Status == ccUser2 );
  ES.Erase();
  #if defined(UseMouse)
  HideMouse();
  #endif
  ES.Done();
  return Status;
};

//--------------------------------------------------------------------------
int GetData( REQUIREDFIELDARRAY *lcFieldArray, RECORDHANDLE lcRecordHandle, int lcField )
  {
    long theDate;
    int month, day, year;
    double theValue;
    short theShort;
    int isBlank;
    FIELDHANDLE lcFieldHandle;

    lcFieldHandle = lcFieldArray[ lcField ].fldHandle;

    /* if this field is blank, we want to return a blank string */
    if ( !Error( PXFldBlank( lcRecordHandle, lcFieldHandle, &isBlank ) ) )
      {
        if ( isBlank )
        {
            lcFieldArray[ lcField ].fldBuffer[0] = '\0';
            return PXSUCCESS;
        }
      }
    else
        return FAIL;

    //printf( " Get %d", lcFieldArray[ lcField ].fldHandle );
    switch( lcFieldArray[ lcField ].fldType[0] )
      {
        case 'a':
        case 'A':
            if ( Error( PXGetAlpha( lcRecordHandle, lcFieldHandle, BUFSIZ, lcFieldArray[ lcField ].fldBuffer ) ) )
		return FAIL;
            break;
        case 'd':
        case 'D':
	    if ( !Error( PXGetDate( lcRecordHandle, lcFieldHandle, &theDate ) ) )
            {
                PXDateDecode( theDate, &month, &day, &year );
                sprintf( lcFieldArray[ lcField ].fldBuffer, "%d/%d/%d", month, day, year );
            }
            else
                return FAIL;
	    break;
        case 'n':
        case 'N':
            if ( !Error( PXGetDoub( lcRecordHandle, lcFieldHandle, &theValue ) ) )
                sprintf( lcFieldArray[ lcField ].fldBuffer, "%5.0lf", theValue );
            else
                return FAIL;
            break;
        case '$':
            if ( !Error( PXGetDoub( lcRecordHandle, lcFieldHandle, &theValue ) ) )
                sprintf( lcFieldArray[ lcField ].fldBuffer, "%4.2lf", theValue );
            else
                return FAIL;
            break;
        case 's':
        case 'S':
            if ( !Error( PXGetShort( lcRecordHandle, lcFieldHandle, &theShort ) ) )
                sprintf( lcFieldArray[ lcField ].fldBuffer, "%d", theShort );
            else
                return FAIL;
            break;
      }
    return( PXSUCCESS );
  }

/*--------------------------------------------------------------------------*/
int PutData( REQUIREDFIELDARRAY *lcFieldArray,
             RECORDHANDLE lcRecordHandle,
	     int lcField )
{
    long theDate;
    int month, day, year;
    double theValue;
    short theShort;

    /* If the field is blank, put a blank into the record buffer. */
    if ( strlen( lcFieldArray[ lcField ].fldBuffer ) == 0 )
      {
	if ( Error( PXPutBlank( lcRecordHandle, lcFieldArray[ lcField ].fldHandle ) ) != PXSUCCESS )
          {
	    return FAIL;
          }
	else
	  {
	    return PXSUCCESS;
          }
      }

    //printf( " Put %d", lcFieldArray[ lcField ].fldHandle );
    switch( lcFieldArray[ lcField ].fldType[0] )
    {
        case 'a':
        case 'A':
	    if ( Error( PXPutAlpha( lcRecordHandle, lcFieldArray[ lcField ].fldHandle, lcFieldArray[ lcField ].fldBuffer ) ) )
                return FAIL;
            break;

        case 'D':
        case 'd':
            sscanf( lcFieldArray[ lcField ].fldBuffer, "%d/%d/%d", &month, &day, &year );
            if ( ( Error( PXDateEncode( month, day, year, &theDate ) ) ) ||
                 ( Error( PXPutDate( lcRecordHandle, lcFieldArray[ lcField ].fldHandle, theDate ) ) ) )
                return FAIL;
	    break;

        case '$':
        case 'N':
        case 'n':
            sscanf( lcFieldArray[ lcField ].fldBuffer, "%lf", &theValue );
            if ( Error( PXPutDoub( lcRecordHandle, lcFieldArray[ lcField ].fldHandle, theValue ) ) )
		return FAIL;
            break;
        case 'S':
        case 's':
            sscanf( lcFieldArray[ lcField ].fldBuffer, "%d", &theShort );
            if ( Error( PXPutShort( lcRecordHandle, lcFieldArray[ lcField ].fldHandle, theShort ) ) )
                return FAIL;
            break;
    }

    return( PXSUCCESS );
}

/*--------------------------------------------------------------------------*/
int cdfilename( char *lcName )
  {
    DirList lcDir;
    boolean lcDone;

    OPDirInit();

    if ( !lcDir.InitCustom( 25, 5, 55, 18,
                            cdColors, DefWindowOptions | wBordered,
                            ( long )coreleft, PickVertical, SingleFile ) )
      {
        return( 1 );
      }

    lcDir.SetPadSize( 1, 1 );
    lcDir.diOptionsOn( diOptimizeSize + diShowDrives );
    lcDir.AddMaskHeader( TRUE, 1, 30, heTC );
    lcDir.SetSortOrder( SortDirName );
    lcDir.SetNameSizeTimeFormat( "<dir>", "Mm/dd/yy", "Hh:mmt" );
    lcDir.SetMask( "*.*", dAnyFile );

    lcDone = FALSE;

    do
      {
        lcDir.Process();
        switch( lcDir.GetLastCommand( ) )
          {
            case ccSelect :  {
                                lcDir.GetSelectedPath( *( PathStr* ) lcName );
                                lcDone = TRUE;
                                break;
                             }
            case ccError  :  {
                                Long2Str( lcDir.RawError( ), lcName );
                                break;
                             }
            case ccQuit   :  {
                                lcDone = TRUE;
                             }
          }
      }
    while( !lcDone );

    lcDir.Done();
  }

/*--------------------------------------------------------------------------*/
int process_loop( TABLEHANDLE lcDiscTable, TABLEHANDLE lcTrackTable,
		  RECORDHANDLE lcDiscRecord, RECORDHANDLE lcTrackRecord )
  {
    int lcRC,
        lcMode = 0,
        lcCount = 0,
        lcRow = 1,
        lcPos1,
        lcPos2,
        lcTrack,
        lcField,
        quitcd = 0;
    char lcCat[80],
    lcReturn[80],
         lcStringIn[255];
    FILE *AsciiIn;
    struct date lcDate;

    getdate( &lcDate );
    cdfilename( lcStringIn );
    if ( ( AsciiIn = fopen( lcStringIn, "rt" ) ) == NULL )
      {
        return( 1 );
      }

    while ( ( fscanf( AsciiIn, "%s", lcStringIn ) ) &&
            ( !feof( AsciiIn ) ) &&
            ( Pos( '[', lcStringIn ) == StBadPos ) );
    if ( !feof( AsciiIn ) )
      do
        {
          lcPos1 = Pos( '[', lcStringIn );
          lcPos2 = Pos( ']', lcStringIn );
          if ( ( lcPos1 != StBadPos ) &&
               ( lcPos2 != StBadPos ) )
            {
              Copy( lcStringIn, ( lcPos1 + 1 ), ( lcPos2 - ( lcPos1 + 1 ) ), DR_DiscRecord[ DR_DiscID ].fldBuffer );
              lcRC = PutData( DR_DiscRecord, lcDiscRecord, DR_DiscID );
              if ( ( !fscanf( AsciiIn, "%s", lcStringIn ) ) ||
                   ( feof( AsciiIn ) ) )
                {
                  quitcd = 1;
                }
              else
                {
                  lcPos1 = PosStr( lcStringIn, "DiscTitle" );
                  if ( lcPos1 == StBadPos )
                    {
                      quitcd = 1;
                    }
                  else
                    {
                      strcpy( lcReturn, "" );
                      lcPos1 = Pos( '=', lcStringIn );
                      lcPos2 = Pos( ':', lcStringIn );
                      if ( lcPos2 == StBadPos )
                        while ( lcPos2 == StBadPos )
                          {
                            Copy( lcStringIn, ( lcPos1 + 1 ), ( strlen( lcStringIn ) - ( lcPos1 + 1 ) ), lcCat );
                            strcat( lcReturn, lcCat );
                            strcat( lcReturn, " " );
                            fscanf( AsciiIn, "%s", lcStringIn );
                            lcPos2 = Pos( ':', lcStringIn );
                            lcPos1 = -1;
                          }
                      Copy( lcStringIn, ( lcPos1 + 1 ), ( lcPos2 - ( lcPos1 + 1 ) ), lcCat );
                      strcat( lcReturn, lcCat );
                      strcpy( DR_DiscRecord[ DR_Artist ].fldBuffer, lcReturn );
                      lcRC = PutData( DR_DiscRecord, lcDiscRecord, DR_Artist );
                      strcpy( lcReturn, "" );
                      while ( ( fscanf( AsciiIn, "%s", lcStringIn ) ) &&
                              ( !feof( AsciiIn ) ) &&
                              ( PosStr( "Track", lcStringIn ) == StBadPos ) )
                        {
                          strcat( lcReturn, lcStringIn );
                          strcat( lcReturn, " " );
                        }

                      lcTrack = 0;
                      strcpy( DR_DiscRecord[ DR_Title ].fldBuffer, lcReturn );
                      lcRC = PutData( DR_DiscRecord, lcDiscRecord, DR_Title );
                      strcpy( lcReturn, "" );
                      do
                        {
                          lcPos1 = Pos( '=', lcStringIn );
                          if ( lcPos1 == StBadPos )
                            {
                              strcat( lcReturn, lcStringIn );
                              strcat( lcReturn, " " );
                            }
                          else
                            {
                              if ( strlen( lcReturn ) > 0 )
                                {
                                  strcpy( TR_TrackRecord[ TR_Title ].fldBuffer, lcReturn );
                                  lcRC = PutData( TR_TrackRecord, lcTrackRecord, TR_Title );
                                  strcpy( TR_TrackRecord[ TR_DiscID ].fldBuffer, DR_DiscRecord[ DR_DiscID ].fldBuffer );
                                  lcRC = PutData( TR_TrackRecord, lcTrackRecord, TR_DiscID );
                                  lcTrack++;
                                  sprintf( lcReturn, "%d", lcTrack );
                                  strcpy( TR_TrackRecord[ TR_TrackID ].fldBuffer, lcReturn );
                                  lcRC = PutData( TR_TrackRecord, lcTrackRecord, TR_TrackID );
                                  lcRC = Error( PXRecAppend( lcTrackTable, lcTrackRecord ) );
                                  lcRC = Error( PXSave( ) );
                                }
                              Copy( lcStringIn, ( lcPos1 + 1 ), ( strlen( lcStringIn ) - ( lcPos1 + 1 ) ), lcReturn );
                              strcat( lcReturn, " " );
                            }
                        }
                      while ( ( fscanf( AsciiIn, "%s", lcStringIn ) ) &&
                              ( !feof( AsciiIn ) ) &&
                              ( PosStr( "DiscLength", lcStringIn ) == StBadPos ) );
                      if ( strlen( lcReturn ) > 0 )
                        {
                          strcpy( TR_TrackRecord[ TR_Title ].fldBuffer, lcReturn );
                          lcRC = PutData( TR_TrackRecord, lcTrackRecord, TR_Title );
                          strcpy( TR_TrackRecord[ TR_DiscID ].fldBuffer, DR_DiscRecord[ DR_DiscID ].fldBuffer );
                          lcRC = PutData( TR_TrackRecord, lcTrackRecord, TR_DiscID );
                          lcTrack++;
                          sprintf( lcReturn, "%d", lcTrack );
                          strcpy( TR_TrackRecord[ TR_TrackID ].fldBuffer, lcReturn );
                          lcRC = PutData( TR_TrackRecord, lcTrackRecord, TR_TrackID );
                          lcRC = Error( PXRecAppend( lcTrackTable, lcTrackRecord ) );
                          lcRC = Error( PXSave( ) );
                        }
                      sprintf( lcReturn, "%d", lcTrack );
                      strcpy( DR_DiscRecord[ DR_Tracks ].fldBuffer, lcReturn );
                      lcRC = PutData( DR_DiscRecord, lcDiscRecord, DR_Tracks );


                      lcPos1 = Pos( '=', lcStringIn );
                      lcField = DR_Min;
                      while ( Pos( ':', lcStringIn ) != StBadPos )
                        {
                          lcPos2 = Pos( ':', lcStringIn );
                          Copy( lcStringIn, ( lcPos1 + 1 ), ( lcPos2 - ( lcPos1 + 1 ) ), lcReturn );
                          strcpy( DR_DiscRecord[ lcField ].fldBuffer, lcReturn );
                          lcRC = PutData( DR_DiscRecord, lcDiscRecord, lcField );
                          Copy( lcStringIn, ( lcPos2 + 1 ), ( strlen( lcStringIn ) - ( lcPos2 + 1 ) ), lcStringIn );
                          lcPos1 = -1;
                          lcField++;
                        }
                      sprintf( DR_DiscRecord[ DR_Entry ].fldBuffer, "%d/%d/%d", lcDate.da_mon, lcDate.da_day, lcDate.da_year );
                      lcRC = PutData( DR_DiscRecord, lcDiscRecord, DR_Entry );
                      lcRC = Error( PXRecAppend( lcDiscTable, lcDiscRecord ) );
                      lcRC = Error( PXSave( ) );
                      //forget writing disc 100ths sec
                      //strcpy( DR_DiscRecord[ lcField ].fldBuffer, lcStringIn );
                      //lcRC = PutData( DR_DiscRecord, lcDiscRecord, lcField );

                      lcTrack = 1;
                      sprintf( TR_TrackRecord[ TR_TrackID ].fldBuffer, "%d", lcTrack );
                      lcRC = PutData( TR_TrackRecord, lcTrackRecord, TR_TrackID );
                      lcRC = Error( PXSrchKey( lcTrackTable, lcTrackRecord, 2, SEARCHFIRST ) );
                      lcRC = Error( PXRecGet( lcTrackTable, lcTrackRecord ) );
                      while ( ( fscanf( AsciiIn, "%s", lcStringIn ) ) &&
                              ( !feof( AsciiIn ) ) &&
                              ( Pos( '[', lcStringIn ) == StBadPos ) )
                        {
                          lcField = TR_Min;
                          lcPos1 = Pos( '=', lcStringIn );
                          while ( Pos( ':', lcStringIn ) != StBadPos )
                            {
                              lcPos2 = Pos( ':', lcStringIn );
                              Copy( lcStringIn, ( lcPos1 + 1 ), ( lcPos2 - ( lcPos1 + 1 ) ), lcReturn );
                              strcpy( TR_TrackRecord[ lcField ].fldBuffer, lcReturn );
                              lcRC = PutData( TR_TrackRecord, lcTrackRecord, lcField );
                              lcField++;
                              Copy( lcStringIn, ( lcPos2 + 1 ), ( strlen( lcStringIn ) - ( lcPos2 + 1 ) ), lcStringIn );
                              lcPos1 = -1;
                            }
                          strcpy( TR_TrackRecord[ lcField ].fldBuffer, lcStringIn );
                          lcRC = PutData( TR_TrackRecord, lcTrackRecord, lcField );
                          lcRC = Error( PXRecUpdate( lcTrackTable, lcTrackRecord ) );
                          lcRC = Error( PXSave( ) );
                          lcTrack++;
                          sprintf( TR_TrackRecord[ TR_TrackID ].fldBuffer, "%d", lcTrack );
                          lcRC = PutData( TR_TrackRecord, lcTrackRecord, TR_TrackID );
                          lcRC = Error( PXSrchKey( lcTrackTable, lcTrackRecord, 2, SEARCHFIRST ) );
                          lcRC = Error( PXRecGet( lcTrackTable, lcTrackRecord ) );
                        }
                    }

                }
            }
          else
            {
              quitcd = 1;
            }
        }
      while ( !quitcd );

    fclose( AsciiIn );

    return(OKAY);
  }

/*--------------------------------------------------------------------------*/
int CheckTableStructure( TABLEHANDLE lcTableHandle, REQUIREDFIELDARRAY *lcFieldArray, int lcFields )
  {
    int rc,
        iteration,
	lcFieldCount,
        iteration2;

    rc = PXSUCCESS;
    lcFieldCount = 0;
    rc = Error( PXRecNFlds( lcTableHandle, &lcFieldCount ) );
    for ( iteration = 1; iteration <= lcFields; ++iteration )
      {
	iteration2 = 0;
	while ( stricmp( lcFieldArray[iteration-1].fldName, fldNames[iteration2] ) != 0 &&
		iteration2 <= lcFieldCount-1 )
	  iteration2++;
	if ( stricmp( lcFieldArray[iteration-1].fldName, fldNames[iteration2]) == 0 )
	  {
	    if ( strncmp( lcFieldArray[iteration-1].fldType, fldTypes[iteration2], strlen( lcFieldArray[iteration-1].fldType ) ) == 0 )
	      {
		lcFieldArray[iteration-1].fldHandle = iteration2 + 1;
		lcFieldArray[iteration-1].fldBuffer = (char *) malloc( BUFSIZ );
		rc = PXSUCCESS;
	      }
	    else
	      {
		sprintf( lcString, "ERROR: Type mismatch (%s vs. %s) for Field #%d (%s)\n", fldTypes[iteration2],
										lcFieldArray[iteration - 1].fldType,
										iteration,
										lcFieldArray[iteration-1].fldName);
		lcWindow.wFastText( lcString, 24, 2 );
		iteration = lcFields;
		rc = PXERR_OUTOFRANGE;
	      }
	  }
	else
	  {
	    sprintf( lcString, "ERROR: %d %s MISSING\n", iteration, lcFieldArray[iteration-1].fldName);
	    lcWindow.wFastText( lcString, 24, 2 );
	    iteration = lcFields;
	    rc = PXERR_OUTOFRANGE;
	  }
      }

    return rc;
  }

/*--------------------------------------------------------------------------*/
int GetTableStructure( TABLEHANDLE lcTableHandle )
  {
    int rc;
    FIELDHANDLE lcFieldHandle;
    char fldName[ BUFSIZ ];
    char fldType[ BUFSIZ ];
    int lcFieldCount;

    lcFieldCount = 0;
    rc = Error( PXRecNFlds(lcTableHandle, &lcFieldCount ) );
    if ( rc == PXSUCCESS )
      for ( lcFieldHandle = 1; lcFieldHandle <= lcFieldCount; ++lcFieldHandle )
        {
          rc = Error( PXFldName( lcTableHandle, lcFieldHandle, BUFSIZ, fldName ) );
          if ( rc == PXSUCCESS )
            rc = Error( PXFldType( lcTableHandle, lcFieldHandle, BUFSIZ, fldType ) );
          if ( rc == PXSUCCESS )
            {
              /* printf( "%d\t", fldHandle ); */
              fldNames[ lcFieldHandle-1 ] = strdup( fldName );
              /* printf( "%s\t", fldNames[ fldHandle-1 ] ); */
              fldTypes[ lcFieldHandle-1 ] = strdup( fldType );
              /* printf( "%s\n", fldTypes[ fldHandle-1 ] ); */
            }
          else
            lcFieldHandle = lcFieldCount + 1;
	}

    return rc;
  }

/*--------------------------------------------------------------------------*/
int DeleteTableStructure( TABLEHANDLE lcTableHandle )
  {
    int rc;
    FIELDHANDLE lcFieldHandle;
    char fldName[ BUFSIZ ];
    char fldType[ BUFSIZ ];
    int lcFieldCount;

    lcFieldCount = 0;
    rc = Error( PXRecNFlds(lcTableHandle, &lcFieldCount ) );
    if ( rc == PXSUCCESS )
      for ( lcFieldHandle = lcFieldCount; lcFieldHandle >= 1; --lcFieldHandle )
        {
	  free( (void *)fldTypes[ lcFieldHandle - 1 ] );
	  free( (void *)fldNames[ lcFieldHandle - 1 ] );
        }

    return rc;
  }

/*--------------------------------------------------------------------------*/
int MakeTable( TABLEHANDLE *lcTableHandle, REQUIREDFIELDARRAY *lcFieldArray,
	       char *lcTableName, RECORDHANDLE *lcRecordHandle, int lcFields )
  {
    FIELDHANDLE lcKeyHandles[ ] = { 1, 2, 3 };
    int  iteration,
	 lcKeyFields,
         lcRC;
    char far*lcfldNames[ MAXFIELDS ];
    char far*lcfldTypes[ MAXFIELDS ];

    CharStr( ' ', 40, lcString);
    lcWindow.wFastText( lcString, 5, 20 );
    sprintf( lcString, "Making %s", lcTableName );
    lcWindow.wFastText( lcString, 5, 20 );
    lcKeyFields = 0;
    for ( iteration = 1; iteration <= lcFields; ++iteration )
      {
	if ( lcFieldArray[ iteration - 1 ].required == 3 )
	  {
	    lcKeyFields++;
	  }
	lcfldNames[ iteration - 1 ] = strdup( lcFieldArray[ iteration - 1 ].fldName );
	lcfldTypes[ iteration - 1 ] = strdup( lcFieldArray[ iteration - 1 ].fldType );
      }

    lcRC = Error( PXTblCreate( lcTableName, lcFields, lcfldNames, lcfldTypes ) );
    if ( lcRC == PXSUCCESS )
      lcRC = Error( PXKeyAdd( lcTableName, lcKeyFields, lcKeyHandles, PRIMARY ) );
    if ( lcRC == PXSUCCESS )
      lcRC = Error( PXTblOpen( lcTableName, lcTableHandle, 0, 0 ) );
    if ( lcRC == PXSUCCESS )
      lcRC = Error( PXRecBufOpen( *lcTableHandle, lcRecordHandle ) );

    for ( iteration = 1; iteration <= lcFields; ++iteration )
      {
	free( (void *)lcfldNames[ iteration - 1 ] );
	free( (void *)lcfldTypes[ iteration - 1 ] );
	lcFieldArray[ iteration - 1 ].fldBuffer = (char *) malloc( BUFSIZ );
      }

    return lcRC;
  }

/*--------------------------------------------------------------------------*/
  int process_main( void )
    {
      int exist,
          lcrc;
      RECORDHANDLE lcDiscRecord,
                   lcTrackRecord;
      TABLEHANDLE  lcDiscTable,
		   lcTrackTable;

      OPRawWindowInit();

      lcWindow.InitCustom( 2, 2, 79, 23, cdColors, wBordered + wClear );
      lcWindow.wFrame.AddHeader( "CDMUSIC Status Window", heTC );
      lcWindow.Draw();

      lcrc = Error( PXTblExist( "DISC", &exist ) );
      if ( lcrc == PXSUCCESS )
	{
	  if ( exist )
	    {
	      lcrc = Error( PXTblOpen( "DISC", &lcDiscTable, 0, 0 ) );
	      if ( lcrc == PXSUCCESS )
		lcrc = Error( PXRecBufOpen( lcDiscTable, &lcDiscRecord ) );
	    }
	  else
	    {
	      lcrc = MakeTable( &lcDiscTable, DR_DiscRecord, "DISC", &lcDiscRecord, DR_LASTFIELD + 1 );
	    }
	}
      if ( lcrc == PXSUCCESS )
	{
	  if ( lcrc == PXSUCCESS )
	    lcrc = GetTableStructure( lcDiscTable );
	  if ( lcrc == PXSUCCESS )
	    lcrc = CheckTableStructure( lcDiscTable, DR_DiscRecord, DR_LASTFIELD + 1 );
	  if ( lcrc == PXSUCCESS )
	    lcrc = DeleteTableStructure( lcDiscTable );
	}

      if ( lcrc == PXSUCCESS )
	lcrc = Error( PXTblExist( "TRACK", &exist ) );
      if ( lcrc == PXSUCCESS )
	{
	  if ( exist )
	    {
	      lcrc = Error( PXTblOpen( "TRACK", &lcTrackTable, 0, 0 ) );
	      if ( lcrc == PXSUCCESS )
		lcrc = Error( PXRecBufOpen( lcTrackTable, &lcTrackRecord ) );
	    }
	  else
	    {
	      lcrc = MakeTable( &lcTrackTable, TR_TrackRecord, "TRACK", &lcTrackRecord, TR_LASTFIELD + 1 );
	    }
	}
      if ( lcrc == PXSUCCESS )
	{
	  if ( lcrc == PXSUCCESS )
	    lcrc = GetTableStructure( lcTrackTable );
	  if ( lcrc == PXSUCCESS )
	    lcrc = CheckTableStructure( lcTrackTable, TR_TrackRecord, TR_LASTFIELD + 1 );
	  if ( lcrc == PXSUCCESS )
	    lcrc = DeleteTableStructure( lcTrackTable );
	}


      if ( lcrc == PXSUCCESS )
	lcrc = process_loop( lcDiscTable, lcTrackTable, lcDiscRecord, lcTrackRecord );

      if ( lcrc == PXSUCCESS )
	lcrc = Error( PXRecBufClose( lcTrackRecord ) );
      if ( lcrc == PXSUCCESS )
	lcrc = Error( PXRecBufClose( lcDiscRecord ) );
      if ( lcrc == PXSUCCESS )
	lcrc = Error( PXTblClose( lcTrackTable ) );
      if ( lcrc == PXSUCCESS )
	lcrc = Error( PXTblClose( lcDiscTable ) );

      lcWindow.wFrame.AddHeader( "Finished - Press any key", heBC );
      lcWindow.wFrame.UpdateFrame();
      ReadKeyWord();
      lcWindow.Erase();
      lcWindow.Done();

      return lcrc;
    }

/*--------------------------------------------------------------------------*/
main( void )
  {
    int rc;

    printf( "CDASCII.EXE: Imports CD music library database records from ASCII file v1.0\n" );
    printf( "Uses Paradox v4.0 database format\n" );

    rc = ( Error ( PXInit( ) ) );
    if (rc == PXSUCCESS)
      {
	return( process_main() );
      }
    else
      {
	printf( "CDASCII: %s\n", PXErrMsg( rc ) );
      }
  }
