#include "cdmusic.h"
#include "cdmcrt.h"

extern char artist[ 80 ];
extern char title[ 80 ];
extern REQUIREDFIELDARRAY TR_TrackRecord[],
			  DR_DiscRecord[];
extern TRACKFIELDARRAY TR_TrackArray[ 99 ];

#if defined(UseMouse)
  char MouseChar = 4;
#endif

//Color set used by entry screen
ColorSet cdColors = {
  /* TextColor */        WhiteOnBlue,     /* TextMono */         WhiteOnBlack,
  /* CtrlColor */        YellowOnBlue,    /* CtrlMono */         WhiteOnBlack,
  /* FrameColor */       CyanOnBlue,      /* FrameMono */        LtGrayOnBlack,
  /* HeaderColor */      WhiteOnCyan,     /* HeaderMono */       BlackOnLtGray,
  /* ShadowColor */      DkGrayOnBlack,   /* ShadowMono */       WhiteOnBlack,
  /* HighlightColor */   WhiteOnRed,      /* HighlightMono */    BlackOnLtGray,
  /* PromptColor */      LtGrayOnBlue,    /* PromptMono */       LtGrayOnBlack,
  /* SelPromptColor */   LtGrayOnBlue,    /* SelPromptMono */    LtGrayOnBlack,
  /* ProPromptColor */   LtGrayOnBlue,    /* ProPromptMono */    LtGrayOnBlack,
  /* FieldColor */       YellowOnBlue,    /* FieldMono */        LtGrayOnBlack,
  /* SelFieldColor */    BlueOnCyan,      /* SelFieldMono */     WhiteOnBlack,
  /* ProFieldColor */    LtGrayOnBlue,    /* ProFieldMono */     LtGrayOnBlack,
  /* ScrollBarColor */   CyanOnBlue,      /* ScrollBarMono */    LtGrayOnBlack,
  /* SliderColor */      CyanOnBlue,      /* SliderMono */       WhiteOnBlack,
  /* HotSpotColor */     BlackOnCyan,     /* HotSpotMono */      BlackOnLtGray,
  /* BlockColor */       YellowOnCyan,    /* BlockMono */        WhiteOnBlack,
  /* MarkerColor */      WhiteOnCyan,     /* MarkerMono */       BlackOnLtGray,
  /* DelimColor */       YellowOnBlue,    /* DelimMono */        WhiteOnBlack,
  /* SelDelimColor */    BlueOnCyan,      /* SelDelimMono */     WhiteOnBlack,
  /* ProDelimColor */    YellowOnBlue,    /* ProDelimMono */     WhiteOnBlack,
  /* SelItemColor */     YellowOnCyan,    /* SelItemMono */      BlackOnLtGray,
  /* ProItemColor */     LtGrayOnBlue,    /* ProItemMono */      LtGrayOnBlack,
  /* HighItemColor */    WhiteOnBlue,     /* HighItemMono */     WhiteOnBlack,
  /* AltItemColor */     WhiteOnBlue,     /* AltItemMono */      WhiteOnBlack,
  /* AltSelItemColor */  WhiteOnCyan,     /* AltSelItemMono */   BlackOnLtGray,
  /* FlexAHelpColor */   WhiteOnBlue,     /* FlexAHelpMono */    WhiteOnBlack,
  /* FlexBHelpColor */   WhiteOnBlue,     /* FlexBHelpMono */    WhiteOnBlack,
  /* FlexCHelpColor */   LtCyanOnBlue,    /* FlexCHelpMono */    BlackOnLtGray,
  /* UnselXrefColor */   YellowOnBlue,    /* UnselXrefMono */    LtBlueOnBlack,
  /* SelXrefColor */     WhiteOnCyan,     /* SelXrefMono */      BlackOnLtGray,
  /* MouseColor */       WhiteOnRed,      /* MouseMono */        BlackOnLtGray
};


//Color set used by entry screen
ColorSet EsColors = {
  /* TextColor */        YellowOnBlue,    /* TextMono */         WhiteOnBlack,
  /* CtrlColor */        YellowOnBlue,    /* CtrlMono */         WhiteOnBlack,
  /* FrameColor */       CyanOnBlue,      /* FrameMono */        LtGrayOnBlack,
  /* HeaderColor */      WhiteOnCyan,     /* HeaderMono */       BlackOnLtGray,
  /* ShadowColor */      DkGrayOnBlack,   /* ShadowMono */       WhiteOnBlack,
  /* HighlightColor */   WhiteOnRed,      /* HighlightMono */    BlackOnLtGray,
  /* PromptColor */      LtGrayOnBlue,    /* PromptMono */       LtGrayOnBlack,
  /* SelPromptColor */   LtGrayOnBlue,    /* SelPromptMono */    LtGrayOnBlack,
  /* ProPromptColor */   LtGrayOnBlue,    /* ProPromptMono */    LtGrayOnBlack,
  /* FieldColor */       YellowOnBlue,    /* FieldMono */        LtGrayOnBlack,
  /* SelFieldColor */    BlueOnCyan,      /* SelFieldMono */     WhiteOnBlack,
  /* ProFieldColor */    LtGrayOnBlue,    /* ProFieldMono */     LtGrayOnBlack,
  /* ScrollBarColor */   CyanOnBlue,      /* ScrollBarMono */    LtGrayOnBlack,
  /* SliderColor */      CyanOnBlue,      /* SliderMono */       WhiteOnBlack,
  /* HotSpotColor */     BlackOnCyan,     /* HotSpotMono */      BlackOnLtGray,
  /* BlockColor */       YellowOnCyan,    /* BlockMono */        WhiteOnBlack,
  /* MarkerColor */      WhiteOnCyan,     /* MarkerMono */       BlackOnLtGray,
  /* DelimColor */       YellowOnBlue,    /* DelimMono */        WhiteOnBlack,
  /* SelDelimColor */    BlueOnCyan,      /* SelDelimMono */     WhiteOnBlack,
  /* ProDelimColor */    YellowOnBlue,    /* ProDelimMono */     WhiteOnBlack,
  /* SelItemColor */     YellowOnCyan,    /* SelItemMono */      BlackOnLtGray,
  /* ProItemColor */     LtGrayOnBlue,    /* ProItemMono */      LtGrayOnBlack,
  /* HighItemColor */    WhiteOnBlue,     /* HighItemMono */     WhiteOnBlack,
  /* AltItemColor */     WhiteOnBlue,     /* AltItemMono */      WhiteOnBlack,
  /* AltSelItemColor */  WhiteOnCyan,     /* AltSelItemMono */   BlackOnLtGray,
  /* FlexAHelpColor */   WhiteOnBlue,     /* FlexAHelpMono */    WhiteOnBlack,
  /* FlexBHelpColor */   WhiteOnBlue,     /* FlexBHelpMono */    WhiteOnBlack,
  /* FlexCHelpColor */   LtCyanOnBlue,    /* FlexCHelpMono */    BlackOnLtGray,
  /* UnselXrefColor */   YellowOnBlue,    /* UnselXrefMono */    LtBlueOnBlack,
  /* SelXrefColor */     WhiteOnCyan,     /* SelXrefMono */      BlackOnLtGray,
  /* MouseColor */       WhiteOnRed,      /* MouseMono */        BlackOnLtGray
};

FrameArray Frame1 = "ĳ";
#define WinOptions  wBordered+wClear+wUserContents

//---------------------------------------------------------------------------
word cd_discscrn(EntryScreen &ES, ColorSet &EsColors )
  //-Initialize entry screen generated by MAKESCRN
{
    if (! ES.InitCustom(5, 5, 55, 15, EsColors, WinOptions))
      return ES.InitStatus;
    ES.wFrame.SetFrameType(Frame1);
    ES.EnableExplosions(15);
    ES.wFrame.AddShadow(shBR, shSeeThru);
    ES.wFrame.AddHeader("DISC INFORMATION", heTL);
    ES.wFrame.AddHeader("F1 - SEARCH, F2 - TRACK, F3 - QUIT, F9 - PRINT", heBL);
    ES.esFieldOptionsOn(efCursorToEnd);
    ES.SetWrapMode(WrapAtEdges);

    ES.esFieldOptionsOn( efClickExit + efClearFirstChar + efProtected );

    ES.AddSimpleStringField(
      DR_DiscRecord[ DR_DiscID ].fldName, 1, 2,
      'X', 1, 18, 15, 80, 0,
      DR_DiscRecord[ DR_DiscID ].fldBuffer );

    ES.esFieldOptionsOff( efProtected );
    ES.AddSimpleStringField(
      DR_DiscRecord[ DR_Artist ].fldName, 2, 2,
      'X', 2, 18, 24, 80, 0,
      DR_DiscRecord[ DR_Artist ].fldBuffer );

    ES.AddSimpleStringField(
      DR_DiscRecord[ DR_Title ].fldName, 3, 2,
      'X', 3, 18, 24, 80, 0,
      DR_DiscRecord[ DR_Title ].fldBuffer );

    ES.esFieldOptionsOn( efProtected );
    ES.AddSimpleStringField(
      DR_DiscRecord[ DR_Tracks ].fldName, 4, 2,
      'X', 4, 18, 15, 80, 0,
      DR_DiscRecord[ DR_Tracks ].fldBuffer );

    ES.AddSimpleStringField(
      DR_DiscRecord[ DR_Min ].fldName, 5, 2,
      'X', 5, 18, 15, 80, 0,
      DR_DiscRecord[ DR_Min ].fldBuffer );

    ES.AddSimpleStringField(
      DR_DiscRecord[ DR_Sec ].fldName, 6, 2,
      'X', 6, 18, 15, 80, 0,
      DR_DiscRecord[ DR_Sec ].fldBuffer );

    ES.AddSimpleStringField(
      DR_DiscRecord[ DR_Entry ].fldName, 7, 2,
      'X', 7, 18, 15, 80, 0,
      DR_DiscRecord[ DR_Entry ].fldBuffer );

    return ES.RawError();
};

//------------------------------------------------------------------------------------------------
word cd_trackscrn( ScrollingEntryScreen &ES, ColorSet &EsColors )
  //-Initialize entry screen generated by MAKESCRN
  {
    int lciteration;
    char lcNumber[ 16 ];

    lciteration = 1;
    while ( ( TR_TrackArray[ lciteration ].title != NULL ) &&
            ( lciteration < 15 ) )
      {
        lciteration++;
      }
    if (! ES.InitCustom( 15, 9, 65, lciteration + 7, EsColors, WinOptions))
      return ES.InitStatus;
    ES.wFrame.SetFrameType(Frame1);
    ES.EnableExplosions(15);
    ES.wFrame.AddShadow(shBR, shSeeThru);
    ES.wFrame.AddHeader("TRACK INFORMATION", heTL);
    ES.SetWrapMode(WrapAtEdges);

    ES.esFieldOptionsOn( efCursorToEnd + efClickExit + efClearFirstChar );

    lciteration = 1;
    while ( TR_TrackArray[ lciteration ].title != NULL )
      {
        ES.AddSimpleStringField(
          "", lciteration, 5,
          'X', lciteration, 5, 32, 80, 0,
          TR_TrackArray[ lciteration ].title );
        //sprintf( lcNumber, "%d", lciteration );
        //ES.AddTextField( lcNumber, lciteration, 2 );
        sprintf( lcNumber, "%d", TR_TrackArray[ lciteration ].trackid );
        ES.AddTextField( lcNumber, lciteration, 2 );
        sprintf( lcNumber, "%d", TR_TrackArray[ lciteration ].min );
        ES.AddTextField( lcNumber, lciteration, 39 );
        sprintf( lcNumber, "%d", TR_TrackArray[ lciteration ].sec );
        ES.AddTextField( lcNumber, lciteration, 42 );
        lciteration++;
      }

    return ES.RawError();
  };


//--------------------------------------------------------------------------
word cd_dialog( char *lcStringIn )
  {
    DialogBox lcDialog;
    boolean lcFinished;

    OPDialogInit();

    if ( !lcDialog.InitCustom(
         25, 10, 55, 14,
         EsColors,
         DefWindowOptions | wBordered,
         DefaultDialogColors
       ) )
      {
        exit( 1 );
      }

    lcDialog.wFrame.AddShadow( shBR, shOverWrite );
    lcDialog.wFrame.AddHeader( "CDMUSIC", heTC );
    lcDialog.AddCenteredTextField( lcStringIn, 2 );
    lcDialog.AddPushButton( "O&k",    04, 06, 8, 0 , ccSelect, TRUE  );
    lcDialog.AddPushButton( "Cancel", 04, 18, 8, 0,  ccQuit,   FALSE );
    if ( lcDialog.RawError( ) != 0 )
      {
        exit( 1 );
      }
    lcFinished = FALSE;
    do
      {
        lcDialog.Process();
        switch( lcDialog.GetLastCommand( ) )
          {
            case ccSelect :
            case ccQuit   :
            case ccError  :
              lcFinished = TRUE;
          }
      }
    while ( !lcFinished );
    lcDialog.Erase( );
    lcDialog.Done( );

    return PXSUCCESS;
  }