#include <stdio.h>
#include <stdlib.h>
#include <dos.h>

#define OKAY 0

#include "cdmaster.h"

char *nodrives= "No CDROM drives attached.\n";
char *nomscdex= "MSCDEX is not installed.\n";

main(int argc, char **argv)
  {
	int bgntrack = 1;
	int endtrack = 1;
	int numcdroms = 0;
	int ourdrive = 0;
        int quitcd = 0;
        int status = 0;
	struct cdtable *cdt;

	if (!ismscdex())
		{
		fprintf(stderr, nomscdex);
		return(1);
		}

	if (!(numcdroms= getnumcdroms()))
		{
		fprintf(stderr, nodrives);
		return(2);
		}

	if (!(ourdrive= getfirstcdrom()))
                {
		fprintf(stderr, nodrives);
		return(4);
		}
      do
        {
	if ( cdt = buildaudiotoc( ourdrive ) )
            {
		long sframe,
                     f,
                     dframes = 0,
                     lc10,
                     lcsec,
                     lcmin,
	             track = 1;
                struct discinfo *di;
		struct trackinfo ti;
                if ( di = getdiscinfotable( ourdrive ) )
                  {
                  }

                printf( "CD #%ld\n", cdt->di.eodisc );
                /* printf( "CD #%ld\n", di->eodisc ); */
                printf( "Tracks->\t%d\n", cdt->di.ltrk );
                endtrack = cdt->di.ltrk;
                do 
                  {
                    printf( "%ld", cdt->di.eodisc );
                    printf( "\t%d", track);
		    if (status= cdtrackinfo(ourdrive, bgntrack, &ti) >= 0)
                      f = gettrackframes( ourdrive, track );
                    dframes += f;
                    lcmin = ( ( f / 75 ) / 60 );
                    lcsec = ( ( f - ( ( lcmin * 60 ) * 75 ) ) / 75 );
                    lc10  = ( ( f - ( ( ( lcmin * 60 ) * 75 ) + 
                                        ( lcsec * 75 )      ) ) * ( 100 / 75 ) );
                    printf( "\t%2.2ld:%2.2ld.%2.2ld\n", lcmin, lcsec, lc10 );
                  } 
                while ( ++track <= endtrack );

                lcmin = ( ( dframes / 75 ) / 60 );
                lcsec = ( ( dframes - ( ( lcmin * 60 ) * 75 ) ) / 75 );
                lc10  = ( ( dframes - ( ( ( lcmin * 60 ) * 75 ) + 
                                     ( lcsec * 75 )      ) ) * ( 100 / 75 ) );
                printf( "disc length-> %2.2ld:%2.2ld.%2.2ld\n", lcmin, lcsec, lc10 );

		destroyaudiotoc(ourdrive);
                cdeject( ourdrive );
	    }
	else
		printf("failed, no initialization.\n");
        do
          {
            status = cdstatus( ourdrive );
          }
        while ( !( status & CDISHERE) ); 
        }
      while( !quitcd );
      return(OKAY);
}

