extern "C" {
#include "cdmaster.h"
         }
#include "cdmusic.h"
#include "cdmcrt.h"

#define OKAY 0
#define FAIL 1

char *nodrives= "No CDROM drives attached.\n";
char *nomscdex= "MSCDEX is not installed.\n";

char far*fldNames[ MAXFIELDS ];
char far*fldTypes[ MAXFIELDS ];

REQUIREDFIELDARRAY TR_TrackRecord[] =
  {
    { 3, "Disc ID",          "N",    1 },
    { 3, "Track ID",         "N",    2 },
    { 1, "Title",            "A80",  3 },
    { 1, "Min",              "S",    4 },
    { 1, "Sec",              "S",    5 },
    { 1, "Sec100",           "S",    6 }
  };

REQUIREDFIELDARRAY SR_SearchRecord[] =
  {
    { 3, "Disc ID",          "N",    1 },
    { 1, "Artist",           "A80",  2 },
    { 1, "Title",            "A80",  3 },
    { 1, "Tracks",           "S",    4 },
    { 1, "Min",              "S",    5 },
    { 1, "Sec",              "S",    6 },
    { 1, "Entry Date",           "D",    7 }
  };

REQUIREDFIELDARRAY DR_DiscRecord[] =
  {
    { 3, "Disc ID",          "N",    1 },
    { 1, "Artist",           "A80",  2 },
    { 1, "Title",            "A80",  3 },
    { 1, "Tracks",           "S",    4 },
    { 1, "Min",              "S",    5 },
    { 1, "Sec",              "S",    6 },
    { 1, "Entry Date",           "D",    7 }
  };

REQUIREDFIELDARRAY PD_DiscRecord[] =
  {
    { 3, "Artist",           "A80",  1 },
    { 3, "Title",            "A80",  2 },
    { 3, "Disc ID",          "N",    3 },
    { 1, "Tracks",           "S",    4 },
    { 1, "Min",              "S",    5 },
    { 1, "Sec",              "S",    6 },
    { 1, "Entry Date",           "D",    7 }
  };

TRACKFIELDARRAY TR_TrackArray[ 99 ];

extern char MouseChar;
extern ColorSet EsColors,
               cdColors;
RawWindow glWindow;
char glString[ 80 ];
TABLEHANDLE glDiscTable;
RECORDHANDLE glSearchRecord;


/*--------------------------------------------------------------------------*/
int Error( int lcRC )
  {
    if ( lcRC != PXSUCCESS )
      {
      CharStr( ' ', 78, glString );
        glWindow.wFastText( glString, 20, 2 );
      sprintf( glString, "CDMUSIC: %s", PXErrMsg( lcRC ) );
      glWindow.wFastText( glString, 20, 2 );
      }

    return lcRC;
  }

//--------------------------------------------------------------------------
int GetData( REQUIREDFIELDARRAY *lcFieldArray, RECORDHANDLE lcRecordHandle, int lcField )
  {
    long theDate;
    int month, day, year;
    double theValue;
    short theShort;
    int isBlank;
    FIELDHANDLE lcFieldHandle;

    lcFieldHandle = lcFieldArray[ lcField ].fldHandle;

    /* if this field is blank, we want to return a blank string */
    if ( !Error( PXFldBlank( lcRecordHandle, lcFieldHandle, &isBlank ) ) )
      {
        if ( isBlank )
        {
            lcFieldArray[ lcField ].fldBuffer[0] = '\0';
            return PXSUCCESS;
        }
      }
    else
        return FAIL;

    //printf( " Get %d", lcFieldArray[ lcField ].fldHandle );
    switch( lcFieldArray[ lcField ].fldType[0] )
      {
        case 'a':
        case 'A':
            if ( Error( PXGetAlpha( lcRecordHandle, lcFieldHandle, BUFSIZ, lcFieldArray[ lcField ].fldBuffer ) ) )
            return FAIL;
            break;
        case 'd':
        case 'D':
          if ( !Error( PXGetDate( lcRecordHandle, lcFieldHandle, &theDate ) ) )
            {
                PXDateDecode( theDate, &month, &day, &year );
                sprintf( lcFieldArray[ lcField ].fldBuffer, "%d/%d/%d", month, day, year );
            }
            else
                return FAIL;
          break;
        case 'n':
        case 'N':
            if ( !Error( PXGetDoub( lcRecordHandle, lcFieldHandle, &theValue ) ) )
                sprintf( lcFieldArray[ lcField ].fldBuffer, "%5.0lf", theValue );
            else
                return FAIL;
            break;
        case '$':
            if ( !Error( PXGetDoub( lcRecordHandle, lcFieldHandle, &theValue ) ) )
                sprintf( lcFieldArray[ lcField ].fldBuffer, "%4.2lf", theValue );
            else
                return FAIL;
            break;
        case 's':
        case 'S':
            if ( !Error( PXGetShort( lcRecordHandle, lcFieldHandle, &theShort ) ) )
                sprintf( lcFieldArray[ lcField ].fldBuffer, "%d", theShort );
            else
                return FAIL;
            break;
      }
    return( PXSUCCESS );
  }

/*--------------------------------------------------------------------------*/
int PutData( REQUIREDFIELDARRAY *lcFieldArray,
             RECORDHANDLE lcRecordHandle,
           int lcField )
  {
    long theDate;
    int month, day, year;
    double theValue;
    short theShort;

    /* If the field is blank, put a blank into the record buffer. */
    if ( strlen( lcFieldArray[ lcField ].fldBuffer ) == 0 )
      {
      if ( Error( PXPutBlank( lcRecordHandle, lcFieldArray[ lcField ].fldHandle ) ) != PXSUCCESS )
          {
          return FAIL;
          }
      else
        {
          return PXSUCCESS;
         }
      }

    //printf( " Put %d", lcFieldArray[ lcField ].fldHandle );
    switch( lcFieldArray[ lcField ].fldType[0] )
    {
        case 'a':
        case 'A':
          if ( Error( PXPutAlpha( lcRecordHandle, lcFieldArray[ lcField ].fldHandle, lcFieldArray[ lcField ].fldBuffer ) ) )
                return FAIL;
            break;

        case 'D':
        case 'd':
            sscanf( lcFieldArray[ lcField ].fldBuffer, "%d/%d/%d", &month, &day, &year );
            if ( ( Error( PXDateEncode( month, day, year, &theDate ) ) ) ||
                 ( Error( PXPutDate( lcRecordHandle, lcFieldArray[ lcField ].fldHandle, theDate ) ) ) )
                return FAIL;
          break;

        case '$':
        case 'N':
        case 'n':
            sscanf( lcFieldArray[ lcField ].fldBuffer, "%lf", &theValue );
            if ( Error( PXPutDoub( lcRecordHandle, lcFieldArray[ lcField ].fldHandle, theValue ) ) )
            return FAIL;
            break;
        case 'S':
        case 's':
            sscanf( lcFieldArray[ lcField ].fldBuffer, "%d", &theShort );
            if ( Error( PXPutShort( lcRecordHandle, lcFieldArray[ lcField ].fldHandle, theShort ) ) )
                return FAIL;
            break;
    }

    return PXSUCCESS;
  }

/*--------------------------------------------------------------------------*/
word track_scrn( )
{
  word Status;
  ScrollingEntryScreen ES;

  OPEntryInit();

  #if defined(UseMouse)
  if (MouseInstalled) {
      //activate mouse cursor
      SoftMouseCursor(0x0000, (ColorMono(EsColors.MouseColor, EsColors.MouseMono) << 8)+
                       MouseChar);
      ShowMouse();
      //enable mouse support
      EntryCommands.cpOptionsOn(cpEnableMouse);
    };
  #endif

  //initialize entry screen
  Status = cd_trackscrn( ES, EsColors );

  ES.Process();
  ES.Erase();
  #if defined(UseMouse)
  HideMouse();
  #endif
  ES.Done();
  return Status;
};

/*--------------------------------------------------------------------------*/
void PickTitle( word lcItem, pkMode lcMode,
                pkItemType &lcType, char *lcIString,
                PickListPtr PickPtr )
  {
    int lcRC,
        lcDone = 0,
        lcCount = 0;

    lcRC = Error( PXSrchFld( glDiscTable, glSearchRecord, SR_SearchRecord[ SR_Artist ].fldHandle, SEARCHFIRST ) );
    do
      {
        lcCount++;
        if ( ( lcItem == lcCount ) &&
             ( lcRC == PXSUCCESS ) )
          {
            if ( lcRC == PXSUCCESS )
              lcRC = Error( PXRecGet( glDiscTable, glSearchRecord ) );
            if ( lcRC == PXSUCCESS )
              lcRC = Error( PXGetAlpha( glSearchRecord, SR_SearchRecord[ SR_Title ].fldHandle, BUFSIZ, SR_SearchRecord[ SR_Title ].fldBuffer ) );
            strcpy( lcIString, SR_SearchRecord[ SR_Title ].fldBuffer );
            lcDone = 1;
          }
         if ( ( lcRC == PXSUCCESS ) &&
              ( !lcDone ) )
           lcRC = PXSrchFld( glDiscTable, glSearchRecord, SR_SearchRecord[ SR_Artist ].fldHandle, SEARCHNEXT );
      }
    while ( ( lcRC == PXSUCCESS ) &&
            ( !lcDone ) );
  }

/*--------------------------------------------------------------------------*/
word disc_search( TABLEHANDLE lcDiscTable, RECORDHANDLE lcDiscRecord,
                  RECORDHANDLE lcSearchRecord )
  {
    PickList lcPick;
    int lcRC,
        lcCount;
    long lcLong;
    word lcCmd = ccQuit;


    strcpy( SR_SearchRecord[ SR_Artist ].fldBuffer, DR_DiscRecord[ DR_Artist ].fldBuffer );
    lcRC = Error( PXPutAlpha( lcSearchRecord, SR_SearchRecord[ SR_Artist ].fldHandle, SR_SearchRecord[ SR_Artist ].fldBuffer ) );
    if ( lcRC == PXSUCCESS )
      lcRC = PXSrchFld( lcDiscTable, lcSearchRecord, SR_SearchRecord[ SR_Artist ].fldHandle, SEARCHFIRST );
    if ( lcRC == PXSUCCESS )
      {
        lcCount = 0;
        do
          {
            lcRC = PXSrchFld( lcDiscTable, lcSearchRecord, SR_SearchRecord[ SR_Artist ].fldHandle, SEARCHNEXT );
            lcCount++;
          }
        while ( lcRC == PXSUCCESS );
        glDiscTable = lcDiscTable;
        glSearchRecord = lcSearchRecord;

        OPPickInit();
        lcRC = lcPick.InitCustom ( 35, 10, 70, 20,
                            EsColors,
                            DefWindowOptions | wBordered,
                            35,
                            lcCount,
                            PickTitle,
                            PickVertical,
                            SingleChoice );
        lcPick.SetSearchMode(PickCharSearch);
        lcPick.wFrame.AddShadow( shBR, shOverWrite);
        lcPick.wFrame.AddHeader( SR_SearchRecord[ SR_Artist ].fldBuffer, heTL );
        lcPick.Process();
        lcPick.Erase();
        //get selection
        lcCmd = lcPick.GetLastCommand( );
        if ( lcCmd == ccSelect )
          {
            lcCount = 0;
            lcRC = PXSUCCESS;
            while ( ( lcCount <= SR_LASTFIELD ) &&
                    ( lcRC == PXSUCCESS ) )
              {
                lcRC = GetData( SR_SearchRecord, lcSearchRecord, lcCount );
                lcCount++;
              }
          }
        lcPick.Done();
      }
    else
      {
        glWindow.wFastText( "CDMUSIC: Artist Search Failed", 20, 2 );
      }
    return lcCmd;
  }

/*--------------------------------------------------------------------------*/
int cd_scrn( TABLEHANDLE lcDiscTable, RECORDHANDLE lcDiscRecord, int lcSearch )
{
  word lcField,
       lcTrackEdit = 0,
       lcRC,
       Status;
  EntryScreen ES;
  PXCODE pxErr;
  RECORDHANDLE lcSearchRecord;

  OPEntryInit();
  lcSearch = 0;

  #if defined(UseMouse)
  if (MouseInstalled) {
      //activate mouse cursor
      SoftMouseCursor(0x0000, (ColorMono(EsColors.MouseColor, EsColors.MouseMono) << 8)+
                       MouseChar);
      ShowMouse();
      //enable mouse support
      EntryCommands.cpOptionsOn(cpEnableMouse);
    };
  #endif

  //initialize entry screen
  Status = cd_discscrn(ES, EsColors );
  if (Status != 0) {
    printf("Error initializing entry screen: %u\r\n", Status);
    exit( 0 );
    return Status;
  };

  EntryCommands.AddCommand( ccUser1,  1, 0x3B00, 0 ); //F1   SEARCH
  EntryCommands.AddCommand( ccUser2,  1, 0x3C00, 0 ); //F2   TRACK
  EntryCommands.AddCommand( ccUser3,  1, 0x3D00, 0 ); //F3   EXIT
  EntryCommands.AddCommand( ccUser10, 1, 0x4400, 0 ); //F10
  EntryCommands.AddCommand( ccUser9,  1, 0x4300, 0 ); //F9   PRINT
  EntryCommands.AddCommand( ccUser8,  1, 0x4200, 0 ); //F8   CLEANUP

  do
    {
      ES.Process();
      Status = ES.GetLastCommand();
      switch( Status )
        {
          case ccUser1 : {
                           if ( strlen( DR_DiscRecord[ DR_Artist ].fldBuffer ) > 1 )
                             {
                               pxErr = Error( PXRecBufOpen( lcDiscTable, &lcSearchRecord ) );
                               Status = disc_search( lcDiscTable, lcDiscRecord, lcSearchRecord );
                               if ( Status == ccSelect )
                                 {
                                   lcSearch = 1;
                                   Status = ccUser1;
                                 }
                               else
                                 {
                                   Status = ccUser2;
                                 }


                               pxErr = Error( PXRecBufClose( lcSearchRecord ) );
                             }
                           break;
                         }
          case ccUser2 : {
                           lcRC = track_scrn( );
                           break;
                         }
        }
      }
    while ( Status == ccUser2 );
    ES.Erase();
    #if defined(UseMouse)
      HideMouse();
    #endif
    ES.Done();
    return Status;
  }

//----------------------------------------------------------------------------
int addcdrecord( TABLEHANDLE lcDiscTable,   TABLEHANDLE lcTrackTable,
                 RECORDHANDLE lcDiscRecord, RECORDHANDLE lcTrackRecord,
                 long lcDiskID, int lcTracks, int lcdrive )
  {
    int    lcRC = PXSUCCESS,
           lcField,
           lctrack,
           lcstatus,
           lcmin,
           lcsec,
           lc10;
    long   lctframes,
           lcdframes;
    struct date lcDate;


    getdate( &lcDate );
    sprintf( DR_DiscRecord[ DR_Tracks ].fldBuffer, "%d", lcTracks );
    lctrack = 1;
    lcdframes = 0;
    do
      {
        sprintf( TR_TrackRecord[ TR_DiscID ].fldBuffer, "%ld", lcDiskID );
        sprintf( TR_TrackRecord[ TR_TrackID ].fldBuffer, "%d", lctrack );
        lctframes = gettrackframes( lcdrive, lctrack );
        lcdframes += lctframes;
        lcmin = ( ( lctframes / 75 ) / 60 );
        lcsec = ( ( lctframes - ( ( lcmin * 60 ) * 75 ) ) / 75 );
        lc10  = ( ( lctframes - ( ( ( lcmin * 60 ) * 75 ) +
                  ( lcsec * 75 )      ) ) * ( 100 / 75 ) );
        sprintf( TR_TrackRecord[ TR_Min ].fldBuffer, "%d", lcmin );
        sprintf( TR_TrackRecord[ TR_Sec ].fldBuffer, "%d", lcsec );
        sprintf( TR_TrackRecord[ TR_Sec100 ].fldBuffer, "%d", lc10 );
        lcField = 0;

        while ( ( lcField <= TR_LASTFIELD ) &&
                ( lcRC == PXSUCCESS ) )
          {
            lcRC = PutData( TR_TrackRecord, lcTrackRecord, lcField );
            lcField++;
          }

        TR_TrackArray[ lctrack ].discid = lcDiskID;
        TR_TrackArray[ lctrack ].trackid = lctrack;
        TR_TrackArray[ lctrack ].min = lcmin;
        TR_TrackArray[ lctrack ].sec = lcsec;
        TR_TrackArray[ lctrack ].sec100 = lc10;
        if ( lcRC == PXSUCCESS )
          lcRC = Error( PXRecAppend( lcTrackTable, lcTrackRecord ) );
        if ( lcRC == PXSUCCESS )
          lcRC = Error( PXSave( ) );
      }
    while ( ( ++lctrack <= lcTracks ) &&
            ( lcRC == PXSUCCESS ) );

    if ( lcRC == PXSUCCESS )
      {
        lcmin = ( ( lcdframes / 75 ) / 60 );
        lctframes = long ( lcdframes  / 75 );
        lctframes = lctframes - ( lcmin * 60 );
        lcsec = lctframes;
        lc10  = ( ( lcdframes - ( ( ( lcmin * 60 ) * 75 ) +
                  ( lcsec * 75 )      ) ) * ( 100 / 75 ) );
        sprintf( DR_DiscRecord[ DR_Tracks ].fldBuffer, "%d", lcTracks );
        sprintf( DR_DiscRecord[ DR_Min ].fldBuffer, "%d", lcmin );
        sprintf( DR_DiscRecord[ DR_Sec ].fldBuffer, "%d", lcsec );
        sprintf( DR_DiscRecord[ DR_Entry ].fldBuffer, "%d/%d/%d", lcDate.da_mon, lcDate.da_day, lcDate.da_year );
        lcField = 0;
        while ( ( lcField <= DR_LASTFIELD ) &&
                ( lcRC == PXSUCCESS ) )
          {
            lcRC = PutData( DR_DiscRecord, lcDiscRecord, lcField );
            lcField++;
          }
        if ( lcRC == PXSUCCESS )
          lcRC = Error( PXRecAppend( lcDiscTable, lcDiscRecord ) );
        if ( lcRC == PXSUCCESS )
          lcRC = Error( PXSave( ) );
      }
    return PXSUCCESS;
  }

/*--------------------------------------------------------------------------*/
int HPLaserJetCursor( FILE *lcLaserJetHandle, int lcHoriz, int lcVert )
  {
    char LJVert[] = {27, 42, 112};

    fwrite( LJVert, 1, sizeof( LJVert ), lcLaserJetHandle );
    fprintf( lcLaserJetHandle, "%dY", lcVert );
    fwrite( LJVert, 1, sizeof( LJVert ), lcLaserJetHandle );
    fprintf( lcLaserJetHandle, "%dX", lcHoriz );
    return PXSUCCESS;
  }

/*--------------------------------------------------------------------------*/
int CrossTableCopy( REQUIREDFIELDARRAY *lcFromArray, TABLEHANDLE lcFromTable, RECORDHANDLE lcFromRecord, int lcFromStop,
                REQUIREDFIELDARRAY *lcToArray, TABLEHANDLE lcToTable, RECORDHANDLE lcToRecord, int lcToStop )
  {
    int iteration,
        iteration2,
      lcRC;
    RECORDNUMBER lcRecordNumber;
    FIELDHANDLE lcField;

    CharStr( ' ', 40, glString);
    glWindow.wFastText( glString, 5, 20 );
    glWindow.wFastText( "Cross Copy", 5, 20 );
    glWindow.wFastText( glString, 6, 2 );
    glWindow.wFastText( "Record #->", 6, 2 );
    for ( iteration = 0; iteration < lcToStop; ++iteration )
      {
      if ( lcToArray[ iteration ].required > 0 )
        {
           iteration2 = 0;
           while ( iteration2 < lcFromStop )
             {
             if ( ( stricmp( lcFromArray[ iteration2 ].fldName, lcToArray[ iteration ].fldName ) == 0 ) &&
                  ( strncmpi( lcFromArray[ iteration2 ].fldType, lcToArray[ iteration ].fldType, 1 ) == 0 ) )
                   {
                 lcToArray[ iteration ].crossNdx = iteration2;
               }
             iteration2++;
               }
          }
      }

    lcRC = Error( PXRecFirst( lcFromTable ) );
    lcRecordNumber = 1;
    while ( lcRC == PXSUCCESS )
      {
      if ( lcRC == PXSUCCESS )
        lcRC = Error( PXRecGet( lcFromTable, lcFromRecord ) );
      for ( iteration = 0; iteration < lcToStop; ++iteration )
        {
          if ( lcToArray[ iteration ].required > 0 )
              {
             lcRC = GetData( lcFromArray, lcFromRecord, lcToArray[ iteration ].crossNdx );
             strcpy( lcToArray[ iteration ].fldBuffer, lcFromArray[ lcToArray[ iteration ].crossNdx ].fldBuffer );
             lcRC = PutData( lcToArray, lcToRecord, iteration );
            }
          else
            {
              strcpy( lcToArray[ iteration ].fldBuffer, "" );
              lcRC = PutData( lcToArray, lcToRecord, iteration );
            }
          }
      if ( lcRC == PXSUCCESS )
          lcRC = Error( PXRecAppend( lcToTable, lcToRecord ) );
      if ( lcRC == PXSUCCESS )
        lcRC = Error( PXRecNum( lcFromTable, &lcRecordNumber ) );
      sprintf( glString, "%d", lcRecordNumber );
        glWindow.wFastText( glString, 6, 20 );
      if ( lcRC == PXSUCCESS )
          lcRC = Error( PXRecNext( lcFromTable ) );
      }

    if ( lcRC == PXERR_ENDOFTABLE )
      lcRC = PXSUCCESS;
    return lcRC;
  }

/*--------------------------------------------------------------------------*/
int CheckTableStructure( TABLEHANDLE lcTableHandle, REQUIREDFIELDARRAY *lcFieldArray, int lcFields )
  {
    int rc,
        iteration,
      lcFieldCount,
        iteration2;

    rc = PXSUCCESS;
    lcFieldCount = 0;
    rc = Error( PXRecNFlds( lcTableHandle, &lcFieldCount ) );
    for ( iteration = 1; iteration <= lcFields; ++iteration )
      {
      iteration2 = 0;
      while ( stricmp( lcFieldArray[iteration-1].fldName, fldNames[iteration2] ) != 0 &&
            iteration2 <= lcFieldCount-1 )
        iteration2++;
      if ( stricmp( lcFieldArray[iteration-1].fldName, fldNames[iteration2]) == 0 )
        {
          if ( strncmp( lcFieldArray[iteration-1].fldType, fldTypes[iteration2], strlen( lcFieldArray[iteration-1].fldType ) ) == 0 )
            {
            lcFieldArray[iteration-1].fldHandle = iteration2 + 1;
            lcFieldArray[iteration-1].fldBuffer = (char *) malloc( BUFSIZ );
            rc = PXSUCCESS;
            }
          else
            {
            sprintf( glString, "ERROR: Type mismatch (%s vs. %s) for Field #%d (%s)\n", fldTypes[iteration2],
                                                            lcFieldArray[iteration - 1].fldType,
                                                            iteration,
                                                            lcFieldArray[iteration-1].fldName);
            glWindow.wFastText( glString, 24, 2 );
            iteration = lcFields;
            rc = PXERR_OUTOFRANGE;
            }
        }
      else
        {
          sprintf( glString, "ERROR: %d %s MISSING\n", iteration, lcFieldArray[iteration-1].fldName);
          glWindow.wFastText( glString, 24, 2 );
          iteration = lcFields;
          rc = PXERR_OUTOFRANGE;
        }
      }

    return rc;
  }

/*--------------------------------------------------------------------------*/
int GetTableStructure( TABLEHANDLE lcTableHandle )
  {
    int rc;
    FIELDHANDLE lcFieldHandle;
    char fldName[ BUFSIZ ];
    char fldType[ BUFSIZ ];
    int lcFieldCount;

    lcFieldCount = 0;
    rc = Error( PXRecNFlds(lcTableHandle, &lcFieldCount ) );
    if ( rc == PXSUCCESS )
      for ( lcFieldHandle = 1; lcFieldHandle <= lcFieldCount; ++lcFieldHandle )
        {
          rc = Error( PXFldName( lcTableHandle, lcFieldHandle, BUFSIZ, fldName ) );
          if ( rc == PXSUCCESS )
            rc = Error( PXFldType( lcTableHandle, lcFieldHandle, BUFSIZ, fldType ) );
          if ( rc == PXSUCCESS )
            {
              /* printf( "%d\t", fldHandle ); */
              fldNames[ lcFieldHandle-1 ] = strdup( fldName );
              /* printf( "%s\t", fldNames[ fldHandle-1 ] ); */
              fldTypes[ lcFieldHandle-1 ] = strdup( fldType );
              /* printf( "%s\n", fldTypes[ fldHandle-1 ] ); */
            }
          else
            lcFieldHandle = lcFieldCount + 1;
      }

    return rc;
  }

/*--------------------------------------------------------------------------*/
int DeleteTableStructure( TABLEHANDLE lcTableHandle )
  {
    int rc;
    FIELDHANDLE lcFieldHandle;
    char fldName[ BUFSIZ ];
    char fldType[ BUFSIZ ];
    int lcFieldCount;

    lcFieldCount = 0;
    rc = Error( PXRecNFlds(lcTableHandle, &lcFieldCount ) );
    if ( rc == PXSUCCESS )
      for ( lcFieldHandle = lcFieldCount; lcFieldHandle >= 1; --lcFieldHandle )
        {
        free( (void *)fldTypes[ lcFieldHandle - 1 ] );
        free( (void *)fldNames[ lcFieldHandle - 1 ] );
        }

    return rc;
  }

/*--------------------------------------------------------------------------*/
int MakeTable( TABLEHANDLE *lcTableHandle, REQUIREDFIELDARRAY *lcFieldArray,
             char *lcTableName, RECORDHANDLE *lcRecordHandle, int lcFields )
  {
    FIELDHANDLE lcKeyHandles[ ] = { 1, 2, 3 };
    int  iteration,
       lcKeyFields,
         lcRC;
    char far*lcfldNames[ MAXFIELDS ];
    char far*lcfldTypes[ MAXFIELDS ];

    CharStr( ' ', 40, glString);
    glWindow.wFastText( glString, 5, 20 );
    sprintf( glString, "Making %s", lcTableName );
    glWindow.wFastText( glString, 5, 20 );
    lcKeyFields = 0;
    for ( iteration = 1; iteration <= lcFields; ++iteration )
      {
      if ( lcFieldArray[ iteration - 1 ].required == 3 )
        {
          lcKeyFields++;
        }
      lcfldNames[ iteration - 1 ] = strdup( lcFieldArray[ iteration - 1 ].fldName );
      lcfldTypes[ iteration - 1 ] = strdup( lcFieldArray[ iteration - 1 ].fldType );
      }

    lcRC = Error( PXTblCreate( lcTableName, lcFields, lcfldNames, lcfldTypes ) );
    if ( lcRC == PXSUCCESS )
      lcRC = Error( PXKeyAdd( lcTableName, lcKeyFields, lcKeyHandles, PRIMARY ) );
    if ( lcRC == PXSUCCESS )
      lcRC = Error( PXTblOpen( lcTableName, lcTableHandle, 0, 0 ) );
    if ( lcRC == PXSUCCESS )
      lcRC = Error( PXRecBufOpen( *lcTableHandle, lcRecordHandle ) );

    for ( iteration = 1; iteration <= lcFields; ++iteration )
      {
      free( (void *)lcfldNames[ iteration - 1 ] );
      free( (void *)lcfldTypes[ iteration - 1 ] );
      lcFieldArray[ iteration - 1 ].fldBuffer = (char *) malloc( BUFSIZ );
      }

    return lcRC;
  }

//----------------------------------------------------------------------------
int cd_getdisc( TABLEHANDLE lcDiscTable,   TABLEHANDLE lcTrackTable,
                RECORDHANDLE lcDiscRecord, RECORDHANDLE lcTrackRecord )
  {
    int lcRC,
        lcTrack,
        lcField;

    lcRC = Error( PXRecGet( lcDiscTable, lcDiscRecord ) );
    lcField = 0;
    while ( ( lcField <= DR_LASTFIELD ) &&
            ( lcRC == PXSUCCESS ) )
      {
        lcRC = GetData( DR_DiscRecord, lcDiscRecord, lcField );
        lcField++;
      }

    strcpy( TR_TrackRecord[ TR_DiscID ].fldBuffer, DR_DiscRecord[ DR_DiscID ].fldBuffer );
    lcRC = PutData( TR_TrackRecord, lcTrackRecord, TR_DiscID );
    lcRC = PXSrchKey( lcTrackTable, lcTrackRecord, 1, SEARCHFIRST );
    lcTrack = 1;
    while ( ( lcRC == PXSUCCESS ) &&
            ( TR_TrackArray[ lcTrack ].title != NULL ) )
      {
        lcRC = Error( PXRecGet( lcTrackTable, lcTrackRecord ) );
        lcField = 0;
        while ( ( lcField <= TR_LASTFIELD ) &&
                ( lcRC == PXSUCCESS ) )
          {
            lcRC = GetData( TR_TrackRecord, lcTrackRecord, lcField );
            lcField++;
          }
        sscanf( TR_TrackRecord[ TR_DiscID ].fldBuffer, "%ld", &TR_TrackArray[ lcTrack ].discid );
        sscanf( TR_TrackRecord[ TR_TrackID ].fldBuffer, "%d", &TR_TrackArray[ lcTrack ].trackid );
        sscanf( TR_TrackRecord[ TR_Min ].fldBuffer, "%d", &TR_TrackArray[ lcTrack ].min );
        sscanf( TR_TrackRecord[ TR_Sec ].fldBuffer, "%d", &TR_TrackArray[ lcTrack ].sec );
        sscanf( TR_TrackRecord[ TR_Sec100 ].fldBuffer, "%d", &TR_TrackArray[ lcTrack ].sec100 );
        strcpy( TR_TrackArray[ lcTrack ].title, TR_TrackRecord[ TR_Title ].fldBuffer );
        lcTrack++;
        lcRC =  PXSrchKey( lcTrackTable, lcTrackRecord, 1, SEARCHNEXT );
      }

    return lcRC;
  }

//----------------------------------------------------------------------------
int cd_update( TABLEHANDLE lcDiscTable,   TABLEHANDLE lcTrackTable,
               RECORDHANDLE lcDiscRecord, RECORDHANDLE lcTrackRecord )
  {
    int lcRC,
        lcTrack,
        lcField;

    lcField = 0;
    lcRC = Error( PXSrchKey( lcDiscTable, lcDiscRecord, 1, SEARCHFIRST ) );
    if ( lcRC == PXSUCCESS )
      lcRC = Error( PXRecGet( lcDiscTable, lcDiscRecord ) );
    while ( ( lcField <= DR_LASTFIELD ) &&
            ( lcRC == PXSUCCESS ) )
      {
        lcRC = PutData( DR_DiscRecord, lcDiscRecord, lcField );
        lcField++;
      }
    if ( lcRC == PXSUCCESS )
      {
        lcRC = Error( PXRecUpdate( lcDiscTable, lcDiscRecord ) );
      }
    if ( lcRC == PXSUCCESS )
      {
        lcRC = Error( PXSave( ) );
      }

    strcpy( TR_TrackRecord[ TR_DiscID ].fldBuffer, DR_DiscRecord[ DR_DiscID ].fldBuffer );
    lcRC = PutData( TR_TrackRecord, lcTrackRecord, TR_DiscID );
    lcRC = Error( PXSrchKey( lcTrackTable, lcTrackRecord, 1, SEARCHFIRST ) );
    lcTrack = 1;
    while ( ( lcRC == PXSUCCESS ) &&
            ( TR_TrackArray[ lcTrack ].title != NULL ) )
      {
        if ( lcRC == PXSUCCESS )
          lcRC = Error( PXRecGet( lcTrackTable, lcTrackRecord ) );
        sprintf( TR_TrackRecord[ TR_Min ].fldBuffer, "%d", TR_TrackArray[ lcTrack ].min );
        sprintf( TR_TrackRecord[ TR_Sec ].fldBuffer, "%d", TR_TrackArray[ lcTrack ].sec );
        sprintf( TR_TrackRecord[ TR_Sec100 ].fldBuffer, "%d", TR_TrackArray[ lcTrack ].sec100 );
        strcpy( TR_TrackRecord[ TR_Title ].fldBuffer, TR_TrackArray[ lcTrack ].title );
        lcField = TR_Title;
        while ( ( lcField <= TR_LASTFIELD ) &&
                ( lcRC == PXSUCCESS ) )
          {
            lcRC = PutData( TR_TrackRecord, lcTrackRecord, lcField );
            lcField++;
          }
        lcTrack++;
        lcRC = Error( PXRecUpdate( lcTrackTable, lcTrackRecord ) );
        lcRC = Error( PXSave( ) );
        lcRC = PXSrchKey( lcTrackTable, lcTrackRecord, 1, SEARCHNEXT );
      }

    return lcRC;
  }

//----------------------------------------------------------------------------
int cd_print( TABLEHANDLE lcDiscTable,   TABLEHANDLE lcTrackTable,
              RECORDHANDLE lcDiscRecord, RECORDHANDLE lcTrackRecord )
  {
    int lcRC,
        lcFound,
        lcField,
        lcHoriz = 50,
        lcVert = 50;
    FILE *lcLaserJetHandle;
    TABLEHANDLE lcPrintTable;
    RECORDHANDLE lcPrintRecord;
    char formfeed[] = {12};

    lcRC = Error( PXTblExist( "PRINT", &lcFound ) );
    if ( lcRC == PXSUCCESS )
      {
        if ( lcFound )
          {
            lcRC = Error( PXTblOpen( "PRINT", &lcPrintTable, 0, 0 ) );
            if ( lcRC == PXSUCCESS )
              lcRC = Error( PXRecBufOpen( lcPrintTable, &lcPrintRecord ) );
          }
        else
          {
            lcRC = MakeTable( &lcPrintTable, PD_DiscRecord, "PRINT", &lcPrintRecord, PD_LASTFIELD + 1 );
          }
      }
    if ( lcRC == PXSUCCESS )
      {
        if ( lcRC == PXSUCCESS )
          lcRC = GetTableStructure( lcPrintTable );
        if ( lcRC == PXSUCCESS )
          lcRC = CheckTableStructure( lcPrintTable, PD_DiscRecord, PD_LASTFIELD + 1 );
        if ( lcRC == PXSUCCESS )
          lcRC = DeleteTableStructure( lcPrintTable );
      }

    if ( lcRC == PXSUCCESS )
      lcRC = CrossTableCopy( DR_DiscRecord, lcDiscTable,  lcDiscRecord,  DR_LASTFIELD + 1,
                             PD_DiscRecord, lcPrintTable, lcPrintRecord, PD_LASTFIELD + 1 );

    lcLaserJetHandle = fopen( "PRN","wb" );
    lcRC = Error( PXRecFirst( lcPrintTable ) );
    do
      {
        lcRC = Error( PXRecGet( lcPrintTable, lcPrintRecord ) );
        lcField = 0;
        while ( ( lcField <= PD_LASTFIELD ) &&
                ( lcRC == PXSUCCESS ) )
          {
        lcRC = GetData( PD_DiscRecord, lcPrintRecord, lcField );
        lcField++;
          }
        lcRC = HPLaserJetCursor( lcLaserJetHandle, lcHoriz, lcVert );
        fprintf( lcLaserJetHandle, "%s", PD_DiscRecord[ PD_DiscID ].fldBuffer );
        lcRC = HPLaserJetCursor( lcLaserJetHandle, lcHoriz + 300, lcVert );
        fprintf( lcLaserJetHandle, "%s", PD_DiscRecord[ PD_Artist ].fldBuffer );
        lcRC = HPLaserJetCursor( lcLaserJetHandle, lcHoriz + 900, lcVert );
        fprintf( lcLaserJetHandle, "%s", PD_DiscRecord[ PD_Title ].fldBuffer );
        if ( lcVert >= 3000 )
          {
            lcVert = 50;
            fwrite( formfeed, 1, sizeof( formfeed ), lcLaserJetHandle );
          }
        else
          {
            lcVert += 25;
          }

        strcpy( TR_TrackRecord[ TR_DiscID ].fldBuffer, PD_DiscRecord[ PD_DiscID ].fldBuffer );
        lcRC = PutData( TR_TrackRecord, lcTrackRecord, TR_DiscID );
        lcRC = Error( PXSrchKey( lcTrackTable, lcTrackRecord, 1, SEARCHFIRST ) );
        if ( lcRC == PXSUCCESS )
          do
            {
              lcRC = Error( PXRecGet( lcTrackTable, lcTrackRecord ) );
              lcField = 0;
              while ( ( lcField <= TR_LASTFIELD ) &&
                      ( lcRC == PXSUCCESS ) )
                {
                  lcRC = GetData( TR_TrackRecord, lcTrackRecord, lcField );
                  lcField++;
                }
              lcRC = HPLaserJetCursor( lcLaserJetHandle, lcHoriz + 25, lcVert );
              fprintf( lcLaserJetHandle, "|" );
              lcRC = HPLaserJetCursor( lcLaserJetHandle, lcHoriz + 75, lcVert );
              fprintf( lcLaserJetHandle, "%s", TR_TrackRecord[ TR_TrackID ].fldBuffer );
              lcRC = HPLaserJetCursor( lcLaserJetHandle, lcHoriz + 150, lcVert );
              fprintf( lcLaserJetHandle, "%s", TR_TrackRecord[ TR_Title ].fldBuffer );
              lcRC = HPLaserJetCursor( lcLaserJetHandle, lcHoriz + 900, lcVert );
              fprintf( lcLaserJetHandle, "%s", TR_TrackRecord[ TR_Min ].fldBuffer );
              lcRC = HPLaserJetCursor( lcLaserJetHandle, lcHoriz + 950, lcVert );
              fprintf( lcLaserJetHandle, "%s", TR_TrackRecord[ TR_Sec ].fldBuffer );
              lcRC = HPLaserJetCursor( lcLaserJetHandle, lcHoriz + 1000, lcVert );
              fprintf( lcLaserJetHandle, "%s", TR_TrackRecord[ TR_Sec100 ].fldBuffer );
              if ( lcVert >= 3000 )
                {
                  lcVert = 50;
                  fwrite( formfeed, 1, sizeof( formfeed ), lcLaserJetHandle );
                }
              else
                {
                  lcVert += 25;
                }

              lcRC = PXSrchKey( lcTrackTable, lcTrackRecord, 1, SEARCHNEXT );
            }
          while( lcRC != PXERR_RECNOTFOUND );
        lcRC = PXRecNext( lcPrintTable );
      }
    while ( lcRC != PXERR_ENDOFTABLE );
    fclose( lcLaserJetHandle );

    lcRC = Error( PXRecBufClose( lcPrintRecord ) );
    if ( lcRC == PXSUCCESS )
    lcRC = Error( PXTblClose( lcPrintTable ) );
    if ( lcRC == PXSUCCESS )
      lcRC = Error( PXTblDelete( "PRINT" ) );

    return PXSUCCESS;
  }

//----------------------------------------------------------------------------
int cd_newid( TABLEHANDLE lcDiscTable, TABLEHANDLE lcTrackTable,
              RECORDHANDLE lcDiscRecord, RECORDHANDLE lcTrackRecord )
  {
    int lctrack,
        lcendtrack,
        lcRC;

    strcpy( TR_TrackRecord[ TR_DiscID ].fldBuffer, SR_SearchRecord[ SR_DiscID ].fldBuffer );
    lcRC = PutData( TR_TrackRecord, lcTrackRecord, TR_DiscID );
    lcRC = PXSrchKey( lcTrackTable, lcTrackRecord, 1, SEARCHFIRST );
    if ( lcRC == PXSUCCESS )
      {
        lctrack = 1;
        while ( TR_TrackArray[ lctrack ].title != NULL )
          {
            lcRC = Error( PXRecGet( lcTrackTable, lcTrackRecord ) );
            lcRC = GetData( TR_TrackRecord, lcTrackRecord, TR_Title );
            strcpy( TR_TrackArray[ lctrack ].title, TR_TrackRecord[ TR_Title ].fldBuffer );
            strcpy( TR_TrackRecord[ TR_DiscID ].fldBuffer, DR_DiscRecord[ DR_DiscID ].fldBuffer );
            lcRC = PutData( TR_TrackRecord, lcTrackRecord, TR_DiscID);
            lcRC = Error( PXRecUpdate( lcTrackTable, lcTrackRecord ) );
            lcRC = Error( PXSave( ) );

            strcpy( TR_TrackRecord[ TR_DiscID ].fldBuffer, SR_SearchRecord[ SR_DiscID ].fldBuffer );
            lcRC = PutData( TR_TrackRecord, lcTrackRecord, TR_DiscID );
            lcRC = PXSrchKey( lcTrackTable, lcTrackRecord, 1, SEARCHFIRST );
            lctrack++;
          }
      }

    strcpy( TR_TrackRecord[ TR_DiscID ].fldBuffer, DR_DiscRecord[ DR_DiscID ].fldBuffer );
    strcpy( DR_DiscRecord[ DR_DiscID ].fldBuffer, SR_SearchRecord[ SR_DiscID ].fldBuffer );
    strcpy( DR_DiscRecord[ DR_Title ].fldBuffer, SR_SearchRecord[ SR_Title ].fldBuffer );
    lcRC = PutData( DR_DiscRecord, lcDiscRecord, DR_DiscID );
    lcRC = PXSrchKey( lcDiscTable, lcDiscRecord, 1, SEARCHFIRST );
    if ( lcRC == PXSUCCESS )
      {
        lcRC = Error( PXRecGet( lcDiscTable, lcDiscRecord ) );

        strcpy( DR_DiscRecord[ DR_DiscID ].fldBuffer, TR_TrackRecord[ TR_DiscID ].fldBuffer );
        lcRC = PutData( DR_DiscRecord, lcDiscRecord, DR_DiscID);
        lcRC = Error( PXRecUpdate( lcDiscTable, lcDiscRecord ) );
        lcRC = Error( PXSave( ) );
      }
    return PXSUCCESS;

  }
//----------------------------------------------------------------------------
int cd_deleteid( TABLEHANDLE lcDiscTable, TABLEHANDLE lcTrackTable,
                 RECORDHANDLE lcDiscRecord, RECORDHANDLE lcTrackRecord )
  {
    int lcRC;

    strcpy( TR_TrackRecord[ TR_DiscID ].fldBuffer, DR_DiscRecord[ DR_DiscID ].fldBuffer );
    lcRC = PutData( TR_TrackRecord, lcTrackRecord, TR_DiscID );
    lcRC = PXSrchKey( lcTrackTable, lcTrackRecord, 1, SEARCHFIRST );
    while ( lcRC == PXSUCCESS )
      {
        lcRC = PXRecDelete( lcTrackTable );
        lcRC = PXSrchKey( lcTrackTable, lcTrackRecord, 1, SEARCHFIRST );
      }

    lcRC = PutData( DR_DiscRecord, lcDiscRecord, DR_DiscID );
    lcRC = PXSrchKey( lcDiscTable, lcDiscRecord, 1, SEARCHFIRST );
    if ( lcRC == PXSUCCESS )
      {
        lcRC = PXRecDelete( lcDiscTable );
      }
    return PXSUCCESS;
  }

//----------------------------------------------------------------------------
int cd_cleantable( TABLEHANDLE lcDiscTable, TABLEHANDLE lcTrackTable,
                   RECORDHANDLE lcDiscRecord, RECORDHANDLE lcTrackRecord )
  {
    int lcRC;

    lcRC = Error( PXRecFirst( lcDiscTable ) );
    do
      {
        lcRC = Error( PXRecGet( lcDiscTable, lcDiscRecord ) );
        lcRC = GetData( DR_DiscRecord, lcDiscRecord, DR_DiscID );
        strcpy( TR_TrackRecord[ TR_DiscID ].fldBuffer, DR_DiscRecord[ DR_DiscID ].fldBuffer );
        lcRC = PutData( TR_TrackRecord, lcTrackRecord, TR_DiscID );
        lcRC = PXSrchKey( lcTrackTable, lcTrackRecord, 1, SEARCHFIRST );
        if ( lcRC == PXERR_RECNOTFOUND )
          {
            lcRC = PXRecDelete( lcDiscTable);
          }
        else
          {
            lcRC = PXRecNext( lcDiscTable );
          }
      }
    while ( lcRC == PXSUCCESS );

    return lcRC;
  }

//----------------------------------------------------------------------------
int process_loop( TABLEHANDLE lcDiscTable, TABLEHANDLE lcTrackTable,
                  RECORDHANDLE lcDiscRecord, RECORDHANDLE lcTrackRecord )
  {
    int lcRC,
        lcFound,
        lcField,
        lcSearch,
        bgntrack,
        endtrack,
        numcdroms = 0,
        ourdrive = 0,
        firstdrive = 0,
        quitcd = 0,
        status = 0,
        lcAutoAdd = 1;
    long sframe,
         f,
         dframes,
         lc10,
         lcsec,
         lcmin,
         track;
    word lcCmd;
    char lcLine[ 80 ];
    struct trackinfo ti;
    struct cdtable *cdt;
    struct date lcDate;

    if ( ( !ismscdex( ) ) ||
         ( !( numcdroms = getnumcdroms( ) ) ) ||
         ( !( firstdrive = getfirstcdrom( ) ) ) )
      {
        if ( !ismscdex( ) )
          {
            sprintf( glString, "CDMUSIC: %s", nomscdex );
            glWindow.wFastText( glString, 20, 2 );
          }
        else
          {
            sprintf( glString, "CDMUSIC: %s", nodrives );
            glWindow.wFastText( glString, 20, 2 );
          }
      }

    do
      {
        lcRC = PXSUCCESS;
        ourdrive = firstdrive;
        do
          {
            status = cdstatus( ourdrive );
          }
        while ( !( status & CDISHERE) );

        cdt = buildaudiotoc( ourdrive );
            //initialize Disc Record
            lcField = 0;
            while ( lcField <= DR_LASTFIELD )
            {
              strcpy( DR_DiscRecord[ lcField ].fldBuffer, "" );
              lcField++;
            }

            //initialize Track Record
            lcField = 0;
            while ( lcField <= TR_LASTFIELD )
            {
              strcpy( TR_TrackRecord[ lcField ].fldBuffer, "" );
              lcField++;
            }

            //initialize Search Record
            lcField = 0;
            while ( lcField <= SR_LASTFIELD )
              {
                strcpy( SR_SearchRecord[ lcField ].fldBuffer, "" );
                lcField++;
              }

            for ( lcField = 1; lcField <= 99; lcField++ )
              {
                if ( lcField <= cdt->di.ltrk )
                  {
                    TR_TrackArray[ lcField ].title = ( char * ) malloc( 80 );
                    if ( TR_TrackArray[ lcField ].title != NULL )
                      {
                        strcpy( TR_TrackArray[ lcField ].title, "" );
                      }
                  }
                else
                  {
                    TR_TrackArray[ lcField ].title = NULL;
                  }
              }
            sprintf( DR_DiscRecord[ DR_DiscID ].fldBuffer, "%ld", cdt->di.eodisc );
            lcRC = PutData( DR_DiscRecord, lcDiscRecord, DR_DiscID );
            if ( lcRC == PXSUCCESS )
              lcRC = PXSrchKey( lcDiscTable, lcDiscRecord, 1, SEARCHFIRST );
            if ( lcRC == PXSUCCESS )
              {
                lcFound = 1;
                lcRC = cd_getdisc( lcDiscTable, lcTrackTable, lcDiscRecord, lcTrackRecord );
              }
            else
              {
                lcFound = 0;
                if ( lcAutoAdd )
                  {
                    lcRC = addcdrecord( lcDiscTable, lcTrackTable,
                                        lcDiscRecord, lcTrackRecord,
                                        cdt->di.eodisc, cdt->di.ltrk, ourdrive );
                  }
              }

            lcCmd = cd_scrn( lcDiscTable, lcDiscRecord, lcSearch );
            switch ( lcCmd )
              {
                case ccQuit  : {
                                 if ( ( !lcFound ) &&
                                      ( lcAutoAdd ) )
                                   {
                                     cd_update( lcDiscTable, lcTrackTable, lcDiscRecord, lcTrackRecord );
                                   }
                                 else
                                   {
                                     cd_update( lcDiscTable, lcTrackTable, lcDiscRecord, lcTrackRecord );
                                   }
                                 break;
                               }
                case ccUser0 : {
                                 break;
                               }
                case ccUser1 : {
                                 if ( lcSearch )
                                   {
                                     lcRC = cd_deleteid( lcDiscTable, lcTrackTable, lcDiscRecord, lcTrackRecord );
                                     lcRC = cd_newid( lcDiscTable, lcTrackTable, lcDiscRecord, lcTrackRecord );
                                     lcRC = cd_update( lcDiscTable, lcTrackTable, lcDiscRecord, lcTrackRecord );
                                   }
                                 break;
                               }
                case ccUser2 : {
                                 //handled in cd_scrn()
                                 break;
                               }
                case ccUser3 : {
                                 quitcd = 1;
                                 break;
                               }
                case ccUser8 : {
                                 lcRC = cd_cleantable( lcDiscTable, lcTrackTable, lcDiscRecord, lcTrackRecord );
                                 break;
                               }
                case ccUser9 : { //Print Report
                                 lcRC = cd_print( lcDiscTable, lcTrackTable, lcDiscRecord, lcTrackRecord );
                                 break;
                               }
                case ccUser10: {
                                 break;
                               }
              }

            for ( lcField = cdt->di.ltrk; lcField >= 1; lcField-- )
              {
                free( ( void * ) TR_TrackArray[ lcField ].title );
              }

            lcRC = Error( PXRecBufEmpty( lcDiscRecord ) );
            lcRC = Error( PXRecBufEmpty( lcTrackRecord ) );

          destroyaudiotoc(ourdrive);
          cdeject( ourdrive );
      }
    while( !quitcd );

    return(OKAY);
  }

/*--------------------------------------------------------------------------*/
  int process_main( void )
    {
      int exist,
          lcRC;
      RECORDHANDLE lcDiscRecord,
                   lcTrackRecord;
      TABLEHANDLE  lcDiscTable,
               lcTrackTable;

      OPRawWindowInit();

      glWindow.InitCustom( 2, 2, 79, 23, cdColors, wBordered + wClear );
      glWindow.wFrame.AddHeader( "CDMUSIC Status Window", heTC );
      glWindow.Draw();

      lcRC = Error( PXTblExist( "DISC", &exist ) );
      if ( lcRC == PXSUCCESS )
      {
        if ( exist )
          {
            lcRC = Error( PXTblOpen( "DISC", &lcDiscTable, 0, 0 ) );
            if ( lcRC == PXSUCCESS )
            lcRC = Error( PXRecBufOpen( lcDiscTable, &lcDiscRecord ) );
          }
        else
          {
            lcRC = MakeTable( &lcDiscTable, DR_DiscRecord, "DISC", &lcDiscRecord, DR_LASTFIELD + 1 );
          }
      }
      if ( lcRC == PXSUCCESS )
      {
        if ( lcRC == PXSUCCESS )
          lcRC = GetTableStructure( lcDiscTable );
        if ( lcRC == PXSUCCESS )
          lcRC = CheckTableStructure( lcDiscTable, DR_DiscRecord, DR_LASTFIELD + 1 );
        if ( lcRC == PXSUCCESS )
          lcRC = CheckTableStructure( lcDiscTable, SR_SearchRecord, SR_LASTFIELD + 1 );
        if ( lcRC == PXSUCCESS )
          lcRC = DeleteTableStructure( lcDiscTable );
      }

      if ( lcRC == PXSUCCESS )
      lcRC = Error( PXTblExist( "TRACK", &exist ) );
      if ( lcRC == PXSUCCESS )
      {
        if ( exist )
          {
            lcRC = Error( PXTblOpen( "TRACK", &lcTrackTable, 0, 0 ) );
            if ( lcRC == PXSUCCESS )
            lcRC = Error( PXRecBufOpen( lcTrackTable, &lcTrackRecord ) );
          }
        else
          {
            lcRC = MakeTable( &lcTrackTable, TR_TrackRecord, "TRACK", &lcTrackRecord, TR_LASTFIELD + 1 );
          }
      }
      if ( lcRC == PXSUCCESS )
      {
        if ( lcRC == PXSUCCESS )
          lcRC = GetTableStructure( lcTrackTable );
        if ( lcRC == PXSUCCESS )
          lcRC = CheckTableStructure( lcTrackTable, TR_TrackRecord, TR_LASTFIELD + 1 );
        if ( lcRC == PXSUCCESS )
          lcRC = DeleteTableStructure( lcTrackTable );
      }


      if ( lcRC == PXSUCCESS )
        lcRC = process_loop( lcDiscTable, lcTrackTable, lcDiscRecord, lcTrackRecord );

      lcRC = PXSUCCESS;
      if ( lcRC == PXSUCCESS )
        lcRC = Error( PXRecBufClose( lcTrackRecord ) );
      if ( lcRC == PXSUCCESS )
        lcRC = Error( PXRecBufClose( lcDiscRecord ) );
      if ( lcRC == PXSUCCESS )
        lcRC = Error( PXTblClose( lcTrackTable ) );
      if ( lcRC == PXSUCCESS )
        lcRC = Error( PXTblClose( lcDiscTable ) );

      glWindow.wFrame.AddHeader( "Finished - Press any key", heBC );
      glWindow.wFrame.UpdateFrame();
      ReadKeyWord();
      glWindow.Erase();
      glWindow.Done();

      return lcRC;
    }

/*--------------------------------------------------------------------------*/
main( void )
  {
    int rc;

    printf( "CDMUSIC.EXE: CD music library database input/scanner v1.0\n" );
    printf( "Uses Paradox v4.0 database format with CD-ROM drive\n" );

    rc = ( Error ( PXInit( ) ) );
    if (rc == PXSUCCESS)
      {
        return( process_main() );
      }
    else
      {
        printf( "CDMUSIC: %s\n", PXErrMsg( rc ) );
      }
    return PXSUCCESS;
  }
