001 '	Original Program in BASIC

100 ' MINIFTZ4.3, COPYRIGHT BY FTZ DARMSTADT, FGR FI34, APRIL 1989
105 ' HF-FIELD STRENGTH PREDICTION
110 DEFINT I-N: DIM F(2), FR(3), IFX(24, 4, 2, 4), IV(4, 3, 3), IF9(4, 2)
120 DIM MVT(12, 10, 2), M3C(10, 2), M3T(24, 2, 2), ITAB(12, 24), FTAB(12)
122 DIM ISUN(12), RD(40), BTR(2), F2MUF(3, 24), FBTRM(3, 24), EMUF(24)
124 DIM ELUFY(24), CLONG(40), CLAT(40), IDEC(26, 2), IDIS(26), VV(4), FF(4)
126 DIM EM(5), FOT(3, 24), HPF(24), TX$(2), WIN(12)
130 M$ = "JAN.FEB.MAR.APR.MAY JUNEJULYAUG.SEP.OCT.NOV.DEC."
140 TX$(1) = "HF-FIELD STRENGTH": TX$(2) = "MODES AND ELEVATION ANGLES"
150 P$ = "S": PW$ = "Y": ANGM = 3: SAG = 0: ZKW = 1: IPROZ = 50: IANZ = 12
160 DATA 0,3,4,5,6,8,10,12,15,18,22,26: FOR I = 1 TO 12: READ FTAB(I): NEXT I
170 DATA 2.2,1.4,0.3,0.0,0.0,0.0,0.0,0.0,0.0,0.3,1.4,2.2
180 FOR I = 1 TO 12: READ WIN(I): NEXT I
200 CLS : PRINT "DATA LOADING ...": GOSUB 500
202 PI = 3.14159: PI2 = PI / 2: PID = PI * 2: AK = PI / 180: BK = 180 / PI: DK = .0062137
204 RO = 6371.2: XLG = 2.30259
210 '
214 ' INPUT FROM KEYBOARD
218 '
222 CLS : IDU = 1
226 PRINT "MONTH (0=STOP):  ("; MONTH; ") "; : GOSUB 4940: IF LL = 0 THEN 234
230 IF II < 0 OR II > 12 THEN 226 ELSE MONTH = II
234 IF MONTH = 0 THEN END
238 PRINT "YEAR:  ("; JAHR; ") "; : GOSUB 4940: IF LL = 0 THEN 246
242 IF II < 0 OR II > 99 THEN 238 ELSE JAHR = II
246 PRINT "SSN:  ("; SSN; ") "; : GOSUB 4940: IF AA = 0 THEN 254
250 IF AA < 0 THEN 246 ELSE SSN = AA
254 PRINT "TX-NAME:  ("; TXN$; ") "; : GOSUB 4940: IF LL = 0 THEN 258 ELSE TXN$ = T$
258 PRINT "TX-LAT IN DEG. (N=+, S=-):  ("; X1; ") "; : GOSUB 4940: IF LL = 0 THEN 266
262 IF ABS(AA) > 90 THEN 258 ELSE X1 = AA
266 PRINT "TX-LONG IN DEG. (E=+, W=-):  ("; Y1; ") "; : GOSUB 4940: IF LL = 0 THEN 274
270 IF ABS(AA) > 180 THEN 266 ELSE Y1 = AA
274 PRINT "RX-NAME:  ("; RXN$; ") "; : GOSUB 4940: IF LL = 0 THEN 278 ELSE RXN$ = T$
278 PRINT "RX-LAT IN DEG. (N=+, S=-):  ("; X2; ") "; : GOSUB 4940: IF LL = 0 THEN 286
282 IF ABS(AA) > 90 THEN 278 ELSE X2 = AA
286 PRINT "RX-LONG IN DEG. (E=+, W=-):  ("; Y2; ") "; : GOSUB 4940: IF LL = 0 THEN 294
290 IF ABS(AA) > 180 THEN 286 ELSE Y2 = AA
294 PRINT "POWER IN KW:  ("; ZKW; ") "; : GOSUB 4940: IF LL = 0 THEN 302
298 IF AA < 0 OR AA > 2000 THEN 294 ELSE ZKW = AA
302 PRINT "TX-ANTENNA GAIN IN DBI:  ("; SAG; ") "; : GOSUB 4940: IF LL = 0 THEN 310
306 SAG = AA
310 PRINT "PERCENTAGE OF TIME (10,50,90):  ("; IPROZ; ") "; : GOSUB 4940
314 IF LL = 0 THEN 322 ELSE IF II <> 10 AND II <> 50 AND II <> 90 THEN 310
318 IPROZ = II
322 PRINT "PATH: S=SHORT, L=LONG:  ("; P$; ") "; : GOSUB 4940: IF LL = 0 THEN 330
326 P$ = T$: IF P$ = "l" THEN P$ = "L"
330 PRINT "MINIMUM ANGLE:  ("; ANGM; ") "; : GOSUB 4940: IF LL = 0 THEN 338
334 IF AA < 0 OR AA > 90 THEN 330 ELSE ANGM = AA
338 PRINT "ANGLE- AND MODE-TABLE (Y/N):  ("; PW$; ") "; : GOSUB 4940
342 IF LL = 0 THEN 346 ELSE PW$ = T$: IF PW$ = "n" THEN PW$ = "N"
346 PRINT "MAX. 11 FREQUENCIES (0 = END OF FREQUENCIES):"
350 PRINT "("; : FOR I = 2 TO IANZ: PRINT FTAB(I); : NEXT I: PRINT ")"
354 IAN = 1
358 GOSUB 4940: IF LL = 0 THEN 384 ELSE 366
362 GOSUB 4940
366 IF AA < 0 OR AA > 40 THEN 362 ELSE IAN = IAN + 1: FTAB(IAN) = AA
370 IF AA = 0 THEN IANZ = IAN - 1: GOTO 384
374 IF IAN = 12 THEN IANZ = IAN ELSE GOTO 362
384 PRINT : PRINT "CALCULATING ..."
388 '
392 ' GREAT CIRCLE DISTANCE
396 '
400 SSP = ISUN(MONTH) * .1 * AK: XX1 = X1 * AK: XX2 = X2 * AK: YY1 = Y1 * AK
410 YY2 = Y2 * AK: GCD = SIN(XX1) * SIN(XX2) + COS(XX1) * COS(XX2) * COS(YY2 - YY1)
420 GCD = PI2 - ATN(GCD / SQR(1 - GCD * GCD)): IF GCD < 0 THEN GCD = PI + GCD
430 GCDK = GCD: IF P$ = "L" THEN GCD = 2! * PI - GCD
440 GCDKM = GCD * RO: IHOPE = FIX(GCDKM / 2000) + 1: IHOPF = FIX(GCDKM / 4000) + 1
442 XKM = GCDKM / IHOPE: HP = 110: GOSUB 4890: IF W < ANGM THEN IHOPE = IHOPE + 1: GOTO 442
444 XKM = GCDKM / IHOPF: HP = 300: GOSUB 4890: IF W < ANGM THEN IHOPF = IHOPF + 1: GOTO 444
450 HOPKME = GCDKM / IHOPE: HOPKMF = GCDKM / IHOPF: RD(1) = GCD / 2: RD(2) = .5 * HOPKMF / RO
460 RD(3) = GCD - .5 * HOPKMF / RO: RD(4) = .5 * HOPKME / RO: RD(5) = GCD - .5 * HOPKME / RO
470 GOTO 2300
480 '
490 ' SUB READ DATA
495 '
500 OPEN "I", #1, "FTZMUF2.DAT"
510 FOR M = 1 TO 4: FOR N = 1 TO 2: FOR J = 1 TO 4: FOR I = 1 TO 24
520 INPUT #1, IFX(I, J, N, M): NEXT I: NEXT J: NEXT N: NEXT M
530 FOR N = 1 TO 2: FOR J = 1 TO 4: INPUT #1, IF9(J, N): NEXT J: NEXT N
550 FOR N = 1 TO 2: FOR J = 1 TO 10: FOR I = 1 TO 12
560 INPUT #1, MVT(I, J, N): NEXT I: NEXT J: NEXT N
570 FOR N = 1 TO 2: FOR J = 1 TO 2: FOR I = 1 TO 24
580 INPUT #1, M3T(I, J, N): NEXT I: NEXT J: NEXT N
590 FOR N = 1 TO 2: FOR J = 1 TO 10: INPUT #1, M3C(J, N): NEXT J: NEXT N
600 FOR N = 1 TO 3: FOR J = 1 TO 3: FOR I = 1 TO 4: INPUT #1, IV(I, J, N)
610 NEXT I: NEXT J: NEXT N: CLOSE
620 DATA 10,8,7,5,5,5,5,5,6,7,10,13,13,13,12,11,10,9,9,9,8,8,8,7,7,6
630 DATA 10,9,8,7,6,6,7,8,10,12,14,13,11,10,9,8,8,8,8,8,7,7,6,5,4,3
640 FOR J = 1 TO 2: FOR I = 1 TO 26: READ IDEC(I, J): NEXT I: NEXT J
650 DATA 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,25,30
660 DATA 35,40,45,50
670 FOR I = 1 TO 26: READ IDIS(I): NEXT I
680 DATA 0,-24,-11,90,1,1.55,2.4,5
690 FOR I = 1 TO 4: READ FF(I): NEXT I: FOR I = 1 TO 4: READ VV(I): NEXT I
700 DATA -212,-127,-22,97,188,233,216,141,31,-84,-184,-233
710 FOR I = 1 TO 12: READ ISUN(I): NEXT I: RETURN
1280 '
1285 'SUB MUF
1290 '
1295 X = CLAT(II): Y = CLONG(II)
1300 GX = X * PI / 180: Q = .9799 * SIN(GX) + .1994 * COS(GX) * COS(1.204 + Y * PI / 180)
1305 IF Q > 1 THEN Q = 1 ELSE IF Q < -1 THEN Q = -1
1310 GAX = ATN(Q / SQR(1 - Q * Q)) * 180 / PI
1315 AX = ABS(GAX): SN = SSN * .01: MON = MONTH: T = IT + Y / 15: IF T >= 24 THEN T = T - 24
1320 IF T < 0 THEN T = T + 24
1325 LT = CINT(T): IF LT = 0 THEN LT = 24
1430 ' FOF2
1435 LB = 1: IF GAX >= 0 THEN 1470
1445 LB = 2: MON = MON + 6: IF MON > 12 THEN MON = MON - 12
1470 MON1 = FIX(MON / 3): MON2 = MON1 + 1: IF MON1 = 0 THEN MON1 = 4
1500 IF MON2 > 4 THEN MON2 = 1
1502 M1 = FIX(AX / 10) + 1: M2 = M1 + 1: IF M2 > 10 THEN M2 = 10
1504 N1 = FIX(AX / 20) + 1: IF N1 > 4 THEN N1 = 4
1506 N2 = N1 + 1
1510 BX = (N1 * 20 - AX) / 20: IF AX > 60 THEN BX = (90 - AX) / 30
1520 DI = (MON - FIX(MON / 3) * 3) / 3: DX = (AX - M1 * 10 + 10) / 10
1650 FOR K = 1 TO 2
1652 LF1 = IFX(LT, MON2, K, N1): GOSUB 2260: LF2 = LF1
1654 LF1 = IFX(LT, MON1, K, N1): GOSUB 2260: FT = (LF2 - LF1) * DI + LF1
1670 IF AX > 60 THEN 1710
1680 LF1 = IFX(LT, MON2, K, N2): GOSUB 2260: LF2 = LF1
1682 LF1 = IFX(LT, MON1, K, N2): GOSUB 2260: GOTO 1730
1710 LF1 = IF9(MON2, K): GOSUB 2260: LF2 = LF1
1720 LF1 = IF9(MON1, K): GOSUB 2260
1730 FH = (LF2 - LF1) * DI + LF1: XR = (FT - FH) * BX + FH
1740 LF1 = MVT(MON, M2, K): GOSUB 2260: LF2 = LF1
1745 LF1 = MVT(MON, M1, K): GOSUB 2260: XK = (LF2 - LF1) * DX + LF1
1750 F(K) = XR * XK: NEXT K
1760 F50 = ((F(2) - F(1)) * SN + F(1)) * .001
1990 ' M3000
1995 AX = ABS(X): LX = FIX((AX + 5) / 10) + 1: DIF = (LT - FIX(LT / 6) * 6) / 6
2000 MON = MONTH: IF X > 0 THEN 2005
2002 MON = MON + 6: IF MON > 12 THEN MON = MON - 12
2005 CM = ABS(MON - 6) / 6
2010 FOR K = 1 TO 2: FR(K) = (M3T(LT, 2, K) - M3T(LT, 1, K)) * SN + M3T(LT, 1, K): NEXT K
2030 BX = AX: IF BX > 40 THEN BX = 40
2050 BX = BX / 40: XM3X = (FR(2) - FR(1)) * BX + FR(1)
2060 XCMD = (M3C(LX, 2) - M3C(LX, 1)) * CM + M3C(LX, 1) + XM3X: BM = ABS(LT - 12) / 12
2080 XM3 = ((XM3X - XCMD) * BM + XCMD) / 100
2090 ' 10/90 PERCENT OF FOF2
2095 J1 = FIX(T / 6): J2 = J1 + 1: IF J1 = 0 THEN J1 = 4
2098 IF J2 > 4 THEN J2 = 1
2100 IM = FIX(ABS(MON - 6.5) / 2 + 1): BX = AX: IF BX > 75 THEN BX = 75
2120 IF BX < 15 THEN BX = 15
2130 FOR K = 1 TO 3: IV1 = IV(J1, K, IM): FR(K) = ((IV(J2, K, IM) - IV1) * DIF + IV1) * .01
2160 NEXT K: IF BX > 40 THEN 2200
2180 FAK = (FR(3) - FR(2)) * BX / 40 + FR(3): GOTO 2210
2200 FAK = (FR(2) - FR(1)) * (BX - 40) / 35 + FR(1)
2210 F10 = F50 * FAK: F90 = F50 / FAK * .96
2230 ' MUF FOR 4000 KM
2240 GYRO = AX / 100 + .8: F4000 = F50 * XM3 * 1.1
2250 RETURN
2260 ' SUB DECODE
2270 M = 0: LW = FIX(LF1 / 256): IF LW >= 0 THEN 2290
2280 LF1 = LF1 + 32768!: LW = FIX(LF1 / 256): M = 1
2290 IF LB = 2 THEN LF1 = LF1 - LW * 256: RETURN
2292 LF1 = LW: IF M = 1 THEN LF1 = LF1 + 128
2295 RETURN
2300 '
2310 ' LUF-CONSTANTS
2320 '
2330 HOP = FIX(GCDKM / 3000) + 1: IHOP = HOP: N = 2 * HOP: IF IHOP = 1 THEN 2350
2340 K5 = 6: K6 = N + 5: GOTO 2360
2350 K5 = 2: K6 = N + 1
2360 ARCHOP = GCD / HOP: HOPKM = GCDKM / HOP: AR2 = ARCHOP / 2
2370 PHIF = ATN(RO * SIN(AR2) / (RO + 300 - RO * COS(AR2)))
2380 DP2N = RO * SIN(AR2) / SIN(PHIF): GCDKO = DP2N * HOP * 2: DELTA = PI - PHIF - AR2
2390 PHID = RO * SIN(DELTA) / (RO + 90)
2395 PHID = ATN(PHID / SQR(1 - PHID * PHID))
2400 B = 5.3 / SQR(COS(PHID) * LOG(9500000! / GCDKO)): DP = PI - DELTA - PHID: DN2 = 2 * DP
2410 DN4 = ARCHOP - DN2: RD(K5) = DP
2420 FOR I = K5 TO K6 - 1 STEP 2: RD(I + 1) = RD(I) + DN4: RD(I + 2) = RD(I + 1) + DN2
2425 NEXT I
2430 DFK = SQR(1 + 8.999999E-03 * SSN): FLUNA = SQR(GCDKM / 3000): ABKLP = FLUNA * 2
2440 '
2450 ' AZIMUT
2460 '
2465 ZX1 = XX1: ZX2 = XX2: ZY1 = YY1: ZY2 = YY2: ZGCD = GCDK: GOSUB 3900
2470 IF P$ <> "L" THEN BTR1 = BTR(1): BTR2 = BTR(2): GOTO 2500
2480 IF BTR(1) < 180 THEN BTR1 = 180 + BTR(1) ELSE BTR1 = BTR(1) - 180
2490 IF BTR(2) < 180 THEN BTR2 = 180 + BTR(2) ELSE BTR2 = BTR(2) - 180
2500 '
2510 ' ELFC AND FLFC
2520 '
2530 ARC = HOPKME * DK
2540 ELFC = ((((((-4.368E-09 * ARC + 1.335E-07) * ARC - 5.977E-06) * ARC + .0002625) * ARC - .005039) * ARC + .03761) * ARC - .01332) * ARC + .2085
2550 ARC = HOPKMF * DK
2560 FLFC = ((((((-6.713E-09 * ARC + 4.492E-07) * ARC - 9.986E-06) * ARC + 6.865E-05) * ARC + 9.201999E-05) * ARC + .002265) * ARC + .004699) * ARC
2570 '
2580 ' COORDINATES AND PENETRATION POINTS
2590 '
2600 IF IHOPF = 1 THEN K1 = 1: K2 = 1: K3 = 1: K4 = 1: GOTO 2620
2610 K1 = 2: K2 = 3: K3 = 4: K4 = 5
2620 FOR II = 1 TO K6: PP = RD(II)
2630 CENLAT = COS(PP) * COS(PI2 - XX2) + SIN(PP) * SIN(PI2 - XX2) * COS(BTR2 * AK)
2640 CENLAT = (PI2 - ATN(CENLAT / SQR(1 - CENLAT * CENLAT))) * BK
2650 IF CENLAT < 0 THEN CENLAT = -90 - CENLAT ELSE CENLAT = 90 - CENLAT
2660 CENLG = (COS(PP) - COS(PI2 - CENLAT * AK) * COS(PI2 - XX2)) / SIN(PI2 - CENLAT * AK) / SIN(PI2 - XX2)
2670 IF CENLG > .9999 THEN CENLG = .9999
2672 IF CENLG < -.9999 THEN CENLG = -.9999
2680 CENLG = (PI2 - ATN(CENLG / SQR(1 - CENLG * CENLG))) * BK
2690 IF BTR2 > 180 AND PP < PI THEN CENLG = -CENLG
2692 IF BTR2 < 180 AND PP > PI THEN CENLG = -CENLG
2700 CENLG = YY2 * BK + CENLG: IF CENLG > 180 THEN CENLG = CENLG - 360
2710 IF CENLG < -180 THEN CENLG = CENLG + 360
2720 CLAT(II) = CENLAT: CLONG(II) = CENLG
2725 NEXT II
2730 '
2740 ' W,X,Y
2750 '
2760 WOW = .1: WNS = .2: XOW = 1.2: XNS = .2: YOW = .6: YNS = .4
2765 ZX1 = XX1: ZY1 = YY1: ZX2 = CLAT(1) * AK: ZY2 = CLONG(1) * AK: ZGCD = GCDK / 2
2770 GOSUB 3900: BTT = BTR(2): IF BTT > 180 THEN BTT = BTT - 180
2780 IF BTT < 90 THEN BTT = 90 - BTT ELSE BTT = BTT - 90
2785 ZB = BTT / 90: ZL = 1 - ZB
2790 WW = WOW * ZL + WNS * ZB: XX = XOW * ZL + XNS * ZB: YY = YOW * ZL + YNS * ZB
2800 '
2810 ' F2-MUF
2820 '
2830 GYR = 0: FOR IT = 1 TO 24: HPF(IT) = 0: FOR II = 1 TO K2: GOSUB 1280
2850 IF IT = 1 THEN GYR = GYR + GYRO
2860 GAMMA3 = F50 + .5 * GYRO: F2MUF(II, IT) = GAMMA3 + FLFC * (F4000 - GAMMA3)
2862 GAMMA3 = F90 + .5 * GYRO: FOT(II, IT) = GAMMA3 + FLFC * (F90 * XM3 * 1.1 - GAMMA3)
2864 HPF(IT) = HPF(IT) + XM3: NEXT II
2870 HPF(IT) = HPF(IT) / K2
2872 NEXT IT
2875 GYR = GYR / K2: FOR II = 1 TO K2: GOSUB 3800: NEXT II
2880 '
2890 ' E-MUF
2900 '
2910 FOR IT = 1 TO 24: EMUF(IT) = 0: IF GCDKM > 4000 THEN 2994
2920 GMT = IT: ZT = (15 * GMT - 180) * AK: FOR II = K3 TO K4: CENLG = CLONG(II) * AK
2930 CENLAT = CLAT(II) * AK: Z = ZT + CENLG
2940 CYCEN = SIN(CENLAT) * SIN(SSP) + COS(CENLAT) * COS(SSP) * COS(Z)
2950 IF CYCEN < 0 THEN CYCEN = 0
2970 XKE = 2.25 + 1.5 * COS(CENLAT) + (.01 - .007 * COS(CENLAT)) * SSN
2980 XN = .21 + .12 * COS(CENLAT) + .0002 * SSN: FE = XKE * CYCEN ^ XN
2990 EM(II) = FE * ELFC * 5: NEXT II: EMUF(IT) = EM(K3)
2992 IF EMUF(IT) > EM(K4) THEN EMUF(IT) = EM(K4)
2994 NEXT IT
3000 '
3010 ' LUF
3020 '
3030 FOR IT = 1 TO 24: GMT = IT: ZT = (15 * GMT - 180) * AK: ELUFY(IT) = 0: FOR II = K5 TO K6
3040 CENLG = CLONG(II) * AK: CENLAT = CLAT(II) * AK: Z = ZT + CENLG
3050 CYCEN = SIN(CENLAT) * SIN(SSP) + COS(CENLAT) * COS(SSP) * COS(Z)
3060 IF CYCEN < 0 THEN CYCEN = 0
3070 CYCEN = SQR(CYCEN): GOSUB 4990: ELUFY(IT) = ELUFY(IT) + CYCEN: NEXT II
3080 ELUFY(IT) = SQR(ELUFY(IT)) * DFK * B - GYR
3090 IF ELUFY(IT) < FLUNA THEN ELUFY(IT) = FLUNA
3100 NEXT IT
3110 '
3120 ' DECAY TO NIGHT-LUF
3130 '
3140 FOR IT = 1 TO 24: ILF = IT - 1: IF ILF < 1 THEN ILF = ILF + 24
3150 IF ELUFY(ILF) < ELUFY(IT) THEN 3200 ELSE IF ELUFY(IT) > ABKLP THEN 3200
3160 IF ELUFY(IT) = ABKLP THEN ILB = IT: GOTO 3230
3170 IF ELUFY(ILF) < ABKLP THEN 3200
3180 IF ELUFY(ILF) = ABKLP THEN ILB = ILF: GOTO 3230
3190 ILB = IT: GOTO 3210
3200 NEXT IT: GOTO 3300
3210 ELUFY(ILB) = .795 * ELUFY(ILF) * (((ABKLP - ELUFY(ILB)) / (ELUFY(ILF) - ELUFY(ILB))) * (1 - .795) + .795)
3220 IF ELUFY(ILB) < FLUNA THEN ELUFY(ILB) = FLUNA
3230 FOR IT = 1 TO 3: ILF = IT + ILB: ILG = ILF - 1: IF ILF = 25 THEN 3250
3240 IF ILF < 25 THEN 3260 ELSE ILG = ILG - 24
3250 ILF = ILF - 24
3260 IF ELUFY(ILF) < FLUNA THEN 3290 ELSE ELU = ELUFY(ILG) * .795
3270 IF ELUFY(ILF) < ELU THEN ELUFY(ILF) = ELU
3280 IF ELUFY(ILF) < FLUNA THEN ELUFY(ILF) = FLUNA
3290 NEXT IT
3300 '
3310 ' MUF
3320 '
3325 FOR IT = 1 TO 24: IF F2MUF(K1, IT) < F2MUF(1, IT) THEN F2MUF(1, IT) = F2MUF(K1, IT)
3326 IF F2MUF(K2, IT) < F2MUF(1, IT) THEN F2MUF(1, IT) = F2MUF(K2, IT)
3328 IF F2MUF(1, IT) < EMUF(IT) THEN F2MUF(1, IT) = EMUF(IT)
3330 IF FBTRM(K1, IT) < FBTRM(1, IT) THEN FBTRM(1, IT) = FBTRM(K1, IT)
3340 IF FBTRM(K2, IT) < FBTRM(1, IT) THEN FBTRM(1, IT) = FBTRM(K2, IT)
3350 IF FBTRM(1, IT) < EMUF(IT) THEN FBTRM(1, IT) = EMUF(IT)
3360 IF FOT(K1, IT) < FOT(1, IT) THEN FOT(1, IT) = FOT(K1, IT)
3370 IF FOT(K2, IT) < FOT(1, IT) THEN FOT(1, IT) = FOT(K2, IT)
3380 IF FOT(1, IT) < EMUF(IT) THEN FOT(1, IT) = EMUF(IT)
3390 NEXT IT
3410 '
3420 ' FIELD STRENGTH
3430 '
3440 A = GCDKM * PI / 20000: C = A: IF GCDKM > 20000 THEN C = 2 * PI - A
3450 IF GCDKM > 30000 THEN C = A - PI
3460 FOCUS = 10 * LOG(C / SIN(C)) / XLG: IF FOCUS > 15 THEN FOCUS = 15
3470 D0 = 139.6 - 20 * LOG(GCDKO) / XLG
3480 FOR IT = 1 TO 24: XM = FBTRM(1, IT): FM2 = (XM + GYR) ^ 2: FL2 = (ELUFY(IT) + GYR) ^ 2
3490 IF XM < ELUFY(IT) THEN CLM = FL2 / (FM2 + FL2) ELSE CLM = FM2 / (FM2 + FL2)
3500 FTAB(1) = F2MUF(1, IT): FOR J = 1 TO IANZ: F9 = (FTAB(J) + GYR) ^ 2
3510 FLF = FL2 / F9: FFM = F9 / FM2
3520 FELD = (D0 * (1 - CLM * (FLF + FFM))) - 30 + SAG + FOCUS + 10 * LOG(ZKW) / XLG
3525 IF FELD < -999 THEN FELD = -999
3530 GOSUB 4200: GOSUB 4020: ITAB(J, IT) = CINT(FELD): NEXT J: PRINT: NEXT IT
3540 '
3550 ' OUTPUT
3560 '
3570 PRINT TX$(IDU); " ESTIMATED BY MINIFTZ4.3": PRINT
3580 PRINT "CIRCUIT : "; TXN$; : PRINT TAB(24); "- "; RXN$;
3585 PRINT TAB(56); "MONTH  :";
3590 MON$ = MID$(M$, (MONTH - 1) * 4 + 1, 4): PRINT "    "; MON$; JAHR
3600 PRINT USING "LOCATION: ##.#"; ABS(X1);
3605 A$ = "N": IF X1 < 0 THEN A$ = "S"
3610 PRINT A$; : PRINT USING " ###.#"; ABS(Y1);
3615 A$ = "E": IF Y1 < 0 THEN A$ = "W"
3620 PRINT A$; "   "; : PRINT USING "##.#"; ABS(X2);
3625 A$ = "N": IF X2 < 0 THEN A$ = "S"
3630 PRINT A$; : PRINT USING " ###.#"; ABS(Y2);
3635 A$ = "E": IF Y2 < 0 THEN A$ = "W"
3638 PRINT A$;
3640 PRINT TAB(56); "SSN    :        "; : PRINT USING "###"; SSN
3650 PRINT USING "AZIMUTH : ###.# DEG.      ###.# DEG."; BTR1; BTR2;
3660 PRINT TAB(56); "POWER  : "; : PRINT USING "###.### KW"; ZKW
3670 PRINT USING "DISTANCE: ##### KM"; GCDKM; : PRINT TAB(56);
3680 PRINT USING "TX-GAIN:   ###.# DB"; SAG
3685 PRINT USING "MIN-ANG.:  ##.# DEG."; ANGM: PRINT : IF IDU = 2 THEN 3702
3690 PRINT "      FIELD STRENGTH IN DB ABOVE 1 UV/M FOR"; IPROZ;
3700 PRINT "PERCENT OF TIME": PRINT : PRINT "UTC  MUF  DBU  FOT  "; : GOTO 3710
3702 PRINT TAB(22); "MODES AND ELEVATION ANGLES"
3704 PRINT : PRINT "UTC  MUF MODE  FOT  ";
3710 FOR J = 2 TO IANZ: PRINT USING "##.# "; FTAB(J); : NEXT J: PRINT " LUF": PRINT
3715 FOR I = 1 TO 24: PRINT USING "##  ##.#"; I; F2MUF(1, I); : FTAB(1) = F2MUF(1, I)
3718 J = 1: GOSUB 4800: PRINT T$; : PRINT USING " ##.# "; FOT(1, I);
3726 FOR J = 2 TO IANZ: GOSUB 4800: PRINT T$; : NEXT J: PRINT USING " ##.#"; ELUFY(I): NEXT I
3728 PRINT CHR$(12); : IF IDU = 2 OR PW$ = "N" THEN 210 ELSE IDU = 2: GOTO 3570
3800 '
3810 ' SUB KORMU
3820 '
3830 IF GCDKM > 4000 THEN UFCOR = 1 ELSE UFCOR = 1 + 1 - (GCDKM / 4000) ^ 2
3840 IMIT = CINT(12 - CLONG(II) / 15): IF IMIT < 1 THEN IMIT = IMIT + 24
3850 UFMAX = F2MUF(II, IMIT): UFMIN = F2MUF(II, 1)
3860 FOR I = 2 TO 24: IF F2MUF(II, I) < UFMIN THEN UFMIN = F2MUF(II, I)
3870 NEXT I: UFQU = YY * (UFMIN / UFMAX) ^ 2: FOR I = 1 TO 24: F = F2MUF(II, I)
3890 FBTRM(II, I) = UFCOR * F * (1.2 + WW * (F / UFMAX) + ((UFMAX / F) ^ .3333 - 1) * XX + UFQU)
3895 NEXT I: RETURN
3900 '
3910 ' SUB BEAR
3920 '
3930 U = .5 * (PI - ZX1 - ZX2 + ZGCD): U1 = U - PI2: SU = SIN(U - ZGCD): ZXX1 = ZX2: ZXX2 = ZX1
3940 ZYY1 = ZY2: ZYY2 = ZY1: FOR I = 1 TO 2: DF = ZYY2 - ZYY1: IF ABS(DF) < PI THEN 3960
3950 IF DF < 0 THEN DF = DF + PID ELSE DF = DF - PID
3960 SIND = SIN(U) * SIN(U1 + ZXX1): IF SIND = 0 THEN BT = 180: GOTO 4000
3970 BT = 114.5916 * ATN(SQR(ABS(SIN(U1 + ZXX2) * SU / SIND)))
3980 IF DF < 0 THEN 4000 ELSE IF DF > 0 THEN BT = 360 - BT: GOTO 4000
3990 IF ZXX1 - ZXX2 < 0 THEN BT = 180
4000 BTR(I) = BT: ZXX1 = ZX1: ZXX2 = ZX2: ZYY1 = ZY1: ZYY2 = ZY2
4005 NEXT I: RETURN
4010 '
4020 ' SUB DECILE
4030 '
4040 IF IPROZ = 50 THEN RETURN
4050 IF IPROZ = 10 THEN KA = 1: SI = 1 ELSE KA = 2: SI = -1
4060 FFG = FTAB(J) / F2MUF(1, IT)
4070 IF FFG > 5 THEN FFG = 5 ELSE IF FFG < .1 THEN FFG = .1
4080 IF FFG > 2 THEN KBL = FIX((FFG - 2) * 2 + 20) ELSE KBL = FIX(FFG * 10)
4090 IF KBL > 25 THEN KBL = 25
4100 KBH = KBL + 1: DISDB = IDEC(KBH, KA) - IDEC(KBL, KA)
4110 DISFG = (FFG * 10 - IDIS(KBL)) / (IDIS(KBH) - IDIS(KBL))
4120 WAL = (IDEC(KBL, KA) + DISDB * DISFG) * SI
4130 FELD = FELD + WAL: RETURN
4200 '
4210 ' SUB FCOR
4220 '
4230 IF GCDKM > 4000 THEN RETURN ELSE V = FTAB(J) / F2MUF(1, IT)
4240 IF V < 1 THEN RETURN ELSE IF V > 5 THEN V = 5
4241 K = 1
4242 IF K <= 3 AND (V < VV(K) OR V > VV(K + 1)) THEN K = K + 1: GOTO 4242
4260 Z = ((V - VV(K)) / (VV(K + 1) - VV(K))) * (FF(K + 1) - FF(K)) + FF(K)
4270 Z = Z * (4000 - GCDKM) / 4000: FELD = FELD + Z: RETURN
4800 '
4810 ' SUB MODE/ANGLE
4820 '
4822 IF IDU = 2 THEN 4840 ELSE T$ = RIGHT$("    " + STR$(ITAB(J, I)), 5)
4825 IF ITAB(J, I) < -40 THEN T$ = "  ...": RETURN ELSE RETURN
4840 IF FTAB(J) <= EMUF(I) THEN HP = 110: XKM = HOPKME: A$ = "E": IA = IHOPE: GOTO 4860
4850 HP = 1490 / HPF(I) - 176: XKM = HOPKMF: A$ = "F": IA = IHOPF
4860 GOSUB 4890: IF IW < 0 THEN IW = 0
4880 T$ = STR$(IA) + A$ + RIGHT$(STR$(IW + 100), 2): ZZ = 1.04 * F2MUF(1, I) ^ 2 / FOT(1, I)
4882 IF FTAB(J) > ZZ OR ITAB(J, I) < -40 THEN T$ = " ...."
4885 RETURN
4890 '
4900 ' SUB ANGLE
4910 '
4930 d = .5 * XKM / RO: W = ATN((COS(d) - RO / (RO + HP)) / SIN(d)) * 360 / PID
4935 IW = CINT(W): RETURN
4940 '
4950 ' SUB INPUT
4960 '
4970 INPUT T$: LL = LEN(T$): AA = VAL(T$): IF AA < 65536! THEN II = VAL(T$)
4975 RETURN
4980 '
4990 'SUB WINTER
5000 '
5010 MON = MONTH: XLAT = CLAT(II): IF XLAT > 0 THEN 5030
5020 MON = MON + 6: XLAT = -XLAT: IF MON > 12 THEN MON = MON - 12
5030 WI = WIN(MON): W = 1: IF XLAT < 35 THEN 5090
5040 IF XLAT > 60 THEN 5060
5050 WK = WI * ((XLAT - 35) / 25): GOTO 5070
5060 WK = WI * ((90 - XLAT) / 30)
5070 ENTFK = 1000 / GCDKM: IF ENTFK > 1 THEN ENTFK = 1
5080 W = 1 + WK * (1 - SSN * .005) * ENTFK
5090 CYCEN = CYCEN * W: RETURN
5100 END

