#include <dos.h>
#include <conio.h>
#include "demo.h"
#include <stdio.h>

 /*-------------------------------------------------------------------------
    Font is saved in the filenamed DEMO.PAS.  To use the font, you must call
   interrupt 10h, function 11h, sub-function 10h to load up the font.
   
   The following are the parameter needed to call the function:
  
                  AX  =  0x1110      (ah = 0x11, al = 0x10)
		  BH  =  bytes per character 
		  BL  =  block to load to.  (use 0)
		  CX  =  number of character defined by table
		  DX  =  starting character value
		  ES  =  segment of the table 
		  BP  =  offset of the table 

   Notice:  You should always upload the character immediately after set
            the Video mode.  Also you must make sure that page 0 is active.
	    If it is not call immediately after the video mode set, some
	    side effects may occur.  I had experience some palette errors
	    my self, when I call this function with out changing video 
	    mode.  This doesn't happen all the time, however.  But be on 
	    the safe side is the best.   
   
   FONT MANIA will supply you with the height of the font.  It is defined
   by your label name with "_POINTS" added at the end of the string.  For
   example, if your label reference is call DEMO, then DEMO_POINTS will 
   represent the byte-per-character of the font (the height of the font).
   
   Set the CX to 256 if you want to upload the whole font.   If you want to 
   only upload part of font.  Set CX to whatever number of the character 
   you want to upload, and set DX to the first character you want to upload.
   
   For example, suppose you want to upload the character 65 to 88, 
   ('A' to 'Z') and the label reference is DEMO.  Here are the parameter
   needed:
   
		 AX  =  0x1110;
		 BH  =  DEMO_POINTS;
		 BL  =  0;
		 CX  =  24;               ( 24 characters to load )
		 DX  =  65;               ( first character to load )
		 ES  =  FP_SEG(DEMO);
		 BP  =  FP_OFF(DEMO);
		 
   See below for examples of how to set the registers. 
		 

 --------------------------------------------------------------------------*/


void main(void) {
  int i;
  struct REGPACK r;

  printf("This is font test\n\n");

  for (i=0; i<256; i++) {
    cprintf(" %c", i);
    if (!(i % 32) && (i != 0))
      printf("\n");
  }
  printf("\n\nPress any key to load the font...\n");
  getch();

  r.r_ax = 3;				/* always set video mode first */
  intr(0x10, &r);

  r.r_ax = 0x1110;
  r.r_bx = 0x0e00;
  r.r_cx = 256;
  r.r_dx = 0;
  r.r_es = FP_SEG(TEST);
  r.r_bp = FP_OFF(TEST);
  intr(0x10, &r);

  printf("\nFont loaded\nPress any key...");
  getch();

}


