(* FONT MANIA pascal font *)

uses
    DOS, CRT;

(*--------------------------------------------------------------------------

   Font is saved in the filenamed DEMO.PAS.  To use the font, you must call
   interrupt 10h, function 11h, sub-function 10h to load up the font.
   
   The following are the parameter needed to call the function:
  
                  AX  =  $1110      (ah = $11, al = $10)
		  BH  =  bytes per character 
		  BL  =  block to load to.  (use 0)
		  CX  =  number of character defined by table
		  DX  =  starting character value
		  ES  =  segment of the table (use Seg())
		  BP  =  offset of the table (use Ofs())

   Notice:  You should always upload the character immediately after set
            the Video mode.  Also you must make sure that page 0 is active.
	    If it is not call immediately after the video mode set, some
	    side effects may occur.  I had experience some palette errors
	    my self, when I call this function with out changing video 
	    mode.  This doesn't happen all the time, however.  But be on 
	    the safe side is the best.   
   
   FONT MANIA will supply you with the height of the font.  It is defined
   by your label name with "_POINTS" added at the end of the string.  For
   example, if your label reference is call DEMO, then DEMO_POINTS will 
   represent the byte-per-character of the font (the height of the font).
   
   Set the CX to 256 if you want to upload the whole font.   If you want to 
   only upload part of font.  Set CX to whatever number of the character 
   you want to upload, and set DX to the first character you want to upload.
   
   For example, suppose you want to upload the character 65 to 88, 
   ('A' to 'Z') and the label reference is DEMO.  Here are the parameter
   needed:
   
		 AX  =  $1110;
		 BH  =  DEMO_POINTS;
		 BL  =  0;
		 CX  =  24;               ( 24 characters to load )
		 DX  =  65;               ( first character to load )
		 ES  =  Seg(DEMO);
		 BP  =  Ofs(DEMO);
		 
   See below for examples of how to set the registers. 
		 
		  
---------------------------------------------------------------------------*)

{$I DEMO.PAS}			
Var
   r : registers;
   temp : char;

BEGIN
  WriteLn('This is a font test');
  WriteLn('Press any key to begin upload the font');
  temp := readkey;

  r.ax := $0500;			(* make sure that it's page 0 *)
  intr($10, r);
  
  r.ax := 3;				(* must set the vdo mode first *)
  intr($10, r);

  r.ax := $1110;
  r.bh := test_points;                   (* bytes per character *)
  r.bl := 0;                             (* load to block 0 *)
  r.cx := 256;                           (* 256 characters *)
  r.dx := 0;                             (* start with character 0 *)
  r.es := Seg(test);                     (* segment of table *)
  r.bp := Ofs(test);                     (* offset of the table *)
  intr($10, r);

  WriteLn('Font loadded');
  temp := readkey;

END.