#include <fstream.h>
#include "vector.hpp"

ostream& operator<< (ostream& f, const Vector& V)
{
    f.setf(ios::showpoint | ios::fixed);
    f.width(8);
    f.precision(4);
    f << V.x << " " << V.y << " " << V.z;

    return f;
}


Vector min (const Vector& V1, const Vector& V2)
{
    Vector V;

    V.x = (V1.x < V2.x) ? V1.x : V2.x;
    V.y = (V1.y < V2.y) ? V1.y : V2.y;
    V.z = (V1.z < V2.z) ? V1.z : V2.z;

    return V;
}

Vector max (const Vector& V1, const Vector& V2)
{
    Vector V;

    V.x = (V1.x > V2.x) ? V1.x : V2.x;
    V.y = (V1.y > V2.y) ? V1.y : V2.y;
    V.z = (V1.z > V2.z) ? V1.z : V2.z;

    return V;
}

