#ifndef __VECTOR_HPP
#define __VECTOR_HPP

#include <math.h>
#include <fstream.h>

class Vector {
    public:
      float x, y, z;

      Vector() {x = 0.0; y = 0.0; z = 0.0;}
      Vector (float NewX, float NewY, float NewZ)
	       {x = NewX; y = NewY; z = NewZ;}

      friend Vector operator+ (Vector V1, Vector V2);
      friend Vector operator- (Vector V1, Vector V2);
      friend Vector operator- (Vector V);
      friend Vector operator* (Vector V1, Vector V2);
      friend float  operator% (Vector V1, Vector V2);
      friend Vector operator* (float N, Vector V);
      friend Vector operator* (Vector V, float N);
      friend Vector operator/ (Vector V, float N);
      friend Vector min (const Vector& V1, const Vector& V2);
      friend Vector max (const Vector& V1, const Vector& V2);
      friend float  mag (Vector V);

      friend ostream& operator<< (ostream& f, const Vector& V);
};

inline float mag (Vector V)
{
    return (sqrt(V.x*V.x + V.y*V.y + V.z*V.z));
}

inline Vector operator+ (Vector V1, Vector V2)
{
    return Vector (V1.x + V2.x, V1.y + V2.y, V1.z + V2.z);
}

inline Vector operator- (Vector V1, Vector V2)
{
    return Vector (V1.x - V2.x, V1.y - V2.y, V1.z - V2.z);
}

inline Vector operator- (Vector V)
{
    return Vector (-V.x, -V.y, -V.z);
}

inline Vector operator* (Vector V1, Vector V2)
{
    Vector Temp;

    Temp.x = (V1.z * V2.y) - (V1.y * V2.z);
    Temp.y = (V1.x * V2.z) - (V1.z * V2.x);
    Temp.z = (V1.y * V2.x) - (V1.x * V2.y);

    return Temp;
}

inline float operator% (Vector V1, Vector V2)
{
    return (V1.x*V2.x) + (V1.y*V2.y) + (V1.z*V2.z);
}

inline Vector operator* (float N, Vector V)
{
    return Vector (N*V.x, N*V.y, N*V.z);
}

inline Vector operator* (Vector V, float N)
{
    return Vector (N*V.x, N*V.y, N*V.z);
}


inline Vector operator/ (Vector V, float N)
{
    return Vector (V.x/N, V.y/N, V.z/N);
}

#endif
