/*
NAME: 		lookup.c
AUTHOR: 	Duane Paulson
		Assembler subroutine SOUND.ASM by A.L. Bender, MD
VERSION:	1.0
DATE:		01/28/92

CALL:		LOOKUP word dictionary_file [n[o_pause]]

PURPOSE:	Performs Soundex search for 'word' in file 'dictionary_file'
		'Dictionary_file' should contain a list of words, with each
		word separated by a Carriage-return/Linefeed combination.

RETURNS:	nothing
*/

#include <ctype.h>
#include <stdio.h>
#include <string.h>
#include <conio.h>

extern   int soundex( char *output, char *input);

void main( int argc, char *argv[] )
{
	char 	string[256];
	char  target[5];
	char  source[5];
	char  *src_sdx;
	char  *targ_sdx;
	char  *src_str;
	int   lines = 0;
	int   pause = 1;
	FILE 	*fp;

	printf( "\nLOOKUP %c ver 1.0 %c 01/28/92\n", 254, 254 );

	if ( argc == 1 || argc > 4 )
	{
		printf( "LOOKUP word dictionary_file [n[o_pause]]\n" );
		return;
	}

	if ( argc == 4 && tolower(argv[3][0]) == 'n' )
		pause = 0;

	if( fp = fopen( argv[2], "rb" ) )
	{
		printf( "\nPerforming Soundex search for \"%s\" in <%s>...\n\n", argv[1], argv[2] );
		targ_sdx = target;
		soundex( targ_sdx, argv[1] );
		while( fgets( string, 256, fp ) )
		{
			src_str = string;
			src_sdx = source;
			string[strlen( string ) - 2] = '\0';  /* strip CR-LF */
			soundex( src_sdx, src_str );
			if ( !strcmp( source, target ) )
			{
				printf( "%s\n", string );
				lines++;
				if ( lines == 23 && pause )
				{
					printf( "\tPress a key to continue..." );
					getch();
					lines = 0;
					printf( "\n" );
				}
			}
		}
		printf( "\t**Done**\n" );
		fclose( fp );
	}
	else
		printf( "Error opening file %s.\n", argv[2] );
}

