		PAGE	,132
		
		TITLE	Soundex Subroutine

		COMMENT	$

	This subroutine will generate a string of characters representing
	the soundex code for a particular name.  The name is assumed to all
	alphabetic characters, left adjusted in the string addressed by the
	pointer surname.  The output goes into a five byte string sound
	terminated by a zero.  This string is always initialized to: "0000"
	and the fifth byte is set to zero.
	If there is a valid name in surname, the function returns 0.  Otherwise
	it returns 1.  No data storage is used.  SI and DI are used but are
	preserved.  

	Reference: Remington-Rand Soundex Code Brochure
	Programmed By A. L.  Bender, M. D.
	PO Box 8685, Woodcliff Lake, NJ 07675-8685


	This is freely in public domain and may be used without restriction.
	The large model version was tested.

	Assemble with:
	masm /Mx /Dlanguage={C||BASIC||PASCAL||FORTRAN} /Dmemmodel={LARGE||MEDIUM||COMPACT||SMALL} sound,,,;
	use:
	extern int soundex(char *output, *input);
	char *input;
	char output[5];

	if (soundex(output, input))
		bad exit
	else
		good exit


Note special adaptations will be needed for Pascal and Basic as well as FORTRAN

$
%		.MODEL	memmodel,language
		IF	@DataSize
		.FARDATA
		ELSE
		.DATA
		ENDIF
;			 ABCDEFGHIJKLMNOPQRSTUVWXYZ
sndx		DB	'01230120022455012623010202'

		.CODE
soundex		PROC	sound:PTR BYTE, surname:PTR BYTE
		IF	@DataSize
		PUSH	ES
		PUSH	DS
		ENDIF
		PUSH	SI
		PUSH	DI
		PUSHF		
		CLD			; don't forget this
		IF	@DataSize
		LDS	SI, surname
		LES	DI, sound
		ELSE
		MOV	SI, surname
		MOV	DI, sound
		ENDIF
		MOV	CX,4
		MOV	AX,30H	;	"0\000"
		push	di	;	Save DI for the loop guts
		REP STOSB	;	Clear Destination Area
		MOV	[DI],AH	;	Add termination character (\000)
		pop	di	;	Recover destination address

		LODSB		;	Get first letter of the name
		AND	AL,NOT 20H	;Mask away lower case bit
		CMP	AL,'A'	;	check for A-Z
		JC	badexit
		CMP	AL,'Z'+1;
		JNC	badexit
		STOSB		;	First character of name
		MOV	CX,3	;	Set to store three characters
		MOV	BX,OFFSET sndx	;set up the XLATB
		MOV	AH,AL	;	Remember starting character
		IF	@DataSize
		MOV	DX,SEG FAR_DATA
		ENDIF
sloop:		LODSB		;	get the next character
		CMP	AL,','	;	break on comma or zero
		JZ	done	;	finished
		TEST	AL,AL	;
		JZ	done	;	EOS done
		CMP	AL,' '	;	blank
		JZ	sloop	;	get another character
		CMP	AL,"'"	;	apostrophe
		JZ	sloop	;	get another character
		CMP	AL,'-'	;	dash
		JZ	sloop	;	get another character
		AND	AL,NOT 20H	;convert to upper case
		CMP	AL,AH	;	Is this character the same as the last one?
		JZ	sloop	; 	yes, ignore it - get another character
		MOV	AH,AL	;	Replace last character with current
		SUB	AL,'A'	;	Normalize character wrt sound array
		JC	sloop	;	not alphabetic
		CMP	AL,'Z'-'A'+1	;check for beyond Z
		JNC	sloop	;	not A thru Z
		IF	@DataSize
		PUSH	DS
		MOV	DS,DX
		ENDIF
		XLAT		;	Replace AL with soundex code value
		IF	@DataSize
		POP	DS
		ENDIF
		CMP	AL,'0'	;	Vowel or non assigned soundex letter
		JZ	sloop	;	get another character
		STOSB		;	Insert code into string
		LOOP	sloop	;	did we do three yet?
done:		XOR	AX,AX	;	clear ax for good exit		

exit:		POPF
		POP	DI
		POP	SI
		IF	@DataSize
		POP	DS
		POP	ES
		ENDIF
		RET

badexit:	MOV	AX,1
		JMP	SHORT EXIT
soundex		ENDP
		END
