#define TRUE 1
#define FALSE 0
#define MAX_CMD_LN 128
#define MAX_PRG_NM 100
#define MAX_PRG_LN 100
#define MAX_NR_FLS 500
#include <process.h>
#include <dir.h>
#include <dos.h>
#include <conio.h>
#include <stdio.h>
#include <io.h>
#include <fcntl.h>
#include <string.h>

/* UDF prototypes */
void copyright(void);
void cleatype(void);
void error(void);
int findlast(char *,char);


int main(int nr_args,char *arg[])
{

char cmd_line[MAX_CMD_LN],prog_name[MAX_PRG_NM],*pathfile[MAX_PRG_NM],
     *ext[]={".COM",".EXE",".BAT"};
int f_handle,done,stop,c,pause=FALSE,verify=FALSE,answer=FALSE,
    place_file=FALSE,no_file=FALSE,internal=FALSE,prog_len,ele,seq;
struct ftime ft;
struct ffblk ff;

copyright();

if(nr_args < 3)         /* Minimum allowable arguments */
{
   error();
   exit(1);
}

for(c=0;c<nr_args;c++)
   if(!stricmp(arg[c],"~i"))
   {
      internal=TRUE;
      strcpy(prog_name,arg[2]);
   }

if((!strchr(arg[2],'.')) && (!internal))
{
   for(c=0;c<3;c++)
   {
      strcpy(prog_name,arg[2]);
      strcat(prog_name,ext[c]);
      strcpy(cmd_line,searchpath(prog_name));
      if ((prog_len=strlen(cmd_line))!=0)
      {
         strcat(cmd_line," ");
         break;
      }
   }
}
else
{
   if(internal)
   {
      strcpy(cmd_line,prog_name);
      prog_len=strlen(cmd_line);
   }
   else
      strcpy(cmd_line,searchpath(prog_name));
   strcat(cmd_line," ");
}
if (!strlen(cmd_line))
{
   printf("Cannot locate program: %s",strupr(arg[2]));
   exit(1);
}
prog_len++;
done=findfirst(arg[1],&ff,0); /* set up loop for all found files */
if(done)                      /* Couldn't find first file */
{
   printf("Cannot locate %s\n\n",strupr(arg[1]));
   error();
   exit(1);
}
ele=-1;
while (!done)                        /* Start loop */
{
   if(ele==MAX_NR_FLS-1)
   {
      printf("\nToo many files to process (max=500).  Only processing ");
      printf("first 500 files.\n\n");
      cleatype();
      getch();
      break;
   }
   if((pathfile[++ele]=(char *)malloc(MAX_PRG_LN))==NULL)
   {
      printf("\nMemory allocation failure!\n");
      exit(1);
   }
   if (strrchr(arg[1],'\\'))         /* This whole test is necessary      */
   {                                 /* because findfirst() only returns  */
      strcpy(pathfile[ele],arg[1]);  /* the filename WITHOUT the path,    */
      stop=findlast(pathfile[ele],'\\');  /* even though the path is used to   */
      *(pathfile[ele]+(++stop))='\0';     /* find the file.  This wrecks havoc */
      strcat(pathfile[ele],ff.ff_name);   /* when you try to _open() the name  */
   }                                 /* found in ff.ff_name.              */
   else                              /* See my UDF findlast() for more.   */
       strcpy(pathfile[ele],ff.ff_name);
   done=findnext(&ff);           /* Search for next occurence of new file */
}

for(seq=0;seq <= ele;seq++)
{
   cmd_line[prog_len]='\0';
   for(c=3;c<nr_args;c++)
   {
      if(!stricmp(arg[c],"~f"))
      {
         place_file=TRUE;
         strcat(cmd_line,pathfile[seq]);
         strcat(cmd_line," ");
      }
      else
      {
         if((stricmp(arg[c],"~p")) && (stricmp(arg[c],"~v"))
            && (stricmp(arg[c],"~n")) && (stricmp(arg[c],"~i")))
         {
            strcat(cmd_line,arg[c]);
            strcat(cmd_line," ");
         }
         else
         if(!stricmp(arg[c],"~v"))
            verify=TRUE;
         else
         if(!stricmp(arg[c],"~p"))
            pause=TRUE;
         else
            no_file=TRUE;
      }
   }
   if((!place_file) && (!no_file))
      strcat(cmd_line,pathfile[seq]);

   f_handle=_open(pathfile[seq],O_RDONLY);   /* Read only mode, just to get    */
   getftime(f_handle,&ft);              /* the date-time stamp            */
   _close(f_handle);

   if(verify)
   {
      printf("\n\nAbout to execute:\n   %s\n\n",cmd_line);
      printf("Proceed? (y/N) ");
      cleatype();
      answer=getch();
      printf("\n");
      if((answer==121) || (answer==89))
         system(cmd_line);
      else
         printf("\nSkipping. . .\n\n");
   }
   else
      system(cmd_line);

   f_handle=_open(pathfile[seq],O_RDONLY);
   setftime(f_handle,&ft);       /* Write the changes to disk */
   _close(f_handle);             /* Close the file */

   if((pause) && ((seq+1) <= ele))
   {
      printf("\nPress any key to process next file. . .");
      cleatype();
      getch();
   }
   free((char *)pathfile[seq]);
}

exit(0);                   /* Exit to DOS, errorlevel 0 */
return(0);                 /* This is just to satisfy the linker */
                           /* so that function main() is given something */
                           /* back                                       */
}

/* USER DEFINED FUNCTIONS */

int findlast(char *a,char x)  /* Unlike strrchr(), this function returns  */
{                             /* the the last array element at which a    */
int i,c;                      /* character can be found in a string.      */
for(i=0;i<strlen(a);i++)      /* strrchr() returns a pointer to the rest  */
   if(*(a+i)==x)              /* of the string; findlast() returns the    */
      c=i;                    /* element number itself.                   */
return(c);
}

void error(void)   /* Just text to show the user how screwed up he is   */
{                 /* "\x07" (first line) is hex for ASCII 7, which     */
                  /* rings the bell                                    */

printf("\x07\nSyntax:\n   PRESERVE filename.ext [~i] [~v] [~p] [~n] [command] [~f] [options]\n\n");
printf("where:\n   filename.ext = The file(s) whose time/date you wish to preserve.\n");
printf("                  Wildcards ARE allowed.\n");
printf("   ~i - Mandatory if command to be repeated is an internal DOS command;\n");
printf("        otherwise PRESERVE will inform you that it cannot find that program.\n");
printf("   ~v = Used if you want to verify each operation before it is executed.\n");
printf("   ~p = Used to pause after each operation.\n");
printf("   ~n = Used if the filename(s) does not need to appear anywhere on the\n");
printf("        command line that is to be generated and executed.\n");
printf("   command = The program or DOS command that you wish to be performed on\n");
printf("             the file(s).\n");
printf("   ~f = The physical location in the command line where you want the\n");
printf("        filename(s) to appear when the program or command is executed.\n");
printf("   options = The options required by the program or command being called.\n\n");
printf("                             <- Press any key ->");
cleatype();
getch();
printf("\n\nThe order of the command-line parameters is irrelevant with the exception\n");
printf("of the filename(s) which must be the first parameter.  If the \"~f\" parameter\n");
printf("is omitted, then the filename(s) will be appended to the end of the command\n");
printf("to be executed, unless the \"~n\" parameter is found in which case the\n");
printf("filenames will be preserved, but will not appear anywhere on the command\n");
printf("lines before they are executed.\n\n");
printf("Some examples follow:\n\n");
printf("                             <- Press any key ->");
cleatype();
getch();
printf("\n\n   PRESERVE *.zip pkbanner ~f my_bann.asc\n");
printf("     Runs \"pkbanner\" on all zip files in the current directory, placing\n");
printf("     \"my_bann.asc\" on the command line right after each substituted filename.\n\n");
printf("   PRESERVE test*.c edit ~f ~v ~p\n");
printf("     Runs \"edit\" on all files that qualify \"TEST*.C\", verifies each call\n");
printf("     before it is made and pauses after each execution.\n\n");
printf("   PRESERVE data.* attrib +a ~f ~i\n");
printf("     If you're running 4DOS or NDOS (Norton), \"ATTRIB\" is an internal\n");
printf("     command.  The attribute of all DATA.* files will be updated.\n\n");
printf("   PRESERVE *.* refresh a: ~n\n");
printf("     Imagine that \"REFRESH\" is a program or batch file that automatically\n");
printf("     copies files from drive A back into the current directory, but you don't\n");
printf("     want the date-stamps to be changed.  Note the presence of the \"~n\" switch,\n");
printf("     letting PRESERVE know that a filename name is not needed on the command\n");
printf("     line to execute this command.\n\n\n\n");
printf("GOOD LUCK!\n");
return;

}

void copyright(void)         /* My one moment in fame and glory */
{
printf("\nRAE  E n t e r p r i s e s\nCopyright, 1992\nRichard A. Esterling\n");
printf("PRESERVE.EXE ver 1.01, Jul 92                                   File Preserver\n");
printf("\n");
return;
}

void cleatype(void)
{
while(kbhit())           /* Loop to clear buffer     */
   getch();              /* if user laid on keyboard */
return;
}
