code=1000
nobreak       /* no CTRL-C or CTRL-Break allowed */

/***************************************************************************/
/*									   */
/* This Program has been written specifically to help out people who use   */
/* Wordstar and need to convert to other formats. Plus some tricks...      */
/*									   */
/***************************************************************************/

DOMAINS

         file = input ; output

PREDICATES

	start1
	start(string)
	get_file(string,integer)
	strip_bit(string,integer)
	write_header
	convert(string,integer)
	get_numb(string,integer)
	
/**------------------------------------------------------------------------**/
	
GOAL
	start1.


/**------------------------------------------------------------------------**/
/**                             CLAUSES BODY                               **/
/**------------------------------------------------------------------------**/

CLAUSES

/* Get the Command Line Parameters and pass them on */

	START1 if
		write_header,
		comline(X),
		X = "?",!,
		clearwindow,
		write("StripBit 1.0 Options List"),nl,nl,
		write("Command Line Parameters are required in the format"),nl,nl,
		write(" STRIPBIT sourcefile destinationfile functionhexnumber"),nl,
		write(" where -"),nl,
		write("             sourcefile - any legal DOS path and filename"),nl,
		write("        destinationfile - any legal DOS path and filename"),nl,
		write("      functionhexnumber - "),nl,
		write("                          a or A is AND followed by any 2 digit"),nl,
		write("                                        hex number (00 to FF)"),nl,
		write("                          o or O is OR  followed by any 2 digit"),nl,
		write("                                        hex number (00 to FF)"),nl,
		write("                          x or X is XOR followed by any 2 digit"),nl,
		write("                                        hex number (00 to FF)"),nl,nl,
		write("Example; STRIPBIT myfile.lst myfile.tst"),nl,
		write("Example; STRIPBIT \\dos\\myfile.lst \\temp\\myfile.tst"),nl,
		write("Example; STRIPBIT myfile.lst myfile.tst X20"),nl,
		write("Example; STRIPBIT \\dos\\myfile.lst \\temp\\myfile.tst a7F"),nl,nl,
		write("Default operation when not using functionhexnumber AND's file with 7F"),nl,
		exit.
				
	START1 if
		write_header,
		comline(X),
		X <> "",!,
		start(X).

/* No parameters !, exit with grace and inform user */
		
	START1 if !,
		write("This program requires command line parameters in the"),nl,
		write("following format;"),nl,nl,
		write("  STRIPBIT source_path_file.ext destination_path_file.ext"),nl,
		write("       or"),nl,
		write("  STRIPBIT source_path_file.ext destination_path_file.ext function_hex_number"),nl,nl,
		write("  where function_hex_number can be A (AND), O (OR) or X (XOR) followed"),nl,
		write("  by any 2 digit hexidecimal number from 00 to FF, ie. X20 or A20 or O20"),nl,nl,nl,
		write("Abnormal Exit.....Missing parameters"),nl,
		exit.
	
/* Routine to test for source/destination/functionhexnumber if all are */
/* present then run this routine only into get_number		       */
	
	START(X) if
		str_len(X,A),
		searchstring(X," ",Ra),
		frontstr(Ra,X,_,Raa),
		searchstring(Raa," ",Sa),
		str_len(Raa,Aa),

		B = A - Ra + 1,		/* B=stringlength-" " position */
		Ba = A - B,
		frontstr(Ba,X,Y,_),     /* source filename */

		C = Aa - Sa + 1,
		Ca= Aa - C,
		frontstr(Ca,Raa,Z,Daa),
		frontstr(2,Daa,Type,Andwith),
		str_len(Andwith,Ua),
		frontstr(1,Type,_,Process),
		Ua = 2,
		existfile(Y),!,
		write("Source = ",Y,"  --> Destination = ",Z,"  And_with --> ",Andwith),nl,nl,
		openread(input,Y),
		openwrite(output,Z),
		filemode(output,1),
		readdevice(input),
		writedevice(output),
		convert(Andwith,Bitnum),
		get_file(Process,Bitnum),
		removewindow,
		closefile(input),
		closefile(output),
		readdevice(keyboard),
		writedevice(screen),
		write("Operation Completed....."),nl,
		exit.

/* Run this routine if only source/destination are present */
	
	START(X) if
		str_len(X,A),
		searchchar(X,$20,Position),
		B = A - Position,
		C = Position + 1,
		D = Position - 1,
		substring(X,1,D,Y),
		existfile(Y),!,
		substring(X,C,B,Z),
		write("Source = ",Y,"  --> Destination = ",Z),nl,nl,
		openread(input,Y),
		openwrite(output,Z),
		filemode(output,1),
		readdevice(input),
		writedevice(output),
		Bitnum = $7F,
		Tza = "A",
		get_file(Tza,Bitnum),
		removewindow,
		closefile(input),
		closefile(output),
		readdevice(keyboard),
		writedevice(screen),
		write("Operation Completed....."),nl,
		exit.

/* Exist with grace if the weiner used a non-existant filename or tried to */
/* run with a hex number length greater than 2 or no destination */
		
	START(_) if !,
		write("The source file does not exist or destination file"),nl,
		write("was not specified"),nl,nl,
		write("Check the disk, path and filename..."),nl,nl,
		write("Abnormal Exit....."),nl,
		exit.

/* File conversion loops follow */
	
	GET_FILE(A,Bitnum) if
		writedevice(output),
		strip_bit(A,Bitnum).
		
	GET_FILE(_,_) if !.
		
	STRIP_BIT("A",Bitnum) if	
		readchar(A),!,
		bitand(A,Bitnum,B),
		char_int(C,B),
		write(C),
		strip_bit("A",Bitnum).
	
	STRIP_BIT("a",Bitnum) if	
		readchar(A),!,
		bitand(A,Bitnum,B),
		char_int(C,B),
		write(C),
		strip_bit("a",Bitnum).
	
	STRIP_BIT("O",Bitnum) if	
		readchar(A),!,
		bitor(A,Bitnum,B),
		char_int(C,B),
		write(C),
		strip_bit("O",Bitnum).
	
	STRIP_BIT("o",Bitnum) if	
		readchar(A),!,
		bitor(A,Bitnum,B),
		char_int(C,B),
		write(C),
		strip_bit("o",Bitnum).
	
	STRIP_BIT("X",Bitnum) if	
		readchar(A),!,
		bitxor(A,Bitnum,B),
		char_int(C,B),
		write(C),
		strip_bit("X",Bitnum).
	
	STRIP_BIT("x",Bitnum) if	
		readchar(A),!,
		bitxor(A,Bitnum,B),
		char_int(C,B),
		write(C),
		strip_bit("x",Bitnum).
	
	STRIP_BIT(_,_) if !.

/* Opening Statement */
		
	WRITE_HEADER if
		clearwindow,nl,
		write("HighBit Reset Character Converter for Wordstar and other formats"),nl,
		write("Copyright (c) 1991, Steve Marett, Toronto"),nl,
		write("Written in PDC Prolog v3.21 - Time: 21 minutes"),nl,nl,
		write("This program converts characters with any hexidecimal value"),nl,
		write("to it's OR'd AND'd or XOR'd product dependant on your input"),nl,
		write("value. The default conversion is AND with 7F to convert data"),nl,
		write("higher than 80h to it's ASCII counterpart. No warranties"),nl,nl,
		write("are expressed or implied, this is freeware."),nl,nl.

/* Hex to Decimal Converter */

	CONVERT(X,Y) if
		frontstr(1,X,A,B),
		get_numb(A,Ya),
		get_numb(B,Yb),
		Y = ((Ya*15)+Yb).
		
	GET_NUMB("0",0) if !.
	GET_NUMB("1",1) if !.
	GET_NUMB("2",2) if !.
	GET_NUMB("3",3) if !.
	GET_NUMB("4",4) if !.
	GET_NUMB("5",5) if !.
	GET_NUMB("6",6) if !.
	GET_NUMB("7",7) if !.
	GET_NUMB("8",8) if !.
	GET_NUMB("9",9) if !.
	GET_NUMB("A",10) if !.
	GET_NUMB("B",11) if !.
	GET_NUMB("C",12) if !.
	GET_NUMB("D",13) if !.
	GET_NUMB("E",14) if !.
	GET_NUMB("F",15) if !.
	GET_NUMB("a",10) if !.
	GET_NUMB("b",11) if !.
	GET_NUMB("c",12) if !.
	GET_NUMB("d",13) if !.
	GET_NUMB("e",14) if !.
	GET_NUMB("f",15) if !.
	
	