/****************************************************************************/
/* U N I X 2 D O S -- ADDS CARRIAGE RETURN CHARACTERS BEFORE THE LINE FEED  */
/*                    CHARACTERS IN UNIX TEXT FILES TO MAKE THEM COMPATIBLE */
/*                    WITH THE DOS ENVIRONMENT.                             */
/*                                                                          */
/* TO DO THE WILDCARD EXPANSION, THIS PROGRAM MUST BE COMPILED WITH A       */
/* BORLAND C COMPILER AND LINKED WITH WILDARGS.OBJ, OR YOUR COMPILER'S      */
/* EQUIVALENT.  IF YOU ARE A MICROSOFT C USER, MY HEART BLEEDS FOR YOU AND  */
/* YOU'LL HAVE TO DO THE EXPANSION YOURSELF.  IF YOU COMPILE UNDER UNIX, OF */
/* COURSE, THE EXPANSION IS NOT NECESSARY.                                  */
/*                                                                          */
/* ALSO NOTE: THE BORLAND COMPILER DEFAULTS TO THE "TEXT" MODE FOR FILES,   */
/* WHICH MAKES fputc() PUT OUT A CR/LF PAIR WHEN IT'S GIVEN JUST A LF       */
/* CHARACTER (WHICH IS WHAT \n TRANSLATES TO).  I HAVE CHOSEN TO OPEN THE   */
/* FILES IN "BINARY" MODE AND ADD THE CR MYSELF, SINCE I THINK THAT KEEPS   */
/* THE CODE CLEARER, AND MAKES IT MORE PORTABLE.  I OPEN THE FILES WITH     */
/* THE "rb" AND "wb" TYPES TO SET THE MODE, THOUGH YOU COULD DO IT BY       */
/* SETTING THE VALUE OF THE GLOBAL _fmode BEFORE THE CALLS TO fopen().      */
/*                                                                          */
/* THIS CODE IS RELEASED TO THE PUBLIC DOMAIN, SO DON'T EVEN THINK OF       */
/* REGISTERING IT.                                                          */
/*                                                                          */
/* KEVIN PETRASEK, CIS [76530,540],  JANUARY 24, 1993                       */
/****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define LF 10
#define CR 13

/****************************************************************************/
/* FUNCTION PROTOTYPES                                                      */
/****************************************************************************/
void main(int argc,char *argv[]) ;
void putstr(char *str) ;       /* added to avoid printf to keep exe smaller */

/****************************************************************************/
/* M A I N -- Translate text files specified on the command line from the   */
/*            UNIX format to the DOS format by adding CR's before LF's.     */
/*            The Translation is done to a temporary file, and when each    */
/*            file is completed, the source file is deleted, and the        */
/*            translated file is renamed to take it's place.                */
/****************************************************************************/
void main(int argc,char *argv[]) {
  int  c, num, i, tnum;
  FILE *fpi,*fpo;
  char *ptr, *ptr2 ;
  char tempname[] = "udtemp.$$$";
  char buf[20] ;

  /* IF THERE WERE NO ARGUMENTS, TELL THEM HOW TO USE IT. */
  if (argc == 1) {
	 /*-----------------------------------------------------*/
	 /* The next few lines isolate the command name found   */
	 /* in the first argument string.  DOS turns the        */
	 /* command into a full path spec for the .exe program  */
	 /* that was invoked.  These lines isolate just the     */
	 /* .exe filename, without the extension.  This way,    */
	 /* the usage statement always uses the actual name     */
	 /* of the program file, instead of some bogus hard-    */
	 /* coded program name.                                 */
	 /*-----------------------------------------------------*/
  	 if((ptr = strrchr(argv[0], '\\')) == 0) ptr = argv[0] ;
	 else ptr++ ;
  	 if((ptr2 = strrchr(ptr, '.')) != 0) *ptr2 = 0 ;

	 putstr("\nConverts UNIX text files to DOS text files by adding CR's before LF's.\n") ;
	 putstr("Wildcards are allowed.  Source files are replaced and not preserved.\n\n") ;
     putstr("USAGE:\n\t") ;
     putstr(ptr) ;
     putstr(" filename\n");
     putstr("OR:\n\t") ;
     putstr(ptr) ;
     putstr(" filename1 filename2 filename3 ...\n\n");
     exit(1);
     }

  tnum = 0 ;

  /* FOR ALL THE FILES LISTED ON THE COMMAND LINE */
  for(i=1 ; i<argc ; i++) {
	  if ((fpi = fopen(argv[i],"rb")) == NULL) {		/* OPEN THE SOURCE */
	     putstr("ERROR: Can't Open ") ;
	     putstr(argv[i]) ;
	     putstr("\n");
	     exit(0);
	     }

	  if ((fpo = fopen(tempname,"wb")) == NULL) {		/* OPEN THE DEST.  */
	     putstr("ERROR: Can't Open Temporary File.\n");
		 fclose(fpi) ;
	     exit(0);
	     }

	  num = 0 ;								/* TO COUNT LINES */

	  while ((c = fgetc(fpi)) != EOF) {		/* GET EACH CHAR */
	    if(c == LF) {						/* SEE IF IT'S A LF */
	    	fputc(CR, fpo);					/* IF SO, ADD THE CR */
	    	num++ ;							/* AND COUNT IT */
	    	}

		if(c != CR) {						/* FILTER OUT ANY EXTRA CR's */
			fputc(c,fpo);					/* SEND EVERYTHING ELSE THROUGH */
			}
		}

	  tnum += num ;							/* COUNT THE TOTAL FOR ALL FILES */
	  fclose(fpo);							/* CLOSE THE DESTINATION */
	  fclose(fpi);							/* CLOSE THE SOURCE */
	  remove(argv[i]) ;						/* DELETE THE SOURCE */
	  rename(tempname, argv[i]) ;			/* RENAME THE DESTINATION */

      itoa(num, buf, 10) ;
	  putstr(buf) ;
	  putstr(" Carriage Returns added in ") ;
	  putstr(argv[i]) ;
	  putstr(".\n") ;
	  }

  itoa(tnum, buf, 10) ;
  putstr("Total of ") ;
  putstr(buf) ;
  putstr(" Carriage Returns added in all files.\n") ;
}

/****************************************************************************/
/* P U T S T R -- Puts a string to stdout without appending a newline.      */
/****************************************************************************/
void putstr(char *str) {
  while(*str) putchar(*str++) ;
}