; g_error.inc
;
ifdef		BUILD_HDR
showit		macro	value,string
		IF2
		%out	&value	    &string
		ENDIF
		endm
endif

mk_e		macro	e_tag,e_string
		local	beg_off,end_off

e_tag		=	&ERR_TAB_NUM
ERR_TAB_NUM	=	ERR_TAB_NUM + 1

ifdef		BUILD_RE_TABLE
ifdef		BUILD_HDR
		showit	%(e_tag),e_string
endif		
beg_off		label	byte
		dw	end_off - beg_off
		dw	e_tag
		db	e_string
		db	0
end_off		label	byte
endif
		endm

	;---bits for BX on ENTRY

RE_FATAL	equ	8000h
RE_DOS		equ	4000h

	;---return values
	
RE_RETRY	equ	1
RE_IGNORE	equ	2
RE_ABORT	equ	3
	

ERR_TAB_NUM	=	1


	;--- all errors below 100h are dos ERRORS

mk_e	ed_inv_fun,	'Invalid DOS function.'
mk_e	ed_no_file,	'File not found.'
mk_e	ed_no_path,	'Path not found.'
mk_e	ed_too_many,	'Too many files open.'
mk_e	ed_acc_denied,	'Access denied.'
mk_e	ed_inv_handle,	'Invalid handle.'
mk_e	ed_bad_mem,	'Memory control blocks destroyed.'
mk_e	ed_ins_mem,	'Insufficient memory.'
mk_e	ed_mem_inv,	'Memory block address invalid.'
mk_e	ed_inv_env,	'Invalid environment.'
mk_e	ed_inv_format,	'Invalid format.'
mk_e	ed_inv_acc,	'Invalid access code.'
mk_e	ed_inv_data,	'Invalid data.'
mk_e	ed_inv_drive,	'Invalid drive.'
mk_e	ed_rem_cd,	'Attempt to remove the current directory.'
mk_e	ed_not_same,	'Not the same device.'
mk_e	ed_no_more,	'No more files.'
mk_e	ed_writ_prot,	'Disk is write protected.'
mk_e	ed_bad_unit,	'Bad disk unit.'
mk_e	ed_not_ready,	'Drive is not ready.'
mk_e	ed_inv_disk,	'Invalid disk command.'
mk_e	ed_crc,		'CRC error.'
mk_e	ed_inv_len,	'Invalid length.'
mk_e	ed_seek_err,	'Seek error.'
mk_e	ed_not_msdos,	'Not an msdos disk.'
mk_e	ed_sector,	'Sector not found.'
mk_e	ed_paper,	'Out of paper.'
mk_e	ed_write,	'Write fault.'
mk_e	ed_read,	'Read fault.'
mk_e	ed_general,	'General failure.'
mk_e	ed_share,	'Sharing violation.'
mk_e	ed_lock,	'Lock violation.'
mk_e	ed_wrond_disk,	'Wrong disk.'
mk_e	ed_fcb,		'FCB unavailable.'


	;--- start of FORCE ERRORS.

ERR_TAB_NUM	=	100h

mk_e	e_read_header,	'Can not read .dbf header.'
mk_e	e_not_a_dbf,	'The file you attempted to open is not a DBF.'
mk_e	e_read_dbf_file,'Error while reading DBF file.'
				;occurs while reading a DBF in a DIR command
mk_e	e_dir_internal,	'Internal DIR calculation error.'
mk_e	e_write_record,	'File write error.'
mk_e	e_no_use,	'No database in USE.'
	e_no_delete	=	e_no_use
	e_no_disp	=	e_no_use
	e_no_disp	=	e_no_use
	e_no_file_used	=	e_no_use
	e_et_no_head	=	e_no_use
	e_deleted	=	e_no_use
	e_not_br_file	=	e_no_use
	e_no_file_cs	=	e_no_use
	e_no_copy_head	=	e_no_use
	e_app_no_use	=	e_no_use
	
mk_e	e_div_by_zero,	'Divide by zero.'
mk_e	e_cb_table,	'Call back table full.'
mk_e	e_field_link,	'Attempt to access field that is not linked.'
mk_e	e_not_device,	'Attempt to set printer to a non-device.'
mk_e	e_memo_2_big,	'Memo buffer too small.'
mk_e	e_memo_no_open,	'Memo not opened.'
mk_e	e_memo_full,	'Memo buffer full.'
mk_e	e_bad_pointer,	'Bad alias pointer.'
mk_e	e_no_label,	'Used LABEL or SAMPLE with out a prior SET LABEL FORM.'

mk_e	e_mn_overflow,	'Menu buffer overflow. Reset __MENU_SIZE.'
mk_e	e_mn_no_id,	'Menu ID not FOUND.'

mk_e	e_short_mem,	'Not enough memory for requested block.'
mk_e	e_mem_block,	'Attempt to deallocate memory with an invalid handle.'
mk_e	e_mem_trashed,	'Memory chain is destroyed.'

mk_e	e_blk_size,	'__BLK_SIZE set to 0.'
mk_e	e_skip_index,	'SKIP without current pointer in the index.'
mk_e	e_restore_scr,	'Unable to RESTORE screen.'
mk_e	e_inum_big,	'Index number is larger than the largest opened index.'
mk_e	e_ind_7,	'Only 7 indexes may be opened.'
mk_e	e_no_index,	'Index file not found.'
mk_e	e_bad_indexfile,'File selected is not an index or is corrupted.'
mk_e	e_order_open,	'Tried to SET ORDER TO an unopened index.'
mk_e	e_goto_range,	'Record out of range on GOTO.'
mk_e	e_field_eof,	'Attempt to access a field at EOF.'
mk_e	e_index_bad,	'Index file is corrupted.'
mk_e	e_seek_noind,	'Attempt to SEEK without an index in use.'
mk_e	e_mem_locked,	'Attempt to deallocate a locked block.'
mk_e	e_file_open,	'Attempt to open a FILE or ALIAS twice.'

mk_e	e_bad_fld_size,	'Field in database does not match field in definition.'
mk_e	e_bad_fld_link,	'Database header does not match alias.'
mk_e	e_range,	'Array index out of range.'
mk_e	e_workarea_stk,	'Workarea stack overflow.'
mk_e	e_disk_full,	'Disk full.'
mk_e	e_device_get,	'Attempt to GET while device is set to PRINT.'
mk_e	e_sel_range,	'SELECT <n-exp> is out of range.'
mk_e	e_ex_numeric,	'Field width exceeded during export to numeric field.'
mk_e	e_restore_size,	'Destination smaller than source during RESTORE.'
mk_e	e_no_report,	'Invalid REPORT.'
mk_e	e_math_bounds,	'Undefined operand value.'
mk_e	e_save_gets,	'SAVE_GETS() stack overflow.'
mk_e	e_no_database,	'Unable to open database file.'
mk_e	e_too_big,	'Character size out of bounds.'
mk_e	e_no_bfile,	'Buffered file not previously opened or corrupted.'
mk_e	e_display_blk,	'Display block destroyed during EDIT.'
mk_e	e_owner,	'Unable to locate block parent.'
mk_e	e_string_list,	'Attempt to access a string list that has not bee initialized.'
mk_e	e_string_rng,	'ID out of range in string manipulation (PICK_LIST).'
mk_e	e_field_set,	'Attempt to access field that is not set.'
mk_e	e_mn_no_mem,	'Attempt to perform MENU TO without prior @..PROMPT.'
mk_e	e_dosver2,	'DOS version 2.0 or greater required.'
mk_e	e_dosver3,	'DOS version 3.0 or greater required.'
mk_e	e_share,	'Share not installed.'
mk_e	e_excl,		'Command requires exclusive use of database.'
mk_e	e_flock,	'Command requires file lock.'
mk_e	e_rlock,	'Command requires record lock.'
mk_e	e_cant_handle_it, 	'Cannot handle handle dup (INTERNAL).'
mk_e	e_tsr,		'RUN installed TSR program.'

e_bad_bin	equ	18 + 4000h
e_open_bin	equ	19 + 4000h
e_read_bin	equ	20 + 4000h
