; VLIST.INC
;
; replacement for picklist functions
;
; INCLUDE FILE
;
;

VLIST_IDENT	equ	0A666h
JL_NORMAL       equ     1
JL_SKIP         equ     2
JL_HIT          equ     3
JL_HIDE         equ     4
JL_USE_COLOR_STD        equ    -1
JL_USE_COLOR_ENHCD      equ    -2
JL_USE_ERROR            equ    -3
JL_HIT_BOL              equ    1
JL_HIT_EOL              equ    2
JL_HIT_NOTHING          equ    0

; VLIST HEADER structure -------------------------------------------------

JH_ident	equ	0	; word
JH_handle	equ	2	; word
JH_first	equ	4	; dword
JH_count	equ	8	; word
JH_str_len	equ	10	; word
JH_current	equ	12	; dword
JH_cur_no       equ     16	; word
JH_last		equ	18	; dword

JH_size		equ	22	; size of header structure

; VLIST BLOCK structure --------------------------------------------------

JB_next		equ	0	; dword
JB_last		equ	4	; dword
JB_handle	equ	8	; word
JB_status       equ     10      ; byte
JB_color        equ     11      ; word
JB_str		equ	13	; bytes for JH_STR_LEN+1

JB_size		equ	13	; this PLUS the value at JH_STR_LEN

p_str_len	equ	6
p2_handle	equ	6
p2_status	equ	10
p2_color	equ	12
p2_string	equ	14
o_handle	equ	6
o_str		equ	10
p6_handle	equ	4
p6_which_way	equ	8
p6_reps		equ	10
p_which_way	equ	10
p10_handle 	equ	6
p10_which	equ	10
p11_buffer	equ	6
p11_handle	equ	10
p11_element	equ	14

stk_handle	equ	6
stk_element	equ	10
stk_status	equ	12
stk_cstatus	equ	10
stk_color	equ	12
stk_ccolor	equ	10


Vlist_start_goto	macro	ERROR_MARK
		push	bp
		mov	bp, sp
		push	es
		push	di
		push	si
		push	ds
		push	bx
		push	cx

		les	di, dword ptr [ bp ].stk_handle
		call	validate

		push	word ptr es:[ di ].JH_CURRENT.2
		push	word ptr es:[ di ].JH_current
		push	word ptr es:[ di ].JH_cur_no
		push	es
		push	di

		push	word ptr [ bp ].stk_element
		push	es
		push	di
		call	_Vlist_goto
		add	sp, 6

		cmp	ax, 0
		je	ERROR_MARK

		mov	bx, word ptr es:[di].jh_str_len
		les	di, dword ptr es:[ di ].JH_CURRENT
endm

Vlist_mid_goto		macro

		pop	di
		pop	es
		; go back to current element
		pop	word ptr es:[ di ].JH_cur_no
		pop	word ptr es:[ di ].jh_current
		pop	word ptr es:[ di ].jh_current.2

endm

Vlist_end_goto		macro
		pop	cx
		pop	bx
		pop	ds
		pop	si
		pop	di
		pop	es
		pop	bp

		ret		
endm

Vlist_start	macro	ERROR_GUY

		push	bp
		mov	bp, sp
		push	es
        	push	di
		push	si
		push	ds
		push	bx
		push	cx

		les	di, dword ptr [ bp ].stk_handle
		call	validate

		mov	ax, word ptr es:[ di ].JH_cur_no
		cmp	ax, 0
		je	ERROR_GUY
		cmp	ax, word ptr es:[ di ].JH_count
		ja	ERROR_GUY

		mov	bx, word ptr es:[ di ].jh_str_len
		les	di, dword ptr es:[ di ].JH_CURRENT

endm

Vlist_end	macro
		pop	cx
  		pop	bx
		pop	ds
		pop	si
		pop	di
		pop	es
		pop	bp

		ret
endm


Vlist_edit_str	macro  WHERE_STACK, WHERE_JUMP
		; BX is now string length maximum
		; ES:DI is current element

		push	es
		push	di

		lds	si, dword ptr [ bp ]+where_stack

		add	di, jb_str

		; now
		;   ES:DI = old string location
		;   DS:SI = string on stack to copy to ES:DI

		cld
$do_again:	dec	bx
                lodsb
		stosb
		cmp	bx, 0
		jz	$fudge_pucker
                cmp	al, 0
                jz	$no_fudge
		jmp	$do_again
$fudge_pucker:
		mov	byte ptr es:[ di ], 0
$no_fudge:
		; last character was a 0
$frog:                		
		pop	di
		pop	es
endm


stk_edit 	equ 	12
stk_cedit       equ	10
rep_status	equ	12
rep_color	equ	14
rep_str		equ	16
rep_cstatus	equ	10
rep_ccolor	equ	12
rep_cstr	equ	14


