; VLIST
;
; replacement for picklists
;
;

include	Vlist.inc			; list structures
include j_errors.inc
	
extrn	_$allocate:far
extrn	_free:far
extrn  _$error_handler:far
extrn	validate:near


; GLOBAL DATA ------------------------------------------------------------

dgroup		group _data
_data		segment word public 'DATA'
_data		ends


; LOCAL DATA and CODE ----------------------------------------------------

Vlist_seg	segment	public
		assume cs:Vlist_seg, ds:dgroup


		public	Vlist_move
Vlist_move	proc	near

		push	bp
		mov	bp, sp
		push	es
		push	di
		push	bx
		push	ds
		push	si
		push	cx

		les	di, dword ptr [ bp ].p6_handle
		call	validate

		mov	cx, [ bp ].p6_reps

$start_move:
		cmp	word ptr [ bp ].p6_which_way, 1
		je	$forward

$backward:
		; are we at BOF()?
		cmp	word ptr es:[ di ].JH_cur_no, 0
		jne	$skip_back
		mov	ax, JL_HIT_BOL
		jmp	$end_pop6

$skip_back:
		; goto the current element
		lds	si, dword ptr es:[ di ].jh_current

		; decrement current number
		mov	ax, es:[ di ].jh_cur_no
		dec	ax
		mov	es:[ di ].jh_cur_no, ax

		; go to previous element
		lds	si, dword ptr ds:[ si ].jb_last
		mov	word ptr es:[ di ].jh_current.2, ds
		mov	word ptr es:[ di ].jh_current, si

         	loop	$backward
		mov	ax, JL_HIT_NOTHING
		jmp	$end_pop6
$forward:
		; are we at EOF()?
		mov	ax, word ptr es:[ di ].JH_count
		cmp	word ptr es:[ di ].JH_cur_no, ax
                jna	$skip_forward
		mov	ax, JL_HIT_EOL
		jmp	$end_pop6

$skip_forward:
		; goto the current element
		lds	si, dword ptr es:[ di ].jh_current

		; increment current number
		mov	ax, es:[ di ].jh_cur_no
		inc	ax
		mov	es:[ di ].jh_cur_no, ax

                ; goto next element
		lds 	si, dword ptr ds:[ si ].jb_next
		mov	word ptr es:[ di ].jh_current.2, ds
		mov	word ptr es:[ di ].jh_current, si

		loop	$forward
		mov	ax, JL_HIT_NOTHING

$end_pop6:		
		pop	cx
		pop	si
		pop	ds
		pop	bx
		pop	di
		pop	es
		pop	bp

		ret
Vlist_move	endp



Vlist_seg	ends		
		end
