; VLIST
;
; replacement for picklists
;
;

include	Vlist.inc			; list structures
include j_errors.inc
include Vlistx.inc
	
extrn	_$allocate:far
extrn	_free:far
extrn  _$error_handler:far
extrn  _Vlist_top:far
extrn  _Vlist_bottom:far

; GLOBAL DATA ------------------------------------------------------------

dgroup		group _data
_data		segment word public 'DATA'
_data		ends


; LOCAL DATA and CODE ----------------------------------------------------

Vlist_seg	segment	public
		assume cs:Vlist_seg, ds:dgroup


		;
		; FUNCTION LOGICAL Vlist_goto prototype
		; 	PARAMETERS value long handle,;
		;	 	   value uint which_element
		;

		
		public	_Vlist_goto
_Vlist_goto	proc	far
		push	bp
		mov	bp, sp
		push	es
		push	di
		push	bx
		push	cx
		push	dx

		les	di, dword ptr [ bp ].p10_handle
		call	validate

		mov	dx, word ptr es:[ di ].jh_cur_no
		mov	bx, word ptr es:[ di ].jh_count
		mov	cx, word ptr [ bp ].p10_which

		; element out of range
		cmp	cx, bx
		ja	$goto_error_half
		cmp	cx, 0
		je	$goto_error_half

		; element wants top or bottom
		cmp	cx, 1
		je	$goto_top
		cmp	cx, bx
		je	$goto_bottom

		; element already there
		cmp	cx, dx
		je	$already_there_half

		; compare to see if it is closer to the front or back
		mov	ax, bx	; end count
		sub	ax, cx	; subtract the # from the end
		
		; now ax = number from end
		;     cx = number from front (actual number wanted)
		cmp	ax, cx
		ja	$near_front

$near_end:
		push	ax 	; number from end

		; see if it is closer to the current or the end
		mov	ax, dx  ; current element
		sub	ax, word ptr [ bp ].p10_which
                cmp	ax, 0
		jge	$near_end_cont
		not	ax	; absolute value
		inc	ax

		; now ax = number from current

$near_end_cont:	
				
		pop	dx	; now number from end
		; now ax = number from current
		;     dx = number from end

		cmp	ax, dx
		ja	$near_end_yes

$near_end_no:
		mov	cx, ax
		; cx is now number to move
		jmp	$go_from_current

$near_end_yes:
		mov	cx, dx
		; cx is now number to move
		jmp	$go_from_end

$near_front:
		push	cx 	; number from front

		; see if it is closer to the current or the front
		mov	ax, dx  ; current element
		sub	ax, word ptr [ bp ].p10_which
                cmp	ax, 0
		jge	$near_front_cont
		not	ax	; absolute value
		inc	ax

		; now ax = number from current

$near_front_cont:	
				
		pop	dx	; now number from front
		; now ax = number from current
		;     dx = number from front

		cmp	ax, dx
		ja	$near_front_yes

$near_front_no:
		mov	cx, ax
		; cx is now number to move
		jmp	$go_from_current

$near_front_yes:
		mov	cx, dx
		; cx is now number to move
		jmp	$go_from_front

$goto_error_half:
		jmp	$goto_error

$already_there_half:
		jmp	$already_there

$goto_top:
		push	es
		push	di
		call	_Vlist_top
		add	sp, 4
		jmp	$already_there


$goto_bottom:
		push	es
		push	di
		call	_Vlist_bottom
		add	sp, 4
		jmp	$already_there
		
$go_from_current:
		; CX should contain the number to move from JH_CUR_NO

		push	cx
		mov	ax, word ptr es:[ di ].JH_cur_no
		cmp	ax, word ptr [ bp ].p10_which
		ja	$back
$ahead:
		push	1
		jmp	$what
$back:
		push	0
		
$what:
		push 	es
		push	di
		call	Vlist_move
		add	sp, 8
$frog:
		cmp	ax, JL_HIT_NOTHING
		jne	$goto_error
                mov	ax, 1
		jmp	$end_pop10
$go_from_end:
		; CX should contain the number to move from JH_COUNT
		push	es
		push	di
		call	_Vlist_bottom
		add	sp, 4

		push	cx
		push	0
		push	es
		push	di
		call	Vlist_move
		add	sp, 8
		jmp	$frog

$go_from_front:
		; CX should contain the number to move from 0
		push	es
		push	di
		call	_Vlist_top
		add	sp, 4

		dec	cx
		push	cx
		push	1
		push	es
		push	di
		call	Vlist_move
		add	sp, 8
		jmp	$frog

$already_there:
		mov	ax, 1
		jmp	$end_pop10

$goto_error:
		mov	ax, 0

$end_pop10:
		pop	dx
		pop	cx
		pop	bx
		pop	di
		pop	es
		pop	bp

		ret
_Vlist_goto	endp



Vlist_seg	ends		
		end
