*******************************************************************************
*                                                                             *
*                         VLIST - string list system                          *
*                                                                             *
*                         (c) 1991, Jayson R. Minard                          *
*                                                                             *
*******************************************************************************

#INCLUDE WARN.HDR
#INCLUDE vlistx.fnc
#INCLUDE mouse.fnc
#INCLUDE STRING.HDR
#INCLUDE IO.HDR
#INCLUDE KEYS.HDR
#INCLUDE MATH.HDR

VARDEF EXTERN
  BYTE __color_std, __color_enhcd
ENDDEF

FUNCTION LOGICAL Vlist_Key_Empty PROTOTYPE
  PARAMETERS VALUE ULONG pointer

*******************************************************************************
FUNCTION INT VLIST_Call_Key_Handler PROTOTYPE
  PARAMETERS VALUE ULONG user_function,;
             VALUE LONG list_handle,;
             VALUE UINT list_element,;
                   UINT mouse_stat,;
             VALUE UINT mrow,;
             VALUE UINT mcol,;
                    INT pick_key,;
             VALUE UINT top_element,;
             VALUE UINT last_element,;
             VALUE UINT ur,;
             VALUE UINT uc,;
             VALUE UINT lr,;
             VALUE UINT lc



*******************************************************************************
*-----------------------------------------------------------------------------*
*******************************************************************************

FUNCTION UINT VList_Pick
  PARAMETERS VALUE LONG    handle,;
             VALUE INT     upper_row,;
             VALUE INT     upper_col,;
             VALUE INT     lower_row,;
             VALUE INT     lower_col,;
                   UINT    top_element,;
             VALUE UINT    initial_element,;
             VALUE UINT    first_element_allowed,;
             VALUE UINT    last_element_allowed,;
             VALUE UINT    left_string_marker,;
             VALUE UINT    right_string_marker,;
             VALUE UINT    number_of_columns,;
             VALUE UINT    spaces_between_columns,;
             VALUE ULONG   key_handler_proc,;
             VALUE LOGICAL display_only,;
             VALUE LOGICAL scroll_bar,;
             VALUE LOGICAL return_on_left_right,;
             VALUE LOGICAL is_mouse,;
             VALUE LOGICAL allow_embedded

  VARDEF
    UINT  last_element                 && last total element
    UINT  height                       && height of pick window
    UINT  temp_mark

    UINT  last_good, next_good         && relative to initial element
    UINT  start_good, end_good         && overall first and last valid elements

    LOGICAL refresh
    LOGICAL list_loop

    BYTE   old_std, old_enhcd

    UINT   scroll_col, scroll_top, scroll_bottom, scroll_row
    LOGICAL scroll_refresh
    LOGICAL abort

    UINT   column_start[ 10 ]
    UINT   column_end[ 10 ]
    UINT   column_wide[ 10 ]
    UINT   current_column
    UINT   current_row
    UINT   current_element
    UINT   current_col
    UINT   current_wide

    INT    pick_key

    UINT   temp_row, temp_col, temp_wide, temp_uint9

    INT    _width, _per_column, _left_over
    INT    temp_int1, temp_int2, temp_int3, temp_int4, temp_int5
    DBL    temp_dbl, temp_dbl1, temp_dbl2, temp_dbl3

    CHAR   temp_str

    UINT   mouse_stat
    LOGICAL mouse_search
    UINT    mouse_found
    UINT    mouse_last

    INT    user_proc
    UINT   last_displayed

    UINT    new_element
    UINT    o_column, o_row, o_element, o_wide, o_col, o_top
    UINT    old_element
    LOGICAL not_on_skip, already
    UINT    counter
    UINT    max_screen

    UINT    mrow, mcol
    LOGICAL mouse_set
    INT     move_count
    LOGICAL move_end
    UINT    move_temp
    UINT    old_bad
    LOGICAL old_first

    LOGICAL ml, mr
  ENDDEF

  IF display_only
    is_mouse = .F.
  ENDIF

  mouse_set = .T.

  old_std   = __color_std
  old_enhcd = __color_enhcd

  IF initial_element = 0
    initial_element = 1
    top_element = 1
  ENDIF

  *- Check for valid picklist

  IF .NOT. vlist_is_init( handle )
    RETURN 0
  ENDIF

  IF left_string_marker <> 0 .and. right_string_marker = 0
    right_string_marker = vlist_get_strlen( handle )
  ENDIF

  last_element = vlist_max( handle )
  IF last_element = 0
    RETURN 0
  ENDIF

  IF last_element_allowed = 0
    last_element_allowed = last_element
  ENDIF

  IF first_element_allowed = 0
    first_element_allowed = 1
  ENDIF

  IF number_of_columns = 0
    number_of_columns = 1
  ENDIF

  IF number_of_columns > 10
    RETURN 0
  ENDIF

  *- check starting conditions

  IF initial_element < top_element
    top_element = initial_element
  ENDIF

  *- set the overall global start and end of the list
  start_good = vlist_find_first_good( handle, first_element_allowed )
  end_good   = vlist_find_last_good( handle, last_element_allowed )
  IF start_good > last_element_allowed .OR.;
               end_good < first_element_allowed
    RETURN 0
  ENDIF

  IF initial_element < start_good
    initial_element = start_good
  ENDIF

  IF initial_element > end_good
    initial_element = end_good
  ENDIF

  IF first_element_allowed < start_good
    first_element_allowed = start_good
  ENDIF

  IF last_element_allowed > end_good
    last_element_allowed = end_good
  ENDIF

  *- HEY!  no valid elements
  IF start_good = 0 .AND. end_good = 0
    RETURN 0
  ENDIF

  *- check to see if the element is valid that we want to start on
  IF .NOT. vlist_goto( handle, initial_element )
    initial_element = start_good
    vlist_goto( handle, initial_element )
  ENDIF

  temp_mark = vlist_cget_status( handle )

  * make sure we are on a selectable item
  last_good = vlist_get_last_good( handle, initial_element, first_element_allowed )
  next_good = vlist_get_next_good( handle, initial_element, last_element_allowed )

  IF temp_mark = &jl_skip .OR. temp_mark = &jl_hide
    IF next_good <> 0
      IF ( next_good > last_element_allowed ) .AND.;
                 ( ( last_good = 0 ) .OR.;
                 ( ( last_good<>0 ) .AND. ( last_good < first_element_allowed ) ) )
        RETURN 0
      ENDIF

      initial_element = next_good
    ELSE
      IF last_good < first_element_allowed
        RETURN 0
      ENDIF

      initial_element = last_good
    ENDIF

  ENDIF

  *- check relation of initial_element and top_element
  height = lower_row - upper_row + 1
  max_screen = height * number_of_columns

  IF top_element > initial_element
    top_element = initial_element
  ENDIF

  temp_mark = vlist_count_elements( handle, top_element, initial_element )

  IF temp_mark > max_screen
    temp_mark = temp_mark - max_screen
    vlist_goto( handle, top_element )
    DO WHILE temp_mark > 0
      vlist_skip_next( handle, last_element_allowed )
      temp_mark = temp_mark - 1
    ENDDO

    top_element = vlist_number( handle )
    IF top_element = 0
      top_element = initial_element
    ENDIF

  ENDIF

  current_row = upper_row +;
                vlist_count_elements( handle, top_element, initial_element ) - 1

  * HEY, if we are using a scroll bar, set up its info
  IF scroll_bar
    scroll_refresh = .T.
    scroll_col     = lower_col + __scroll_offset
    scroll_top     = upper_row + 1
    scroll_row     = 0
    scroll_bottom  = lower_row - 1

    __color_std = __color_bar

    FOR temp_int1 = scroll_top TO scroll_bottom
      @temp_int1, scroll_col SAY ""
    NEXT

    __color_std = __color_tab
    @scroll_top-1, scroll_col SAY CHR( 24 )
    @scroll_bottom+1, scroll_col SAY CHR( 25 )

    __color_std = old_std

  ENDIF

  current_column = 0
  IF number_of_columns = 1
    column_start[ 0 ] = upper_col
    column_end[ 0 ] = lower_col
    column_wide[ 0 ] = lower_col - upper_col + 1
  ELSE
    _width      = lower_col - upper_col + 1 -;
                  ( spaces_between_columns*( number_of_columns-1 ) )
    _per_column = TRUNC( _width / number_of_columns )
    _left_over  = ( _width % number_of_columns )

    temp_int2   = 0
    temp_int3   = upper_col

    DO WHILE temp_int2 < number_of_columns
      column_start[ temp_int2 ] = temp_int3
      column_end[ temp_int2 ] = temp_int3 + _per_column - 1
      temp_int3 = column_end[ temp_int2 ] + 1 + spaces_between_columns

      IF temp_int2 <> ( number_of_columns - 1 )

        IF _left_over > 0
          _left_over = _left_over - 1
          column_end[ temp_int2 ] = column_end[ temp_int2 ] + 1
          temp_int3 = temp_int3 + 1
        ENDIF

      ENDIF

      column_wide[ temp_int2 ] = column_end[ temp_int2 ] -;
                                 column_start[ temp_int2 ] + 1
      temp_int2 = temp_int2 + 1
    ENDDO

  ENDIF



  IF is_mouse
    ml = vmouse_left_button()
    mr = vmouse_right_button()
    vmouse_cursor( .T. )
  ENDIF

  *** start the stupid thing!
  refresh   = .T.                      && start by drawing the screen
  list_loop = .T.
  abort     = .F.

  current_element = initial_element
  mouse_search = .F.
  mouse_last = current_element

  user_proc = 999

  DO WHILE list_loop
    IF is_mouse
      vmouse_cursor( .F. )
    ENDIF

    IF refresh

      IF .NOT. vlist_goto( handle, top_element )
        list_loop = .F.
        abort = .T.
        LOOP
      ENDIF

      temp_mark = 0                    && column 0
      mouse_found = 0

      DO WHILE ( temp_mark < ( number_of_columns ) ) .AND.;
                       .NOT. ( vlist_bol( handle ) )
        *- start new column
        temp_row  = upper_row
        temp_col  = column_start[ temp_mark ]
        temp_wide = column_wide[ temp_mark ]

        DO WHILE ( temp_row <= lower_row ) .AND.;
                         ( vlist_number( handle ) <= last_element_allowed )

          IF vlist_number( handle ) = current_element
            current_column = temp_mark
            current_col    = temp_col
            current_row    = temp_row
            current_wide   = temp_wide
          ENDIF

          IF mouse_search .AND. is_mouse
            temp_int5 = vlist_cget_status( handle )
            IF temp_int5 = &jl_normal .OR.;
                       temp_int5 = &jl_hit

              IF ( temp_row = mrow ) .AND.;
                         ( ( mcol>=temp_col ) .AND. ( mcol<=( temp_col+temp_wide-1 ) ) )
                current_element = vlist_number( handle )
                current_column = temp_mark
                current_col = temp_col
                current_row = temp_row
                current_wide = temp_wide
                mouse_found = current_element
              ENDIF

            ENDIF

          ELSE
            temp_str = vlist_cstr( handle )
            vlist_what_color( handle, old_std )

            IF right_string_marker <> 0 .AND. left_string_marker <> 0
              temp_int3 = right_string_marker - left_string_marker + 1
              temp_str = SUBSTR( temp_str, left_string_marker, temp_int3 )
            ENDIF

            IF AT( "...", temp_str ) = 2 .AND. LEN( temp_str ) = 4
              temp_str = REPLICATE( LEFT( temp_str, 1 ), temp_wide )
            ELSE
              IF .NOT. allow_embedded
                temp_str = LEFT( temp_str, temp_wide )
              ENDIF
            ENDIF

            IF allow_embedded
              vlist_say( temp_row, temp_col, temp_wide, temp_str, .F. )
            ELSE
              @temp_row, temp_col SAY temp_str:temp_wide
            ENDIF
 
          ENDIF

          last_displayed = vlist_number( handle )

          vlist_skip_next( handle, last_element_allowed )
          temp_row = temp_row + 1
        ENDDO

        temp_mark = temp_mark + 1

      ENDDO

      scroll_refresh = .T.
      refresh = .F.

    ENDIF

    IF vlist_number( handle ) <> current_element
      vlist_goto( handle, current_element )
    ENDIF

    IF scroll_refresh .AND. scroll_bar

      *- length of scroll bar
      temp_int4 = scroll_bottom - scroll_top + 1

      *- percentage
      temp_dbl1 = last_element_allowed-first_element_allowed+1
      temp_dbl2 = current_element-first_element_allowed+1

      IF current_element >= last_element_allowed
        temp_int5 = scroll_bottom
      ELSE
        IF current_element <= first_element_allowed
          temp_int5 = scroll_top
        ELSE

          temp_dbl3 = temp_int4
          temp_dbl = ( temp_dbl2 / temp_dbl1 ) * temp_dbl3

          *- now figure row offset
          temp_int5 = ROUND( temp_dbl, 0 )

          IF temp_int5 > temp_int4
            temp_int5 = temp_int4
          ENDIF

          temp_int5 = temp_int5 + scroll_top - 1

          IF temp_int5 < scroll_top
            temp_int5 = scroll_top
          ENDIF

        ENDIF

      ENDIF

      IF scroll_row <> temp_int5

        __color_std = __color_bar
        IF scroll_row <> 0
          @scroll_row, scroll_col SAY ""
        ENDIF

        scroll_row = temp_int5
        @scroll_row, scroll_col SAY ""
        __color_std = old_std

      ENDIF

      scroll_refresh = .F.
    ENDIF

    IF display_only
      list_loop = .F.
      LOOP
    ENDIF

    temp_str = vlist_cstr( handle )
    IF right_string_marker <> 0 .AND. left_string_marker <> 0
      temp_int3 = right_string_marker - left_string_marker + 1
      temp_str = SUBSTR( temp_str, left_string_marker, temp_int3 )
    ENDIF

    IF AT( "...", temp_str ) = 2 .AND. LEN( temp_str ) = 4
      temp_str = REPLICATE( LEFT( temp_str, 1 ), current_wide )
    ELSE
      IF .NOT. allow_embedded
        temp_str = LEFT( temp_str, current_wide )
      ENDIF
    ENDIF

    __color_std = old_enhcd

    IF user_proc <> &jl_ignore
      IF allow_embedded
        vlist_say( current_row, current_col, current_wide, temp_str, .T. )
      ELSE
        @current_row, current_col SAY temp_str:current_wide
      ENDIF
 
    ENDIF

    IF is_mouse
      vmouse_cursor( .T. )
    ENDIF

    mouse_stat = 0
    mouse_set  = .F.

    IF mouse_search .AND. is_mouse
      mouse_search = .F.
      mouse_last = mouse_found
    ENDIF

    DO WHILE IS_KEY() = 0 .AND. mouse_stat = &jl_mouse_ignore
      IF is_mouse
        IF vmouse_left_button() .AND. vmouse_right_button()
          mrow = vmouse_row()
          mcol = vmouse_col()
          mouse_stat = &jl_mouse_both
        ELSE
          IF ml
            IF .NOT. vmouse_left_button()   && find release point
              ml = .F.
              mrow = vmouse_row()
              mcol = vmouse_col()
              IF mcol = scroll_col .AND. scroll_bar
                DO CASE
                  CASE mrow = scroll_top - 1
                    mouse_stat = &jl_mouse_xup
                    mouse_set = .T.
                  CASE mrow = scroll_bottom + 1
                    mouse_stat = &jl_mouse_xdown
                    mouse_set = .T.
                  CASE mrow >= scroll_top .AND. mrow <= scroll_bottom
                    mouse_stat = &jl_mouse_xscroll
                    mouse_set = .T.
                  OTHERWISE              && other location
                    mouse_stat = &jl_mouse_xleft
                ENDCASE

              ELSE
                IF ( mrow >= upper_row ) .AND. ( mrow <= lower_row ) .AND.;
                     ( mcol >= upper_col ) .AND. ( mcol <= lower_col )
                  IF ( mrow = current_row ) .AND.;
                       ( mcol >= current_col ) .AND.;
                       ( mcol <= current_col + current_wide - 1 )
                    mouse_stat = &jl_mouse_xselect
                  ELSE
                    mouse_stat = &jl_mouse_xnew
                  ENDIF
 
                ELSE
                  mouse_stat = &jl_mouse_xleft
                ENDIF

              ENDIF
 
            ENDIF
 
          ENDIF

          IF vmouse_left_button()
            ml = .T.
            mrow = vmouse_row()
            mcol = vmouse_col()
            IF mcol = scroll_col .AND. scroll_bar
              DO CASE
                CASE mrow = scroll_top - 1
                  mouse_stat = &jl_mouse_up       && scroll up
                  mouse_set = .T.
                CASE mrow = scroll_bottom + 1
                  mouse_stat = &jl_mouse_down       && scroll down
                  mouse_set = .T.
                CASE mrow >= scroll_top .AND. mrow <= scroll_bottom
                  mouse_stat = &jl_mouse_scroll
                  mouse_set = .T.
                OTHERWISE              && other location
                  mouse_stat = &jl_mouse_left
              ENDCASE

            ELSE
              IF ( mrow >= upper_row ) .AND. ( mrow <= lower_row ) .AND.;
                       ( mcol >= upper_col ) .AND. ( mcol <= lower_col )
                IF ( mrow = current_row ) .AND.;
                     ( mcol >= current_col ) .AND.;
                     ( mcol <= current_col + current_wide - 1 )
                  mouse_stat = &jl_mouse_select
                ELSE
                  mouse_stat = &jl_mouse_new
                ENDIF
 
              ELSE
                mouse_stat = &jl_mouse_left
              ENDIF

            ENDIF

          ENDIF

          IF mr
            IF .NOT. vmouse_right_button()
              mr = .F.
              mrow = vmouse_row()
              mcol = vmouse_col()
              mouse_stat = &jl_mouse_xright
            ENDIF
 
          ELSE
            IF vmouse_right_button()
              mr = .T.
              mrow = vmouse_row()
              mcol = vmouse_col()
              mouse_stat = &jl_mouse_right
            ENDIF
 
          ENDIF

        ENDIF

      ENDIF


    ENDDO

    IF mouse_stat = &jl_mouse_ignore
      pick_key = GET_KEY()
      mouse_last = 0
    ELSE
      IF mouse_stat = &jl_mouse_scroll .OR. mouse_stat = &jl_mouse_xscroll
        DO CASE
          CASE mrow = scroll_bottom
            pick_key = &k_c_pg_down
          CASE mrow = scroll_top
            pick_key = &k_c_pg_up
          CASE mrow > scroll_row
            pick_key = &k_pg_down
          CASE mrow < scroll_row
            pick_key = &k_pg_up
          OTHERWISE
            pick_key = 0
        ENDCASE

      ELSE
        pick_key = 0
      ENDIF

    ENDIF

    IF is_mouse
      vmouse_cursor( .F. )
    ENDIF

    @current_row, current_col
    user_proc = Vlist_Call_Key_Handler( key_handler_proc,;
                                        handle,;
                                        current_element,;
                                        mouse_stat,;
                                        mrow,;
                                        mcol,;
                                        pick_key,;
                                        top_element,;
                                        last_displayed,;
                                        upper_row,;
                                        upper_col,;
                                        lower_row,;
                                        lower_col )

    vlist_goto( handle, current_element )
    vlist_what_color( handle, old_std )

    IF user_proc = &jl_repaint_element .OR.;
             user_proc = &jl_repaint_ignore
      temp_str = vlist_cstr( handle )
      IF right_string_marker <> 0 .AND. left_string_marker <> 0
        temp_int3 = right_string_marker - left_string_marker + 1
        temp_str = SUBSTR( temp_str, left_string_marker, temp_int3 )
      ENDIF

      IF AT( "...", temp_str ) = 2 .AND. LEN( temp_str ) = 4
        temp_str = REPLICATE( LEFT( temp_str, 1 ), current_wide )
      ELSE
        IF .NOT. allow_embedded
          temp_str = LEFT( temp_str, current_wide )
        ENDIF
      ENDIF

      IF user_proc = &jl_repaint_ignore
        user_proc = &jl_ignore
      ELSE
        user_proc = &jl_continue
      ENDIF

    ENDIF

    IF user_proc <> &jl_ignore .AND. user_proc <> &jl_select

      IF allow_embedded
        vlist_say( current_row, current_col, current_wide, temp_str, .F. )
      ELSE
        @current_row, current_col SAY temp_str:current_wide
      ENDIF
 
    ENDIF

    IF is_mouse
      vmouse_cursor( .T. )
      IF user_proc = &jl_goto_mouse
        mouse_search = .T.
        refresh = .T.
        LOOP
      ENDIF

    ENDIF

    IF user_proc = &jl_paint_key
      refresh = .T.
      user_proc = &jl_continue
    ELSE
      IF user_proc = &jl_bad_element
        IF vlist_cget_status( handle ) = &jl_hide
          refresh = .T.
        ENDIF

        old_bad = vlist_number( handle )

        DO CASE
          CASE old_bad = start_good
            pick_key = &k_down
            old_first = .T.
          CASE old_bad = end_good
            pick_key = &k_up
            old_first = .F.
          OTHERWISE
            pick_key = &k_down
            old_bad = 0
        ENDCASE

        user_proc = &jl_continue

      ELSE
        old_bad = 0
      ENDIF

    ENDIF


    IF user_proc = &jl_rescan_menu
      DO WHILE INKEY() <> 0
      ENDDO

      KEY_INT( &k_esc )
      KEY_INT( 10 )

      user_proc = &jl_abort
    ENDIF


    DO CASE
      CASE user_proc = &jl_continue    && evaluate keystroke
        DO CASE
          CASE pick_key = &k_esc
            @current_row, current_col
            list_loop = .F.
            LOOP
          CASE pick_key = &k_enter
            IF vlist_cget_status( handle ) <> &jl_hit
              @current_row, current_col
              list_loop = .F.
              LOOP
            ENDIF

          CASE pick_key = &k_down .OR. pick_key = &k_pg_down .OR.;
                     pick_key = &k_end  .OR. pick_key = &k_c_pg_down .OR.;
                     pick_key = &k_right

            IF pick_key = &k_c_pg_down
              current_element = last_element_allowed
              IF last_displayed <> current_element
                vlist_goto( handle, current_element )
                temp_int1 = max_screen-1
                DO WHILE temp_int1 > 0
                  vlist_skip_last( handle, first_element_allowed )
                  temp_int1 = temp_int1 - 1
                ENDDO

                top_element = vlist_number( handle )
                IF top_element < first_element_allowed
                  top_element = first_element_allowed
                ENDIF

              ENDIF

              refresh = .T.
              LOOP
            ELSE
              IF pick_key = &k_right
                IF number_of_columns = 1 .AND. return_on_left_right
                  @current_row, current_col
                  list_loop = .F.
                  LOOP
                ELSE
                  IF current_column < number_of_columns-1
                    pick_key = &k_pg_down
                  ELSE
                    LOOP
                  ENDIF

                ENDIF

              ENDIF

            ENDIF

            move_count = 0
            move_end   = .F.
            REPEAT

              #INCLUDE j_down.fnc

              IF move_count = 0
                move_end = .T.
              ELSE
                DO CASE
                  CASE pick_key = &k_down
                    move_end = .T.
                  CASE pick_key = &k_pg_down
                    IF move_count >= height
                      IF move_count = height
                        move_end = .T.
                      ELSE
                        DO WHILE move_count > height
                          move_count = move_count - 1
                          IF .NOT. vlist_skip_last( handle, first_element_allowed )
                            move_count = height
                          ENDIF

                        ENDDO

                        move_end = .T.
                        DO WHILE move_end
                          IF vlist_cget_status( handle ) <> &jl_skip
                            move_end = .F.
                            LOOP
                          ENDIF

                          IF .NOT. vlist_skip_last( handle, first_element_allowed )
                            move_end = .F.
                          ENDIF

                        ENDDO

                        move_end = .T.
                      ENDIF

                    ENDIF

                  CASE pick_key = &k_end
                    IF current_element = last_displayed
                      move_end = .T.
                    ENDIF

                ENDCASE

              ENDIF

            UNTIL move_end

          CASE pick_key = &k_up .OR. pick_key = &k_pg_up .OR.;
                     pick_key = &k_home .OR. pick_key = &k_c_pg_up .OR.;
                     pick_key = &k_left

            IF pick_key = &k_c_pg_up
              top_element = first_element_allowed
              current_element = top_element
              refresh = .T.
              LOOP
            ELSE
              IF pick_key = &k_left
                IF number_of_columns = 1 .AND. return_on_left_right
                  @current_row, current_col
                  list_loop = .F.
                  LOOP
                ELSE
                  IF current_column > 0
                    pick_key = &k_pg_up
                  ELSE
                    LOOP
                  ENDIF

                ENDIF

              ENDIF

            ENDIF

            move_temp  = top_element
            move_count = 0
            move_end   = .F.
            REPEAT

              #INCLUDE j_up.fnc
              IF move_count = 0
                move_end = .T.
              ELSE
                DO CASE
                  CASE pick_key = &k_up
                    move_end = .T.
                  CASE pick_key = &k_pg_up
                    IF move_count >= height
                      IF move_count = height
                        move_end = .T.
                      ELSE
                        DO WHILE move_count > height
                          move_count = move_count - 1
                          IF .NOT. vlist_skip_next( handle, last_element_allowed )
                            move_count = height
                          ENDIF

                        ENDDO

                        move_end = .T.
                        DO WHILE move_end
                          IF vlist_cget_status( handle ) <> &jl_skip
                            move_end = .F.
                            LOOP
                          ENDIF

                          IF .NOT. vlist_skip_next( handle, last_element_allowed )
                            move_end = .F.
                          ENDIF

                        ENDDO

                        move_end = .T.
                      ENDIF

                    ENDIF

                  CASE pick_key = &k_home   && go to top then to beginning of list
                    IF current_element = move_temp
                      move_end = .T.
                    ENDIF

                ENDCASE

              ENDIF

            UNTIL move_end

        ENDCASE

      CASE user_proc = &jl_ignore
      CASE user_proc = &jl_repaint
        refresh = .T.
      CASE user_proc = &jl_select
        temp_uint9 = vlist_cget_status( handle )
        IF temp_uint9 <> &jl_hit .AND.;
                 temp_uint9 <> &jl_skip .AND.;
                 temp_uint9 <> &jl_hide

          @current_row, current_col
          list_loop = .F.
          LOOP
        ENDIF

      CASE user_proc = &jl_abort
        @current_row, current_col
        list_loop = .F.
        LOOP
    ENDCASE

    IF old_bad <> 0
      IF old_first
        start_good = current_element
      ELSE
        end_good = current_element
      ENDIF

      IF start_good = 0 .OR. end_good = 0
        RETURN 0
      ENDIF

      old_bad = 0
    ENDIF

    IF mouse_set .AND. is_mouse
      mouse_set = .F.
      mouse_last = current_element
    ENDIF

  ENDDO


  IF is_mouse
    vmouse_cursor( .F. )
    *    Vmouse_restore( Vmouse_buffer[] )
  ENDIF

  __color_std   = old_std
  __color_enhcd = old_enhcd

  IF abort
    RETURN 0
  ELSE
    RETURN vlist_number( handle )
  ENDIF

ENDPRO
