*******************************************************************************
*                                                                             *
*                         VLIST - string list system                          *
*                                                                             *
*                         (c) 1991, Jayson R. Minard                          *
*                                                                             *
*******************************************************************************

#INCLUDE WARN.HDR
#INCLUDE Vlistx.fnc
#INCLUDE mouse.fnc
#INCLUDE STRING.HDR
#INCLUDE MATH.HDR
#INCLUDE SYSTEM.HDR
#INCLUDE IO.HDR

PROCEDURE Vlist_Fish PROTOTYPE
  PARAMETERS CONST LONG handle,;
             CONST UINT low,;
             CONST UINT high,;
             CONST UINT sub_start,;
             CONST UINT sub_chars

PROCEDURE Vlist_sort_substr
  PARAMETERS VALUE LONG handle,;
             VALUE UINT low,;
             VALUE UINT high,;
             VALUE UINT sub_start,;
             VALUE UINT sub_end

  IF .NOT. Vlist_Is_Init( handle )
    RETURN
  ENDIF

  IF low = 0 .OR. high = 0
    low = 1
    high = Vlist_Max( handle )
  ELSE
    IF high > Vlist_Max( handle )
      high = Vlist_Max( handle )
    ENDIF

    IF low > high
      RETURN
    ENDIF

  ENDIF

  IF high = 0
    RETURN
  ENDIF

  IF sub_start = 0
    sub_start = 1
  ENDIF

  IF sub_end > Vlist_Get_Strlen( handle ) .OR. sub_end = 0
      sub_end = Vlist_Get_Strlen( handle )
  ENDIF

  sub_end = sub_end - sub_start + 1

  Vlist_Fish( handle, low, high, sub_start, sub_end )

ENDPRO
