#INCLUDE KEYS.HDR
#INCLUDE vlist.hdr
#INCLUDE vmouse.hdr
#INCLUDE IO.HDR
#INCLUDE SYSTEM.HDR


FUNCTION INT VLIST_Default_Key_Handler
  PARAMETERS VALUE LONG list_handle,;
             VALUE UINT list_element,;
                   UINT mouse_stat,;
             VALUE UINT mrow,;
             VALUE UINT mcol,;
                    INT pick_key,;
             VALUE UINT top_element,;
             VALUE UINT last_element,;
       VALUE UINT ur,;
       VALUE UINT uc,;
       VALUE UINT lr,;
       VALUE UINT lc

  VARDEF
    INT  list_return
    INT  set_key
  ENDDEF

  set_key = 0
  list_return = &jl_continue

  DO CASE
    CASE mouse_stat = &jl_mouse_ignore
    CASE mouse_stat = &jl_mouse_right    && right button pressed
      list_return = &jl_ignore
    CASE mouse_stat = &jl_mouse_xright   && right button released
    *- use set_key so that the LASTKEY() value is accurate
      set_key = &k_esc

    CASE mouse_stat = &jl_mouse_up       && left button + top scroll-bar tab
      list_return = &jl_ignore
    CASE mouse_stat = &jl_mouse_xup      && left button release "     "
      pick_key = &k_c_pg_up
    CASE mouse_stat = &jl_mouse_down     && left button + bottom scroll tab
      list_return = &jl_ignore
    CASE mouse_stat = &jl_mouse_xdown    && left button release "     "
      pick_key = &k_c_pg_down
    CASE mouse_stat = &jl_mouse_xscroll
      list_return = &jl_ignore
    CASE mouse_stat = &jl_mouse_scroll
      && cursor on scroll_bar, the default
      && 'pick_key' values should be set.
      &&    at bottom of list = &k_c_pg_down
      &&    at top of list    = &k_c_pg_up
      &&    above current     = &k_pg_down
      &&    below current     = &k_pg_up

      *- the values of 'pick_key' are set based upon the position of the
      *  mouse cursor relative to the scroll bar marker.
      *
      DO CASE
        CASE pick_key = &k_pg_down     && mouse below current position
          pick_key = &k_down
        CASE pick_key = &k_pg_up       && mouse above current position
          pick_key = &k_up
        CASE pick_key = &k_c_pg_down   && mouse at bottom  on scroll bar
          pick_key = &k_down
        CASE pick_key = &k_c_pg_up     && mouse at top  on scroll bar
          pick_key = &k_up
      ENDCASE

    CASE mouse_stat = &jl_mouse_xnew   && left released + mouse on new
      list_return = &jl_ignore
    CASE mouse_stat = &jl_mouse_new    && left + mouse on new element
      list_return = &jl_goto_mouse

    CASE mouse_stat = &jl_mouse_select  && left + mouse on current element
      list_return = &jl_ignore
    CASE mouse_stat = &jl_mouse_xselect && left released + mouse on current
      set_key = &k_enter

    CASE mouse_stat = &jl_mouse_left    && left + mouse outside of pick area
      list_return = &jl_continue
      IF mrow=ur-1
        pick_key = &k_up
      ELSE
        IF mrow=lr+1
          pick_key = &k_down
        ELSE
          list_return = &jl_ignore
        ENDIF
 
      ENDIF

    CASE mouse_stat = &jl_mouse_xleft   && left released + "         "
      list_return = &jl_ignore
    CASE mouse_stat = &jl_mouse_both    && left & right button hit
      list_return = &jl_ignore
  ENDCASE


  IF set_key <> 0
    DO WHILE INKEY() <> 0
    ENDDO

    KEY_INT( set_key )
    pick_key = INKEY()
  ENDIF


  DO CASE
    CASE pick_key = &k_enter
      list_return = &jl_select
    CASE pick_key = &k_esc
      list_return = &jl_abort
  ENDCASE

  RETURN list_return
ENDPRO