; VLIST
;
; replacement for picklists
;
;

include	Vlist.inc			; list structures
include j_errors.inc
include Vlistx.inc
	
extrn	_$allocate:far
extrn	_free:far
extrn  _$error_handler:far


; GLOBAL DATA ------------------------------------------------------------

dgroup		group _data
_data		segment word public 'DATA'
_data		ends


; LOCAL DATA and CODE ----------------------------------------------------

Vlist_seg	segment	public
		assume cs:Vlist_seg, ds:dgroup

stk_handle	equ	6

		public	_Vlist_clear
_Vlist_clear	proc	far
		push	bp
		mov	bp, sp

		push	es
		push	di
		push	ds
		push	si
		push	ax
		push	cx
		push	dx


		les	di, dword ptr [ bp ].stk_handle
		call	validate

		cmp	word ptr es:[ di ].jh_count, 0
		je	$none

		les	di, dword ptr es:[ di ].JH_FIRST

$grab_next:
		lds	si, dword ptr es:[ di ].JB_NEXT
		; now ES:DI = current element
		;     DS:SI = next element

		push	es
		push	di
		call	_FREE
		add	sp, 4

		push	ds
		pop	es
		mov	di, si
		
		mov	ax, es
		cmp 	ax, 0
		jne	$grab_next
		cmp	si, 0
		jne	$grab_next
		
$none:		; now delete header
		les	di, dword ptr [ bp ].stk_handle

		push	di

		; destroy header info
		mov	cx, JH_SIZE

$erase:		mov	byte ptr es:[ di ], 0
		inc	di
		loop	$erase

		pop	di
		push	es
		push	di
		
		call	_FREE

		add	sp, 4

		pop	dx
		pop	cx
		pop	ax
		pop	si
		pop	ds
		pop	di
		pop	es

		pop	bp
		ret
_Vlist_clear	endp


Vlist_seg	ends		
		end
