; VLIST
;
; replacement for picklists
;
;

include	Vlist.inc			; list structures
include j_errors.inc
include Vlistx.inc
	
extrn	_$allocate:far
extrn	_free:far
extrn   _$error_handler:far
extrn   _Vlist_goto:far
extrn   _Vlist_bottom:far


; GLOBAL DATA ------------------------------------------------------------

dgroup		group _data
_data		segment word public 'DATA'
_data		ends


; LOCAL DATA and CODE ----------------------------------------------------

Vlist_seg	segment	public
		assume cs:Vlist_seg, ds:dgroup

stk_which       equ    10

                ;
                ; FUNCTION LOGICAL Vlist_delete PROTOTYPE
                ;   PARAMETERS value long handle,;
                ;              value uint which
		;
		public	_Vlist_delete
_Vlist_delete	proc	far

		push	bp
		mov	bp, sp
		push	es
		push	di
		push	si
		push	ds
		push	bx
		push	cx

		les	di, dword ptr [ bp ].stk_handle
		call	validate

		push	word ptr es:[ di ].JH_CURRENT.2
		push	word ptr es:[ di ].JH_current
		push	word ptr es:[ di ].JH_cur_no

		push	word ptr [ bp ].stk_which
		push	es
		push	di
		call	_Vlist_goto
		add	sp, 6

		cmp	ax, 0
		je	$was_error26_half

		mov	bx, word ptr es:[di].jh_str_len

		lds	si, dword ptr es:[ di ].JH_CURRENT

                ; ES:DI points to header
                ; DS:SI points to element to delete
                mov     ax, [ bp ].stk_which
                cmp     ax, word ptr es:[ di ].jh_count
                jne     $not_on_last

		; reset last pointer
                mov     bx, word ptr ds:[ si ].jb_last.2
                mov     word ptr es:[ di ].jh_last.2, bx
                mov     bx, word ptr ds:[ si ].jb_last
		mov	word ptr es:[ di ].jh_last, bx

$not_on_last:
		cmp	ax, 1
		jne	$not_on_first

		; reset first pointer
		mov	bx, word ptr ds:[ si ].jb_next.2
		mov	word ptr es:[ di ].jh_first.2, bx
		mov	bx, word ptr ds:[ si ].jb_next
		mov	word ptr es:[ di ].jh_first, bx

$not_on_first:
		push	ds
		push	si
		push	es
		push	di

		les	di, dword ptr ds:[ si ].jb_next
		lds	si, dword ptr ds:[ si ].jb_last

		mov	ax, es
		cmp	ax, 0
		jne	$is_next
                cmp     di, 0
		je	$no_next

$is_next:
		mov	word ptr es:[ di ].jb_last.2, ds
		mov	word ptr es:[ di ].jb_last, si

$no_next:	
		mov	ax, ds
		cmp	ax, 0
		jne	$is_last
                cmp     si, 0
		je	$no_last

$is_last:
		mov	word ptr ds:[ si ].jb_next.2, es
		mov	word ptr ds:[ si ].jb_next, di
		jmp	$no_last

$was_error26_half:
		jmp	$was_error26

$no_last:

		pop	di
		pop	es
		pop	si
		pop	ds

$prepare_delete:
		; decrement count		
		mov	bx, word ptr es:[ di ].jh_count
		dec	bx
		mov	word ptr es:[ di ].jh_count, bx

$do_delete:

		push	ds
		push	si
		call	_free
		add	sp, 4

$done:
		; go back to current element
		pop	word ptr es:[ di ].JH_cur_no
		pop	word ptr es:[ di ].jh_current
		pop	word ptr es:[ di ].jh_current.2

                ; if we deleted the current element, go to bottom of list
                mov     ax, word ptr es:[ di ].jh_cur_no
                cmp     ax, word ptr [ bp ].stk_which
                jne     $ok_end

                push    es
                push    di
                call    _Vlist_bottom
                add     sp, 4
                jmp     $final_end

$ok_end:        jna     $final_end
                dec     ax
                mov     word ptr es:[ di ].jh_cur_no, ax


$final_end:
		mov	ax, 1
		jmp	$end_pop26

$was_error26:
		mov	ax, 0

$end_pop26:		

		pop	cx
		pop	bx
		pop	ds
		pop	si
		pop	di
		pop	es
		pop	bp

		ret		

_Vlist_delete	endp



Vlist_seg	ends		
		end
