; VLIST
;
; replacement for picklists
;
;

include	Vlist.inc			; list structures
include j_errors.inc
include Vlistx.inc
	
extrn	_$allocate:far
extrn	_free:far
extrn   _$error_handler:far
extrn   _Vlist_goto:far
extrn   _Vlist_bottom:far


; GLOBAL DATA ------------------------------------------------------------

dgroup		group _data
_data		segment word public 'DATA'
_data		ends


; LOCAL DATA and CODE ----------------------------------------------------

Vlist_seg	segment	public
		assume cs:Vlist_seg, ds:dgroup

                ;
                ; FUNCTION LOGICAL Vlist_cdelete PROTOTYPE
                ;   PARAMETERS value long handle
		;
		public	_Vlist_cdelete
_Vlist_cdelete	proc	far

		push	bp
		mov	bp, sp
		push	es
		push	di
		push	si
		push	ds
		push	bx
		push	cx

		les	di, dword ptr [ bp ].stk_handle
		call	validate

		cmp	word ptr es:[ di ].jh_cur_no, 0
		je	$was_error26_half
		mov	ax, es:[ di ].jh_cur_no
                cmp	ax, es:[ di ].jh_count
		ja	$was_error26_half

		lds	si, dword ptr es:[ di ].JH_CURRENT

                ; ES:DI points to header
                ; DS:SI points to element to delete
                mov     ax, es:[ di ].JH_CUR_NO
                cmp     ax, word ptr es:[ di ].jh_count
                jne     $not_on_last

		; reset last pointer
                mov     bx, word ptr ds:[ si ].jb_last.2
                mov     word ptr es:[ di ].jh_last.2, bx
                mov     bx, word ptr ds:[ si ].jb_last
		mov	word ptr es:[ di ].jh_last, bx

$not_on_last:
		cmp	ax, 1
		jne	$not_on_first

		; reset first pointer
		mov	bx, word ptr ds:[ si ].jb_next.2
		mov	word ptr es:[ di ].jh_first.2, bx
		mov	bx, word ptr ds:[ si ].jb_next
		mov	word ptr es:[ di ].jh_first, bx

$not_on_first:
		push	ds
		push	si
		push	es
		push	di

		les	di, dword ptr ds:[ si ].jb_next
		lds	si, dword ptr ds:[ si ].jb_last

		mov	ax, es
		cmp	ax, 0
		jne	$is_next
                cmp     di, 0
		je	$no_next

$is_next:
		mov	word ptr es:[ di ].jb_last.2, ds
		mov	word ptr es:[ di ].jb_last, si

$no_next:	
		mov	ax, ds
		cmp	ax, 0
		jne	$is_last
                cmp     si, 0
		je	$no_last

$is_last:
		mov	word ptr ds:[ si ].jb_next.2, es
		mov	word ptr ds:[ si ].jb_next, di
		jmp	$no_last

$was_error26_half:
		jmp	$was_error26

$no_last:

		pop	di
		pop	es
		pop	si
		pop	ds

$prepare_delete:
		; decrement count		
		mov	bx, word ptr es:[ di ].jh_count
		dec	bx
		mov	word ptr es:[ di ].jh_count, bx

$do_delete:

		push	es
		push	di
		les	di, dword ptr ds:[ si ].jb_next
		push	es
		push	di

		push	ds
		push	si
		call	_free
		add	sp, 4

		pop	si
		pop	ds
		pop	di
		pop	es
		
		; es:di = header
		; ds:si = next element
		mov	ax, ds
		cmp	ax, 0
		jne	$set_current
		cmp	si, 0
		jne	$set_current

$jump_end:
                push    es
                push    di
                call    _Vlist_bottom
                add     sp, 4
		jmp	$ok_end

$set_current:
		mov	es:[ di ].jh_current.2, ds
		mov	es:[ di ].jh_current, si


$ok_end:
		mov	ax, 1
		jmp	$end_pop26

$was_error26:
		mov	ax, 0

$end_pop26:		

		pop	cx
		pop	bx
		pop	ds
		pop	si
		pop	di
		pop	es
		pop	bp

		ret		

_Vlist_cdelete	endp



Vlist_seg	ends		
		end
