#INCLUDE vlistx.fnc
#INCLUDE FILEIO.HDR
#INCLUDE IO.HDR
#INCLUDE SYSTEM.HDR

* RETURNS 0 on abort:
FUNCTION UINT Vlist_SIMPLE PROTOTYPE
  PARAMETERS VALUE LONG plist,;
       VALUE UINT r,;
       VALUE UINT c,;
       VALUE UINT r1,;
       VALUE UINT c1,;
       VALUE UINT idx, ;
       VALUE UINT first_allowed,;
       VALUE UINT last_allowed,;
       VALUE LOGICAL disp_only,;
       VALUE LOGICAL ret


FUNCTION LOGICAL Vlist_Smallview
  PARAMETERS CONST CHAR filename,;
             VALUE UINT ur,;
             VALUE UINT uc,;
             VALUE UINT lr,;
             VALUE UINT lc

  VARDEF
    FILE    filehandle
    LONG    filelist
    CHAR    one_line
  ENDDEF

  IF .NOT. EXIST( filename )
    RETURN .F.
  ENDIF

  IF .NOT. F_OPEN( filehandle, filename, &f_read )
    RETURN .F.
  ENDIF

  filelist = vlist_init( 80 )
  IF .NOT. vlist_is_init( filelist )
    RETURN .F.
  ENDIF

  DO WHILE .NOT. F_EOF( filehandle )
    IF .NOT. F_GETLN( filehandle, one_line )
      F_CLOSE( filehandle )
      vlist_clear( filelist )
      RETURN .F.
    ENDIF

    IF .NOT. vlist_add( filelist, one_line )
      F_CLOSE( filehandle )
      vlist_clear( filelist )
      RETURN .F.
    ENDIF

  ENDDO

  Vlist_Simple( filelist, ur, uc, lr, lc, 1, 0, 0, .F., .F. )

  F_CLOSE( filehandle )
  vlist_clear( filelist )

  RETURN .T.

ENDPRO