#INCLUDE FILEIO.HDR
#INCLUDE IO.HDR
#INCLUDE SYSTEM.HDR
#INCLUDE STRING.HDR
#INCLUDE KEYS.HDR
#INCLUDE vlist.hdr
#INCLUDE vmouse.hdr

VARDEF EXTERN
  BYTE __color_enhcd
  BYTE __color_std
ENDDEF

#ifdef shit
FUNCTION INT Fullview_Key_Handler
  PARAMETERS VALUE LONG list_handle,;
             VALUE UINT list_element,;
                   UINT mouse_stat,;
             VALUE UINT mrow,;
             VALUE UINT mcol,;
                    INT pick_key,;
             VALUE UINT top_element,;
             VALUE UINT last_element,;
       VALUE UINT ur,;
       VALUE UINT uc,;
       VALUE UINT lr,;
       VALUE UINT lc

  VARDEF
    INT  list_return
    INT  set_key
  ENDDEF

  set_key = 0
  list_return = &jl_continue

  DO CASE
    CASE mouse_stat = &jl_mouse_ignore
    CASE mouse_stat = &jl_mouse_right    && right button pressed
      list_return = &jl_ignore
    CASE mouse_stat = &jl_mouse_xright   && right button released
    *- use set_key so that the LASTKEY() value is accurate
      set_key = &k_esc

    CASE mouse_stat = &jl_mouse_up       && left button + top scroll-bar tab
      list_return = &jl_ignore
    CASE mouse_stat = &jl_mouse_xup      && left button release "     "
      pick_key = &k_c_pg_up
    CASE mouse_stat = &jl_mouse_down     && left button + bottom scroll tab
      list_return = &jl_ignore
    CASE mouse_stat = &jl_mouse_xdown    && left button release "     "
      pick_key = &k_c_pg_down
    CASE mouse_stat = &jl_mouse_xscroll
      list_return = &jl_ignore
    CASE mouse_stat = &jl_mouse_scroll
      && cursor on scroll_bar, the default
      && 'pick_key' values should be set.
      &&    at bottom of list = &k_c_pg_down
      &&    at top of list    = &k_c_pg_up
      &&    above current     = &k_pg_down
      &&    below current     = &k_pg_up

      *- the values of 'pick_key' are set based upon the position of the
      *  mouse cursor relative to the scroll bar marker.
      *
      DO CASE
        CASE pick_key = &k_pg_down     && mouse below current position
          pick_key = &k_down
        CASE pick_key = &k_pg_up       && mouse above current position
          pick_key = &k_up
        CASE pick_key = &k_c_pg_down   && mouse at bottom  on scroll bar
          pick_key = &k_down
        CASE pick_key = &k_c_pg_up     && mouse at top  on scroll bar
          pick_key = &k_up
      ENDCASE

    CASE mouse_stat = &jl_mouse_xnew   && left released + mouse on new
      list_return = &jl_ignore
    CASE mouse_stat = &jl_mouse_new    && left + mouse on new element
      list_return = &jl_goto_mouse

    CASE mouse_stat = &jl_mouse_select  && left + mouse on current element
      list_return = &jl_ignore
    CASE mouse_stat = &jl_mouse_xselect && left released + mouse on current
      set_key = &k_enter

    CASE mouse_stat = &jl_mouse_left    && left + mouse outside of pick area
      list_return = &jl_continue
      IF mrow=ur-1
        pick_key = &k_up
      ELSE
        IF mrow=lr+1
          pick_key = &k_down
        ELSE
          list_return = &jl_ignore
        ENDIF

      ENDIF

    CASE mouse_stat = &jl_mouse_xleft   && left released + "         "
      list_return = &jl_ignore
    CASE mouse_stat = &jl_mouse_both    && left & right button hit
      list_return = &jl_ignore
  ENDCASE


  IF set_key <> 0
    DO WHILE INKEY() <> 0
    ENDDO

    KEY_INT( set_key )
    pick_key = INKEY()
  ENDIF


  DO CASE
    CASE pick_key = &k_enter
      list_return = &jl_select
    CASE pick_key = &k_esc
      list_return = &jl_abort
    CASE pick_key = &k_down .AND. list_element <> last_element
      pick_key = &k_end
      KEY_INT( &k_down )
    CASE pick_key = &k_up .AND. list_element <> top_element
      pick_key = &k_home
      KEY_INT( &k_up )
  ENDCASE

  RETURN list_return
ENDPRO

#ENDIF


FUNCTION LOGICAL Vlist_Fullview
  PARAMETERS CONST CHAR filename,;
             VALUE UINT ur,;
             VALUE UINT uc,;
             VALUE UINT lr,;
             VALUE UINT lc,;
             VALUE LOGICAL mice

  VARDEF
    FILE    filehandle
    LONG    filelist
    CHAR    one_line
    UINT    temp1, topline
    UINT    left_mark, right_mark, max_right
    LOGICAL keep_view
    BYTE    old_enhcd, old_std
  ENDDEF

  old_enhcd = __color_enhcd
  old_std   = __color_std

  IF .NOT. EXIST( filename )
    RETURN .F.
  ENDIF

  IF .NOT. F_OPEN( filehandle, filename, &f_read )
    RETURN .F.
  ENDIF

  max_right = 0

  filelist = Vlist_Init( 140 )
  IF .NOT. Vlist_Is_Init( filelist )
    RETURN .F.
  ENDIF

  DO WHILE .NOT. F_EOF( filehandle )
    IF .NOT. F_GETLN( filehandle, one_line )
      F_CLOSE( filehandle )
      Vlist_Clear( filelist )
      RETURN .F.
    ENDIF

    IF LEN( TRIM( one_line ) ) > max_right
      max_right = LEN( TRIM( one_line ) )
    ENDIF

    *    one_line = one_line + SPACE( 138 - LEN( one_line ) )

    *- &JL_HIT will not allow mouse to select item
    IF .NOT. Vlist_Append( filelist, &jl_hit, &jl_default, one_line )
      F_CLOSE( filehandle )
      Vlist_Clear( filelist )
      RETURN .F.
    ENDIF

  ENDDO

  temp1 = 1
  topline    = 1
  keep_view  = .T.
  left_mark  = 1
  right_mark = lc - uc + 1

  IF max_right > 132
    max_right = 132
  ENDIF

  #ifdef shit
  __color_enhcd = old_std
  #ENDIF

  DO WHILE keep_view

    #ifdef shit
    temp1 = Vlist_Pick( filelist, ur, uc, lr, lc, topline, temp1, 0, 0,;
                        left_mark, right_mark,;
                        1, 0,;
                        Fullview_Key_Handler,;
                        .F., .T., .T., mice, .F. )
    #ELSE
    temp1 = Vlist_Pick( filelist, ur, uc, lr, lc, topline, temp1, 0, 0,;
                        left_mark, right_mark,;
                        1, 0,;
                        Vlist_Default_Key_Handler,;
                        .F., .T., .T., mice, .F. )
    #ENDIF


    IF LASTKEY() = &k_left
      IF left_mark > 1
        left_mark  = left_mark - 5
        right_mark = right_mark - 5
      ENDIF

    ELSE
      IF LASTKEY() = &k_right
        IF right_mark < max_right
          left_mark  = left_mark + 5
          right_mark = right_mark + 5
        ENDIF

      ELSE
        keep_view = .F.
        LOOP
      ENDIF

    ENDIF

  ENDDO

  F_CLOSE( filehandle )
  Vlist_Clear( filelist )

  __color_std   = old_std
  __color_enhcd = old_enhcd

  RETURN .T.

ENDPRO