; VLIST
;
; replacement for picklists
;
;

include	Vlist.inc			; list structures
include j_errors.inc
include Vlistx.inc
	
extrn	_$allocate:far
extrn	_free:far
extrn  _$error_handler:far


; GLOBAL DATA ------------------------------------------------------------

dgroup		group _data
_data		segment word public 'DATA'
_data		ends


; LOCAL DATA and CODE ----------------------------------------------------

Vlist_seg	segment	public
		assume cs:Vlist_seg, ds:dgroup


		;
		; FUNCTION LONG VLIST_INIT PROTOTYPE
		;	PARAMETERS VALUE UINT str_len
		;
		public	_Vlist_init
_Vlist_init	proc	far

		push	bp
		mov	bp, sp
		push	ds
		push	si
		push	es
		push	di

		push	bx
		push	cx
		
		mov	ax, JH_size

		push	ax
		
		call	alloc

		; see if a null pointer was returned

		jnc	$we_ok
		add	sp, 2
		xor	dx, dx
		xor	ax, ax
                jmp	$end_pop

$we_ok:
                add	sp, 2
		mov	bx, [ bp ].p_str_len
		; new header is at DX:AX

		mov	es, dx
		mov	di, ax

		mov	word ptr es:[ di ].JH_ident, VLIST_IDENT
		mov	word ptr es:[ di ].JH_handle, es
		mov	word ptr es:[ di ].JH_first, 0
		mov	word ptr es:[ di ].JH_first.2, 0
		mov	word ptr es:[ di ].JH_count, 0
		mov	word ptr es:[ di ].JH_str_len, BX
		mov	word ptr es:[ di ].JH_current, 0
		mov	word ptr es:[ di ].JH_current.2, 0
		mov	word ptr es:[ di ].JH_cur_no, 0
		
$end_pop:
		pop	cx
		pop	bx

		pop	di
		pop	es
		pop	si
		pop	ds
		pop	bp
		ret

_Vlist_init	endp



Vlist_seg	ends		
		end
