#INCLUDE vlist.hdr
#INCLUDE STRING.HDR
#INCLUDE IO.HDR

VARDEF EXTERN
  BYTE  __color_std, __color_enhcd
ENDDEF

PROCEDURE Vlist_Embed_Left
  PARAMETERS CHAR sstring,;
             VALUE UINT slen
  VARDEF
    BYTE   bstring[ 255 ] BASED sstring
    BYTE   echar BASED __embed_char
    UINT   counter, place
  ENDDEF

  place = 0
  counter = 0
  DO WHILE bstring[ place ] <> 0 .AND. counter < slen
    IF bstring[ place ] <> echar
      counter = counter + 1
    ENDIF
    place   = place + 1
  ENDDO

  bstring[ place ] = 0
ENDPRO

PROCEDURE Vlist_Say
  PARAMETERS VALUE UINT srow,;
             VALUE UINT scol,;
             VALUE UINT swidth,;
             CONST CHAR sstring,;
             VALUE LOGICAL selected

  VARDEF
    BYTE        old_std
    CHAR        disp_str, temp_str
    UINT        current_col, stop_col, temp_int1
  ENDDEF

  old_std = __color_std

  disp_str = sstring
  current_col = scol

  IF swidth > 0
    VList_Embed_Left( disp_str, swidth )
  ENDIF

  temp_int1 = AT( __embed_char, disp_str )
  IF temp_int1 > 0
    stop_col = current_col + swidth - 1
    DO WHILE temp_int1 > 0
      temp_str = LEFT( disp_str, temp_int1 - 1 )
      @srow, current_col SAY temp_str
      current_col = current_col + temp_int1

      IF selected
        __color_std = __color_hi_enhcd
      ELSE
        __color_std = __color_hi_std
      ENDIF

      @srow, current_col - 1 SAY SUBSTR( disp_str, temp_int1 + 1, 1 )

      __color_std = old_std

      disp_str = SUBSTR( disp_str, temp_int1 + 2, 200 )

      temp_int1 = AT( __embed_char, disp_str )
    ENDDO

    @srow, current_col SAY disp_str
    current_col = current_col + LEN( disp_str )

    IF swidth <> 0
      IF current_col <= stop_col
        @srow, current_col SAY SPACE( stop_col - current_col + 1 )
      ENDIF
 
    ENDIF

  ELSE
    IF swidth = 0
      @srow, scol SAY disp_str
    ELSE
      @ srow, scol SAY disp_str:swidth
    ENDIF
 
  ENDIF


  __color_std = old_std

ENDPRO
