#INCLUDE WARN.HDR
#INCLUDE STRING.HDR
#INCLUDE Vlistx.fnc
#INCLUDE IO.HDR


FUNCTION LOGICAL VList_Locate_SubStr
  PARAMETERS VALUE LONG handle,;
       CONST CHAR look_string,;
       VALUE UINT start_sub,;
       VALUE UINT end_sub,;
       VALUE LOGICAL exact_match,;
       VALUE LOGICAL from_current

  VARDEF
    LOGICAL keep_going
    LOGICAL fnd
    UINT    leng
    CHAR    find_str
    CHAR    temp_str
  ENDDEF

  IF .NOT. Vlist_Is_Init( handle )
    RETURN .F.
  ENDIF

  IF .NOT. from_current
    VLIst_Top( handle )
  ENDIF

  IF start_sub = 0
    start_sub = 1
  ENDIF

  IF end_sub = 0 .OR. end_sub > Vlist_Get_Strlen( handle )
    end_sub = Vlist_Get_Strlen( handle )
  ENDIF

  end_sub = end_sub - start_sub + 1

  find_str = look_string
  leng = LEN( find_str )
  find_str = RTRIM( find_str )

  IF .NOT. exact_match
    leng = LEN( find_str )
    IF end_sub > leng
      end_sub = leng
    ENDIF
 
  ENDIF

  IF leng > end_sub
    find_str = LEFT( find_str, end_sub )
  ENDIF

  keep_going = .F.
  fnd = .F.

  IF from_current
    Vlist_Skip( handle, &jl_forward )
  ENDIF

  IF Vlist_Bol( handle )
    fnd = .F.
  ELSE

    REPEAT

      temp_str = Vlist_Cstr( handle )
      temp_str = rtrim( SUBSTR( temp_str, start_sub, end_sub ) )
      IF temp_str = find_str
        fnd = .T.
        keep_going = .T.
        LOOP
      ENDIF

      Vlist_Skip( handle, &jl_forward )
      IF Vlist_Bol( handle )
        fnd = .F.
        keep_going = .T.
        LOOP
      ENDIF

      IF Vlist_Number( handle ) = 0
        fnd = .F.
        keep_going = .T.
        LOOP
      ENDIF

    UNTIL keep_going
 
  ENDIF

  RETURN fnd
ENDPRO
