**-- Pop-Up menu for VList

VARDEF EXTERN
  BYTE __color_std
ENDDEF

#INCLUDE WARN.HDR
#INCLUDE vlistx.fnc
#INCLUDE STRING.HDR
#INCLUDE IO.HDR
#INCLUDE KEYS.HDR
#INCLUDE SYSTEM.HDR


FUNCTION INT VLIST_Default_Menu_Handler PROTOTYPE
  PARAMETERS VALUE LONG list_handle,;
             VALUE UINT list_element,;
                   UINT mouse_stat,;
             VALUE UINT mrow,;
             VALUE UINT mcol,;
                    INT pick_key,;
       VALUE UINT top_element,;
       VALUE UINT last_element,;
       VALUE UINT ur,;
       VALUE UINT uc,;
       VALUE UINT lr,;
       VALUE UINT lc

FUNCTION UINT Vlist_PICK PROTOTYPE
  PARAMETERS VALUE LONG    handle,;
             VALUE INT     upper_row,;
             VALUE INT     upper_col,;
             VALUE INT     lower_row,;
             VALUE INT     lower_col,;
                   UINT    top_element,;    && must be variable
             VALUE UINT    initial_element,;
             VALUE UINT    first_element_allowed,;    && limits list
             VALUE UINT    last_element_allowed,;
             VALUE UINT    left_string_marker,;  && displays SUBSTR
             VALUE UINT    right_string_marker,;
             VALUE UINT    number_of_columns,;   && column format 1-10
             VALUE UINT    spaces_between_columns,;
             VALUE ULONG   key_handler_proc,;
             VALUE LOGICAL display_only,;
             VALUE LOGICAL scroll_bar,;&& YAY!
             VALUE LOGICAL return_on_left_right,;
             VALUE LOGICAL is_mouse,;
             VALUE LOGICAL allow_embedded


FUNCTION UINT VList_PopTart
  PARAMETERS VALUE LONG      handle,;
       VALUE UINT      system,;
       VALUE INT       s_row,;
       VALUE INT       s_col,;
       VALUE UINT      max_row,;
       VALUE UINT      first,;
       CONST CHAR( 8 ) border_chars,;
       VALUE BYTE      border_color,;
       VALUE BYTE      title_color,;
       VALUE LOGICAL   shadow,;
       VALUE LOGICAL   save_under,;
             UINT      save_var,;
       VALUE LOGICAL   restore_under,;
       VALUE LOGICAL   scroll_bar,;
       VALUE LOGICAL   mouse,;
             VALUE UINT      left_start,;
             VALUE UINT      start_element,;
             VALUE LOGICAL   return_left_right,;
                   UINT      element_selected,;
                   UINT      top_element,;
             VALUE ULONG     menu_key_proc,;
             VALUE LOGICAL allow_embedded

  VARDEF
    LOGICAL cont
    UINT  old_row, old_col, old_std
    UINT  sel
    CHAR  temp_str, title
    UINT  temp1, temp2, temp3, temp4
    UINT  ur, uc, lr, lc, wid, left_sub
    UINT  border_offset
    LOGICAL center_row, center_col
    UINT  fudge
  ENDDEF

  center_row = .F.
  center_col = .F.

  IF s_row = -1
    s_row = 0
    center_row = .T.
  ENDIF
 
  IF s_col = -1
    s_col = 0
    center_col = .T.
  ENDIF

  IF .NOT. vlist_is_init( handle )
    RETURN 0
  ENDIF

  IF vlist_max( handle ) = 0
    RETURN 0
  ENDIF

  border_offset = 0

  old_row = ROW()
  old_col = COL()

  temp_str = I_STR( system )+"."
  temp1 = start_element

  vlist_goto( handle, temp1 )

  cont = .T.
  DO WHILE cont
    IF vlist_bol( handle )
      cont = .F.
      LOOP
    ENDIF

    IF SUBSTR( vlist_cstr( handle ), left_start, LEN( temp_str ) ) <> temp_str
      cont =.F.
      LOOP
    ENDIF

    temp2 = vlist_number( handle )
    vlist_skip( handle, &jl_forward )
  ENDDO

  vlist_goto( handle, temp1 )

  temp3 = temp2
  temp2 = temp1+1

  * temp1 = title
  * temp2 = first menu item
  * temp3 = last menu item

  ur = s_row
  uc = s_col

  left_sub = 1
  title = vlist_cstr( handle )
  left_sub = AT( "|", title )+1
  wid = LEN( title ) - left_sub + 3

  FOR lc = temp2 TO temp3
    vlist_goto( handle, lc )
    temp_str = SUBSTR( vlist_cstr( handle ), left_sub, 128 )
    IF LEN( temp_str ) > wid
      wid = LEN( temp_str )
    ENDIF

  NEXT

  IF center_row
    fudge = 12 - ( ( temp3 - temp2  + 1 ) / 2 )
    ur = fudge
  ENDIF
 
  IF center_col
    uc = 40 - ( wid / 2 )
  ENDIF


  lc = uc + 1 + wid + border_offset
  lr = ur + 2 + ( temp3 - temp2 )
  IF shadow
    lc = lc + 1
    lr = lr + 1
    temp4 = 6
  ELSE
    temp4 = 0
  ENDIF

  IF lr > max_row
    lr = max_row
  ENDIF

  DO WHILE lc > 79
    lc = lc - 1
    IF uc > 0
      uc = uc - 1
    ENDIF

  ENDDO

  IF save_under
    save_var = SAVESCRN( ur, uc, lr, lc )
  ENDIF

  FILL( ur, uc, lr, lc, border_chars, " ", border_color, __color_std, temp4 )
  old_std  = __color_std
  __color_std = title_color

  IF LEN( SUBSTR( title, left_sub, 128 ) ) > 0
    IF allow_embedded
      vlist_say( ur, uc+2, 0,;
                 SUBSTR( title, left_sub, LEN( title ) ), .F. )
    ELSE
      @ ur, uc+2 SAY SUBSTR( title, left_sub, LEN( title ) )
    ENDIF
 
  ENDIF

  __color_std = old_std

  IF shadow
    lc = lc - 1
    lr = lr - 1
  ENDIF

  temp4 = temp2
  IF first = 0
    first = 1
  ELSE
    IF first > ( temp3-temp2+1 )
      first = temp3-temp2+1
    ENDIF

  ENDIF

  sel = first + temp1
  element_selected = Vlist_Pick( handle, ur+1, uc+1+border_offset,;
                     lr-1, lc-1-border_offset,;
                     top_element, sel, temp2, temp3,;
                     left_sub, left_sub+wid,;
                     1, 0,;
                     menu_key_proc,;
                     .F., scroll_bar, return_left_right, mouse,;
                     allow_embedded )

  IF restore_under
    RESTORESCRN( save_var )
  ENDIF

  IF LASTKEY() <> 27 .AND. LASTKEY() <> &k_left .AND. LASTKEY() <> &k_right
    sel = element_selected
    IF ( vlist_goto( handle, sel ) ) .AND.;
         ( sel > 0 ) .AND.;
         ( sel <= vlist_max( handle ) )
      temp_str = vlist_cstr( handle )
      temp_str = SUBSTR( temp_str, 1, left_sub )
      temp_str = SUBSTR( temp_str, left_start, left_sub )
      temp_str = SUBSTR( temp_str, AT( ".", temp_str )+1, 128 )
      sel = VAL( temp_str )
    ELSE
      sel = 0
    ENDIF
 
  ELSE
    sel = 0
  ENDIF


  @old_row, old_col
  RETURN sel
ENDPRO