; VLIST
;
; replacement for picklists
;
;

include	Vlist.inc			; list structures
include j_errors.inc
include Vlistx.inc
	
extrn	_$allocate:far
extrn	_free:far
extrn  _$error_handler:far


; GLOBAL DATA ------------------------------------------------------------

dgroup		group _data
_data		segment word public 'DATA'
_data		ends


; LOCAL DATA and CODE ----------------------------------------------------

Vlist_seg	segment	public
		assume cs:Vlist_seg, ds:dgroup


		;
		; FUNCTION LOGICAL VLIST_APPEND PROTOTYPE
		;	PARAMETERS VALUE LONG Vlist_handle,;
		;		   VALUE UINT status,;
		;		   VALUE INT  color,;
		;		   CONST CHAR Vlist_str
		;
                public	_Vlist_append
_Vlist_append	proc	far

		push	bp
		mov 	bp, sp

		push	ds
		push	si
		push	es
		push	di
		push	bx
		push	cx

		les	di, dword ptr [ bp ].p2_handle

		call	validate

		mov	ax, word ptr es:[ di ].JH_str_len
		add	ax, JB_size
		inc	ax

		push	ax

		call	alloc

		; see if a null pointer was returned

		jnc	$so_far_so_good
		add	sp, 2

		; set RETURN to .F.
		xor	ax, ax
		jmp	$end_pop2

$so_far_so_good:
		add	sp, 2
		
		; DX:AX contains the new string block
		mov	bx, es:[ di ].JH_count

		cmp	bx, 0
		jne	$already_some

		; since this is the first, set up the pointers
		mov	word ptr es:[ di ].jh_first.2, dx
		mov	word ptr es:[ di ].jh_first, ax
		mov	word ptr es:[ di ].jh_last.2, dx
		mov	word ptr es:[ di ].jh_last, ax


		mov	bx, 0
		mov	ds, bx
		xor	si, si

		jmp	$increment

$already_some:	
		; since this is NOT the first, reposition LAST pointers
		; thereby adding to the rear of the linked list.

		mov	ds, es:[ di ].jh_last.2
		mov	si, es:[ di ].jh_last
		mov	es:[ di ].jh_last.2, dx
		mov	es:[ di ].jh_last, ax
		
		; DS:SI	points to old LAST block

		mov	ds:[ si ].JB_next.2, dx
		mov	ds:[ si ].JB_next, ax

$increment:
		; ES:DI points to header
		; DX:AX points to new block
		; DS:SI points to last block

		inc	bx
		mov	word ptr es:[ di ].jh_current.2, dx
		mov	word ptr es:[ di ].jh_current, ax
		mov	word ptr es:[ di ].jh_cur_no, bx
		mov	word ptr es:[ di ].jh_count, bx
		mov	bx, word ptr es:[ di ].jh_str_len

		push	es
		push	di
		mov	es, dx
		mov	di, ax

		push	ax
		mov	ax, word ptr [ bp ].p2_status
		xor	ah, ah
		mov	byte ptr es:[ di ].JB_status, al
		mov	ax, [ bp ].p2_color
		mov	word ptr es:[ di ].JB_color, ax
		pop	ax

		mov	word ptr es:[ di ].JB_next, 0
		mov	word ptr es:[ di ].JB_next.2, 0
		mov	es:[ di ].JB_last, si
		mov	es:[ di ].JB_last.2, ds

		mov	es:[ di ].jb_handle, dx

		pop	di
		pop	es

		push	ax

		les	di, dword ptr [ bp ].p2_string
		mov	cx, -1
		xor	al, al
		repne	scasb
		not	cx

                inc	bx

		cmp	cx, bx
		jbe	$cont
		mov	cx, bx

$cont:
		; now COPY the string:
		lds	si, dword ptr [ bp ].p2_string

		mov	es, dx
		pop	di
		add	di, jb_str

		; now
		;   ES:DI = new string
		;   DS:SI = string on stack

		; COPY STRING HERE
		rep	movsb

		; set RETURN to .T.
		mov	ax, 1

$end_pop2:
		pop	cx
		pop	bx
		pop	di
		pop	es
		pop	si
		pop	ds
		pop	bp
		ret

_Vlist_append	endp




Vlist_seg	ends		
		end
