#DEFINE search_embedded
*- if the above line is not there, then when a character key is pressed
*  'A'..'Z', the first element with any capital letter matching is found.
*  If it does exist, the first with an embedded will be found.
*

#INCLUDE KEYS.HDR
#INCLUDE vlist.hdr
#INCLUDE STRING.HDR
#INCLUDE WARN.HDR
#INCLUDE vmouse.hdr
#INCLUDE IO.HDR
#INCLUDE SYSTEM.HDR

FUNCTION INT vlist_default_Menu_handler
  PARAMETERS VALUE LONG list_handle,;
             VALUE UINT list_element,;
                   UINT mouse_stat,;
             VALUE UINT mrow,;
             VALUE UINT mcol,;
                    INT pick_key,;
             VALUE UINT top_element,;
             VALUE UINT last_element,;
             VALUE UINT ur,;
             VALUE UINT uc,;
             VALUE UINT lr,;
             VALUE UINT lc


  VARDEF
    INT     list_return
    INT     set_key
    CHAR    temp_str
    UINT    search_loop, temp_stat, found_element, temp_int, loop_int
    LOGICAL    fnd
  ENDDEF


  set_key = 0
  list_return = &jl_continue

  DO CASE
    CASE mouse_stat = &jl_mouse_ignore
    CASE mouse_stat = &jl_mouse_right    && right button pressed
      list_return = &jl_ignore
    CASE mouse_stat = &jl_mouse_xright   && right button released
    *- use set_key so that the LASTKEY() value is accurate
      set_key = &k_esc

    CASE mouse_stat = &jl_mouse_up       && left button + top scroll-bar tab
      list_return = &jl_ignore
    CASE mouse_stat = &jl_mouse_xup      && left button release "     "
      pick_key = &k_c_pg_up
    CASE mouse_stat = &jl_mouse_down     && left button + bottom scroll tab
      list_return = &jl_ignore
    CASE mouse_stat = &jl_mouse_xdown    && left button release "     "
      pick_key = &k_c_pg_down
    CASE mouse_stat = &jl_mouse_xscroll
      list_return = &jl_ignore
    CASE mouse_stat = &jl_mouse_scroll
      && cursor on scroll_bar, the default
      && 'pick_key' values should be set.
      &&    at bottom of list = &k_c_pg_down
      &&    at top of list    = &k_c_pg_up
      &&    above current     = &k_pg_down
      &&    below current     = &k_pg_up

      *- the values of 'pick_key' are set based upon the position of the
      *  mouse cursor relative to the scroll bar marker.
      *
      DO CASE
        CASE pick_key = &k_pg_down     && mouse below current position
          pick_key = &k_down
        CASE pick_key = &k_pg_up       && mouse above current position
          pick_key = &k_up
        CASE pick_key = &k_c_pg_down   && mouse at bottom  on scroll bar
          pick_key = &k_down
        CASE pick_key = &k_c_pg_up     && mouse at top  on scroll bar
          pick_key = &k_up
      ENDCASE

    CASE mouse_stat = &jl_mouse_xnew   && left released + mouse on new
      list_return = &jl_ignore
    CASE mouse_stat = &jl_mouse_new    && left + mouse on new element
      list_return = &jl_goto_mouse

    CASE mouse_stat = &jl_mouse_select  && left + mouse on current element
      list_return = &jl_ignore
    CASE mouse_stat = &jl_mouse_xselect && left released + mouse on current
      set_key = &k_enter
    CASE mouse_stat = &jl_mouse_xleft   && left released + "         "
      list_return = &jl_ignore
    CASE mouse_stat = &jl_mouse_left    && left + mouse outside of pick area
      IF mrow < ur - 2
        list_return = &jl_rescan_menu
      ELSE
        list_return = &jl_ignore
      ENDIF

    CASE mouse_stat = &jl_mouse_both    && left & right button hit
      list_return = &jl_ignore
  ENDCASE


  IF set_key <> 0
    DO WHILE INKEY() <> 0
    ENDDO

    KEY_INT( set_key )
    pick_key = INKEY()
  ENDIF


  DO CASE
    CASE pick_key = &k_enter
      list_return = &jl_select
    CASE pick_key = &k_esc
      list_return = &jl_abort
    CASE pick_key = 0
    CASE pick_key = &k_up
      IF top_element = Vlist_Number( list_handle )
        pick_key = &k_c_pg_down
      ENDIF

    CASE pick_key = &k_down
      IF last_element = Vlist_Number( list_handle )
        pick_key = &k_c_pg_up
      ENDIF

    CASE ( pick_key >= 65 .AND. pick_key <=90 ) .OR.;
             ( pick_key >= 97 .AND. pick_key <= 122 )

      *- find element in those that are displayed.  This is assuming
      *  that the menu does not scroll.

      fnd = .F.

      FOR search_loop = top_element TO last_element
        VLIST_GOTO( list_handle, search_loop )
        temp_str = VList_Cstr( list_handle )
        temp_stat = VList_Cget_Status( list_handle )

        IF temp_stat = &jl_hide .OR. temp_stat = &jl_skip
          LOOP
        ENDIF

        temp_str = TRIM( SUBSTR( temp_str, AT( "|", temp_str ) + 1, 254 ) )

        #ifdef search_embedded
        IF AT( __embed_char, temp_str ) > 0
          IF UPPER( SUBSTR( temp_str,;
                       AT( __embed_char, temp_str ) + 1,;
                       1 ) ) = UPPER( CHR( pick_key ) )
            fnd = .T.
            found_element = search_loop
            EXIT
          ENDIF
 
        ENDIF
 
        #ELSE

        IF UPPER( CHR( pick_key ) ) $ temp_str
          fnd = .T.
          found_element = search_loop
          EXIT
        ENDIF

        #ENDIF

      NEXT

      list_return = &jl_ignore
      pick_key = 0

      IF fnd
        Vlist_Goto( list_handle, list_element )
        temp_int = 0

        IF found_element < list_element
          FOR loop_int = found_element TO list_element
            Vlist_Goto( list_handle, loop_int )
            temp_stat = Vlist_Cget_Status( list_handle )
            IF temp_stat <> &jl_hide .AND.;
                 temp_stat <> &jl_skip
              temp_int = temp_int + 1
            ENDIF

          NEXT

          FOR loop_int = 1 TO temp_int - 1
            KEY_INT( &k_up )
          NEXT

        ELSE
          IF found_element > list_element
            FOR loop_int = list_element TO found_element
              Vlist_Goto( list_handle, loop_int )
              temp_stat = Vlist_Cget_Status( list_handle )
              IF temp_stat <> &jl_hide .AND.;
                   temp_stat <> &jl_skip
                temp_int = temp_int + 1
              ENDIF

            NEXT

            FOR loop_int = 1 TO temp_int - 1
              KEY_INT( &k_down )
            NEXT

          ENDIF

        ENDIF

        *- and to select the element.
        KEY_INT( &k_enter )

      ENDIF


  ENDCASE

  RETURN list_return
ENDPRO
