**-- Pop-Up menu for VList
#INCLUDE WARN.HDR
#INCLUDE vlistx.fnc
#INCLUDE STRING.HDR
#INCLUDE IO.HDR
#INCLUDE SYSTEM.HDR



FUNCTION UINT VList_PopTart PROTOTYPE
  PARAMETERS VALUE LONG      handle,;
       VALUE UINT      system,;
       VALUE INT       s_row,;
       VALUE INT       s_col,;
       VALUE UINT      max_row,;
       VALUE UINT      first,;
       CONST CHAR( 8 ) border_chars,;
       VALUE BYTE      border_color,;
       VALUE BYTE      title_color,;
       VALUE LOGICAL   shadow,;
       VALUE LOGICAL   save_under,;
             UINT      save_var,;
       VALUE LOGICAL   restore_under,;
       VALUE LOGICAL   scroll_bar,;
       VALUE LOGICAL   mouse,;
             VALUE UINT      left_start,;
       VALUE UINT      start_element,;
       VALUE LOGICAL   return_left_right,;
       UINT      element_selected,;
       UINT      top_element,;
             VALUE ULONG     menu_key_proc,;
             VALUE LOGICAL allow_embedded



FUNCTION LOGICAL VList_PopUp
  PARAMETERS VALUE LONG      handle,;
       VALUE UINT      system,;
       UINT      first,;
             VALUE ULONG     menu_key_proc,;
       VALUE INT       s_row,;
       VALUE INT       s_col,;
       VALUE UINT      max_row,;
       CONST CHAR( 8 ) border_chars,;
       VALUE BYTE      border_color,;
       VALUE BYTE      title_color,;
       VALUE LOGICAL   shadow,;
       VALUE LOGICAL   save_under,;
             UINT      save_var,;
       VALUE LOGICAL   restore_under,;
       VALUE LOGICAL   scroll_bar,;
       VALUE LOGICAL   mouse,;
       VALUE LOGICAL   allow_embedded

  VARDEF
    CHAR temp_str
    UINT temp1
    UINT element_selected, top_element
  ENDDEF

  IF .NOT. vlist_is_init( handle )
    RETURN .F.
  ENDIF

  temp_str = I_STR( system )+".0 "

  IF vlist_locate_substr( handle, temp_str, 1, LEN( temp_str ), .T., .F. )
    temp1 = vlist_number( handle )
    top_element = temp1 + 1

    temp1 = Vlist_Poptart( handle, system, s_row, s_col, max_row, first, border_chars,;
       border_color, title_color, shadow, save_under, save_var,;
       restore_under, scroll_bar, mouse, 1, temp1, .F.,;
     element_selected, top_element, menu_key_proc, allow_embedded )

    first = temp1

    IF LASTKEY() = 27
      temp1 = 0
    ENDIF

  ELSE
    temp1 = 0
  ENDIF

  IF temp1 = 0
    RETURN .F.
  ELSE
    RETURN .T.
  ENDIF

ENDPRO