**-- Pulldown menu for VList
#INCLUDE WARN.HDR
#INCLUDE vlistx.fnc
#INCLUDE STRING.HDR
#INCLUDE IO.HDR
#INCLUDE SYSTEM.HDR
#INCLUDE KEYS.HDR
#INCLUDE COLORS.HDR
#INCLUDE mouse.fnc

VARDEF EXTERN
  BYTE __color_std, __color_enhcd
ENDDEF

FUNCTION UINT VList_Call_Pulldown PROTOTYPE
  PARAMETERS VALUE ULONG proc_to_call,;
             VALUE LONG handle,;
             VALUE UINT system,;
             VALUE UINT over,;
             VALUE UINT down


FUNCTION UINT VList_PopTart PROTOTYPE
  PARAMETERS VALUE LONG      handle,;
       VALUE UINT      system,;
       VALUE INT       s_row,;
       VALUE INT       s_col,;
       VALUE UINT      max_row,;
       VALUE UINT      first,;
       CONST CHAR( 8 ) border_chars,;
       VALUE BYTE      border_color,;
       VALUE BYTE      title_color,;
       VALUE LOGICAL   shadow,;
       VALUE LOGICAL   save_under,;
             UINT      save_var,;
       VALUE LOGICAL   restore_under,;
       VALUE LOGICAL   scroll_bar,;
       VALUE LOGICAL   mouse,;
             VALUE UINT      left_start,;
       VALUE UINT      start_element,;
       VALUE LOGICAL   return_left_right,;
       UINT      element_selected,;
       UINT      top_element,;
             VALUE ULONG     key_handling_proc,;
             VALUE LOGICAL   allow_embedded



FUNCTION LOGICAL VList_Pulldown
  PARAMETERS VALUE LONG      handle,;
       VALUE UINT      system,;
             UINT      over,;
             UINT      down,;
       VALUE ULONG     menu_processing_proc,;   && MAKE UNTYPED in HEADER!!!!!!!!!!!!!!
       VALUE ULONG     menu_key_proc,;
       VALUE UINT      header_row,;
       VALUE UINT      menu_row,;
       VALUE UINT      max_row,;
       VALUE INT       col_offset,;
       CONST CHAR( 8 ) border_chars,;
       VALUE BYTE      border_color,;
       VALUE BYTE      header_color,;
       VALUE LOGICAL   shadow,;
       VALUE LOGICAL   scroll_bar,;
       VALUE LOGICAL   mouse,;
       VALUE LOGICAL   always_down,;
       VALUE LOGICAL   allow_embedded

  VARDEF
    CHAR       temp_str, temp_str2
    CHAR( 40 ) temp_str3
    UINT       temp1, temp2, temp3, old_over
    UINT       element_selected
    BYTE       h_col[ 15 ]
    BYTE       h_last[ 15 ]
    UINT       h_start[ 15 ]
    UINT       h_end[ 15 ]
    UINT       h_top[ 15 ]
    CHAR( 40 ) h_title[ 15 ]
    INT        h_max
    LOGICAL    ret_val, menu_loop, cont, pulled, refresh_title
    UINT       left_mark
    BYTE       old_std, old_hi
    UINT       save_var, header_var, return_status
    UINT       cap_search, cap_find
    LOGICAL    check_mouse
    UINT       mrow, mcol
  ENDDEF

  check_mouse = .F.

  old_std = __color_std

  IF over = 0 .OR. down = 0
    RETURN .F.
  ENDIF

  over = over - 1

  IF down = 0
    down = 1
  ENDIF

  h_max = -1
  IF .NOT. vlist_is_init( handle )
    RETURN .F.
  ENDIF

  temp_str = I_STR( system )+"."
  left_mark = LEN( temp_str )
  temp_str = temp_str +"1 @"

  IF vlist_locate_substr( handle, temp_str, 1, LEN( temp_str ), .T., .F. )
    temp1 = vlist_number( handle )

    ** we have the start of the menu system in temp1
    *   ?.? @?

    temp_str  = I_STR( system )+"."

    cont = .T.
    temp3 = temp1

    DO WHILE cont
      IF vlist_bol( handle )
        h_end[ h_max ] = temp3
        cont = .F.
        LOOP
      ENDIF

      temp_str2 = vlist_cstr( handle )
      IF SUBSTR( temp_str2, 1, left_mark ) <> temp_str
        h_end[ h_max ] = temp3
        cont =.F.
        LOOP
      ENDIF

      temp2 = AT( "@", temp_str2 )
      IF temp2 > 0
        IF h_max > 13
          cont = .F.
          LOOP
        ENDIF

        IF h_max > -1
          h_end[ h_max ] = vlist_number( handle ) - 1
        ENDIF

        h_max = h_max + 1
        temp_str3 = LTRIM( SUBSTR( temp_str2, temp2+1, 128 ) )
        temp_str2 = LEFT( temp_str3, AT( " ", temp_str3 )-1 )
        h_col[ h_max ] = VAL( temp_str3 )

        IF over = h_max
          h_last[ h_max ] = down
        ELSE
          h_last[ h_max ] = 1
        ENDIF

        h_start[ h_max ] = vlist_number( handle ) + 1
        temp_str2 = SUBSTR( temp_str3, AT( "|", temp_str3 )+1, 128 )
        h_title[ h_max ] = temp_str2
        h_top[ h_max ] = h_start[ h_max ]+1

      ENDIF

      temp3 = vlist_number( handle )
      vlist_skip( handle, &jl_forward )

    ENDDO

    IF h_max = -1
      menu_loop = .F.
    ELSE
      menu_loop = .T.
    ENDIF

    IF always_down
      pulled = .T.
    ELSE
      pulled = .F.
    ENDIF

    IF over > h_max
      over = h_max
    ENDIF

    header_var = SAVESCRN( header_row, 0, header_row, 79 )
    ret_val = .T.
    refresh_title = .T.

    DO WHILE menu_loop
      IF refresh_title
        refresh_title = .F.
        __color_std = header_color

        FOR temp1 = 0 TO h_max
          IF allow_embedded
            IF pulled
              old_hi = __color_hi_std
              __color_hi_std = __color_std
            ENDIF
            vlist_say( header_row, h_col[ temp1 ],;
                       0, h_title[ temp1 ], .F. )
            IF pulled
              __color_hi_std = old_hi
            ENDIF
          ELSE
            @header_row, h_col[ temp1 ] SAY h_title[ temp1 ]
          ENDIF
 
        NEXT
      ENDIF
    * highlight title

      __color_std = __color_enhcd
      IF allow_embedded
        IF pulled
          old_hi = __color_hi_enhcd
          __color_hi_enhcd = __color_enhcd
        ENDIF
        vlist_say( header_row, h_col[ over ],;
                   0, h_title[ over ], .T. )
        IF pulled
          __color_hi_enhcd = old_hi
        ENDIF
      ELSE
        @header_row, h_col[ over ] SAY h_title[ over ]
      ENDIF

      IF mouse
        vmouse_cursor( .T. )
      ENDIF

      __color_std = old_std
      old_over = over
      IF pulled
        temp2 = h_last[ over ]
        temp3 = ( h_end[ over ] - h_start[ over ] + 1 )

        IF temp2 > temp3
          temp2 = temp3
        ENDIF

        down = temp2

        __color_std = old_std

        IF h_start[ over ] < 1 .OR.;
             h_start[ over ] > vlist_max( handle )
          h_start[ over ] = 1
        ENDIF

        vlist_goto( handle, h_start[ over ] )
        temp_str = SUBSTR( vlist_cstr( handle ), left_mark+1, 20 )
        temp_str = LEFT( temp_str, AT( ".", temp_str ) - 1 )
        temp3 = VAL( TRIM( temp_str ) )

        IF mouse
          vmouse_cursor( .F. )
          DO WHILE vmouse_left_button() .AND. vmouse_row() = header_row
          ENDDO
 
        ENDIF

        temp1 = Vlist_Poptart( handle, temp3,;
                               menu_row, h_col[ over ] + col_offset,;
                               max_row,;
                               temp2,;
                               border_chars, border_color, header_color,;
                               shadow, .T., save_var, .F.,;
                               scroll_bar, mouse, left_mark+1,;
                               h_start[ over ], .T., element_selected,;
                               h_top[ over ],;
                               menu_key_proc,;
                               allow_embedded )

        h_last[ over ] = element_selected - h_start[ over ]

        DO WHILE INKEY() <> 0
        ENDDO

        temp3 = LASTKEY()
        DO CASE
          CASE temp3 = &k_esc .AND. always_down
            menu_loop = .F.
          CASE temp3 = &k_esc
            pulled = .F.
            refresh_title = .T.
          CASE temp3 = &k_enter
            down = temp1
            return_status = Vlist_Call_Pulldown( menu_processing_proc,;
                               handle, system, over+1, down )

            IF return_status = 1
              menu_loop = .F.
            ENDIF

          CASE temp3 = &k_right
            IF over < h_max
              over = over + 1
            ELSE
              over = 0
            ENDIF

          CASE temp3 = &k_left
            IF over > 0
              over = over - 1
            ELSE
              over = h_max
            ENDIF

          CASE temp3 = 10              && check mouse position
            check_mouse = .T.
        ENDCASE

        RESTORESCRN( save_var )
        IF mouse
          vmouse_cursor( .T. )
        ENDIF

      ELSE
        temp3 = 0
        DO WHILE temp3 = 0
          temp3 = INKEY()
          IF mouse
            IF vmouse_left_button()
              temp3 = 10
            ENDIF

            IF vmouse_right_button()
              DO WHILE vmouse_right_button()
              ENDDO

              temp3 = 27
            ENDIF
 
          ENDIF

        ENDDO

        DO CASE
          CASE temp3 = &k_end
            over = h_max
          CASE temp3 = &k_home
            over = 0
          CASE temp3 = &k_esc
            menu_loop = .F.
          CASE temp3 = &k_enter .OR. temp3 = &k_down .OR.;
              temp3 = &k_pg_down
            pulled = .T.
            refresh_title = .T.
          CASE temp3 = &k_right
            IF over < h_max
              over = over + 1
            ELSE
              over = 0
            ENDIF

          CASE temp3 = &k_left
            IF over > 0
              over = over - 1
            ELSE
              over = h_max
            ENDIF

          CASE temp3 = 10
            check_mouse = .T.

          CASE ( temp3 >= 65 .AND. temp3 <=  90 ) .OR.;
                 ( temp3 >= 97 .AND. temp3 <= 122 )

            cap_find = over
            FOR cap_search = 0 TO h_max
              IF allow_embedded
                IF AT( __embed_char, h_title[ cap_search ] ) > 0
                  IF UPPER( SUBSTR( h_title[ cap_search ],;
                               AT( __embed_char, h_title[ cap_search ] ) + 1,;
                               1 ) ) = UPPER( CHR( temp3 ) )
                    cap_find = cap_search
                    pulled = .T.
                    refresh_title = .T.
                    EXIT
                  ENDIF
 
                ENDIF
 
              ELSE
                IF AT( UPPER( CHR( temp3 ) ), h_title[ cap_search ] ) > 0
                  cap_find = cap_search
                  pulled   = .T.
                  refresh_title = .T.
                  EXIT
                ENDIF
 
              ENDIF
 
            NEXT
 
            over = cap_find

        ENDCASE

      ENDIF

      IF check_mouse
        mrow = vmouse_row()
        mcol = vmouse_col()

        DO WHILE INKEY() <> 0
        ENDDO

        IF mrow = header_row
          FOR temp3 = 0 TO h_max
            temp2 = h_col[ temp3 ]
            temp1 = temp2 + LEN( h_title[ temp3 ] ) - 1
            IF mcol >= temp2 .AND.;
                mcol <= temp1
              over = temp3
            ENDIF

          NEXT

        ENDIF

        check_mouse = .F.
        pulled = .T.
        refresh_title = .T.
      ENDIF

      IF mouse
        vmouse_cursor( .F. )
      ENDIF

      __color_std = header_color
      IF allow_embedded
        IF pulled
          old_hi = __color_hi_std
          __color_hi_std = __color_std
        ENDIF
        vlist_say( header_row, h_col[ old_over ], 0,;
                   h_title[ old_over ], .F. )
        IF pulled
          __color_hi_std = old_hi
        ENDIF
      ELSE
        @header_row, h_col[ old_over ] SAY h_title[ old_over ]
      ENDIF

    ENDDO

    RESTORESCRN( header_var )
  ELSE

    ret_val = .F.
  ENDIF

  over = over + 1
  __color_std = old_std
  RETURN ret_val
ENDPRO
