#include vlist.hdr
#include string.hdr
#include io.hdr

procedure vlist_embed_caps
  parameters value long plist,;
             value uint first_element,;
             value uint last_element

  vardef
    uint marker
    uint place
    char temp_str
  enddef

  if .not. vlist_is_init( plist )
    return
  endif

  if first_element = 0
    first_element = 1
  ENDIF

  if last_element = 0 .or. last_element > vlist_max( plist )
    last_element = vlist_max( plist )
  endif

  for marker = first_element to last_element
    IF vlist_goto( plist, marker )
      temp_str = vlist_cstr( plist )
      place = 1
      DO WHILE place <= LEN( temp_str )
        IF substr( temp_str, place, 1 ) $ "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
          temp_str = LEFT( temp_str, place - 1 ) + ;
                     __embed_char +;
                     SUBSTR( temp_str, place, 250 )
          vlist_cedit( plist, temp_str )
          exit
        ENDIF
        place = place + 1
      ENDDO
    ENDIF

  NEXT

ENDPRO

