#INCLUDE vlistx.fnc
#INCLUDE vmouse.hdr
#INCLUDE STRING.HDR
#INCLUDE KEYS.HDR
#INCLUDE WARN.HDR
#INCLUDE IO.HDR
#INCLUDE SYSTEM.HDR

VARDEF EXTERN
  BYTE  __color_std, __color_enhcd
ENDDEF

FUNCTION INT VLIST_Call_Prompt_Handler PROTOTYPE
  PARAMETERS VALUE ULONG user_function,;
             VALUE LONG list_handle,;
             VALUE UINT list_element,;
                   UINT mouse_stat,;
             VALUE UINT mrow,;
             VALUE UINT mcol,;
                    INT pick_key,;
             VALUE UINT top_element,;
             VALUE UINT last_element


FUNCTION UINT Vlist_Prompt
  PARAMETERS VALUE LONG    plist,;
             VALUE UINT    system,;
             VALUE UINT    first,;
             VALUE ULONG   handler_proc,;
             VALUE LOGICAL is_mouse,;
             VALUE LOGICAL allow_embeded

  VARDEF
    LOGICAL     ml, mr
    UINT        current_element, first_element, last_element
    CHAR( 10 )  syst
    CHAR        temp_str
    LOGICAL     prompt_loop
    LOGICAL     rescan, mouse_scan
    UINT        mrow, mcol, temp_count, temp_loop, temp_stat
    UINT        current_row, current_col, ret_val, temp_row, temp_col
    BYTE        old_std, old_enhcd
    UINT        mouse_stat
    INT         user_proc, pick_key
    LOGICAL     check_element, go_forward
    LOGICAL     move_marker
  ENDDEF

  old_std   =   __color_std
  old_enhcd =   __color_enhcd

  ret_val = 0

  IF .NOT. vlist_is_init( plist )
    RETURN 0
  ENDIF

  IF first > vlist_max( plist )
    first = vlist_max( plist )
  ENDIF

  IF first < 1
    first = 1
  ENDIF

  IF is_mouse
    ml = Vmouse_Left_Button()
    mr = Vmouse_Right_Button()
    Vmouse_Cursor( .T. )
  ENDIF

  syst = I_STR( system ) + "."
  IF .NOT.  vlist_locate_substr( plist, syst, 1, LEN( syst ), .T., .F. )
    RETURN 0
  ENDIF

  REPEAT
    first_element = vlist_number( plist )
    vlist_skip( plist, &jl_backward )

    IF vlist_tol( plist )
      EXIT
    ENDIF
 
  UNTIL LEFT( vlist_cstr( plist ), LEN( syst ) ) <> syst

  vlist_goto( plist, first_element )

  REPEAT
    last_element = vlist_number( plist )
    vlist_skip( plist, &jl_forward )

    IF vlist_bol( plist )
      EXIT
    ENDIF
 
  UNTIL LEFT( vlist_cstr( plist ), LEN( syst ) ) <> syst

  temp_count = 0

  vlist_goto( plist, first_element )

  FOR temp_loop = first_element TO last_element
    temp_stat = vlist_cget_status( plist )

    IF temp_stat <> &jl_hide .AND. temp_stat <> &jl_skip
      temp_count = temp_count + 1
    ENDIF

    vlist_skip( plist, &jl_forward )
 
  NEXT

  IF temp_count = 0
    RETURN 0
  ENDIF

  syst = syst + I_STR( first )

  IF .NOT.  vlist_locate_substr( plist, syst, 1, LEN( syst ), .T., .F. )
    current_element = first_element
  ELSE
    current_element = vlist_number( plist )
  ENDIF

  vlist_goto( plist, current_element )
  temp_stat = vlist_cget_status( plist )
  IF temp_stat = &jl_hide .OR. temp_stat = &jl_skip
    DO WHILE temp_stat = &jl_hide .OR. temp_stat = &jl_skip
      vlist_skip( plist, &jl_forward )
      IF vlist_number( plist ) > last_element
        vlist_goto( plist, first_element )
      ENDIF
 
      temp_stat = vlist_cget_status( plist )
    ENDDO
 
    current_element = vlist_number( plist )
  ENDIF

  prompt_loop = .T.
  mouse_scan  = .F.
  rescan = .T.  && draw all prompts again
  move_marker = .F.

  DO WHILE prompt_loop
    pick_key = 0

    IF is_mouse
      Vmouse_Cursor( .F. )
    ENDIF

    IF rescan
      FOR temp_loop = first_element TO last_element
        vlist_goto( plist, temp_loop )
        temp_stat = vlist_cget_status( plist )
        IF temp_stat = &jl_hide
          LOOP
        ENDIF

        temp_str = vlist_cstr( plist )

        temp_count = AT( "@", temp_str )
        temp_str = LTRIM( SUBSTR( temp_str, temp_count+1, 254 ) )

        temp_row = VAL( TRIM( LEFT( temp_str, AT( ",", temp_str ) - 1 ) ) )
        temp_str = LTRIM( SUBSTR( temp_str, AT( ",", temp_str ) + 1, 254 ) )
        temp_col = VAL( TRIM( LEFT( temp_str, AT( " ", temp_str ) - 1 ) ) )

        temp_str = SUBSTR( temp_str, AT( "|", temp_str ) + 1, 254 )

        IF mouse_scan .AND. is_mouse
          IF ( mrow = temp_row ) .AND.;
               ( ( mcol >= temp_col ) .AND.;
               ( mcol < ( temp_col + LEN( temp_str ) ) ) ) .AND.;
               ( temp_stat <> &jl_skip )

            current_element = vlist_number( plist )
            current_row     = temp_row
            current_col     = temp_col

            mouse_scan = .F.
          ENDIF
 
        ELSE
          IF current_element = vlist_number( plist )
            current_row = temp_row
            current_col = temp_col
          ENDIF

          IF .NOT. move_marker

            vlist_what_color( plist, old_std )

            IF allow_embeded
              vlist_say( temp_row, temp_col, 0, temp_str, .F. )
            ELSE
              @temp_row, temp_col SAY temp_str
            ENDIF

          ENDIF
 
        ENDIF

      NEXT

      rescan = .F.
    ENDIF

    IF move_marker
      move_marker = .F.
    ENDIF

    IF mouse_scan = .T.  .AND. is_mouse && scanned, yet no element found
      IF mouse_stat = &jl_mouse_new
        mouse_stat = &jl_mouse_left && or whatever
      ELSE
        mouse_stat = &jl_mouse_xleft
      ENDIF

      mouse_scan = .F.
    ELSE
      __color_std = old_enhcd
      vlist_goto( plist, current_element )
      temp_str = vlist_cstr( plist )
      temp_str = SUBSTR( temp_str, AT( "|", temp_str )+1, 254 )

      IF allow_embeded
        vlist_say( current_row, current_col, 0, temp_str, .T. )
      ELSE
        @current_row, current_col SAY temp_str
      ENDIF

      mouse_stat = &jl_mouse_ignore

      IF is_mouse
        Vmouse_Cursor( .T. )
      ENDIF

      DO WHILE IS_KEY() = 0 .AND. mouse_stat = &jl_mouse_ignore
        IF is_mouse
          IF Vmouse_Left_Button() .AND. Vmouse_Right_Button()
            mrow = Vmouse_Row()
            mcol = Vmouse_Col()
            mouse_stat = &jl_mouse_both
          ELSE
            IF ml
              IF .NOT. Vmouse_Left_Button()   && find release point
                ml = .F.
                mrow = Vmouse_Row()
                mcol = Vmouse_Col()
                IF mrow = current_row .AND.;
                    ( ( mcol >= current_col ) .AND.;
                    ( mcol < ( current_col+LEN( temp_str ) ) ) )
                  mouse_stat = &jl_mouse_xselect
                ELSE
                  mouse_stat = &jl_mouse_xnew
                ENDIF
 
              ENDIF
 
            ENDIF

            IF Vmouse_Left_Button()
              ml = .T.
              mrow = Vmouse_Row()
              mcol = Vmouse_Col()
              IF mrow = current_row .AND.;
                  ( ( mcol >= current_col ) .AND.;
                    ( mcol < ( current_col+LEN( temp_str ) ) ) )
                mouse_stat = &jl_mouse_select
              ELSE
                mouse_stat = &jl_mouse_new
              ENDIF
 
            ENDIF

            IF mr
              IF .NOT. Vmouse_Right_Button()
                mr = .F.
                mrow = Vmouse_Row()
                mcol = Vmouse_Col()
                mouse_stat = &jl_mouse_xright
              ENDIF
 
            ELSE
              IF Vmouse_Right_Button()
                mr = .T.
                mrow = Vmouse_Row()
                mcol = Vmouse_Col()
                mouse_stat = &jl_mouse_right
              ENDIF
 
            ENDIF

          ENDIF

        ENDIF

      ENDDO

      IF mouse_stat = &jl_mouse_ignore
        pick_key = GET_KEY()
      ENDIF

      IF is_mouse
        Vmouse_Cursor( .F. )
      ENDIF

    ENDIF

    check_element = .F.
    go_forward    = .T.

    user_proc = Vlist_Call_Prompt_Handler( handler_proc,;
                                        plist,;
                                        current_element,;
                                        mouse_stat,;
                                        mrow,;
                                        mcol,;
                                        pick_key,;
                                        first_element,;
                                        last_element )
    IF is_mouse
      IF user_proc = &jl_goto_mouse
        IF ( mrow = current_row ) .AND.;
             ( ( mcol >= current_col ) .AND.;
               ( mcol < ( current_col+LEN( temp_str ) ) ) )
          user_proc = &jl_ignore
        ENDIF
 
      ENDIF
 
    ENDIF

    vlist_what_color( plist, old_std )

    IF user_proc = &jl_repaint_element .OR.;
             user_proc = &jl_repaint_ignore

      temp_str = vlist_cstr( plist )
      temp_str = SUBSTR( temp_str, AT( "|", temp_str )+1, 254 )

      IF user_proc = &jl_repaint_ignore
        user_proc = &jl_ignore
      ELSE
        user_proc = &jl_continue
      ENDIF

    ENDIF

    IF user_proc <> &jl_ignore .AND. user_proc <> &jl_select
      IF allow_embeded
        vlist_say( current_row, current_col, 0, temp_str, .F. )
      ELSE
        @current_row, current_col SAY temp_str
      ENDIF
 
    ENDIF

    IF is_mouse
      Vmouse_Cursor( .T. )
      IF user_proc = &jl_goto_mouse
        mouse_scan = .T.
        rescan = .T.
        LOOP
      ENDIF

    ENDIF


    IF user_proc = &jl_paint_key
      rescan = .T.
      user_proc = &jl_continue
    ENDIF

    DO CASE
      CASE user_proc = &jl_continue    && evaluate keystroke
        DO CASE
          CASE pick_key = &k_esc
            prompt_loop = .F.
            LOOP

          CASE pick_key = &k_enter
            IF vlist_cget_status( plist ) <> &jl_hit
              prompt_loop = .F.
              LOOP
            ENDIF

          CASE pick_key = &k_home .OR. pick_key = &k_pg_up .OR.;
                 pick_key = &k_c_pg_up
            current_element = first_element
            check_element = .T.
            go_forward    = .T.

          CASE pick_key = &k_end .OR. pick_key = &k_pg_down .OR.;
                 pick_key = &k_c_pg_down
            current_element = last_element
            check_element = .T.
            go_forward    = .F.

          CASE pick_key = &k_down  .OR. pick_key = &k_right
            IF current_element = last_element
              current_element = first_element
            ELSE
              current_element = current_element + 1
            ENDIF
 
            check_element = .T.
            go_forward    = .T.

          CASE pick_key = &k_up .OR. pick_key = &k_left
            IF current_element = first_element
              current_element = last_element
            ELSE
              current_element = current_element - 1
            ENDIF
 
            check_element = .T.
            go_forward    = .F.

        ENDCASE

        IF check_element
          check_element = .F.
          move_marker = .T.
          rescan = .T.

          vlist_goto( plist, current_element )

          temp_stat = vlist_cget_status( plist )
          IF temp_stat = &jl_skip .OR. temp_stat = &jl_hide
            IF go_forward
              temp_loop = current_element

              REPEAT
                vlist_skip( plist, &jl_forward )
                IF ( vlist_number( plist ) > last_element ) .OR.;
                     ( vlist_bol( plist ) )
                  vlist_goto( plist, first_element )
                ENDIF
 
                temp_stat = vlist_cget_status( plist )
                IF temp_stat = &jl_skip .OR. temp_stat = &jl_hide
                  LOOP
                ELSE
                  EXIT
                ENDIF
 
              UNTIL temp_loop = vlist_number( plist )

              current_element = vlist_number( plist )

            ELSE
              temp_loop = current_element

              REPEAT
                vlist_skip( plist, &jl_backward )
                IF ( vlist_number( plist ) < first_element ) .OR.;
                     ( vlist_tol( plist ) )
                  vlist_goto( plist, last_element )
                ENDIF
 
                temp_stat = vlist_cget_status( plist )
                IF temp_stat = &jl_skip .OR. temp_stat = &jl_hide
                  LOOP
                ELSE
                  EXIT
                ENDIF
 
              UNTIL temp_loop = vlist_number( plist )

              current_element = vlist_number( plist )


            ENDIF
 
          ENDIF

        ENDIF

      CASE user_proc = &jl_ignore
      CASE user_proc = &jl_repaint
        rescan = .T.
      CASE user_proc = &jl_select
        temp_stat = vlist_cget_status( plist )
        IF temp_stat <> &jl_hit .AND.;
                 temp_stat <> &jl_skip .AND.;
                 temp_stat <> &jl_hide
          prompt_loop = .F.
          LOOP
        ENDIF

      CASE user_proc = &jl_abort
        prompt_loop = .F.
        LOOP
    ENDCASE

  ENDDO

  IF is_mouse
    Vmouse_Cursor( .F. )
  ENDIF

  __color_std   = old_std
  __color_enhcd = old_enhcd

  temp_str = vlist_cstr( plist )
  temp_str = SUBSTR( temp_str, AT( ".", temp_str )+1, 254 )
  temp_str = LEFT( temp_str, AT( "@", temp_str ) - 1 )
  ret_val  = VAL( TRIM( temp_str ) )

  RETURN ret_val
ENDPRO
