#DEFINE search_embedded
*- if the above line is not there, then when a character key is pressed
*  'A'..'Z', the first element with any capital letter matching is found.
*  If it does exist, the first with an embedded will be found.
*

#INCLUDE WARN.HDR
#INCLUDE IO.HDR
#INCLUDE SYSTEM.HDR
#INCLUDE KEYS.HDR
#INCLUDE vlist.hdr
#INCLUDE vmouse.hdr
#INCLUDE STRING.HDR

FUNCTION INT vlist_default_prompt_handler
  PARAMETERS VALUE LONG list_handle,;
             VALUE UINT list_element,;
                   UINT mouse_stat,;
             VALUE UINT mrow,;
             VALUE UINT mcol,;
                    INT pick_key,;
             VALUE UINT top_element,;
             VALUE UINT last_element

  VARDEF
    INT     list_return
    INT     set_key

    UINT    temp_int, temp_int2, loop_int, temp_stat
    CHAR    temp
  ENDDEF

  set_key = 0
  list_return = &jl_continue

  DO CASE
    CASE mouse_stat = &jl_mouse_ignore
    CASE mouse_stat = &jl_mouse_right    && right button pressed
      list_return = &jl_ignore
    CASE mouse_stat = &jl_mouse_xright   && right button released
    *- use set_key so that the LASTKEY() value is accurate
      set_key = &k_esc

    CASE mouse_stat = &jl_mouse_xnew   && left released + mouse on new
      list_return = &jl_ignore
    CASE mouse_stat = &jl_mouse_new    && left + mouse on new element
      list_return = &jl_goto_mouse

    CASE mouse_stat = &jl_mouse_select  && left + mouse on current element
      list_return = &jl_ignore
    CASE mouse_stat = &jl_mouse_xselect && left released + mouse on current
      set_key = &k_enter

    CASE mouse_stat = &jl_mouse_left    && left + mouse outside of pick area
      list_return = &jl_ignore
    CASE mouse_stat = &jl_mouse_xleft   && left released + "         "
      list_return = &jl_ignore
    CASE mouse_stat = &jl_mouse_both    && left & right button hit
      list_return = &jl_ignore
  ENDCASE


  IF set_key <> 0
    DO WHILE INKEY() <> 0
    ENDDO

    KEY_INT( set_key )
    pick_key = INKEY()
  ENDIF


  DO CASE
    CASE pick_key = &k_enter
      list_return = &jl_select
    CASE pick_key = &k_esc
      list_return = &jl_abort
    CASE pick_key = 0

    CASE ( pick_key >= 65 .AND. pick_key <=90 ) .OR.;
           ( pick_key >= 97 .AND. pick_key <= 122 )

      temp_int  = 0
      temp_int2 = 0

      FOR temp_int = top_element TO last_element

        VList_Goto( list_handle, temp_int )
        temp_stat = Vlist_Cget_Status( list_handle )

        IF temp_stat <> &jl_normal
          LOOP
        ENDIF

        temp = Vlist_Cstr( list_handle )
        temp = TRIM( SUBSTR( temp, AT( "|", temp )+1, 128 ) )

        #ifdef search_embedded
        IF AT( __embed_char, temp ) > 0
          IF UPPER( SUBSTR( temp, AT( __embed_char, temp ) + 1, 1 ) ) =;
               UPPER( CHR( pick_key ) )
            temp_int2 = VList_Number( list_handle )
            EXIT
          ENDIF

        ENDIF
 
        #ELSE
        IF UPPER( CHR( pick_key ) ) $ temp
          temp_int2 = Vlist_Number( list_handle )
          EXIT
        ENDIF
 
        #ENDIF

      NEXT

      list_return = &jl_ignore
      pick_key = 0

      IF temp_int2 <> 0
        Vlist_Goto( list_handle, list_element )
        temp_int = 0

        IF temp_int2 < list_element
          FOR loop_int = temp_int2 TO list_element
            Vlist_Goto( list_handle, loop_int )
            temp_stat = Vlist_Cget_Status( list_handle )
            IF temp_stat <> &jl_hide .AND.;
                 temp_stat <> &jl_skip
              temp_int = temp_int + 1
            ENDIF

          NEXT

          FOR loop_int = 1 TO temp_int - 1
            KEY_INT( &k_up )
          NEXT

        ELSE
          IF temp_int2 > list_element
            FOR loop_int = list_element TO temp_int2
              Vlist_Goto( list_handle, loop_int )
              temp_stat = Vlist_Cget_Status( list_handle )
              IF temp_stat <> &jl_hide .AND.;
                   temp_stat <> &jl_skip
                temp_int = temp_int + 1
              ENDIF

            NEXT

            FOR loop_int = 1 TO temp_int - 1
              KEY_INT( &k_down )
            NEXT

          ENDIF

        ENDIF

        KEY_INT( &k_enter )

      ENDIF

  ENDCASE

  RETURN list_return
ENDPRO