
#include warn.hdr
#include string.hdr
#include system.hdr
#include io.hdr

*******************************************************************************
*                               VList_FixPath()                               *
*******************************************************************************

FUNCTION CHAR VList_Fixpath
  PARAMETERS VALUE CHAR filespec

  VARDEF
    CHAR   final_spec based filespec
    CHAR   other_spec
  ENDDEF

  final_spec = TRIM( final_spec )

  IF LEN( final_spec ) = 0
    final_spec = CHR( CURDRIVE() + 'A' ) + ":" + CURDIR( 0 )
  ELSE
    IF LEFT( final_spec, 2 ) = ".\"
      final_spec = VList_Fixpath( "" ) + SUBSTR( final_spec, 3, LEN( final_spec )-2 )
    ELSE
      IF LEFT( final_spec, 3 )="..\"
        other_spec = TRIM( VList_Fixpath( "" ) )
        DO WHILE LEFT( final_spec, 3 ) = "..\"
          final_spec = TRIM( SUBSTR( final_spec, 4, LEN( final_spec )-3 ) )
          IF LEN( other_spec )>2
            IF RIGHT( other_spec, 1 ) = "\"
              other_spec = LEFT( other_spec, LEN( other_spec )-1 )
            ENDIF

            IF RAT( "\", other_spec )>0
              other_spec = LEFT( other_spec, RAT( "\", other_spec )-1 )
            ENDIF

          ENDIF

        ENDDO

        IF RIGHT( other_spec, 1 ) <> "\"
          other_spec = other_spec + "\"
          final_spec = other_spec + final_spec
        ENDIF

      ENDIF

    ENDIF

  ENDIF

  IF .NOT. ( SUBSTR( final_spec, 2, 1 ) = ":" )
    IF SUBSTR( final_spec, 1, 1 ) = "\"
      final_spec = CHR( CURDRIVE() + 'A' ) + ":" + final_spec
    ELSE
      final_spec = CHR( CURDRIVE() + 'A' ) + ":\" + final_spec
    ENDIF

  ELSE
    IF LEN( final_spec ) = 2
      final_spec = final_spec + "\"
    ENDIF

  ENDIF

  IF .NOT. ( SUBSTR( final_spec, LEN( final_spec ), 1 ) = "\" )
    final_spec = final_spec + "\"
  ENDIF

  final_spec = TRIM( final_spec )

  RETURN final_spec
ENDPRO
