#include string.hdr
#include io.hdr
#include warn.hdr

*******************************************************************************
*                              VList_ShortPath()                              *
*******************************************************************************

FUNCTION CHAR VList_ShortPath
  PARAMETERS VALUE UINT        leng,;
             CONST CHAR( 128 ) old_path

  VARDEF
    CHAR( 128 ) new_path
    CHAR( 128 ) temp
    CHAR( 128 ) prefix
    UINT        marker
  ENDDEF

  new_path = TRIM( old_path )

  IF RIGHT( new_path, 1 ) = "\"
    new_path = LEFT( new_path, LEN( new_path ) - 1 )
  ENDIF

  DO WHILE LEN( new_path ) > leng
    prefix = LEFT( new_path, 3 )
    temp = SUBSTR( new_path, 4, 128 )
    IF LEFT( temp, 3 ) = "..."
      prefix = prefix + "...\"
      temp = SUBSTR( temp, 5, 128 )
    ELSE
      prefix = prefix + "...\"
    ENDIF

    marker = AT( "\", temp )
    IF marker > 0
      new_path =  prefix + SUBSTR( temp, marker+1, 128 )
    ELSE
      RETURN new_path
    ENDIF

  ENDDO

  RETURN new_path
ENDPRO
