
#INCLUDE WARN.HDR
#INCLUDE vlist.hdr
#INCLUDE vmouse.hdr
#INCLUDE STRING.HDR
#INCLUDE SYSTEM.HDR
#INCLUDE IO.HDR
#INCLUDE FILEIO.HDR
#INCLUDE COLORS.HDR

VARDEF EXTERN
  BYTE __color_std, __color_enhcd
ENDDEF

*******************************************************************************
*                               VList_1_Fpick()                               *
*******************************************************************************

FUNCTION CHAR VList_1_Fpick
  PARAMETERS VALUE UINT ur,;
             VALUE UINT uc,;
             VALUE UINT lr,;
             VALUE UINT lc,;
             CONST CHAR border_chars,;
             VALUE BYTE border_color,;
             VALUE BYTE dir_color,;
             CONST CHAR start_path,;
             CONST CHAR start_mask,;
             VALUE LOGICAL leave_dir,;
             VALUE LOGICAL shadow,;
             VALUE LOGICAL is_mouse,;
             VALUE LOGICAL display_dirname

  VARDEF
    CHAR( 128 )    dir_path
    CHAR( 80 )     show_path
    CHAR( 40 )     dir_mask
    UINT           columns, marker, topp
    LOGICAL        keep_going, is_dir
    LONG           dir_list
    CHAR           ret
    CHAR( 15 )     temp_name
  ENDDEF

  columns = ( lc - uc + 1 + 2 ) / 16
  IF columns = 0
    columns = 1
  ENDIF
 
  dir_mask = TRIM( start_mask )

  IF shadow
    SAVE_AREA( ur-1, uc-1, lr+2, lc+2 )
  ELSE
    SAVE_AREA( ur-1, uc-1, lr+1, lc+1 )
  ENDIF

  keep_going = .T.
  ret = "*"

  dir_path = start_path

  DO WHILE keep_going
    dir_path  = VList_FixPath( dir_path )
    show_path = Vlist_ShortPath( ( lc - uc - 2 ), dir_path )

    IF shadow
      FILL( ur-1, uc-1, lr+2, lc+2, border_chars, " ", border_color, __color_std, 6 )
    ELSE
      FILL( ur-1, uc-1, lr+1, lc+1, border_chars, " ", border_color, __color_std, 0 )
    ENDIF

    SAVE_AREA( ur-1, uc-1, ur-1, lc+1 )
    @ ur-1, uc+1 SAY " reading... "

    dir_list = VLIST_INIT( 16 )
    IF dir_list = 0
      RESTORE_AREA()
      RESTORE_AREA()
      RETURN "-"
    ENDIF

    IF .NOT. FIND_FIRST( dir_path + start_mask, 0x30 )
      keep_going = .F.
      RESTORE_AREA()
      Vlist_Clear( dir_list )
      LOOP
    ENDIF

    REPEAT
      temp_name = FIND_FSTR()
      IF temp_name = ".\"
        LOOP
      ENDIF

      IF AT( "\", temp_name ) > 0
        temp_name = LEFT( temp_name, RAT( "\", temp_name ) - 1 )
        is_dir = .T.
      ELSE
        is_dir = .F.
      ENDIF

      marker = AT( ".", temp_name )
      IF marker = 0 .OR. temp_name = ".."
        temp_name = temp_name + SPACE( 12 - LEN( temp_name ) )
      ELSE
        temp_name = LEFT( temp_name, marker - 1 ) +;
                    SPACE( 9 - marker + 1 ) +;
                    SUBSTR( temp_name, marker + 1, 3 )
        temp_name = temp_name + SPACE( 12 - LEN( temp_name ) )
      ENDIF

      IF is_dir
        temp_name = " " + temp_name + " "
        IF leave_dir
          IF .NOT. VList_Append( dir_list, &jl_normal, dir_color, temp_name )
            RESTORE_AREA()
            RESTORE_AREA()
            Vlist_Clear( dir_list )
            RETURN "-"
          ENDIF
 
        ELSE
          IF .NOT. VList_Append( dir_list, &jl_skip, dir_color, temp_name )
            RESTORE_AREA()
            RESTORE_AREA()
            Vlist_Clear( dir_list )
            RETURN "-"
          ENDIF

        ENDIF
 
      ELSE
        temp_name = " " + temp_name + "  "
        IF .NOT. VList_Add( dir_list, temp_name )
          RESTORE_AREA()
          RESTORE_AREA()
          Vlist_Clear( dir_list )
          RETURN "-"
        ENDIF
 
      ENDIF

    UNTIL .NOT. FIND_NEXT()

    @ ur-1, uc+1 SAY " sorting... "
    Vlist_Sort( dir_list, 1, Vlist_Max( dir_list ) )

    RESTORE_AREA()
    IF display_dirname
      @ ur-1, uc+1 SAY " " + show_path + " "
    ENDIF

    marker = 1
    topp   = 1

    CURSOR_OFF()
    marker = Vlist_Pick( dir_list, ur, uc, lr, lc, topp, marker,;
                         0, 0, 1, 14, columns, 2,;
                         Vlist_Default_Key_Handler,;
                         .F., is_mouse, .F., is_mouse, .F. )
    CURSOR_ON()

    IF LASTKEY() = 27
      ret = "*"
      keep_going = .F.
      Vlist_Clear( dir_list )
      LOOP
    ENDIF

    temp_name = Vlist_Cstr( dir_list )

    IF AT( "", temp_name ) = 0
      ret = temp_name
      keep_going = .F.
      Vlist_Clear( dir_list )
      LOOP
    ELSE
      Vlist_Clear( dir_list )
      IF TRIM( LEFT( temp_name, 13 ) ) = ".."
        dir_path = LEFT( dir_path, LEN( dir_path ) - 1 )
        dir_path = LEFT( dir_path, RAT( "\", dir_path ) )
      ELSE
        dir_path = dir_path + TRIM( LEFT( temp_name, 9 ) ) + "." +;
                              TRIM( SUBSTR( temp_name, 11, 3 ) )
        IF RIGHT( dir_path,  1 ) = "."
          dir_path = LEFT( dir_path, LEN( dir_path ) - 1 )
        ENDIF
 
      ENDIF
 
    ENDIF
 
  ENDDO

  RESTORE_AREA()

  IF ret <> "*"
    ret = dir_path + TRIM( LEFT( ret, 9 ) ) + "." +;
                     TRIM( SUBSTR( ret, 11, 3 ) )
  ENDIF

  RETURN TRIM( ret )
ENDPRO
