
#INCLUDE WARN.HDR
#INCLUDE vlist.hdr
#INCLUDE vmouse.hdr
#INCLUDE STRING.HDR
#INCLUDE SYSTEM.HDR
#INCLUDE IO.HDR
#INCLUDE FILEIO.HDR
#INCLUDE COLORS.HDR

VARDEF EXTERN
  BYTE __color_std, __color_enhcd
ENDDEF

FUNCTION INT fpick_Key_Handler
  PARAMETERS VALUE LONG list_handle,;    && current list handle
             VALUE UINT list_element,;   && current element #
                   UINT mouse_stat,;     && the &JL_MOUSE_???? defines
             VALUE UINT mrow,;           && current mouse row
             VALUE UINT mcol,;           && current mouse column
                    INT pick_key,;       && key hit if any
             VALUE UINT top_element,;    && top element displayed in PICK
             VALUE UINT last_element,;   && last element displayed in PICK
             VALUE UINT ur,;             && upper left row of PICK area
             VALUE UINT uc,;             && upper left column
             VALUE UINT lr,;             && lower right row
             VALUE UINT lc               && lower right column
  vardef
    int ret
  enddef

  do case
    case pick_key = 13
      ret = &jl_abort
    case pick_key = 21
      ret = &jl_abort
    case pick_key = 32
      ret = &jl_select
    otherwise
      ret = vlist_default_key_handler( list_handle, list_element, mouse_stat,;
                             mrow, mcol, pick_key, top_element, last_element,;
                             ur, uc, lr, lc )
      IF lastkey() = 13
        key_int( 32 )
        do while inkey() <> 0
        enddo
      ENDIF
  endcase

  RETURN ret
ENDPRO

*******************************************************************************
*                               VList_Fpick()                                 *
*<
*< -1 on return means memory error
*<  0 on return means esc pressed
*<  # on return means this is a list handle!  use vlist_max to determine
*<       the number selected.
*<
*******************************************************************************

FUNCTION LONG VList_Fpick
  PARAMETERS VALUE UINT ur,;
             VALUE UINT uc,;
             VALUE UINT lr,;
             VALUE UINT lc,;
             CONST CHAR border_chars,;
             VALUE BYTE border_color,;
             VALUE BYTE dir_color,;
             VALUE BYTE mark_color,;
             CONST CHAR start_path,;
             CONST CHAR start_mask,;
             VALUE LOGICAL leave_dir,;
             VALUE LOGICAL shadow,;
             VALUE LOGICAL is_mouse,;
             VALUE LOGICAL display_dirname,;
             VALUE LOGICAL maintain_list,;
             VALUE UINT    max_select

  VARDEF
    CHAR( 128 )    dir_path
    CHAR( 80 )     show_path
    CHAR( 40 )     dir_mask
    UINT           columns, marker, topp, old_mark
    LOGICAL        keep_going, is_dir, rescan, reset_var
    LONG           dir_list
    CHAR( 15 )     temp_name
    LONG           picked_list
    CHAR( 128 )    fullname
    UINT           temp_color, temp_loop
  ENDDEF

  reset_var = .T.

  picked_list = vlist_init( 52 )   && marked filename + path
  IF picked_list = 0
    RETURN -1
  ENDIF

  columns = ( lc - uc + 1 + 2 ) / 16
  IF columns = 0
    columns = 1
  ENDIF
 
  dir_mask = TRIM( start_mask )
  rescan   = .T.

  IF shadow
    SAVE_AREA( ur-1, uc-1, lr+2, lc+2 )
  ELSE
    SAVE_AREA( ur-1, uc-1, lr+1, lc+1 )
  ENDIF

  keep_going = .T.

  dir_path = start_path

  DO WHILE keep_going
    old_mark = marker
    If rescan
      dir_path  = VList_FixPath( dir_path )
      show_path = Vlist_ShortPath( ( lc - uc - 2 ), dir_path )

      IF shadow
        FILL( ur-1, uc-1, lr+2, lc+2, border_chars, " ", border_color, __color_std, 6 )
      ELSE
        FILL( ur-1, uc-1, lr+1, lc+1, border_chars, " ", border_color, __color_std, 0 )
      ENDIF

      SAVE_AREA( ur-1, uc-1, ur-1, lc+1 )
      @ ur-1, uc+1 SAY " reading... "

      dir_list = VLIST_INIT( 16 )
      IF dir_list = 0
        RESTORE_AREA()
        RESTORE_AREA()
        vlist_clear( picked_list )
        RETURN -1
      ENDIF

      IF .NOT. FIND_FIRST( dir_path + start_mask, 0x30 )
        keep_going = .F.
        RESTORE_AREA()
        Vlist_Clear( dir_list )
        LOOP
      ENDIF

      REPEAT
        temp_name = FIND_FSTR()
        IF temp_name = ".\"
          LOOP
        ENDIF

        IF AT( "\", temp_name ) > 0
          temp_name = LEFT( temp_name, RAT( "\", temp_name ) - 1 )
          is_dir = .T.
        ELSE
          is_dir = .F.
        ENDIF

        marker = AT( ".", temp_name )
        IF marker = 0 .OR. temp_name = ".."
          temp_name = temp_name + SPACE( 12 - LEN( temp_name ) )
        ELSE
          temp_name = LEFT( temp_name, marker - 1 ) +;
                      SPACE( 9 - marker + 1 ) +;
                      SUBSTR( temp_name, marker + 1, 3 )
          temp_name = temp_name + SPACE( 12 - LEN( temp_name ) )
        ENDIF

        IF is_dir
          temp_name = " " + temp_name + " "
          IF leave_dir
            IF .NOT. VList_Append( dir_list, &jl_normal, dir_color, temp_name )
              RESTORE_AREA()
              RESTORE_AREA()
              Vlist_Clear( dir_list )
              Vlist_Clear( picked_list )
              RETURN -1
            ENDIF
   
          ELSE
            IF .NOT. VList_Append( dir_list, &jl_skip, dir_color, temp_name )
              RESTORE_AREA()
              RESTORE_AREA()
              Vlist_Clear( dir_list )
              vlist_clear( picked_list )
              RETURN -1
            ENDIF

          ENDIF
   
        ELSE
          fullname = dir_path + temp_name
          *- is this file marked?
          IF vlist_locate_substr( picked_list, fullname, 1, LEN( fullname ),;
                                 .T., .F. )
            temp_name  = "" + temp_name + "  "
            temp_color = mark_color
          ELSE
            temp_name  = " " + temp_name + "  "
            temp_color = &jl_default
          ENDIF

          IF .NOT. VList_Append( dir_list, &jl_normal, temp_color, temp_name )
            RESTORE_AREA()
            RESTORE_AREA()
            Vlist_Clear( dir_list )
            vlist_clear( picked_list )
            RETURN -1
          ENDIF
   
        ENDIF

      UNTIL .NOT. FIND_NEXT()

      @ ur-1, uc+1 SAY " sorting... "
      Vlist_Sort_substr( dir_list, 1, Vlist_Max( dir_list ), 2, 14 )

      RESTORE_AREA()
      IF display_dirname
        @ ur-1, uc+1 SAY " " + show_path + " "
      ENDIF

      IF reset_var
        marker = 1
        topp   = 1
      ELSE
        marker = old_Mark
        reset_var = .T.
      ENDIF
    ENDIF && rescan

    CURSOR_OFF()
    marker = Vlist_Pick( dir_list, ur, uc, lr, lc, topp, marker,;
                         0, 0, 1, 14, columns, 2,;
                         fpick_Key_Handler,;
                         .F., is_mouse, .F., is_mouse, .F. )
    CURSOR_ON()

    DO CASE
      CASE LASTKEY() = 27
        keep_going = .F.
        Vlist_Clear( dir_list )
        vlist_clear( picked_list )
        picked_list = 0
        LOOP
      CASE LASTKEY() = 13 && exit key!
        keep_going = .F.
        vlist_clear( dir_list )
        LOOP
      CASE LASTKEY() = 21 && clear all marks CTRL-U
        vlist_clear( picked_list )
        picked_list = vlist_init( 52 )
        IF picked_list = 0
          keep_going = .F.
          picked_list = -1
          LOOP
        ENDIF
        rescan = .T.
        reset_var = .F.
        LOOP
    ENDCASE

    temp_name = Vlist_Cstr( dir_list )

    IF AT( "", temp_name ) = 0
      *- this is someone to mark or unmark!
      rescan = .F.
      fullname  = temp_name
      temp_name = substr( fullname, 2, 12 )
      IF LEFT( fullname, 1 ) = ""
        * unmark
        fullname = dir_path + temp_name
        IF .NOT. vlist_locate_substr( picked_list, fullname,;
                                      1, LEN( fullname ),;
                                     .T., .F. )
          * we aren't in here anyway, something is wrong!
        ELSE
          vlist_cdelete( picked_list )
        ENDIF
        temp_name = " " + temp_name + "  "
        vlist_creplace( dir_list, &jl_normal, &jl_default, temp_name )
      ELSE
        * mark
        fullname = dir_path + temp_Name
        IF .NOT. vlist_locate_substr( picked_list, fullname,;
                                      1, LEN( fullname ),;
                                     .T., .F. )
          * mark em dano
          vlist_add( picked_list, fullname )
        ELSE
          * already marked!
        ENDIF
        temp_name = "" + temp_name + "  "
        vlist_creplace( dir_list, &jl_normal, mark_color, temp_name )
      ENDIF
      IF max_select > 0
        IF vlist_max( picked_list ) >= max_select
          vlist_clear( dir_list )
          keep_going = .F.
        ENDIF
      ENDIF
      LOOP
    ELSE
      rescan = .T.
      Vlist_Clear( dir_list )
      IF .not. maintain_list
        vlist_clear( picked_list )
        picked_list = vlist_init( 52 )
        IF picked_list = 0
          keep_going = .F.
          picked_list = -1
          LOOP
        ENDIF
      ENDIF

      IF TRIM( LEFT( temp_name, 13 ) ) = ".."
        dir_path = LEFT( dir_path, LEN( dir_path ) - 1 )
        dir_path = LEFT( dir_path, RAT( "\", dir_path ) )
      ELSE
        dir_path = dir_path + TRIM( LEFT( temp_name, 9 ) ) + "." +;
                              TRIM( SUBSTR( temp_name, 11, 3 ) )
        IF RIGHT( dir_path,  1 ) = "."
          dir_path = LEFT( dir_path, LEN( dir_path ) - 1 )
        ENDIF
 
      ENDIF
 
    ENDIF
 
  ENDDO

  RESTORE_AREA()

  IF picked_list > 0
    IF vlist_max( picked_list ) > 0
      vlist_top( picked_list )
      do while .not. vlist_bol( picked_list )
        fullname  = vlist_cstr( picked_list )
        temp_name = substr( fullname, RAT("\",fullname)+1, 128 )
        fullname  = left( fullname, RAT("\",fullname) )
        temp_name = TRIM( LEFT( temp_name, 8 ) ) + "." +;
                    TRIM( SUBSTR( temp_name, 10, 3 ) )
        fullname  = fullname + temp_name
        vlist_cedit( picked_list, fullname )
        vlist_skip( picked_list, &jl_forward )
      enddo
    ENDIF
  ENDIF

  RETURN picked_list
ENDPRO
