*******************************************************************************
*                                                                             *
*                              VisionWare Vol. 1                              *
*                                                                             *
*                        dynamic string list functions                        *
*                                                                             *
*******************************************************************************


*******************************************************************************
* GLOBAL VARIABLES                                                            *
*                                                                             *
* __color_skip      : default &JL_SKIP element color                          *
* __color_hit       : default &JL_HIT element color                           *
* __color_bar       : default color of the scroll-bar                         *
* __color_tab       : default color of the scroll-bar tabs                    *
* __color_hi_std    : default color for embedded character highlight
* __color_hi_enhcd  : default color for embedded character selected highlight
* __scroll_offset   : column offset from the right of the pick area for       *
*                     the scroll-bar (-? to +?)                               *
*
* __embed_????????????????
*******************************************************************************

VARDEF EXTERN
  BYTE __color_skip
  BYTE __color_hit
  BYTE __color_bar
  BYTE __color_tab
  INT __scroll_offset
  BYTE __color_hi_std
  BYTE __color_hi_enhcd
  CHAR( 1 ) __embed_char     && CHR( 225 )
ENDDEF

*******************************************************************************
*GLOBAL DEFINES                                                               *
*                                                                             *
* return values from keyboard handlers:                                       *
*    &jl_continue        : evaluate keystroke                                 *
*    &jl_ignore          : ignore keystroke                                   *
*    &jl_repaint         : ignore keystroke and repaint the PICK area         *
*    &jl_select          : select current element                             *
*    &jl_abort           : abort the list                                     *
*    &jl_paint_key       : evaluate keystroke AND repaint the PICK area       *
*    &jl_bad_element     : this element is no longer valid for the PICK,      *
*                            move to the next valid element.                  *
*    &jl_repaint_element : redraw the current element from the list buffer,   *
*                            evaluate keystroke also.                         *
*    &jl_repaint_ignore  : redraw the current element from the list buffer,   *
*                            do NOT evaluate keystroke.                       *
*    &jl_goto_mouse      : goto the element that the mouse cursor is on       *
*                                                                             *
* values for the mouse_status sent the the keyboard handler:                  *
*    &jl_mouse_ignore       : the mouse is doing nothing                      *
*    &jl_mouse_right        : the right mouse button was pressed              *
*    &jl_mouse_up           : the left mouse button was pressed on the        *
*                               up-tab for the scroll-bar.                    *
*    &jl_mouse_down         : the left mouse button was pressed on the        *
*                               down-tab for the scroll-bar.                  *
*    &jl_mouse_scroll       : the left mouse button was pressed somewhere     *
*                               on the scroll-bar.                            *
*    &jl_mouse_new          : the left mouse button was pressed on an         *
*                               element that is not currently selected.       *
*    &jl_mouse_select       : the left mouse button was pressed on the        *
*                               currently highlighted element.                *
*    &jl_mouse_left         : the left button was pressed somewhere           *
*                               outside of the pick area.                     *
*    &jl_mouse_both         : the left and right buttons are pressed.         *
*    &jl_mouse_xright       : the right button was released.                  *
*    &jl_mouse_xup          : the left button was released on the up-tab for  *
*                               the scroll-bar.                               *
*    &jl_mouse_xdown        : the left button was released on the down-tab    *
*                               for the scroll-bar.                           *
*    &jl_mouse_xscroll      : the left button was released somewhere on       *
*                               the scroll-bar.                               *
*    &jl_mouse_xnew         : the left button was released on an element      *
*                               that is not currently selected.               *
*    &jl_mouse_xselect      : the left button was released on the currently   *
*                               highlighted element.                          *
*    &jl_mouse_xleft        : the left button was released somewhere outside  *
*                               of the pick area.                             *
*                                                                             *
* element status defines:                                                     *
*    &jl_normal             : normal element using __COLOR_STD                *
*    &jl_skip               : shown element using __COLOR_SKIP, cannot be     *
*                               highlighted or selected.                      *
*    &jl_hit                : shown element using __COLOR_HIT, CAN be         *
*                               highlighted, but NOT selected.                *
*    &jl_hide               : element not shown or able to be selected.       *
*                                                                             *
* element colors:                                                             *
*    &jl_default            : use current default color according to element  *
*                               status.  Any other value represents the       *
*                               actual color to use.                          *
*                                                                             *
* current pointer movement:                                                   *
*    &jl_forward            : move pointer to next element                    *
*    &jl_backward           : move pointer to previous element                *
*******************************************************************************

#DEFINE jl_continue         0
#DEFINE jl_ignore           1
#DEFINE jl_repaint          2
#DEFINE jl_select           3
#DEFINE jl_abort            4
#DEFINE jl_paint_key        5
#DEFINE jl_bad_element      6
#DEFINE jl_repaint_element  7
#DEFINE jl_repaint_ignore   8
#DEFINE jl_goto_mouse       9
#DEFINE jl_rescan_menu     10
#DEFINE jl_mouse_ignore     0
#DEFINE jl_mouse_right      1
#DEFINE jl_mouse_up         2
#DEFINE jl_mouse_down       3
#DEFINE jl_mouse_scroll     4
#DEFINE jl_mouse_new        5
#DEFINE jl_mouse_select     6
#DEFINE jl_mouse_left       7
#DEFINE jl_mouse_both       8
#DEFINE jl_mouse_xright     9
#DEFINE jl_mouse_xup        10
#DEFINE jl_mouse_xdown      11
#DEFINE jl_mouse_xscroll    12
#DEFINE jl_mouse_xnew       13
#DEFINE jl_mouse_xselect    14
#DEFINE jl_mouse_xleft      15
#DEFINE jl_normal           1
#DEFINE jl_skip             2
#DEFINE jl_hit              3
#DEFINE jl_hide             4
#DEFINE jl_default         -1
#DEFINE jl_error           -3
#DEFINE jl_forward          1
#DEFINE jl_backward         0

*******************************************************************************
* VList_Default_Menu_Handler()   - see source file MENUKEY.PRG                *
*                                                                             *
* This routine process all mouse and keyboard activity for a menu operation.  *
* This can be used as the 'keyboard handler' parameter for VLIST_POPUP or     *
* VLIST_PULLDOWN.                                                             *
*******************************************************************************

FUNCTION INT VLIST_Default_Menu_Handler PROTOTYPE
  PARAMETERS VALUE LONG list_handle,;    && current list handle
             VALUE UINT list_element,;   && current element #
                   UINT mouse_stat,;     && the &JL_MOUSE_???? defines
             VALUE UINT mrow,;           && current mouse row
             VALUE UINT mcol,;           && current mouse column
                    INT pick_key,;       && key hit if any
             VALUE UINT top_element,;    && top element displayed in PICK
             VALUE UINT last_element,;   && last element displayed in PICK
             VALUE UINT ur,;             && upper left row of PICK area
             VALUE UINT uc,;             && upper left column
             VALUE UINT lr,;             && lower right row
             VALUE UINT lc               && lower right column


*******************************************************************************
* VList_Default_Key_Handler()   - see source file PICKKEY.PRG                 *
*                                                                             *
* This routine process all mouse and keyboard activity for a PICK operation.  *
* This can be used as the 'keyboard handler' parameter for VLIST_PICK.        *
*******************************************************************************

FUNCTION INT VLIST_Default_Key_Handler PROTOTYPE
  PARAMETERS VALUE LONG list_handle,;    && current list handle
             VALUE UINT list_element,;   && current element #
                   UINT mouse_stat,;     && the &JL_MOUSE_???? defines
             VALUE UINT mrow,;           && current mouse row
             VALUE UINT mcol,;           && current mouse column
                    INT pick_key,;       && key hit if any
             VALUE UINT top_element,;    && top element displayed in PICK
             VALUE UINT last_element,;   && last element displayed in PICK
             VALUE UINT ur,;             && upper left row of PICK area
             VALUE UINT uc,;             && upper left column
             VALUE UINT lr,;             && lower right row
             VALUE UINT lc               && lower right column



*******************************************************************************
* VList_Init()                                                                *
*                                                                             *
* initialize a list of a specified maximum width per element.  If the return  *
* value is 0, no list was initialized due to low memory.  The returned value  *
* is the list handle.                                                         *
*******************************************************************************

FUNCTION LONG Vlist_Init PROTOTYPE
  PARAMETERS VALUE UINT str_len    && max width of each element in this list


*******************************************************************************
* VList_Append()                                                              *
*                                                                             *
* add an element to list with the following parameters:                       *
*     item_status      :  status of how the element is displayed;             *
*                            &jl_normal, &jl_skip, &jl_hit, &jl_hide          *
*     item_color       :  color to display element.  IF &jl_default is        *
*                            used, the defualt colors are used according      *
*                            to the element status.  IF any other actual      *
*                            value is used, this specific color is used       *
*                            for this element.                                *
*                                                                             *
* a return value of .F. indicates lack of memory.                             *
*                                                                             *
* the current element pointer is moved to this new element.                   *
*******************************************************************************

FUNCTION LOGICAL Vlist_Append PROTOTYPE
  PARAMETERS VALUE LONG handle,;       && list handle
             VALUE UINT item_status,;  && see GLOBAL DEFINES 'element status'
             VALUE INT  item_color,;   && see GLOBAL DEFINES 'color defines'
             CONST CHAR add_string     && string to place in list


*******************************************************************************
* VList_Add()                                                                 *
*                                                                             *
* add an element to a list with the status being set to &JL_NORMAL, and the   *
* color being set to &JL_DEFAULT.  This is the same as VList_Append except    *
* less parameters are required.                                               *
*******************************************************************************

FUNCTION LOGICAL Vlist_Add PROTOTYPE
  PARAMETERS VALUE LONG handle,;
             CONST CHAR add_str


*******************************************************************************
* VList_Max()                                                                 *
*                                                                             *
* returns the number of elements in a list.                                   *
*******************************************************************************

FUNCTION UINT Vlist_Max PROTOTYPE
  PARAMETERS VALUE LONG handle

*******************************************************************************
* VList_Tol()                                                                 *
*                                                                             *
* returns .T. if the current element pointer is at 0 which is above           *
* the first element in the list.  Similar to BOF() function for               *
* database handling.                                                          *
*******************************************************************************

FUNCTION LOGICAL Vlist_Tol PROTOTYPE
  PARAMETERS VALUE LONG handle


*******************************************************************************
* VList_Bol()                                                                 *
*                                                                             *
* returns .T. if the current element pointer is at VList_Max()+1 which        *
* is below the last element in the list.  Similar to EOF() function for       *
* database handling.                                                          *
*******************************************************************************

FUNCTION LOGICAL Vlist_Bol PROTOTYPE
  PARAMETERS VALUE LONG handle


*******************************************************************************
* VList_Skip()                                                                *
*                                                                             *
* move current element pointer forward 1 or backward 1.  Use the              *
* defines &JL_FORWARD or &JL_BACKWARD to signify direction in the             *
* 'which_way' parameter.                                                      *
*******************************************************************************

PROCEDURE Vlist_Skip PROTOTYPE
  PARAMETERS VALUE LONG handle,;
             VALUE UINT which_way    && &JL_FORWARD or &JL_BACKWARD


*******************************************************************************
* VList_Number()                                                              *
*                                                                             *
* return the current element pointer's element number.                        *
*******************************************************************************

FUNCTION UINT Vlist_Number PROTOTYPE
  PARAMETERS VALUE LONG handle


*******************************************************************************
* VList_Top()                                                                 *
*                                                                             *
* move the current element pointer to the top of the list (element 1)         *
*******************************************************************************

PROCEDURE Vlist_Top PROTOTYPE
  PARAMETERS VALUE LONG handle


*******************************************************************************
* VList_Bottom()                                                              *
*                                                                             *
* move the current element pointer to the bottom of the list                  *
*******************************************************************************

PROCEDURE Vlist_Bottom PROTOTYPE
  PARAMETERS VALUE LONG handle


*******************************************************************************
* VList_Goto()                                                                *
*                                                                             *
* move the current element pointer to a specific element #                    *
*******************************************************************************

FUNCTION LOGICAL Vlist_Goto PROTOTYPE
  PARAMETERS VALUE LONG handle,;
             VALUE UINT which_element


*******************************************************************************
* VList_Str()                                                                 *
*                                                                             *
* return the element contents of a specified element.                         *
*                                                                             *
* the current element pointer is NOT moved to this element.                   *
*******************************************************************************

FUNCTION CHAR Vlist_Str PROTOTYPE
  PARAMETERS VALUE LONG handle,;
             VALUE UINT which_element  && element to return string from



*******************************************************************************
* VList_CStr()                                                                *
*                                                                             *
* return the element contents of the CURRENT element.  This is the element    *
* that the current element pointer is directed to.                            *
*******************************************************************************

FUNCTION CHAR Vlist_Cstr PROTOTYPE
  PARAMETERS VALUE LONG handle


*******************************************************************************
* VList_Set_Status()                                                          *
*                                                                             *
* set the status of a specific element.  The current element pointer is       *
* NOT changed to point to this element                                        *
*******************************************************************************

FUNCTION LOGICAL Vlist_Set_Status PROTOTYPE
  PARAMETERS VALUE LONG handle,;
             VALUE UINT which_element,;   && element to set status for
             VALUE UINT new_status        && status to change to (ex. &JL_SKIP)


*******************************************************************************
* VList_CSet_Stats()                                                          *
*                                                                             *
* set the status of the CURRENT element.                                      *
*******************************************************************************

FUNCTION LOGICAL Vlist_Cset_Status PROTOTYPE
  PARAMETERS VALUE LONG handle,;
             VALUE UINT new_status


*******************************************************************************
* VList_Get_Status()                                                          *
*                                                                             *
* get the status of a specified element.  The current element pointer is      *
* not affected by this operation.                                             *
*******************************************************************************

FUNCTION UINT Vlist_Get_Status PROTOTYPE
  PARAMETERS VALUE LONG handle,;
             VALUE UINT which_element


*******************************************************************************
* VList_CGet_Status()                                                         *
*                                                                             *
* get the status of the CURRENT element.                                      *
*******************************************************************************

FUNCTION UINT Vlist_Cget_Status PROTOTYPE
  PARAMETERS VALUE LONG handle


*******************************************************************************
* VList_Set_Color()                                                           *
*                                                                             *
* set the color of a specified element.  The current element pointer          *
* is not affected by this operation.                                          *
*******************************************************************************

FUNCTION LOGICAL Vlist_Set_Color PROTOTYPE
  PARAMETERS VALUE LONG handle,;
             VALUE UINT which_element,;
             VALUE INT  new_color


*******************************************************************************
* VList_CSet_Color()                                                          *
*                                                                             *
* set the color of the CURRENT element.                                       *
*******************************************************************************

FUNCTION LOGICAL Vlist_Cset_Color PROTOTYPE
  PARAMETERS VALUE LONG handle,;
             VALUE INT  new_color


*******************************************************************************
* VList_Get_Color()                                                           *
*                                                                             *
* return the color of a specified element.                                    *
*******************************************************************************

FUNCTION INT Vlist_Get_Color PROTOTYPE
  PARAMETERS VALUE LONG handle,;
             VALUE UINT which_element


*******************************************************************************
* VList_CGet_Color()                                                          *
*                                                                             *
* return the color of the current element.                                    *
*******************************************************************************

FUNCTION INT Vlist_Cget_Color PROTOTYPE
  PARAMETERS VALUE LONG handle


*******************************************************************************
* VList_Is_Init()                                                             *
*                                                                             *
* returns .T. if the list is initialized using VLIST_INIT()                   *
*******************************************************************************

FUNCTION LOGICAL Vlist_Is_Init PROTOTYPE
  PARAMETERS VALUE LONG handle


*******************************************************************************
* VList_Get_StrLen()                                                          *
*                                                                             *
* returns the MAX string length for a list                                    *
*******************************************************************************

FUNCTION UINT Vlist_Get_Strlen PROTOTYPE
  PARAMETERS VALUE LONG handle


*******************************************************************************
* Vlist_Edit()                                                                *
*                                                                             *
* Alter the STRING contents of a specified element.                           *
*******************************************************************************

FUNCTION LOGICAL Vlist_Edit PROTOTYPE
  PARAMETERS VALUE LONG handle,;
             VALUE UINT which_element,;
             CONST CHAR edit_str


*******************************************************************************
* VList_CEdit()                                                               *
*                                                                             *
* Alter the STRING contents of the current element.                           *
*******************************************************************************

FUNCTION LOGICAL Vlist_Cedit PROTOTYPE
  PARAMETERS VALUE LONG handle,;
             CONST CHAR edit_str


*******************************************************************************
* VList_Replace()                                                             *
*                                                                             *
* Change the STATUS, COLOR, and STRING contents of a specified element        *
*******************************************************************************

FUNCTION LOGICAL Vlist_Replace PROTOTYPE
  PARAMETERS VALUE LONG handle,;
             VALUE UINT which_element,;
             VALUE UINT item_status,;
             VALUE INT  item_color,;
             CONST CHAR edit_str


*******************************************************************************
* VList_CReplace()                                                            *
*                                                                             *
* Change the STATUS, COLOR, and STRING contents of the current element        *
*******************************************************************************

FUNCTION LOGICAL Vlist_Creplace PROTOTYPE
  PARAMETERS VALUE LONG handle,;
             VALUE UINT item_status,;
             VALUE INT  item_color,;
             CONST CHAR edit_str


*******************************************************************************
* VList_Sort()                                                                *
*                                                                             *
* sort a list (or partial list).  If the 'start_element' and 'end_element'    *
* parameters are both 0, the entire list is assumed.  If the                  *
* 'start_sub_string' and 'end_sub_string' parameters are both 0,              *
* a quicker sort routine is used for the entire string contents.              *
*******************************************************************************

PROCEDURE Vlist_SORT_substr PROTOTYPE
  PARAMETERS VALUE LONG handle,;
             VALUE UINT start_element,;
             VALUE UINT end_element,;
             VALUE UINT start_sub_string,;
             VALUE UINT end_sub_string

PROCEDURE Vlist_SORT PROTOTYPE
  PARAMETERS VALUE LONG handle,;
             VALUE UINT start_element,;
             VALUE UINT end_element


*******************************************************************************
* VList_Insert()                                                              *
*                                                                             *
* insert an element before the specified element.                             *
*                                                                             *
* the current element pointer is moved to this new element.                   *
*******************************************************************************

FUNCTION LOGICAL Vlist_Insert PROTOTYPE
  PARAMETERS VALUE LONG handle,;
             VALUE UINT which_element,;
             VALUE UINT item_status,;
             VALUE INT  item_color,;
             CONST CHAR add_str


*******************************************************************************
* VList_CInsert()                                                             *
*                                                                             *
* insert an element before the current element.                               *
*                                                                             *
* the current element pointer is moved to the new element.                    *
*******************************************************************************

FUNCTION LOGICAL Vlist_Cinsert PROTOTYPE
  PARAMETERS VALUE LONG handle,;
             VALUE UINT item_status,;
             VALUE INT  item_color,;
             CONST CHAR add_str


*******************************************************************************
* VList_Delete()                                                              *
*                                                                             *
* delete a specified element.                                                 *
*******************************************************************************

FUNCTION LOGICAL Vlist_Delete PROTOTYPE
  PARAMETERS VALUE LONG handle,;
             VALUE UINT which_element


*******************************************************************************
* VList_CDelete()                                                             *
*                                                                             *
* delete the current element                                                  *
*******************************************************************************

FUNCTION LOGICAL Vlist_Cdelete PROTOTYPE
  PARAMETERS VALUE LONG handle


*******************************************************************************
* VList_Copy()                                                                *
*                                                                             *
* copy the contents of one element to another specified element               *
*******************************************************************************

FUNCTION LOGICAL Vlist_Copy PROTOTYPE
  PARAMETERS VALUE LONG handle,;
             VALUE UINT source,;
             VALUE UINT dest


*******************************************************************************
* VList_CCopy()                                                               *
*                                                                             *
* copy the contents of the CURRENT element to a specified element             *
*******************************************************************************

FUNCTION LOGICAL Vlist_Ccopy PROTOTYPE
  PARAMETERS VALUE LONG handle,;
             VALUE UINT dest


*******************************************************************************
* VList_Clear()                                                               *
*                                                                             *
* erase the entire contents of a list and free all of the attached memory.    *
* the list is no longer valid.                                                *
*******************************************************************************

PROCEDURE Vlist_Clear PROTOTYPE
  PARAMETERS VALUE LONG handle


*******************************************************************************
* VList_Save()                                                                *
*                                                                             *
* save a list (or partial list) to disk.  If the 'encrypt' parameter is .T.   *
* the list is saved in an encrypted format.                                   *
*                                                                             *
* if 'start_element' and 'end_element' is 0, the entire list is assumed.      *
*******************************************************************************

FUNCTION LOGICAL Vlist_Save PROTOTYPE
  PARAMETERS VALUE LONG handle,;           && handle of list
             CONST CHAR filename,;         && file to save to
             VALUE UINT start_element,;    && first element
             VALUE UINT end_element,;      && last element
             VALUE LOGICAL encrypt

*******************************************************************************
* VList_Save_Append()                                                         *
*                                                                             *
* save a list onto the end of an existing file.                               *
*******************************************************************************

FUNCTION LOGICAL Vlist_Save_Append PROTOTYPE
  PARAMETERS VALUE LONG handle,;
             CONST CHAR filename,;
             VALUE UINT start_element,;
             VALUE UINT end_element


*******************************************************************************
* VList_Restore()                                                             *
*                                                                             *
* creates a list from a LIST-FILE.  This list is initialized internally       *
* and no VLIST_INIT() is needed.                                              *
*                                                                             *
* new_list = VLIST_RESTORE(...)                                               *
*******************************************************************************

FUNCTION LONG Vlist_Restore PROTOTYPE
  PARAMETERS CONST CHAR filename,;
             VALUE UINT start_element,;
             VALUE UINT end_element


*******************************************************************************
* VList_Restore_Append()                                                      *
*                                                                             *
* reads a LIST-FILE and appends its contents to the end of an existing        *
* list.                                                                       *
*******************************************************************************

FUNCTION LOGICAL Vlist_Restore_Append PROTOTYPE
  PARAMETERS VALUE LONG handle,;
             CONST CHAR filename,;
             VALUE UINT start_element,;
             VALUE UINT end_element


*******************************************************************************
* VList_FullView()                                                            *
*                                                                             *
* view a text file with mouse support                                         *
*******************************************************************************

FUNCTION LOGICAL Vlist_Fullview PROTOTYPE
  PARAMETERS CONST CHAR filename,;
             VALUE UINT ur,;        && display area
             VALUE UINT uc,;
             VALUE UINT lr,;
             VALUE UINT lc,;
             VALUE LOGICAL mice     && is mouse present?



*******************************************************************************
* VList_SmallView()                                                           *
*                                                                             *
* view a text file with NO mouse support.                                     *
*******************************************************************************

FUNCTION LOGICAL Vlist_Smallview PROTOTYPE
  PARAMETERS CONST CHAR filename,;
             VALUE UINT ur,;         && display area
             VALUE UINT uc,;
             VALUE UINT lr,;
             VALUE UINT lc


*******************************************************************************
* VList_Seek()                                                                *
*                                                                             *
* seek for an element using a binary search.                                  *
*                                                                             *
* if found, the function returns .T. and the current element pointer is       *
* moved to the element.                                                       *
*******************************************************************************

FUNCTION LOGICAL VList_Seek PROTOTYPE
  PARAMETERS VALUE LONG handle,;
             CONST CHAR look_string,;        && string to find
             VALUE LOGICAL exact_match       && must it be exact?


*******************************************************************************
* VList_Seek_SubStr()                                                         *
*                                                                             *
* same as VList_Seek() except only a SUBSTR of the element contents is        *
* compared.                                                                   *
*******************************************************************************

FUNCTION LOGICAL VList_Seek_SubStr PROTOTYPE
  PARAMETERS VALUE LONG handle,;
             CONST CHAR look_string,;
             VALUE UINT start_sub,;
             VALUE UINT end_sub,;
             VALUE LOGICAL exact_match


*******************************************************************************
* VList_Locate()                                                              *
*                                                                             *
* a sequential search for a string.                                           *
*                                                                             *
* if the 'from_current' parameter is .T., the search starts from the          *
* current element, else the search starts from the list top.                  *
*******************************************************************************

FUNCTION LOGICAL VList_Locate PROTOTYPE
  PARAMETERS VALUE LONG handle,;
       CONST CHAR look_string,;
       VALUE LOGICAL exact_match,;
       VALUE LOGICAL from_current   && start from current pointer or
 
&& go back to top.

*******************************************************************************
* VList_Locate()                                                              *
*                                                                             *
* a sequential search for a substring.                                        *
*******************************************************************************

FUNCTION LOGICAL VList_Locate_SubStr PROTOTYPE
  PARAMETERS VALUE LONG handle,;
       CONST CHAR look_string,;
       VALUE UINT start_sub,;
       VALUE UINT end_sub,;
       VALUE LOGICAL exact_match,;
       VALUE LOGICAL from_current


*******************************************************************************
* VList_Empty()                                                               *
*                                                                             *
* is the list empty of any elements?                                          *
*******************************************************************************

FUNCTION LOGICAL Vlist_Empty  PROTOTYPE
  PARAMETERS VALUE LONG handle


*******************************************************************************
* VList_Free_Screen()                                                         *
*                                                                             *
* clear a variable created using SAVESCRN() without restoring the screen.     *
*******************************************************************************

PROCEDURE Vlist_Free_Screen PROTOTYPE
  PARAMETERS VALUE UINT screen_var


FUNCTION UINT Vlist_Find_First_Good prototype
  PARAMETERS VALUE LONG handle,;
             VALUE UINT lower_limit

FUNCTION UINT Vlist_Find_Last_Good prototype
  PARAMETERS VALUE LONG handle,;
             VALUE UINT last_allowed

FUNCTION UINT Vlist_Get_Last_Good prototype
  PARAMETERS VALUE LONG handle,;
             VALUE UINT element,;
             VALUE UINT first_display

FUNCTION UINT Vlist_Get_Next_Good prototype
  PARAMETERS VALUE LONG handle,;
             VALUE UINT element,;
             VALUE UINT last_display

FUNCTION UINT Vlist_Count_Elements prototype
  PARAMETERS VALUE LONG handle,;
             VALUE UINT start_element,;
             VALUE UINT end_element

FUNCTION LOGICAL Vlist_Skip_Next prototype
  PARAMETERS VALUE LONG handle,;
             VALUE UINT last_display

FUNCTION LOGICAL Vlist_Skip_Last prototype
  PARAMETERS VALUE LONG handle,;
             VALUE UINT first_display

PROCEDURE Vlist_What_Color prototype
  PARAMETERS VALUE LONG handle,;
             VALUE BYTE old_std

PROCEDURE Vlist_Say PROTOTYPE
  PARAMETERS VALUE UINT srow,;
             value uint scol,;
             value uint swidth,;
             const char sstring,;
             value logical selected

procedure vlist_embed_caps prototype
  parameters value long plist,;
             value uint first,;
             value uint last_element
             
