*******************************************************************************
*                                                                             *
*                     Database browse using VLIST_PICK()                      *
*                                                                             *
*                          (c) 1991 Jayson R. Minard                          *
*                                                                             *
* This demo shows a VERY simple database browse using VLIST_PICK.  Please     *
* note that only 5 records are read at a time therefore using only a small    *
* amount of memory...                                                         *
*                                                                             *
*******************************************************************************

#DEFINE browse_height 5

#INCLUDE WARN.HDR
#INCLUDE DATABASE.HDR
#INCLUDE STRING.HDR
#INCLUDE SYSTEM.HDR
#INCLUDE IO.HDR
#INCLUDE COLORS.HDR
#INCLUDE KEYS.HDR
#INCLUDE vlist.hdr
#INCLUDE vmouse.hdr

DBFDEF browse1
  CHAR( 20 )  last_name
  CHAR( 20 )  first_name
  CHAR( 30 )  address1
  CHAR( 30 )  address2
  CHAR( 15 )  city
  CHAR( 2 )   state
  CHAR( 9 )   zip
  CHAR( 12 )  phone1
  CHAR( 12 )  phone2
  INT( 3 )    age
ENDDEF

INDEXDEF
  CHAR( 40 )    i_browse1     UPPER( browse1->last_name + browse1->first_name )
ENDDEF

VARDEF EXTERN
  BYTE __color_std
ENDDEF

VARDEF
  LOGICAL is_mouse
ENDDEF

FUNCTION CHAR Pad
  PARAMETERS CONST CHAR pad_str,;
             VALUE UINT wid

  VARDEF
    CHAR temp_str
  ENDDEF

  temp_str = LEFT( pad_str, wid )
  temp_str = temp_str + SPACE( wid - LEN( temp_str ) )

  RETURN temp_str
ENDPRO

FUNCTION CHAR Dbf_Titles
  VARDEF
    CHAR temp_str
  ENDDEF

  temp_str = SPACE( 5 ) + CENTER( "Name", 42 ) + "  "
  temp_str = temp_str + CENTER( "City/Sate/Zip", 29 ) + "  "
  temp_str = temp_str + CENTER( "Phone 1", 12 ) + "  "
  temp_str = temp_str + CENTER( "Phone 2", 12 ) + "  "
  temp_str = temp_str + "Age"

  RETURN temp_str
ENDPRO

FUNCTION CHAR Dbf_Line
  VARDEF
    CHAR temp_str
  ENDDEF

  temp_str = STR( A_RECNO( browse1 ), 5, 0 )
  temp_str = temp_str + PAD( TRIM( browse1->last_name ) + ", " +;
                             TRIM( browse1->first_name ), 42 ) + "  "
  temp_str = temp_str + PAD( TRIM( browse1->city ) + ", " +;
                             TRIM( browse1->state ) + " " +;
                             TRIM( browse1->zip ), 29 ) + "  "
  temp_str = temp_str + browse1->phone1 + "  "
  temp_str = temp_str + browse1->phone2 + "  "
  temp_str = temp_str + STR( browse1->age, 3, 0 )

  RETURN temp_str
ENDPRO

PROCEDURE Hold
* this does nothing...
ENDPRO

FUNCTION UINT Dbf_Width
* this function should return the string width of what the function
  * dbf_line() produces...

  !browse1 GOTO TOP

  RETURN LEN( Dbf_Line() )
ENDPRO

FUNCTION INT DBF_Handler
  PARAMETERS VALUE LONG list_handle,;
             VALUE UINT list_element,;
                   UINT mouse_stat,;
             VALUE UINT mrow,;
             VALUE UINT mcol,;
                    INT pick_key,;
             VALUE UINT top_element,;
             VALUE UINT last_element,;
       VALUE UINT ur,;
       VALUE UINT uc,;
       VALUE UINT lr,;
       VALUE UINT lc

  VARDEF
    INT   list_return
    CHAR  temp_str
    ULONG temp_rec
    UINT  counter
    INT  set_key
  ENDDEF

  set_key = 0
  list_return = &jl_continue

  DO CASE
    CASE mouse_stat = &jl_mouse_ignore
    CASE mouse_stat = &jl_mouse_right    && right button pressed
      list_return = &jl_ignore
    CASE mouse_stat = &jl_mouse_xright   && right button released
    *- use set_key so that the LASTKEY() value is accurate
      set_key = &k_esc

    CASE mouse_stat = &jl_mouse_up       && left button + top scroll-bar tab
      pick_key    = &k_up
    CASE mouse_stat = &jl_mouse_xup      && left button release "     "
      list_return = &jl_ignore
    CASE mouse_stat = &jl_mouse_down     && left button + bottom scroll tab
      pick_key = &k_down
    CASE mouse_stat = &jl_mouse_xdown    && left button release "     "
      list_return = &jl_ignore
    CASE mouse_stat = &jl_mouse_xscroll
      list_return = &jl_ignore
    CASE mouse_stat = &jl_mouse_scroll
      && cursor on scroll_bar, the default
      && 'pick_key' values should be set.
      &&    at bottom of list = &k_c_pg_down
      &&    at top of list    = &k_c_pg_up
      &&    above current     = &k_pg_down
      &&    below current     = &k_pg_up

      *- the values of 'pick_key' are set based upon the position of the
      *  mouse cursor relative to the scroll bar marker.
      *
      DO CASE
        CASE pick_key = &k_pg_down     && mouse below current position
          pick_key = &k_down
        CASE pick_key = &k_pg_up       && mouse above current position
          pick_key = &k_up
        CASE pick_key = &k_c_pg_down   && mouse at bottom  on scroll bar
          pick_key = &k_down
        CASE pick_key = &k_c_pg_up     && mouse at top  on scroll bar
          pick_key = &k_up
      ENDCASE

    CASE mouse_stat = &jl_mouse_xnew   && left released + mouse on new
      list_return = &jl_ignore
    CASE mouse_stat = &jl_mouse_new    && left + mouse on new element
      list_return = &jl_goto_mouse

    CASE mouse_stat = &jl_mouse_select  && left + mouse on current element
      list_return = &jl_ignore
    CASE mouse_stat = &jl_mouse_xselect && left released + mouse on current
      set_key = &k_enter

    CASE mouse_stat = &jl_mouse_left    && left + mouse outside of pick area
      list_return = &jl_continue
      DO CASE
        CASE mrow=ur-1
          pick_key = &k_up
        CASE mrow=lr+1
          pick_key = &k_down
        CASE mrow=16 .AND. mcol = 39
          set_key = &k_left
          Hold()
        CASE mrow=16 .AND. mcol = 41
          set_key = &k_right
          Hold()
        CASE mrow=15 .AND. mcol = 40
          pick_key = &k_up
          Hold()
        CASE mrow=17 .AND. mcol = 40
          pick_key = &k_down
          Hold()
        OTHERWISE
          list_return = &jl_ignore
      ENDCASE

    CASE mouse_stat = &jl_mouse_xleft   && left released + "         "
      list_return = &jl_ignore

    CASE mouse_stat = &jl_mouse_both    && left & right button hit
      list_return = &jl_ignore
  ENDCASE


  IF set_key <> 0
    DO WHILE INKEY() <> 0
    ENDDO

    KEY_INT( set_key )
    pick_key = INKEY()
  ENDIF


  DO CASE
    CASE pick_key = &k_enter
      list_return = &jl_select
    CASE pick_key = &k_esc
      list_return = &jl_abort
  ENDCASE

  IF list_return = &jl_continue
    DO CASE
      CASE pick_key = &k_home .OR.;
               pick_key = &k_end

      CASE pick_key = &k_c_right .OR.;
               pick_key = &k_c_left
        list_return = &jl_abort

      CASE pick_key = &k_down
        IF list_element = last_element
          temp_str = Vlist_Str( list_handle, list_element )
          temp_str = LEFT( temp_str, 5 )
          temp_rec = VAL( temp_str )

          !browse1 GOTO temp_rec
          !browse1 SKIP
          IF A_EOF( browse1 )
            list_return = &jl_ignore
          ELSE
            list_return = &jl_repaint
            Vlist_Delete( list_handle, 1 )
            Vlist_Add( list_handle, Dbf_Line() )
          ENDIF

        ENDIF

      CASE pick_key = &k_c_pg_down .OR.;
               pick_key = &k_c_end
        counter = 0
        !browse1 GOTO BOTTOM
        DO WHILE .NOT. A_BOF( browse1 ) .AND. counter < &browse_height
          counter = counter + 1
          !browse1 SKIP -1
        ENDDO

        DO WHILE .NOT. A_EOF( browse1 )
          Vlist_Add( list_handle, Dbf_Line() )
          Vlist_Delete( list_handle, 1 )
          !browse1 SKIP
        ENDDO

        pick_key    = &k_end
        list_return = &jl_paint_key

      CASE pick_key = &k_pg_down
        temp_str = Vlist_Str( list_handle, last_element )
        temp_str = LEFT( temp_str, 5 )
        temp_rec = VAL( temp_str )

        !browse1 GOTO temp_rec
        counter = 0

        DO WHILE .NOT. A_EOF( browse1 ) .AND. ( counter < &browse_height )
          !browse1 SKIP
          counter = counter + 1
          IF .NOT. A_EOF( browse1 )
            Vlist_Delete( list_handle, 1 )
            Vlist_Add( list_handle, Dbf_Line() )
          ENDIF

        ENDDO

        list_return = &jl_repaint

      CASE pick_key = &k_up
        IF list_element = top_element
          temp_str = Vlist_Str( list_handle, list_element )
          temp_str = LEFT( temp_str, 5 )
          temp_rec = VAL( temp_str )

          !browse1 GOTO temp_rec
          !browse1 SKIP -1
          IF A_BOF( browse1 )
            list_return = &jl_ignore
          ELSE
            list_return = &jl_repaint
            Vlist_Delete( list_handle, last_element )
            Vlist_Insert( list_handle, 1,;
                          &jl_normal, &jl_default, Dbf_Line() )
          ENDIF

        ENDIF

      CASE pick_key = &k_pg_up
        temp_str = Vlist_Str( list_handle, top_element )
        temp_str = LEFT( temp_str, 5 )
        temp_rec = VAL( temp_str )

        !browse1 GOTO temp_rec
        counter = 0

        DO WHILE .NOT. A_BOF( browse1 ) .AND. ( counter < &browse_height )
          !browse1 SKIP -1
          counter = counter + 1
          IF .NOT. A_BOF( browse1 )
            Vlist_Delete( list_handle, last_element )
            Vlist_Insert( list_handle, 1,;
                          &jl_normal, &jl_default, Dbf_Line() )
          ENDIF

        ENDDO

        list_return = &jl_repaint

      CASE pick_key = &k_c_pg_up .OR.;
               pick_key = &k_c_home
        counter = 0
        !browse1 GOTO TOP
        DO WHILE .NOT. A_EOF( browse1 ) .AND. counter < &browse_height
          counter = counter + 1
          Vlist_Add( list_handle, Dbf_Line() )
          Vlist_Delete( list_handle, 1 )
          !browse1 SKIP
        ENDDO

        pick_key    = &k_home
        list_return = &jl_paint_key

    ENDCASE

  ENDIF

  RETURN list_return
ENDPRO


PROCEDURE Force_Main

  VARDEF
    LONG     browse_list
    UINT     b_left,;
             b_right,;
             b_top,;
             b_select,;
             counter
    LOGICAL  b1,;
             keep_going,;
             scroll_bar
    INT      lkey
    ULONG    recnum
    CHAR     temp_str
  ENDDEF

  IF .NOT. EXIST( "browse1.dbf" )
    BUILD "browse1.dbf" FROM ALIAS browse1
    b1 = .T.
  ENDIF

  OPEN "browse1.dbf" ALIAS browse1 EXCLUSIVE
  SET ALIAS i_browse1 TO "browse1.fdx"

  IF .NOT. EXIST( "browse1.fdx" ) .OR. b1
    !browse1 INDEX i_browse1
  ENDIF

  !browse1 SET INDEX TO i_browse1

  !browse1 GOTO TOP

  browse_list = Vlist_Init( 250 )
  recnum      = 0
  b_top       = 1
  b_select    = 1
  b_left      = 6
  b_right     = 65        && 60 wide display area
  keep_going  = .T.
  scroll_bar  = .F.

  counter = 0

  DO WHILE .NOT. A_EOF( browse1 ) .AND. counter < &browse_height
    counter = counter + 1
    Vlist_Add( browse_list, Dbf_Line() )
    !browse1 SKIP
  ENDDO

  CLEAR
  __color_std = &black_light_grey
  @24, 0 SAY CENTER( "VLIST demonstration 'BROWSE' (c) 1991 Jayson R. Minard", 80 )

  FILL( 3, 7, 11, 70, &double_box, " ", &black_light_grey, &black_white, 0 )
  @5,  8 TO 5, 69
  @5,  7 SAY ""
  @5, 70 SAY ""

  IF Vmouse_Init() = 0
    is_mouse = .F.
  ELSE
    Vmouse_Reset()
    is_mouse = .T.
  ENDIF

  IF is_mouse
    FILL( 14, 37, 18, 43, &single_box, " ", &black_light_grey, &black_white, 0 )

    @13, 38 SAY "mouse"

    __color_std = &black_white
    @16, 40 SAY CHR( 4 )
    @16, 39 SAY CHR( 27 ) && left
    @16, 41 SAY CHR( 26 ) && right
    @17, 40 SAY CHR( 25 ) && down
    @15, 40 SAY CHR( 24 ) && up
  ENDIF

  __color_std = &black_white

  __scroll_offset = 2

  CURSOR_OFF()

  *---------------------------------------------------------------------------*

  DO WHILE keep_going
    @4, 9 SAY SUBSTR( Dbf_Titles(), b_left, b_right-b_left+1 )

    b_select = VLIST_PICK( browse_list, 6, 9, 10, 68,;
                           b_top, b_select, 0, 0,;
                           b_left, b_right,;
                           1, 0,;
                           Dbf_Handler,;
                           .F., scroll_bar, .T., is_mouse, .F. )

    lkey = LASTKEY()

    DO CASE
      CASE lkey = &k_esc .OR. b_select = 0
        keep_going = .F.
        recnum     = 0

      CASE lkey = &k_c_right
        IF Dbf_Width() > 60
          b_right = Dbf_Width()
          b_left  = b_right - 59
        ENDIF

      CASE lkey = &k_c_left
        b_left  = 6
        b_right = 65

      CASE lkey = &k_right
        IF b_right < ( Dbf_Width() )
          b_right = b_right + 5
          b_left  = b_left  + 5
        ENDIF

      CASE lkey = &k_left
        IF b_left > 6
          b_left  = b_left  - 5
          b_right = b_right - 5
        ENDIF

      CASE lkey = &k_enter
        keep_going = .F.
        temp_str   = VLIST_CSTR( browse_list )
        temp_str   = LEFT( temp_str, 5 )
        recnum     = VAL( temp_str )
    ENDCASE

  ENDDO

  IF recnum <> 0
    !browse1 GOTO recnum
    * now we are at the selected record!
  ENDIF


  *---------------------------------------------------------------------------*

  IF is_mouse
    Vmouse_Reset()
    Vmouse_Cursor( .F. )
  ENDIF

  CURSOR_ON()

  CLEAR

  IF recnum <> 0
    ? "record selected:   " + I_STR( recnum )
    ?
    ? TRIM( browse1->last_name ) + ", " + TRIM( browse1->first_name )
    ?
  ELSE
    ? "ESC aborted selection."
    ?
  ENDIF

  VLIST_CLEAR( browse_list )

  CLOSE ALL
  QUIT
ENDPRO
