*******************************************************************************
*                                                                             *
*                            File Edit using VLIST                            *
*                                                                             *
*                          (c) 1991 Jayson R. Minard                          *
*                                                                             *
*******************************************************************************

#INCLUDE STRING.HDR
#INCLUDE IO.HDR
#INCLUDE FILEIO.HDR
#INCLUDE WARN.HDR
#INCLUDE SYSTEM.HDR
#INCLUDE vlist.hdr
#INCLUDE vmouse.hdr
#INCLUDE COLORS.HDR

VARDEF EXTERN
  BYTE __color_std, __color_enhcd
ENDDEF

VARDEF
  LOGICAL is_mouse
ENDDEF

FUNCTION LOGICAL File_Valid
  PARAMETERS CONST CHAR xfile_name

  VARDEF
    CHAR temp_spec
    CHAR temp_path
    CHAR file_name
  ENDDEF

  file_name = TRIM( xfile_name )

  IF LEN( file_name ) = 0
    temp_spec = "*.*"
  ELSE
    temp_spec = file_name
  ENDIF

  IF AT( "*", temp_spec ) > 0 .OR. AT( "?", temp_spec ) > 0
    @4, 0 CLEAR TO 4, 79
    IF AT( "\", temp_spec ) > 0
      temp_path = UPPER( ;
                  Vlist_Fixpath( LEFT( temp_spec, RAT( "\", temp_spec ) ) ) )
      temp_spec = SUBSTR( temp_spec, RAT( "\", temp_spec ) + 1, 128 )
    ELSE
      temp_path = ""
    ENDIF

    SAVE_SCREEN()

    @24, 24 SAY "<RETURN> select file  <ESC> exit"

    CURSOR_OFF()

    file_name = Vlist_1_Fpick( 2, 1, 22, 78, &double_box, &black_light_grey,;
                               &black_light_cyan, temp_path, temp_spec,;
                               .T., .F.,;
                               is_mouse, .T. )

    CURSOR_ON()

    DO CASE
      CASE file_name = "-"
        RESTORE_AREA()
        CLEAR
        ?
        ? "!ERROR:  not enough memory..."
        ? "         Aborted..."
        ?
        QUIT 1
      CASE file_name = "*" .AND. LASTKEY() <> 27
        RESTORE_AREA()
        @4, 2 SAY "No matching filenames found..."
        RETURN .F.
      CASE file_name = "*"
      OTHERWISE
        KEYBOARD( file_name )
        KEY_INT( 13 )     && enter
    ENDCASE

    RESTORE_AREA()
  ELSE
    RETURN .T.
  ENDIF


  RETURN .F.
ENDPRO

PROCEDURE FORCE_MAIN

  VARDEF
    CHAR( 128 )  file_name
    FILE         in_file
    CHAR         one_line
    UINT         file_top, file_select
    LONG         file_list, pop_list
    LOGICAL      changed
    LOGICAL      keep_going
    INT          temp_row
    UINT         save_var
    UINT         quit_select
  ENDDEF

  __color_std      = &black_white
  __color_enhcd    = &blue_white
  __color_hi_std   = &black_light_cyan
  __color_hi_enhcd = &blue_light_cyan
  __color_bar      = &black_light_grey
  __color_tab      = &black_white

  CLEAR
  SET SCOREBOARD OFF

  IF Vmouse_Init() = 0
    is_mouse = .F.
  ELSE
    is_mouse = .T.
    Vmouse_Reset()
  ENDIF

  file_name = SPACE( 128 )
  @0, 2 SAY "Enter filename:  " GET file_name PICTURE "@S50@K" VALID File_Valid( file_name )
  @2, 2 SAY "<ENTER> for pick-list  <ESC> to quit"
  READ

  IF LASTKEY() = 27
    CLEAR
    ?
    ? "Aborted..."
    ?
    QUIT
  ENDIF

  @0, 0 CLEAR TO 0, 79
  @0, 2 SAY "Filename:   " + file_name PICTURE "@S60"
  @2, 0 CLEAR TO 2, 79

  SET SCOREBOARD OFF
  CURSOR_OFF()

  IF .NOT. F_OPEN( in_file, file_name, &f_read )
    CLEAR
    ?
    ? "Cannot open file..."
    ?
    QUIT 1
  ENDIF

  file_list = VList_Init( 128 )
  IF file_list = 0
    CLEAR
    ?
    ? "Error initializing list..."
    ?
    QUIT 1
  ENDIF

  @12, 35 SAY "Reading..."

  DO WHILE .NOT. F_EOF( in_file )
    F_GETLN( in_file, one_line )
    IF .NOT. VList_ADD( file_list, one_line )
      @14, 21 SAY "Out of memory, partial file loaded..."
      @16, 33 SAY "press any key!"

      file_top = 40
      Vlist_Goto( file_list, Vlist_Max( file_list ) )
      DO WHILE file_top > 0
        IF .NOT. Vlist_Delete( file_list, Vlist_Max( file_list ) )
          EXIT
        ENDIF
 
        file_top = file_top - 1
      ENDDO

      GET_KEY()
      EXIT
    ENDIF

  ENDDO

  F_CLOSE( in_file )

  pop_list = VLIST_INIT( 30 )
  __embed_char = "^"
  Vlist_Add( pop_list, "1.0 | Exit: " )
  Vlist_Add( pop_list, "1.1 | ^Save and exit " )
  Vlist_Add( pop_list, "1.2 | ^Abort w/no save " )

  changed     = .F.
  keep_going  = .T.
  file_top    = 1
  file_select = 1

  FILL( 1, 0, 23, 79, &double_box, " ", &black_light_grey, &black_white, 0 )
  @24, 22 SAY "<RETURN> edit line  <ESC> save | exit"

  DO WHILE keep_going
    file_select = Vlist_Pick( file_list, 2, 1, 22, 78,;
                               file_top, file_select,;
                               0, 0, 0, 0,;
                               1, 0,;
                               Vlist_Default_Key_Handler,;
                               .F., .T., .F., is_mouse, .F. )
    IF LASTKEY() = 27
      IF changed
        quit_select = 1
        Vlist_Popup( pop_list, 1, quit_select, Vlist_Default_Menu_Handler,;
                     -1, -1, 24, &double_box, &black_light_grey,;
                     &black_white, .T., .T., save_var, .T., .F.,;
                     is_mouse, .T. )
      ELSE
        KEY_INT( 13 )
        DO WHILE INKEY() <> 0
        ENDDO

        quit_select = 2
      ENDIF

      IF LASTKEY() <> 27
        IF quit_select = 1
          IF .NOT. F_OPEN( in_file, file_name, &f_create )
            CLEAR
            ?
            ? "ERROR opening file for writing..."
            ?
            QUIT 1
          ENDIF

          Vlist_Top( file_list )
          DO WHILE .NOT. Vlist_Bol( file_list )
            one_line = Vlist_Cstr( file_list )
            F_PUT( in_file, RTRIM( one_line ) + CHR( 13 ) + CHR( 10 ) )
            Vlist_Skip( file_list, &jl_forward )
          ENDDO

          F_CLOSE( in_file )
        ENDIF

        keep_going = .F.
        LOOP
      ENDIF

    ELSE
      changed = .T.
      SAVE_SCREEN()
      temp_row = ROW()
      FILL( temp_row - 1, 0, temp_row + 1, 79, &single_box, " ",;
            &black_light_grey, &black_white, 0 )

      one_line = Vlist_Cstr( file_list )
      @ temp_row, 1 GET one_line PICTURE "@S78"
      CURSOR_ON()
      READ
      CURSOR_OFF()

      IF LASTKEY() <> 27
        Vlist_Cedit( file_list, RTRIM( one_line ) )
      ENDIF

      RESTORE_AREA()
    ENDIF

  ENDDO

  Vlist_Clear( file_list )
  Vlist_Clear( pop_list )

  IF is_mouse
    Vmouse_Reset()
    Vmouse_Cursor( .F. )
  ENDIF

  CURSOR_ON()
  CLEAR
  CLOSE ALL
  QUIT
ENDPRO