*******************************************************************************
*                                                                             *
*                       VList File-Picker Demo/Example                        *
*                                                                             *
*                          (c) 1991 Jayson R. Minard                          *
*                                                                             *
*******************************************************************************

#INCLUDE STRING.HDR
#INCLUDE WARN.HDR
#INCLUDE vlist.hdr
#INCLUDE vmouse.hdr
#INCLUDE IO.HDR
#INCLUDE COLORS.HDR

VARDEF EXTERN
  BYTE __color_std, __color_enhcd
ENDDEF

PROCEDURE Force_Main

  VARDEF
    LOGICAL is_mouse
    CHAR    temp
    LONG    picked_list
    UINT    loop_dude
  ENDDEF

  IF Vmouse_Init() = 0
    is_mouse = .F.
  ELSE
    is_mouse = .T.
    Vmouse_Reset()
  ENDIF

  CLEAR

  __color_std   = &black_white
  __color_enhcd = &blue_white
  __color_bar   = &black_light_grey
  __color_tab   = &black_white

  @ 3, 3 SAY "VLIST demo of function:  VList_1_FPick()"

  temp =  Vlist_1_Fpick( 5, 5, 15, 35, &double_box, &black_light_grey,;
                   &black_light_cyan, "", "*.*", .T., .T., is_mouse, .T. )

  ?
  ? "First response: ", temp
  ?
  ? "press any key"

  GET_KEY()

  CLEAR

  @ 3, 3 SAY "VLIST demo of function:  VList_1_FPick()"

  temp =  Vlist_1_Fpick( 5, 15, 19, 28, &double_box, &black_light_grey,;
                   &black_light_cyan, "", "*.*", .F., .T., is_mouse, .F. )

  ?
  ? "Second response: ", temp
  ?
  ? "press any key"
  GET_KEY()

  CLEAR

  __color_std = &black_white
  @ 3, 3 SAY "VLIST demo of function:  VList_FPick()"
  @ 23, 3 SAY "<SPACE> tags/change dir, <ENTER> exits, <CTRL-U> untags all"
  __color_std = &black_light_grey

  picked_list = vlist_fpick( 5, 15, 19, 28, &double_box, &black_light_grey,;
                             &black_light_cyan, &black_white, "", "*.*",;
                             .T., .T., is_mouse, .T., .T., 0 )

  clear
  ?
  do case
    case picked_list = -1
      ?
      ? "Out of memory or something close to that effect!"
      ?
    case picked_list = 0
      ?
      ? "<ESC> pressed!"
      ?
    otherwise
      IF vlist_max( picked_list ) = 0
        ?
        ? "no items selected!"
        ?
      ELSE
        ?
        ? "Selected list:"
        FOR loop_dude = 1 to vlist_max( picked_list )
          vlist_goto( picked_list, loop_dude )
          ? "  "+vlist_cstr( picked_list )
        NEXT
        ?
      ENDIF
  ENDCASE

  IF is_mouse
    Vmouse_Reset()
    Vmouse_Cursor( .F. )
  ENDIF

ENDPRO